/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.CPUImpl;
import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.MemoryImpl;
import bea.jmapi.NICImpl;
import com.bea.jvm.CPU;
import com.bea.jvm.HardwareComponent;
import com.bea.jvm.Machine;
import com.bea.jvm.NIC;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.PhysicalMemory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineImpl
extends JVMComponentImpl
implements Machine {
    private final CPUImpl[] cpus;
    private final String desc;
    private final PhysicalMemory memory;

    private native long getTotalPhysicalMemory();

    private native long getUsedPhysicalMemory();

    public MachineImpl(JVMImpl jvm) {
        super(jvm);
        int n;
        String s;
        this.memory = new PhysicalMemoryImpl(this.jvm);
        this.desc = s = AccessController.doPrivileged(new GetPropertyAction("os.arch", "Unknown"));
        try {
            n = this.getNumCPUS();
        }
        catch (NotAvailableException e) {
            n = 1;
        }
        this.cpus = new CPUImpl[n];
        for (int i = 0; i < this.cpus.length; ++i) {
            this.cpus[i] = new CPUImpl(jvm, this.desc, i);
        }
    }

    private native int getNumCPUS();

    CPUImpl getCPU(int index) {
        try {
            return this.cpus[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid CPU: " + index);
        }
    }

    @Override
    public List<? extends CPU> getCPUs() throws NotAvailableException {
        return Arrays.asList(this.cpus);
    }

    @Override
    public synchronized Collection<? extends NIC> getNICs() throws NotAvailableException {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            ArrayList<NICImpl> list = new ArrayList<NICImpl>();
            while (e.hasMoreElements()) {
                list.add(new NICImpl(this.jvm, e.nextElement()));
            }
            return list;
        }
        catch (SocketException e) {
            throw new NotAvailableException(e.getMessage());
        }
    }

    @Override
    public PhysicalMemory getPhysicalMemory() throws NotAvailableException {
        return this.memory;
    }

    @Override
    public Collection<? extends HardwareComponent> getHardwareComponents() throws NotAvailableException {
        ArrayList<HardwareComponent> list = new ArrayList<HardwareComponent>();
        list.add(this.getPhysicalMemory());
        list.addAll(this.getCPUs());
        list.addAll(this.getNICs());
        return list;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.cpus.length);
        buf.append('x');
        buf.append(this.cpus[0]);
        buf.append("\n\tnics: {\n");
        for (NIC nIC : this.getNICs()) {
            buf.append("\t   ");
            buf.append(nIC);
            buf.append('\n');
        }
        buf.append("\t}\n\t");
        buf.append(this.memory.toString());
        return buf.toString();
    }

    @Override
    public native double getCPULoad();

    @Override
    public native String getPhysicalMachineID();

    private final class PhysicalMemoryImpl
    extends MemoryImpl
    implements PhysicalMemory {
        public PhysicalMemoryImpl(JVMImpl jvm) {
            super(jvm, "Physcial Memory");
        }

        public long getTotalMemory() {
            return MachineImpl.this.getTotalPhysicalMemory();
        }

        public long getUsedMemory() {
            return MachineImpl.this.getUsedPhysicalMemory();
        }
    }
}

