/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.LoggingModuleImpl;
import com.bea.jvm.LoggingModule;
import com.bea.jvm.LoggingSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.jrockit.log.NativeLogModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingSystemImpl
implements LoggingSystem {
    private Collection<LoggingModuleImpl> modules;
    private List<String> loggingLevels;

    public LoggingSystemImpl() {
        this.initializeLogs();
        this.initializeLevels();
    }

    private void initializeLevels() {
        this.loggingLevels = Collections.unmodifiableList(Arrays.asList("QUIET", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"));
    }

    private void initializeLogs() {
        Collection<NativeLogModule> c = NativeLogModule.getAllModules();
        ArrayList<LoggingModuleImpl> l = new ArrayList<LoggingModuleImpl>(c.size());
        for (NativeLogModule m : c) {
            l.add(new LoggingModuleImpl(m));
        }
        this.modules = Collections.unmodifiableCollection(l);
    }

    @Override
    public List<String> getLevels() {
        return this.loggingLevels;
    }

    @Override
    public Collection<? extends LoggingModule> getModules() {
        return this.modules;
    }

    public String toString() {
        return "LoggingSystem(" + this.modules.size() + " modules, " + this.loggingLevels.size() + " levels)";
    }
}

