/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ListenerComponent<E, L>
extends JVMComponentImpl {
    private List<L> listeners = Collections.emptyList();
    private Object listenerLock = new Object();

    public ListenerComponent(JVMImpl jvm) {
        super(jvm);
    }

    protected void addedFirstListener() {
    }

    protected void removedLastListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(L listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<L> nList = new ArrayList<L>(this.listeners.size() + 1);
            nList.addAll(this.listeners);
            nList.add(listener);
            if (this.listeners.isEmpty()) {
                this.addedFirstListener();
            }
            this.listeners = nList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(L listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return false;
            }
            ArrayList<L> nList = new ArrayList<L>(this.listeners);
            nList.remove(listener);
            List<L> oList = this.listeners;
            this.listeners = nList;
            if (nList.isEmpty()) {
                this.removedLastListener();
            }
            return oList.size() != nList.size();
        }
    }

    public void sendEvent(E event) {
        List<L> myListeners = this.listeners;
        int n = myListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.sendEvent(myListeners.get(i), event);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public boolean hasListeners() {
        return this.listeners.size() > 0;
    }

    protected Object listenerLock() {
        return this.listenerLock;
    }

    protected abstract void sendEvent(L var1, E var2);
}

