/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.CGStrategyImpl;
import bea.jmapi.CPUImpl;
import bea.jmapi.ClassLibraryImpl;
import bea.jmapi.CompilationSystemImpl;
import bea.jmapi.DiagnosticCommandImpl;
import bea.jmapi.GarbageCollectorImpl;
import bea.jmapi.LoggingSystemImpl;
import bea.jmapi.MachineImpl;
import bea.jmapi.MemorySystemImpl;
import bea.jmapi.NativeInterfaceClient;
import bea.jmapi.OperatingSystemImpl;
import bea.jmapi.ProfilingSystemImpl;
import bea.jmapi.ThreadSystemImpl;
import com.bea.jvm.CPU;
import com.bea.jvm.ClassLibrary;
import com.bea.jvm.CodeGenerationStrategy;
import com.bea.jvm.CompilationSystem;
import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.JVM;
import com.bea.jvm.LoggingSystem;
import com.bea.jvm.Machine;
import com.bea.jvm.ManagementPermission;
import com.bea.jvm.MemorySystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OperatingSystem;
import com.bea.jvm.OptimizationLevel;
import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.ThreadSystem;
import com.bea.jvm.event.ClassLoadEvent;
import com.bea.jvm.event.CompilationEvent;
import com.bea.jvm.event.GarbageCollectionEvent;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMImpl
extends NativeInterfaceClient
implements JVM {
    private final Thread eventThread;
    private final String name = System.getProperty("java.vm.name");
    private final String version = System.getProperty("java.vm.version");
    private final String vendor = System.getProperty("java.vm.vendor");
    private final ThreadSystemImpl threadSystemImpl;
    private final MemorySystemImpl memorySystemImpl;
    private final ClassLibraryImpl classLibraryImpl;
    private final OperatingSystemImpl operatingSystemImpl;
    private final CompilationSystemImpl compilationSystemImpl;
    private final ProfilingSystemImpl profilingSystemImpl;
    private final MachineImpl machineImpl;
    private final DiagnosticCommandImpl diagnosticCommandImpl;
    private final GarbageCollectorImpl garbageCollectorImpl;
    private final LoggingSystemImpl loggingSystemImpl;

    public JVMImpl() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new ManagementPermission("createInstance"));
        }
        this.eventThread = new Thread("JMAPI event thread");
        this.init();
        this.diagnosticCommandImpl = new DiagnosticCommandImpl();
        this.threadSystemImpl = new ThreadSystemImpl(this);
        this.garbageCollectorImpl = new GarbageCollectorImpl(this);
        this.memorySystemImpl = new MemorySystemImpl(this, this.garbageCollectorImpl);
        this.classLibraryImpl = new ClassLibraryImpl(this);
        this.operatingSystemImpl = new OperatingSystemImpl(this);
        this.compilationSystemImpl = new CompilationSystemImpl(this);
        this.profilingSystemImpl = new ProfilingSystemImpl(this);
        this.machineImpl = new MachineImpl(this);
        this.loggingSystemImpl = new LoggingSystemImpl();
    }

    @Override
    public ThreadSystem getThreadSystem() {
        return this.threadSystemImpl;
    }

    @Override
    public MemorySystem getMemorySystem() {
        return this.memorySystemImpl;
    }

    @Override
    public ClassLibrary getClassLibrary() {
        return this.classLibraryImpl;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystemImpl;
    }

    @Override
    public CompilationSystem getCompilationSystem() {
        return this.compilationSystemImpl;
    }

    @Override
    public ProfilingSystem getProfilingSystem() {
        return this.profilingSystemImpl;
    }

    @Override
    public LoggingSystem getLoggingSystem() {
        return this.loggingSystemImpl;
    }

    @Override
    public Machine getMachine() {
        return this.machineImpl;
    }

    @Override
    public DiagnosticCommand getDiagnosticCommand() {
        return this.diagnosticCommandImpl;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.vendor + " " + this.name + " version " + this.version;
    }

    private native void suggestProcessAffinity0(int[] var1);

    private native int[] getProcessAffinity0();

    @Override
    public void suggestProcessAffinity(Collection<CPU> cpuCollection) {
        int[] affinity = new int[cpuCollection.size()];
        int n = 0;
        for (CPU cpu : cpuCollection) {
            try {
                affinity[n++] = ((CPUImpl)cpu).getIndex();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid cpu");
            }
        }
        this.suggestProcessAffinity0(affinity);
    }

    @Override
    public Collection<CPU> getProcessAffinity() throws NotAvailableException {
        int[] affinity = this.getProcessAffinity0();
        ArrayList<CPU> c = new ArrayList<CPU>();
        for (int i = 0; i < affinity.length; ++i) {
            c.add(this.machineImpl.getCPU(affinity[i]));
        }
        return c;
    }

    @Override
    public native long getStartTime();

    @Override
    public native double getJVMLoad();

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public native String getJVMInitArgs();

    @Override
    public native String getJavaCommandLine();

    private native void init();

    private native void destroy();

    protected void finalize() throws Throwable {
        this.destroy();
        try {
            this.eventThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.finalize();
    }

    private void onGCEnd(int strategy, int type, long start, long end, long pause) {
        this.garbageCollectorImpl.sendEvent(new GarbageCollectionEvent(this.garbageCollectorImpl, type, start, end));
    }

    private void onClassLoad(Class<?> loaded) {
        this.classLibraryImpl.sendEvent(new ClassLoadEvent(loaded, 0));
    }

    private void onCompiled(AccessibleObject member, int level, long time) {
        CGStrategyImpl gcs = this.compilationSystemImpl.getCodeGenerationStrategy(level);
        this.compilationSystemImpl.sendEvent(new CompilationEvent(member, (CodeGenerationStrategy)gcs, (OptimizationLevel)gcs, time));
    }

    private byte[] onClassFileHook(ClassLoader loader, String name, byte[] bytes) {
        return this.classLibraryImpl.preProcess(loader, name, bytes);
    }

    static {
        System.loadLibrary("jmapi");
    }
}

