/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.GCHeuristicImpl;
import bea.jmapi.GCStrategyImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.ListenerComponent;
import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.GarbageCollectionHeuristic;
import com.bea.jvm.GarbageCollectionStrategy;
import com.bea.jvm.GarbageCollector;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.event.FinalizationListener;
import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import com.bea.jvm.event.GarbageCollectionStrategyChangeEvent;
import com.bea.jvm.event.GarbageCollectionStrategyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarbageCollectorImpl
extends ListenerComponent<GarbageCollectionEvent, GarbageCollectionListener>
implements GarbageCollector {
    private final GCStrategyListeneners gcStrategyListeners;
    private final GarbageCollectionStrategy[] strategies;
    private final GarbageCollectionHeuristic[] heuristics;
    private DiagnosticCommand.Command gcCommand;

    public GarbageCollectorImpl(JVMImpl jvm) {
        super(jvm);
        GarbageCollectionHeuristic[] h;
        GarbageCollectionStrategy[] s;
        try {
            s = this.getStrategies0();
            h = this.getHeuristics0();
        }
        catch (NotAvailableException e) {
            s = new GarbageCollectionStrategy[]{new GCStrategyImpl()};
            h = new GarbageCollectionHeuristic[]{new GCHeuristicImpl()};
        }
        this.strategies = s;
        this.heuristics = h;
        this.gcStrategyListeners = new GCStrategyListeneners(jvm);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isDynamic()) {
            buf.append("Dynamic GC, current strategy: ");
        }
        buf.append(this.getGarbageCollectionStrategy().toString());
        return buf.toString();
    }

    private native GarbageCollectionStrategy[] getStrategies0();

    private native GarbageCollectionHeuristic[] getHeuristics0();

    private native int getStrategy0();

    private native int getHeuristic0();

    @Override
    public boolean isGenerational() throws NotAvailableException {
        return this.getGarbageCollectionStrategy().isGenerational();
    }

    @Override
    public native boolean hasCompaction() throws NotAvailableException;

    @Override
    public boolean isIncremental() throws NotAvailableException {
        return this.getGarbageCollectionStrategy().isIncremental();
    }

    @Override
    public boolean isConcurrent() throws NotAvailableException {
        return this.getGarbageCollectionStrategy().isConcurrent();
    }

    @Override
    public boolean isParallel() throws NotAvailableException {
        return this.getGarbageCollectionStrategy().isParallel();
    }

    @Override
    public native long getTotalGarbageCollectionCount();

    @Override
    public native long getLastGCStart();

    @Override
    public native long getLastGCEnd();

    @Override
    public native long getTotalGarbageCollectionTime();

    private native long getNurserySize0();

    @Override
    public long getNurserySize() {
        long nurserySize = this.getNurserySize0();
        if (this.isGenerational() && nurserySize != 0L) {
            return nurserySize;
        }
        throw new NotAvailableException("getNurserySize is not supported unless the current GC is using a nursery.");
    }

    private native void setNurserySize0(long var1);

    @Override
    public void setNurserySize(long nurserySize) {
        if (!this.isGenerational()) {
            throw new NotAvailableException("setNurserySize is not supported unless the current GC is using a nursery.");
        }
        this.setNurserySize0(nurserySize);
    }

    @Override
    public void addGarbageCollectionListener(GarbageCollectionListener listener) {
        super.addListener(listener);
    }

    @Override
    public void removeGarbageCollectionListener(GarbageCollectionListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void addFinalizationListener(FinalizationListener listener) throws NotAvailableException {
        this.addFinalizationListener(listener, false);
    }

    @Override
    public void addFinalizationListener(FinalizationListener listener, boolean onlyFailed) throws NotAvailableException {
        throw new NotAvailableException();
    }

    @Override
    public void removeFinalizationListener(FinalizationListener listener) throws NotAvailableException {
        throw new NotAvailableException();
    }

    @Override
    public Collection<GarbageCollectionStrategy> getGarbageCollectionStrategies() throws NotAvailableException {
        return Collections.unmodifiableCollection(Arrays.asList(this.strategies));
    }

    @Override
    public GarbageCollectionStrategy getGarbageCollectionStrategy() throws NotAvailableException {
        return this.strategies[this.getStrategy0()];
    }

    @Override
    public GarbageCollectionHeuristic getGarbageCollectionHeuristic() {
        return this.heuristics[this.getHeuristic0()];
    }

    @Override
    public Collection<GarbageCollectionHeuristic> getGarbageCollectionHeuristics() throws NotAvailableException {
        return Collections.unmodifiableCollection(Arrays.asList(this.heuristics));
    }

    private native void suggestGCHeuristics(int var1);

    @Override
    public void suggestGarbageCollectionHeuristic(GarbageCollectionHeuristic heuristic) throws NotAvailableException {
        try {
            for (int i = 0; i < this.heuristics.length; ++i) {
                if (this.heuristics[i] != heuristic) continue;
                this.suggestGCHeuristics(i);
                return;
            }
        }
        catch (UnsupportedOperationException e) {
            throw new NotAvailableException(e.getMessage());
        }
        throw new NotAvailableException(heuristic.toString());
    }

    private native void suggestGCStrategy(int var1);

    @Override
    public void suggestGarbageCollectionStrategy(GarbageCollectionStrategy strategy) throws NotAvailableException {
        try {
            for (int i = 0; i < this.strategies.length; ++i) {
                if (this.strategies[i] != strategy) continue;
                this.suggestGCStrategy(i);
                return;
            }
        }
        catch (UnsupportedOperationException e) {
            throw new NotAvailableException(e.getMessage());
        }
        throw new NotAvailableException(strategy.toString());
    }

    @Override
    public boolean isDynamic() throws NotAvailableException {
        return this.strategies.length > 1 && this.isSelfOptimizing();
    }

    @Override
    public native boolean isSelfOptimizing();

    @Override
    public void addGarbageCollectionStrategyChangeListener(GarbageCollectionStrategyChangeListener listener) {
        this.gcStrategyListeners.addListener(listener);
    }

    @Override
    public void removeGarbageCollectionStrategyChangeListener(GarbageCollectionStrategyChangeListener listener) {
        this.gcStrategyListeners.removeListener(listener);
    }

    private native void setPauseTimeTarget0(long var1);

    @Override
    public void setPauseTimeTarget(long target) throws NotAvailableException {
        try {
            this.setPauseTimeTarget0(target);
        }
        catch (UnsupportedOperationException e) {
            throw new NotAvailableException(e.getMessage());
        }
    }

    @Override
    public native long getPauseTimeTarget();

    @Override
    public native long getMinPauseTimeTarget();

    @Override
    public native long getMaxPauseTimeTarget();

    @Override
    public void gc() {
        if (this.gcCommand == null) {
            try {
                this.gcCommand = this.jvm.getDiagnosticCommand().getCommand("runsystemgc");
            }
            catch (NotAvailableException e) {
                System.gc();
                return;
            }
        }
        this.gcCommand.execute("full=true");
    }

    @Override
    protected native void addedFirstListener();

    @Override
    protected native void removedLastListener();

    @Override
    protected void sendEvent(GarbageCollectionListener listener, GarbageCollectionEvent event) {
        listener.onGarbageCollection(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GCStrategyListeneners
    extends ListenerComponent<GarbageCollectionStrategyChangeEvent, GarbageCollectionStrategyChangeListener>
    implements GarbageCollectionListener {
        private GarbageCollectionStrategy strategy;

        public GCStrategyListeneners(JVMImpl jvm) {
            super(jvm);
            this.strategy = GarbageCollectorImpl.this.getGarbageCollectionStrategy();
        }

        @Override
        protected void addedFirstListener() {
            GarbageCollectorImpl.this.addGarbageCollectionListener(this);
        }

        @Override
        protected void removedLastListener() {
            GarbageCollectorImpl.this.removeGarbageCollectionListener(this);
        }

        @Override
        protected void sendEvent(GarbageCollectionStrategyChangeListener listener, GarbageCollectionStrategyChangeEvent event) {
            listener.onGarbageCollectionStrategyChange(event);
        }

        @Override
        public void onGarbageCollection(GarbageCollectionEvent event) {
            GarbageCollectionStrategy s = GarbageCollectorImpl.this.getGarbageCollectionStrategy();
            if (s != this.strategy) {
                GarbageCollectionStrategyChangeEvent event2 = new GarbageCollectionStrategyChangeEvent(GarbageCollectorImpl.this, event.getEndTime(), this.strategy, s);
                this.sendEvent(event2);
                this.strategy = s;
            }
        }
    }
}

