/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import com.bea.jvm.GarbageCollectionStrategy;
import java.util.Map;
import java.util.Properties;

public class GCStrategyImpl
implements GarbageCollectionStrategy {
    private String name;
    private boolean isGenerational;
    private boolean isParallelMark;
    private boolean isParallelSweep;
    private boolean isConcurrentMark;
    private boolean isConcurrentSweep;
    private boolean isIncremental;
    private transient Properties strategyProperties;

    private GCStrategyImpl(String name, boolean isGenerational, boolean isParallelMark, boolean isParallelSweep, boolean isConcurrentMark, boolean isConcurrentSweep, boolean isIncremental) {
        this.name = name;
        this.isGenerational = isGenerational;
        this.isParallelMark = isParallelMark;
        this.isParallelSweep = isParallelSweep;
        this.isConcurrentMark = isConcurrentMark;
        this.isConcurrentSweep = isConcurrentSweep;
        this.isIncremental = isIncremental;
    }

    GCStrategyImpl() {
        this("<unknown>", false, false, false, false, false, false);
    }

    public boolean isConcurrentMark() {
        return this.isConcurrentMark;
    }

    public boolean isConcurrentSweep() {
        return this.isConcurrentSweep;
    }

    public boolean isParallelMark() {
        return this.isParallelMark;
    }

    public boolean isParallelSweep() {
        return this.isParallelSweep;
    }

    public String getName() {
        return this.name;
    }

    public Properties getStrategyProperties() {
        if (this.strategyProperties == null) {
            Properties p = new Properties();
            p.put("generational", this.isGenerational() ? "true" : "false");
            p.put("mark", this.isParallelMark() ? "parallel" : (this.isConcurrentMark() ? "concurrent" : "<unknown>"));
            p.put("sweep", this.isParallelSweep() ? "parallel" : (this.isConcurrentSweep() ? "concurrent" : "<unknown>"));
            this.strategyProperties = p;
        }
        return this.strategyProperties;
    }

    public String getDescription() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        for (Map.Entry e : this.getStrategyProperties().entrySet()) {
            buf.append(", ").append(e.getKey()).append("=").append(e.getValue());
        }
        return buf.toString();
    }

    public boolean isConcurrent() {
        return this.isConcurrentMark() || this.isConcurrentSweep();
    }

    public boolean isGenerational() {
        return this.isGenerational;
    }

    public boolean isParallel() {
        return this.isParallelMark() || this.isParallelSweep();
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }
}

