/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.WeakClassListener;
import com.bea.jvm.ExceptionProfileEntry;
import com.bea.jvm.event.ClassLoadEvent;
import com.bea.jvm.event.ClassLoadListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExceptionProfileImpl
extends JVMComponentImpl
implements ExceptionProfileEntry {
    private Class<? extends Throwable> throwableType;
    private boolean singleEnabled;
    private boolean compositeEnabled;

    private native void checkAvailable();

    public ExceptionProfileImpl(JVMImpl jvm, Class<? extends Throwable> throwableType) {
        super(jvm);
        this.checkAvailable();
        if (!Throwable.class.isAssignableFrom(throwableType)) {
            throw new ClassCastException(throwableType.getName());
        }
        this.throwableType = throwableType;
    }

    protected ExceptionProfileImpl(ExceptionProfileImpl other) {
        super(other.jvm);
        this.throwableType = other.throwableType;
        this.setSingleEnabled(other.isSingleEnabled());
        this.setCompositeEnabled(other.isCompositeEnabled());
    }

    @Override
    public Class<? extends Throwable> getProfiled() {
        return this.throwableType;
    }

    @Override
    public boolean isSingleEnabled() {
        return this.singleEnabled;
    }

    @Override
    public void setSingleEnabled(boolean on) {
        this.singleEnabled = this.setSingleEnabled0(this.throwableType, on);
    }

    public native boolean setSingleEnabled0(Class<? extends Throwable> var1, boolean var2);

    @Override
    public boolean isCompositeEnabled() {
        return this.compositeEnabled;
    }

    @Override
    public void setCompositeEnabled(boolean on) {
        this.compositeEnabled = this.setCompositeEnabled0(this.throwableType, on);
    }

    public native boolean setCompositeEnabled0(Class<? extends Throwable> var1, boolean var2);

    @Override
    public long getCompositeCount() {
        return this.compositeEnabled ? this.getCompositeCount0(this.throwableType) : 0L;
    }

    @Override
    public long getSingleCount() {
        return this.singleEnabled ? this.getSingleCount0(this.throwableType) : 0L;
    }

    private native long getCompositeCount0(Class<? extends Throwable> var1);

    private native long getSingleCount0(Class<? extends Throwable> var1);

    private native Object[] getSingleCounts0(Class<? extends Throwable> var1);

    @Override
    public Map<Class<? extends Throwable>, Long> getSingleCounts() {
        if (!this.singleEnabled && !this.compositeEnabled) {
            return Collections.emptyMap();
        }
        Object[] arrays = this.getSingleCounts0(this.throwableType);
        Object[] classes = (Object[])arrays[0];
        long[] counts = (long[])arrays[1];
        HashMap<Class<? extends Throwable>, Long> result = new HashMap<Class<? extends Throwable>, Long>(counts.length);
        int n = counts.length;
        for (int i = 0; i < n; ++i) {
            Class c = (Class)classes[i];
            result.put(c.asSubclass(Throwable.class), new Long(counts[i]));
        }
        return result;
    }

    private static String toString(ExceptionProfileEntry e) {
        StringBuilder buf = new StringBuilder();
        buf.append(e.getProfiled().toString());
        if (!e.isCompositeEnabled() && !e.isSingleEnabled()) {
            buf.append(" - disabled");
        }
        if (e.isSingleEnabled()) {
            buf.append(" count=").append(e.getSingleCount());
        }
        if (e.isCompositeEnabled()) {
            buf.append(" composite=").append(e.getCompositeCount());
        }
        return buf.toString();
    }

    public String toString() {
        return ExceptionProfileImpl.toString(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setSingleEnabled(false);
        this.setCompositeEnabled(false);
    }

    @Override
    public ExceptionProfileEntry getResetableInstance() {
        return new ResetableEntry(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResetableEntry
    extends ExceptionProfileImpl
    implements ClassLoadListener {
        private long singleReset;
        private long compositeReset;
        private WeakHashMap<Class<? extends Throwable>, Long> types;
        private int numClasses;
        private WeakClassListener delegator;

        public ResetableEntry(ExceptionProfileImpl other) {
            super(other);
        }

        @Override
        public void setCompositeEnabled(boolean on) {
            super.setCompositeEnabled(on);
            this.compositeReset = this.initCompositeCount(on);
        }

        @Override
        public void setSingleEnabled(boolean on) {
            super.setSingleEnabled(on);
            this.singleReset = on ? this.getSingleCount() : 0L;
        }

        private synchronized void checkDeadSubtypes() {
            if (this.types == null) {
                return;
            }
            long res = 0L;
            for (long l : this.types.values()) {
                res += l;
            }
            this.compositeReset = res;
        }

        @Override
        public long getCompositeCount() {
            long res;
            long now;
            do {
                now = this.compositeReset;
                res = super.getCompositeCount();
                this.checkDeadSubtypes();
            } while (now != this.compositeReset);
            return res - now;
        }

        @Override
        public long getSingleCount() {
            return super.getSingleCount() - this.singleReset;
        }

        @Override
        public ExceptionProfileEntry getResetableInstance() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClass(Class<? extends Throwable> c, Long l) {
            if (c.getClassLoader() != null) {
                ResetableEntry resetableEntry = this;
                synchronized (resetableEntry) {
                    if (this.types == null) {
                        this.types = new WeakHashMap();
                        this.numClasses = 0;
                    }
                    this.types.put(c, l);
                    ++this.numClasses;
                }
            }
        }

        @Override
        public void onClassLoad(ClassLoadEvent event) {
            Class<?> c = event.getClassObject();
            if (this.getProfiled().isAssignableFrom(c)) {
                this.addClass(c.asSubclass(Throwable.class), new Long(0L));
            }
        }

        private synchronized long initCompositeCount(boolean on) {
            long res = on ? this.getCompositeCount() : 0L;
            this.types = null;
            if (this.delegator != null) {
                this.jvm.getClassLibrary().removeClassLoadListener(this.delegator);
            }
            if (res == 0L) {
                return 0L;
            }
            if (this.delegator == null) {
                this.delegator = new WeakClassListener(this);
            }
            this.jvm.getClassLibrary().addClassLoadListener(this.delegator);
            Map<Class<? extends Throwable>, Long> m = this.getSingleCounts();
            res = 0L;
            for (Map.Entry<Class<? extends Throwable>, Long> e : m.entrySet()) {
                long l = e.getValue();
                this.addClass(e.getKey(), l);
                res += l;
            }
            return res;
        }

        @Override
        public String toString() {
            return ExceptionProfileImpl.toString(this);
        }
    }
}

