/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import com.bea.jvm.DiagnosticCommand;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticCommandImpl
extends DiagnosticCommand {
    private native void execute(String var1, FileDescriptor var2);

    private FileOutputStream asFileOutputStream(final OutputStream os) throws IOException {
        if (os instanceof FileOutputStream) {
            return (FileOutputStream)os;
        }
        final File file = File.createTempFile("_diagnostic", ".out");
        return new FileOutputStream(file){

            public void flush() throws IOException {
                super.flush();
                this.close();
                FileInputStream fis = new FileInputStream(file);
                fis.getChannel().transferTo(0L, file.length(), Channels.newChannel(os));
                fis.close();
                os.flush();
                file.delete();
            }
        };
    }

    @Override
    public void execute(String command, OutputStream resultstream) throws IOException {
        FileOutputStream fos = this.asFileOutputStream(resultstream);
        try {
            this.execute(command, fos.getFD());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            fos.flush();
        }
    }

    @Override
    public void executeDefault(String command) {
        try {
            this.execute(command, (FileDescriptor)null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public native String[] getAvailableCommandNames();

    @Override
    public native String getDescription(String var1);

    @Override
    public Collection<DiagnosticCommand.Parameter> getParameters(String command) {
        return Arrays.asList(this.getParameters0(command));
    }

    private native DiagnosticCommand.Parameter[] getParameters0(String var1);

    static {
        System.loadLibrary("jmapi");
    }
}

