/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.CGStrategyImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.ListenerComponent;
import com.bea.jvm.CodeGenerationStrategy;
import com.bea.jvm.CompilationSystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OptimizationLevel;
import com.bea.jvm.event.CompilationEvent;
import com.bea.jvm.event.CompilationListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationSystemImpl
extends ListenerComponent<CompilationEvent, CompilationListener>
implements CompilationSystem {
    private final CGStrategyImpl[] availableStrategies;

    public CompilationSystemImpl(JVMImpl jvm) {
        super(jvm);
        CGStrategyImpl[] impls;
        try {
            impls = this.initStrategies();
        }
        catch (NotAvailableException e) {
            impls = new CGStrategyImpl[]{new CGStrategyImpl("<unknown>", 0, true)};
        }
        this.availableStrategies = impls;
    }

    private native CGStrategyImpl[] initStrategies();

    @Override
    public List<? extends OptimizationLevel> getOptimizationLevels() throws NotAvailableException {
        return Arrays.asList(this.availableStrategies);
    }

    @Override
    public List<? extends CodeGenerationStrategy> getCodeGenerationStrategies() throws NotAvailableException {
        return Arrays.asList(this.availableStrategies);
    }

    @Override
    public boolean isCompiled(Method method) {
        return this.getStrategy(method) != -1;
    }

    @Override
    public boolean isCompiled(Constructor<?> constructor) {
        return this.getStrategy(constructor) != -1;
    }

    @Override
    public boolean isOptimized(Method method) {
        return this.getCodeGenerationStrategy(method).isOptimizing();
    }

    @Override
    public native boolean isOptimizing();

    @Override
    public native void setOptimizing(boolean var1);

    @Override
    public boolean isOptimized(Constructor<?> constructor) {
        return this.getCodeGenerationStrategy(constructor).isOptimizing();
    }

    @Override
    public OptimizationLevel getOptimizationLevel(Method method) throws NotAvailableException {
        return (OptimizationLevel)((Object)this.getCodeGenerationStrategy(method));
    }

    private native int getStrategy(AccessibleObject var1);

    @Override
    public CodeGenerationStrategy getCodeGenerationStrategy(Method method) {
        return this.getCodeGenerationStrategy(this.getStrategy(method));
    }

    CGStrategyImpl getCodeGenerationStrategy(int level) {
        try {
            return this.availableStrategies[level];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.availableStrategies[0];
        }
    }

    @Override
    public OptimizationLevel getOptimizationLevel(Constructor<?> constructor) {
        return (OptimizationLevel)((Object)this.getCodeGenerationStrategy(constructor));
    }

    @Override
    public CodeGenerationStrategy getCodeGenerationStrategy(Constructor<?> constructor) {
        try {
            return this.availableStrategies[this.getStrategy(constructor)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.availableStrategies[0];
        }
    }

    private native boolean forceCompilation(AccessibleObject var1, int var2);

    @Override
    public boolean forceCompilation(Method method) {
        return this.forceCompilation((AccessibleObject)method, 0);
    }

    @Override
    public boolean forceCompilation(Constructor<?> constructor) {
        return this.forceCompilation(constructor, 0);
    }

    @Override
    public boolean forceCompilation(Method method, OptimizationLevel optLevel) {
        return this.forceCompilation((AccessibleObject)method, optLevel.getLevel());
    }

    @Override
    public boolean forceCompilation(Method method, CodeGenerationStrategy strategy) {
        return this.forceCompilation((AccessibleObject)method, strategy.getLevel());
    }

    @Override
    public boolean forceCompilation(Constructor<?> constructor, OptimizationLevel optLevel) {
        return this.forceCompilation(constructor, optLevel.getLevel());
    }

    @Override
    public boolean forceCompilation(Constructor<?> constructor, CodeGenerationStrategy strategy) {
        return this.forceCompilation(constructor, strategy.getLevel());
    }

    @Override
    public void addCompilationListener(CompilationListener listener) {
        this.addListener(listener);
    }

    @Override
    public void removeCompilationListener(CompilationListener listener) {
        this.removeListener(listener);
    }

    @Override
    public void redefineMethod(Method method, byte[] buffer, int offset, int length) throws NotAvailableException {
        throw new NotAvailableException("redefineMethod");
    }

    public String toString() {
        return "CompileSystem " + this.getCodeGenerationStrategies();
    }

    @Override
    protected native void addedFirstListener();

    @Override
    protected native void removedLastListener();

    @Override
    protected void sendEvent(CompilationListener listener, CompilationEvent event) {
        listener.onMethodCompilation(event);
    }
}

