/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMImpl;
import bea.jmapi.ListenerComponent;
import com.bea.jvm.ClassLibrary;
import com.bea.jvm.ClassPreProcessor;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.event.ClassLoadEvent;
import com.bea.jvm.event.ClassLoadListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLibraryImpl
extends ListenerComponent<ClassLoadEvent, ClassLoadListener>
implements ClassLibrary {
    private ClassPreProcessor processor;

    public ClassLibraryImpl(JVMImpl jvm) {
        super(jvm);
    }

    @Override
    public Collection<ClassLoader> getAllClassLoaders() throws NotAvailableException {
        HashSet<ClassLoader> dict = new HashSet<ClassLoader>();
        Class<?>[] classes = this.getAllClasses0((String)null);
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            ClassLoader loader = classes[i].getClassLoader();
            dict.add(loader);
        }
        return dict;
    }

    @Override
    public Class<?> getClass(final String className, final ClassLoader loader, boolean load) throws ClassNotFoundException {
        if (load) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return Class.forName(className, false, loader);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
        for (Class<?> c : this.getInitiatedClasses(loader)) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return this.getClass(className, loader, false);
    }

    private native Class<?>[] getAllClasses0(String var1);

    private native Class<?>[] getAllClasses0(ClassLoader var1);

    @Override
    public Collection<Class<?>> getAllClasses(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException();
        }
        Class<?>[] res = this.getAllClasses0(className);
        if (res == null || res.length == 0) {
            throw new ClassNotFoundException(className);
        }
        return Arrays.asList(res);
    }

    @Override
    public Collection<Class<?>> getAllClasses(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        return this.getDeclaredClasses(loader);
    }

    @Override
    public Collection<Class<?>> getAllClasses() throws NotAvailableException {
        return Arrays.asList(this.getAllClasses0((String)null));
    }

    @Override
    public Collection<Class<?>> getDeclaredClasses(ClassLoader loader) throws NotAvailableException {
        Class<?>[] classes = this.getAllClasses0(loader);
        int j = 0;
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> c = classes[i];
            if (c.getClassLoader() != loader) continue;
            classes[j++] = c;
        }
        return Arrays.asList(classes).subList(0, j);
    }

    @Override
    public Collection<Class<?>> getInitiatedClasses(ClassLoader loader) throws NotAvailableException {
        return Arrays.asList(this.getAllClasses0(loader));
    }

    @Override
    public void addClassLoadListener(final ClassLoader loader, final ClassLoadListener listener) {
        this.addListener(new ClassLoadListener(){

            public void onClassLoad(ClassLoadEvent event) {
                if (event.getClassObject().getClassLoader() == loader) {
                    listener.onClassLoad(event);
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o == listener;
            }
        });
    }

    @Override
    public void addClassLoadListener(ClassLoadListener listener) {
        this.addListener(listener);
    }

    @Override
    public void removeClassLoadListener(ClassLoadListener listener) {
        this.removeListener(listener);
    }

    @Override
    public native void redefineClass(Class<?> var1, byte[] var2, int var3, int var4);

    private native void setPreprocessing(boolean var1);

    @Override
    public synchronized void setClassPreProcessor(ClassPreProcessor preProcessor) {
        this.processor = preProcessor;
        this.setPreprocessing(this.processor != null);
    }

    @Override
    public ClassPreProcessor getClassPreProcessor() {
        return this.processor;
    }

    byte[] preProcess(ClassLoader loader, String name, byte[] bytes) {
        ClassPreProcessor processor = this.processor;
        if (processor != null) {
            try {
                bytes = processor.preProcess(loader, name, bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    public String toString() {
        return "ClassLibrary of " + this.jvm;
    }

    @Override
    protected native void addedFirstListener();

    @Override
    protected native void removedLastListener();

    @Override
    protected void sendEvent(ClassLoadListener listener, ClassLoadEvent event) {
        listener.onClassLoad(event);
    }
}

