/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import com.bea.jvm.CallTraceElement;
import com.bea.jvm.ThreadSnapshot;

class CallTraceElementImpl
implements CallTraceElement {
    private final ThreadSnapshot.Monitor[] monitors;
    private final String fileName;
    private final String className;
    private final String methodName;
    private final int lineNumber;
    private static final ThreadSnapshot.Monitor[] EMPTY_MONITORS = new ThreadSnapshot.Monitor[0];

    private CallTraceElementImpl(String className, String methodName, int lineNumber, ThreadSnapshot.Monitor[] monitors, String fileName) {
        if (className == null) {
            throw new NullPointerException("null class name");
        }
        if (methodName == null) {
            throw new NullPointerException("null method name");
        }
        this.monitors = monitors != null ? monitors : EMPTY_MONITORS;
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public ThreadSnapshot.Monitor[] getMonitors() {
        return this.monitors;
    }

    public String toString() {
        String info = this.className + "." + this.methodName;
        info = this.isNativeMethod() ? info + "(Native Method)" : (this.fileName != null ? (this.lineNumber >= 0 ? info + "(" + this.fileName + ":" + this.lineNumber + ")" : info + "(" + this.fileName + ":" + "???)") : info + "(Unknown Source)");
        return info;
    }
}

