/*
 * Decompiled with CFR 0.152.
 */
package bea.jmapi;

import bea.jmapi.JVMComponentImpl;
import bea.jmapi.JVMImpl;
import bea.jmapi.MethodProfileData;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BIPUSH;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionFactory;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.SIPUSH;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BCMethodProf
extends JVMComponentImpl {
    private static final WeakHashMap<AccessibleObject, SoftReference<BCMethodProf>> entries = new WeakHashMap();
    private static final ArrayList<BCMethodProf> deadProfilers = new ArrayList();
    private Class<?> clazz;
    private SoftReference<Class<?>> clazzRef;
    private final String className;
    private final String signature;
    private final String name;
    private int icIndex = -1;
    private int itIndex = -1;
    private int icCount;
    private int itCount;
    private int itLocal;
    private boolean needTransform;
    private static final Object workaroundSync;

    static synchronized BCMethodProf forMethod(JVMImpl jvm, Method m) {
        BCMethodProf bc;
        SoftReference<BCMethodProf> r = entries.get(m);
        BCMethodProf bCMethodProf = bc = r != null ? r.get() : null;
        if (bc == null) {
            bc = new BCMethodProf(jvm, m);
            entries.put(m, new SoftReference<BCMethodProf>(bc));
        }
        return bc;
    }

    static synchronized BCMethodProf forConstructor(JVMImpl jvm, Constructor<?> c) {
        BCMethodProf bc;
        SoftReference<BCMethodProf> r = entries.get(c);
        BCMethodProf bCMethodProf = bc = r != null ? r.get() : null;
        if (bc == null) {
            bc = new BCMethodProf(jvm, c);
            entries.put(c, new SoftReference<BCMethodProf>(bc));
        }
        return bc;
    }

    private BCMethodProf(JVMImpl jvm, Method m) {
        this(jvm, m.getDeclaringClass(), m.getName(), BCMethodProf.getSignature(m.getParameterTypes(), m.getReturnType()));
    }

    private BCMethodProf(JVMImpl jvm, Constructor<?> c) {
        this(jvm, c.getDeclaringClass(), "<init>", BCMethodProf.getSignature(c.getParameterTypes(), Void.TYPE));
    }

    private BCMethodProf(JVMImpl jvm, Class<?> clazz, String name, String signature) {
        super(jvm);
        this.clazz = clazz;
        this.className = clazz.getName();
        this.signature = signature;
        this.name = name;
        this.checkDeadEntries(true);
    }

    long getInvocationCount() {
        int n = this.icIndex;
        if (n != -1) {
            return MethodProfileData.get(n);
        }
        return 0L;
    }

    long getTiming() {
        int n = this.itIndex;
        if (n != -1) {
            return MethodProfileData.get(n);
        }
        return 0L;
    }

    synchronized void enableInvocationCount() {
        if (1 == ++this.icCount) {
            this.needTransform = true;
        }
    }

    synchronized void disableInvocationCount() {
        if (this.icCount == 0) {
            return;
        }
        if (0 == --this.icCount) {
            this.needTransform = true;
        }
    }

    synchronized void enableTiming() {
        if (1 == ++this.itCount) {
            this.needTransform = true;
        }
    }

    synchronized void disableTiming() {
        if (this.itCount == 0) {
            return;
        }
        if (0 == --this.itCount) {
            this.needTransform = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update() {
        if (!this.needTransform) {
            return;
        }
        try {
            Class<?> clazz = this.clazz;
            synchronized (clazz) {
                block10: {
                    if (this.isCounting() == (this.icIndex != -1) && this.isTiming() == (this.itIndex != -1)) {
                        this.needTransform = false;
                    }
                    if (this.needTransform) break block10;
                    return;
                }
                this.transform(this.clazz);
                this.needTransform = false;
            }
        }
        finally {
            this.checkRelease();
        }
    }

    private boolean checkRelease() {
        if (!this.isCounting() && this.icIndex != -1 || !this.isTiming() && this.itIndex != -1) {
            Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
            boolean found = false;
            block0: for (StackTraceElement[] trace : traces.values()) {
                for (StackTraceElement e : trace) {
                    if (!e.getClassName().equals(this.className) || !e.getMethodName().equals(this.name)) continue;
                    found = true;
                    break block0;
                }
            }
            if (found) {
                return false;
            }
            this.release();
        }
        return true;
    }

    private void release() {
        if (this.icIndex != -1 && !this.isCounting()) {
            MethodProfileData.release(this.icIndex);
            this.icIndex = -1;
        }
        if (this.itIndex != -1 && !this.isTiming()) {
            MethodProfileData.release(this.itIndex);
            this.itIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.checkRelease()) {
            if (this.canBeUnloaded(this.clazz)) {
                Cleaner.create(this.clazz, new Runnable(){

                    public void run() {
                        BCMethodProf.this.checkDeadEntries(false);
                    }
                });
            }
            ArrayList<BCMethodProf> arrayList = deadProfilers;
            synchronized (arrayList) {
                this.clazzRef = new SoftReference(this.clazz);
                this.clazz = null;
                deadProfilers.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeadEntries(boolean acquire) {
        ArrayList<BCMethodProf> arrayList = deadProfilers;
        synchronized (arrayList) {
            Iterator i = deadProfilers.iterator();
            while (i.hasNext()) {
                BCMethodProf p = (BCMethodProf)i.next();
                if (acquire && p.clazzRef.get() == this.clazz && p.name.equals(this.name) && p.signature.equals(this.signature)) {
                    this.icIndex = p.icIndex;
                    p.icIndex = -1;
                    this.itIndex = p.itIndex;
                    p.itIndex = -1;
                    i.remove();
                    continue;
                }
                if (p.clazzRef.get() == null) {
                    p.release();
                    i.remove();
                    continue;
                }
                if (!p.checkRelease()) continue;
                i.remove();
            }
        }
    }

    private boolean canBeUnloaded(Class<?> c) {
        ClassLoader l = c.getClassLoader();
        ClassLoader p = ClassLoader.getSystemClassLoader();
        while (true) {
            if (l == p) {
                return false;
            }
            if (p == null) break;
            p = p.getParent();
        }
        return true;
    }

    private boolean isTiming() {
        return this.itCount > 0;
    }

    private boolean isCounting() {
        return this.icCount > 0;
    }

    private static native void initIDs();

    private native void transform(Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transform(Class<?> c, String src, byte[] bytes) {
        assert (Thread.holdsLock(this));
        assert (Thread.holdsLock(c));
        assert (c == this.clazz);
        ArrayList<SoftReference<BCMethodProf>> copy = new ArrayList<SoftReference<BCMethodProf>>();
        Class<BCMethodProf> clazz = BCMethodProf.class;
        synchronized (BCMethodProf.class) {
            copy.addAll(entries.values());
            // ** MonitorExit[clazz] (shouldn't be in output)
            ArrayList<BCMethodProf> l = new ArrayList<BCMethodProf>();
            for (SoftReference softReference : copy) {
                BCMethodProf p = (BCMethodProf)softReference.get();
                if (p == null || p.clazz != c) continue;
                l.add(p);
            }
            assert (l.size() > 0);
            if (l.size() < 2 && !this.isCounting() && !this.isTiming()) {
                return null;
            }
            Object object = workaroundSync;
            synchronized (object) {
                ClassGen classGen = this.getClassGen(c, src, bytes);
                for (BCMethodProf p : l) {
                    p.transform(classGen);
                }
                JavaClass jc = classGen.getJavaClass();
                return jc.getBytes();
            }
        }
    }

    private void transform(ClassGen gen) {
        if (!this.isCounting() && !this.isTiming()) {
            return;
        }
        com.sun.org.apache.bcel.internal.classfile.Method m = this.getMethod(gen);
        MethodGen mg = new MethodGen(m, gen.getClassName(), gen.getConstantPool());
        if (this.isCounting()) {
            if (this.icIndex == -1) {
                this.icIndex = MethodProfileData.newEntry();
            }
            this.generateInvocationCount(gen, mg);
        }
        if (this.isTiming()) {
            if (this.itIndex == -1) {
                this.itIndex = MethodProfileData.newEntry();
            }
            this.generateTiming(gen, mg);
        }
        InstructionList l = mg.getInstructionList();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            InstructionHandle h = (InstructionHandle)iter.next();
            Instruction i = h.getInstruction();
            if (!(i instanceof LDC)) continue;
            LDC ldc = (LDC)i;
            ldc.setIndex(ldc.getIndex());
        }
        mg.setMaxStack();
        mg.setMaxLocals();
        gen.replaceMethod(m, mg.getMethod());
    }

    private void generateInvocationCount(ClassGen gen, MethodGen mg) {
        InstructionList il = new InstructionList();
        InstructionFactory f = new InstructionFactory(gen);
        il.append(this.pushInt(gen.getConstantPool(), this.icIndex));
        il.append(f.createInvoke(MethodProfileData.class.getName(), "invoke", Type.VOID, new Type[]{Type.INT}, (short)184));
        mg.getInstructionList().insert(il);
    }

    private void generateTiming(ClassGen gen, MethodGen mg) {
        ConstantPoolGen cp = gen.getConstantPool();
        int var = mg.getMaxLocals();
        InstructionList start = new InstructionList();
        InstructionList end = new InstructionList();
        InstructionFactory f = new InstructionFactory(gen);
        start.append(f.createInvoke(MethodProfileData.class.getName(), "time", Type.LONG, Type.NO_ARGS, (short)184));
        start.append(new LSTORE(var));
        end.append(this.pushInt(cp, this.itIndex));
        end.append(new LLOAD(var));
        end.append(f.createInvoke(MethodProfileData.class.getName(), "timing", Type.VOID, new Type[]{Type.INT, Type.LONG}, (short)184));
        InstructionList il = mg.getInstructionList();
        il.insert(start);
        block3: for (InstructionHandle h : il.getInstructionHandles()) {
            Instruction i = h.getInstruction();
            switch (i.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    InstructionHandle tmp = il.insert(h, end.copy());
                    il.redirectBranches(h, tmp);
                    continue block3;
                }
            }
        }
    }

    private ClassGen getClassGen(Class<?> c, String src, byte[] bytes) {
        JavaClass jc;
        try {
            jc = new ClassParser(new ByteArrayInputStream(bytes), src).parse();
        }
        catch (IOException e) {
            throw new InternalError();
        }
        return new ClassGen(jc);
    }

    private com.sun.org.apache.bcel.internal.classfile.Method getMethod(ClassGen gen) {
        for (com.sun.org.apache.bcel.internal.classfile.Method m : gen.getMethods()) {
            if (!m.getName().equals(this.name) || !m.getSignature().equals(this.signature)) continue;
            return m;
        }
        throw new InternalError("No such method " + this.name + this.signature);
    }

    private Instruction pushInt(ConstantPoolGen cp, int i) {
        if (i <= 5 && i >= -1) {
            return new BIPUSH((byte)i);
        }
        if (i >= Short.MIN_VALUE && i < Short.MAX_VALUE) {
            return new SIPUSH((short)i);
        }
        return new LDC(cp.addInteger(i));
    }

    private static Type getType(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return Type.BOOLEAN;
            }
            if (c == Byte.TYPE) {
                return Type.BYTE;
            }
            if (c == Character.TYPE) {
                return Type.CHAR;
            }
            if (c == Double.TYPE) {
                return Type.DOUBLE;
            }
            if (c == Float.TYPE) {
                return Type.FLOAT;
            }
            if (c == Integer.TYPE) {
                return Type.INT;
            }
            if (c == Long.TYPE) {
                return Type.LONG;
            }
            if (c == Short.TYPE) {
                return Type.SHORT;
            }
            if (c == Void.TYPE) {
                return Type.VOID;
            }
            throw new InternalError("Should have found primitive type");
        }
        if (c.isArray()) {
            int n = 0;
            while (c.isArray()) {
                ++n;
                c = c.getComponentType();
            }
            return new ArrayType(BCMethodProf.getType(c), n);
        }
        return new ObjectType(c.getName());
    }

    private static String getSignature(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new InternalError("Should have found primitive type");
        }
        if (c.isArray()) {
            return "[" + BCMethodProf.getSignature(c.getComponentType());
        }
        return "L" + c.getName().replace('.', '/') + ";";
    }

    private static String getSignature(Class<?>[] args, Class<?> ret) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (Class<?> c : args) {
            buf.append(BCMethodProf.getSignature(c));
        }
        buf.append(')').append(BCMethodProf.getSignature(ret));
        return buf.toString();
    }

    static {
        BCMethodProf.initIDs();
        workaroundSync = ClassGen.class;
    }
}

