/*
 * Decompiled with CFR 0.152.
 */
package n38i.exe.pki.crls;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import n38i.exe.N38Constantes;
import n38i.exe.N38Excepcion;
import n38i.exe.N38InterfaceLog;
import n38i.exe.N38LogManager;
import n38i.exe.pki.N38GeneradorExcepcionCertificado;
import n38i.exe.pki.crls.N38ElementoPKI;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public final class N38ElementoCRLChain
extends N38GeneradorExcepcionCertificado
implements N38ElementoPKI {
    private X509Certificate certificado = null;
    private X509CRL crl = null;
    private X509CRL arl = null;
    private String subject = null;
    private String revocador = null;
    private long n38UltimaModificacion = 0L;
    private LDAPEntry entradaLDAP = null;
    private N38LogManager logManager = N38LogManager.getInstancia();
    private N38InterfaceLog miLog = N38LogManager.creaLog(this.getClass().getName(), N38Constantes.n38FicheroLog);

    public N38ElementoCRLChain() {
        this.miLog.getCat(0, "N38ElementoCRLChain ()");
    }

    public N38ElementoCRLChain(LDAPEntry lDAPEntry) throws N38Excepcion, Exception {
        this.miLog.getCat(0, "N38ElementoCRLChain (entradaLDAP)");
        this.cargarElemento(lDAPEntry);
        this.setEntradaLDAP(lDAPEntry);
    }

    private void cargarElemento(LDAPEntry lDAPEntry) throws N38Excepcion, Exception {
        try {
            byte[] byArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            LDAPAttribute lDAPAttribute = null;
            Object var4_5 = null;
            Object var5_6 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            this.miLog.getCat(0, "Va a recoger el atributo modifytimestamp ; " + new Date(System.currentTimeMillis()));
            lDAPAttribute = lDAPEntry.getAttribute("modifytimestamp");
            this.miLog.getCat(0, "modifytimestamp -> " + lDAPAttribute.getStringValueArray()[0]);
            String string = lDAPAttribute.getStringValueArray()[0];
            this.miLog.getCat(0, "modifytimestamp -> " + string);
            this.n38UltimaModificacion = Long.parseLong(string.substring(0, string.length() - 1));
            this.miLog.getCat(0, "Va a recoger el atributo cacertificate;binary ; " + new Date(System.currentTimeMillis()));
            lDAPAttribute = lDAPEntry.getAttribute("cacertificate;binary");
            if (lDAPAttribute == null) {
                this.miLog.getCat(0, "cacertificate;binary No existe -> intenta cacertificate");
                lDAPAttribute = lDAPEntry.getAttribute("cacertificate");
            }
            Enumeration enumeration = null;
            enumeration = lDAPAttribute.getByteValues();
            byteArrayInputStream = new ByteArrayInputStream((byte[])enumeration.nextElement());
            while (byteArrayInputStream.available() > 0) {
                this.certificado = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            byteArrayInputStream.close();
            this.subject = ((Object)this.certificado.getSubjectDN()).toString();
            this.miLog.getCat(0, "Ha recogido el Subject -> " + this.subject + " ; " + new Date(System.currentTimeMillis()));
            this.revocador = this.certificado.getIssuerDN().getName();
            lDAPAttribute = null;
            this.miLog.getCat(0, "Va a recoger el atributo certificaterevocationlist;binary ; " + new Date(System.currentTimeMillis()));
            lDAPAttribute = lDAPEntry.getAttribute("certificaterevocationlist;binary");
            if (lDAPAttribute == null) {
                this.miLog.getCat(0, "certificaterevocationlist;binary No existe -> intenta certificaterevocationlist");
                lDAPAttribute = lDAPEntry.getAttribute("certificaterevocationlist");
            }
            if (lDAPAttribute == null) {
                this.miLog.getCat(0, "No tengo CRL para -> " + this.subject + " ; " + new Date(System.currentTimeMillis()));
            } else {
                enumeration = null;
                byteArrayInputStream = null;
                enumeration = lDAPAttribute.getByteValues();
                certificateFactory = CertificateFactory.getInstance("X.509");
                this.miLog.getCat(0, "Va a recoger la CRL ; " + new Date(System.currentTimeMillis()));
                byArray = (byte[])enumeration.nextElement();
                if (byArray.length > 0) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.crl = (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
                    this.miLog.getCat(0, "CRL -> " + this.crl.toString() + " ; " + new Date(System.currentTimeMillis()));
                    byteArrayInputStream.close();
                    this.revocador = this.crl.getIssuerDN().getName();
                } else {
                    this.miLog.getCat(0, "No Hay CRL ; " + new Date(System.currentTimeMillis()));
                    this.miLog.getCat(0, "No Hay CRL");
                }
            }
            lDAPAttribute = null;
            this.miLog.getCat(0, "Va a recoger el atributo authorityrevocationlist;binary ; " + new Date(System.currentTimeMillis()));
            lDAPAttribute = lDAPEntry.getAttribute("authorityrevocationlist;binary");
            if (lDAPAttribute == null) {
                this.miLog.getCat(0, "authorityrevocationlist;binary No existe -> intenta authorityrevocationlist");
                lDAPAttribute = lDAPEntry.getAttribute("authorityrevocationlist");
            }
            if (lDAPAttribute == null) {
                this.miLog.getCat(0, "No tengo ARL para -> " + this.subject + " ; " + new Date(System.currentTimeMillis()));
            } else {
                enumeration = null;
                byteArrayInputStream = null;
                enumeration = lDAPAttribute.getByteValues();
                certificateFactory = CertificateFactory.getInstance("X.509");
                this.miLog.getCat(0, "Va a recoger la ARL ; " + new Date(System.currentTimeMillis()));
                byArray = (byte[])enumeration.nextElement();
                if (byArray.length > 0) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.miLog.getCat(0, "va a generarlo -> " + (byteArrayInputStream != null));
                    this.arl = (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
                    this.miLog.getCat(0, "consigue generarlo");
                    this.miLog.getCat(0, "ARL -> " + this.arl.toString() + " ; " + new Date(System.currentTimeMillis()));
                    byteArrayInputStream.close();
                    this.revocador = this.arl.getIssuerDN().getName();
                    this.miLog.getCat(0, "Revocador -> " + this.revocador);
                } else {
                    this.miLog.getCat(0, "No Hay ARL ; " + new Date(System.currentTimeMillis()));
                    this.miLog.getCat(0, "No Hay ARL");
                }
            }
        }
        catch (Throwable throwable) {
            this.generarN38Excepcion(throwable);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getRevocador() {
        return this.revocador;
    }

    public X509CRL getCrl() {
        return this.crl;
    }

    public X509CRL getArl() {
        return this.arl;
    }

    public X509Certificate getCertificado() {
        return this.certificado;
    }

    public long getN38UltimaModificacion() {
        return this.n38UltimaModificacion;
    }

    public LDAPEntry getEntradaLDAP() {
        return this.entradaLDAP;
    }

    public void setEntradaLDAP(LDAPEntry lDAPEntry) {
        this.entradaLDAP = lDAPEntry;
    }
}

