/*
 * Decompiled with CFR 0.152.
 */
package n38i.exe.pki;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import n38i.exe.Log;
import n38i.exe.N38Constantes;
import n38i.exe.N38Excepcion;
import n38i.exe.pki.constantesPKI.N38CodigosErroresPKI;

public class N38GeneradorExcepcionCertificado
implements N38CodigosErroresPKI {
    protected Log miLog;

    public N38GeneradorExcepcionCertificado() {
        if (N38Constantes.n38Log.equalsIgnoreCase("true")) {
            this.miLog = new Log(this.getClass().getName(), N38Constantes.n38FicheroLog);
        }
    }

    public void generarN38Excepcion(Throwable throwable) throws N38Excepcion, Exception {
        if (throwable instanceof KeyStoreException) {
            throw new N38Excepcion("E032");
        }
        if (throwable instanceof InvalidKeySpecException) {
            throw new N38Excepcion("E025");
        }
        if (throwable instanceof UnrecoverableKeyException) {
            throw new N38Excepcion("E025");
        }
        if (throwable instanceof NoSuchProviderException) {
            throw new N38Excepcion("E026");
        }
        if (throwable instanceof NoSuchAlgorithmException) {
            throw new N38Excepcion("E027");
        }
        if (throwable instanceof InvalidKeyException) {
            throw new N38Excepcion("E028");
        }
        if (throwable instanceof SignatureException) {
            throw new N38Excepcion("E029");
        }
        if (throwable instanceof CertificateNotYetValidException) {
            throw new N38Excepcion("E021");
        }
        if (throwable instanceof CertificateExpiredException) {
            throw new N38Excepcion("E022");
        }
        if (throwable instanceof CRLException) {
            throw new N38Excepcion("E030");
        }
        if (throwable instanceof CertificateException) {
            throw new N38Excepcion("E025");
        }
        if (throwable instanceof N38Excepcion) {
            throw (N38Excepcion)throwable;
        }
        if (throwable instanceof IOException) {
            throw new N38Excepcion("E025");
        }
        if (N38Constantes.n38Log.equalsIgnoreCase("true")) {
            this.miLog.getCat(3, "Excepci\u00f3n Gen\u00e9rica - Certificados -> " + throwable.getMessage() + " ; " + new Date(System.currentTimeMillis()));
            this.miLog.getCat(3, "Excepci\u00f3n Gen\u00e9rica - Certificados -> " + throwable.toString() + " ; " + new Date(System.currentTimeMillis()));
        }
        throwable.printStackTrace();
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw new Exception(throwable);
        }
    }
}

