/*
 * Decompiled with CFR 0.152.
 */
package n38i.exe;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.HashMap;
import java.util.Iterator;
import n38i.exe.N38Constantes;
import n38i.exe.N38Excepcion;
import n38i.exe.N38InterfaceLog;
import n38i.exe.N38LogManager;
import stec.net.Codecs;

public class N38ProcesadorFirma {
    PrivateKey n38ClavePrivada = null;
    PublicKey n38ClavePublica = null;
    String n38AlgoritmoFirma = null;
    String n38AlgoritmoHash = null;
    private N38LogManager logManager = null;
    private N38InterfaceLog log = null;

    public N38ProcesadorFirma() {
        this.instanciarLog();
    }

    public N38ProcesadorFirma(PublicKey publicKey, String string) {
        this.n38ClavePublica = publicKey;
        this.n38AlgoritmoFirma = string;
        this.instanciarLog();
        this.log.getCat(0, "N38ProcesadorFirma (clavePublica, algoritmoFirma)");
    }

    public N38ProcesadorFirma(PrivateKey privateKey, String string) {
        this.n38ClavePrivada = privateKey;
        this.n38AlgoritmoFirma = string;
        this.instanciarLog();
        this.log.getCat(0, "N38ProcesadorFirma (clavePrivada, algoritmoFirma)");
    }

    private void instanciarLog() {
        this.logManager = N38LogManager.getInstancia();
        this.log = N38LogManager.creaLog(this.getClass().getName(), N38Constantes.n38FicheroLog);
        this.log.getCat(0, "N38ProcesadorFirma.instanciarLog ()");
    }

    public boolean n38ValidarFirma(HashMap hashMap, String string) throws N38Excepcion {
        try {
            String string2 = this.obtenerParametrosFirma(hashMap);
            Signature signature = Signature.getInstance(this.n38AlgoritmoFirma);
            signature.initVerify(this.n38ClavePublica);
            signature.update(string2.getBytes());
            hashMap = null;
            string2 = null;
            boolean bl = signature.verify(Codecs.base64Decode((byte[])string.getBytes("UTF8")));
            string = null;
            signature = null;
            this.limpiarGeneradorFirma();
            return bl;
        }
        catch (Exception exception) {
            this.log.getCat(3, "N38ProcesadorFirma.n38ValidarFirma () Exception -> " + exception);
            exception.printStackTrace();
            N38Excepcion n38Excepcion = new N38Excepcion("E220");
            n38Excepcion.setInfo(exception.getMessage());
            throw n38Excepcion;
        }
    }

    public String n38GenerarFirma(HashMap hashMap) throws N38Excepcion {
        try {
            String string = this.obtenerParametrosFirma(hashMap);
            Signature signature = Signature.getInstance(this.n38AlgoritmoFirma);
            signature.initSign(this.n38ClavePrivada);
            signature.update(string.getBytes());
            string = null;
            return new String(Codecs.base64Encode((byte[])signature.sign()), "UTF8");
        }
        catch (Exception exception) {
            this.log.getCat(3, "N38ProcesadorFirma.n38ValidarFirma () Exception -> " + exception);
            exception.printStackTrace();
            N38Excepcion n38Excepcion = new N38Excepcion();
            n38Excepcion.setInfo(exception.getMessage());
            throw n38Excepcion;
        }
    }

    private String obtenerParametrosFirma(HashMap hashMap) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (hashMap.size() > 0) {
            string = "";
            string3 = "";
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string3 = (String)hashMap.get(string2);
            string = string + string3;
        }
        iterator = null;
        string2 = null;
        string3 = null;
        return string;
    }

    private void limpiarGeneradorFirma() {
        this.n38ClavePrivada = null;
        this.n38ClavePublica = null;
        this.n38AlgoritmoFirma = null;
        this.n38AlgoritmoHash = null;
        this.log.getCat(3, "limpiarGeneradorFirma () - Ha limpiado Parametros");
    }

    public static void main(String[] stringArray) {
    }
}

