/*
 * Decompiled with CFR 0.152.
 */
package n38i.exe;

import n38i.exe.N38Excepcion;
import n38i.exe.N38LogManager;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class N38OrganizacionUsuario {
    private String raiz = null;
    private LDAPConnection conLDAP;
    private N38LogManager log = null;

    public N38OrganizacionUsuario(String string, LDAPConnection lDAPConnection) throws Exception {
        this.conLDAP = lDAPConnection;
        this.raiz = string;
    }

    public String obtenerN38OrganizacionDNI(String string) throws LDAPException, N38Excepcion, Exception {
        String string2 = null;
        String[] stringArray = new String[]{"objectclass", "dn"};
        LDAPSearchResults lDAPSearchResults = this.conLDAP.search(this.raiz, 2, "(&(objectclass=n38persona)(dni=" + string + "))", stringArray, false);
        if (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = null;
            lDAPEntry = lDAPSearchResults.next();
            string2 = lDAPEntry.getDN();
            return this.obtenerN38Organizacion(string2);
        }
        N38Excepcion n38Excepcion = new N38Excepcion("E115");
        n38Excepcion.setInfo("No se encuentra la persona -> " + string);
        throw n38Excepcion;
    }

    public String obtenerN38Organizacion(String string) throws LDAPException, N38Excepcion, Exception {
        String string2 = null;
        try {
            this.log = N38LogManager.getInstancia();
            N38LogManager.addLog(this.getClass().getName());
            N38LogManager.getCat(this.getClass().getName(), 0, "Entro en obtenerN38Organizacion;");
            N38LogManager.getCat(this.getClass().getName(), 0, "DN recibido -> " + string);
            string2 = this.obtenerValorRdnOrganizacion(string);
            N38LogManager.getCat(this.getClass().getName(), 0, "El 'o' de la organizaci\u00f3n es -> " + string2);
            String[] stringArray = new String[]{"objectclass", "o", "n38uidorg"};
            N38LogManager.getCat(this.getClass().getName(), 0, "Filtro pasado -> (&(objectclass=n38organization)(o=" + string2 + "))");
            LDAPSearchResults lDAPSearchResults = this.conLDAP.search(this.raiz, 1, "(&(objectclass=n38organization)(o=" + string2 + "))", stringArray, false);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = null;
                lDAPEntry = lDAPSearchResults.next();
                String string3 = lDAPEntry.getAttribute("n38uidorg").getStringValueArray()[0];
                N38LogManager.getCat(this.getClass().getName(), 0, "Encuentra y devuelve n38uidorg -> " + string3 + " como uid de la organizaci\u00f3n -> " + string2);
                return string3;
            }
            N38Excepcion n38Excepcion = new N38Excepcion("E115");
            n38Excepcion.setInfo("No se encuentra la Organizacion -> " + string2);
            throw n38Excepcion;
        }
        catch (LDAPException lDAPException) {
            N38LogManager.getCat(this.getClass().getName(), 3, "En obtenerN38Organizacion se ha producido la LDAPException : " + lDAPException.toString());
            throw lDAPException;
        }
        catch (Exception exception) {
            N38LogManager.getCat(this.getClass().getName(), 3, "En obtenerN38Organizacion se ha producido la Exception : " + exception.toString());
            throw exception;
        }
    }

    private String obtenerValorRdnOrganizacion(String string) {
        N38LogManager.getCat(this.getClass().getName(), 1, "Entro en obtenerValorRdnOrganizacion para DN -> " + string);
        String[] stringArray = null;
        stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
        if (stringArray != null) {
            N38LogManager.getCat(this.getClass().getName(), 1, "Longitud del array de Rdn's -> " + stringArray.length);
            N38LogManager.getCat(this.getClass().getName(), 1, "Organizacion -> " + stringArray[stringArray.length - 2]);
            return stringArray[stringArray.length - 2];
        }
        return null;
    }
}

