/*
 * Decompiled with CFR 0.152.
 */
package n38i.exe;

import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;
import n38i.exe.Log;
import n38i.exe.N38ColaElementos;
import n38i.exe.N38Constantes;
import n38i.exe.N38Excepcion;
import n38i.exe.N38ItemRoundRobin;
import n38i.exe.N38Servicio;

public class N38GestorConexiones {
    private String[] nombreServidores;
    public N38ColaElementos colaServicios;
    private long horaLLamada = 0L;
    private N38GestorConexiones instancia;
    private Log miLog;
    private boolean servidorUnico = false;

    public N38GestorConexiones(String string) throws N38Excepcion, Exception {
        String[] stringArray = (String[])N38Constantes.n38HashServidores.get(string);
        if (stringArray == null) {
            N38Excepcion n38Excepcion = new N38Excepcion("I000");
            n38Excepcion.setInfo("No se ha podido conectar con el Servidor de Seguridad pedido");
            throw n38Excepcion;
        }
        this.colaServicios = this.crearColaElementos(stringArray);
    }

    public N38GestorConexiones newInstance(String string) throws N38Excepcion, Exception {
        if (N38Constantes.n38Log.equals("true")) {
            this.miLog = new Log(this.getClass().getName(), N38Constantes.n38FicheroLog);
        }
        this.servidorUnico = false;
        return new N38GestorConexiones(string);
    }

    private static boolean tiempoEsMayor(long l, long l2) {
        return l2 > l;
    }

    private long getDiferenciaTiempo(long l, long l2) {
        return l - l2;
    }

    private N38Servicio getInstanceN38Servicio(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return new N38Servicio(stringArray[0], stringArray[1]);
    }

    private void setHoraActivacionElemento(long l, N38ColaElementos n38ColaElementos, int n) {
        N38ItemRoundRobin n38ItemRoundRobin = (N38ItemRoundRobin)n38ColaElementos.elementAt(n);
        n38ItemRoundRobin.setHoraActivacion(l);
        n38ColaElementos.updateElementAt(n, n38ItemRoundRobin);
    }

    public int getQuantumServidor(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return Integer.parseInt(stringArray[2]);
    }

    private N38ColaElementos crearColaElementos(String[] stringArray) {
        int n = stringArray.length;
        N38ColaElementos n38ColaElementos = new N38ColaElementos(n);
        for (int i = 0; i < n; ++i) {
            long l = System.currentTimeMillis();
            N38Servicio n38Servicio = this.getInstanceN38Servicio(stringArray[i]);
            long l2 = this.getQuantumServidor(stringArray[i]);
            n38ColaElementos.encolarElemento(new N38ItemRoundRobin(l, n38Servicio, l2));
        }
        return n38ColaElementos;
    }

    private synchronized N38Servicio obtenerServicioValido() {
        N38ItemRoundRobin n38ItemRoundRobin = (N38ItemRoundRobin)this.colaServicios.obtenerPrimero();
        N38Servicio n38Servicio = n38ItemRoundRobin.getServicio();
        long l = n38ItemRoundRobin.getQuantum();
        long l2 = n38ItemRoundRobin.gethoraActivacion();
        if (this.getDiferenciaTiempo(System.currentTimeMillis(), l2) > l) {
            if (this.colaServicios.size == 1) {
                this.setHoraActivacionElemento(System.currentTimeMillis(), this.colaServicios, 0);
            } else {
                this.setHoraActivacionElemento(System.currentTimeMillis(), this.colaServicios, 1);
                N38ItemRoundRobin n38ItemRoundRobin2 = (N38ItemRoundRobin)this.colaServicios.desencolarPrimero();
                this.colaServicios.encolarElemento(n38ItemRoundRobin2);
            }
            n38Servicio = this.obtenerServicioValido();
        }
        return n38Servicio;
    }

    private N38Servicio n38ObtenerDireccionServicio() {
        return this.obtenerServicioValido();
    }

    private Socket tratarSocketException() throws N38Excepcion {
        Socket socket = null;
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            throw new N38Excepcion("E115");
        }
        if (this.colaServicios.size == 1) {
            this.servidorUnico = true;
            this.setHoraActivacionElemento(System.currentTimeMillis(), this.colaServicios, 0);
        } else {
            this.setHoraActivacionElemento(System.currentTimeMillis(), this.colaServicios, 1);
            N38ItemRoundRobin n38ItemRoundRobin = (N38ItemRoundRobin)this.colaServicios.desencolarPrimero();
            this.colaServicios.encolarElemento(n38ItemRoundRobin);
        }
        socket = this.n38ObtenerConexion();
        return socket;
    }

    public synchronized Socket n38ObtenerConexion() throws N38Excepcion {
        boolean bl;
        Socket socket = null;
        if (this.horaLLamada == 0L) {
            this.horaLLamada = System.currentTimeMillis();
        }
        boolean bl2 = bl = this.getDiferenciaTiempo(System.currentTimeMillis(), this.horaLLamada) > Long.parseLong(N38Constantes.n38TimeOutGestorConexiones);
        if (bl) {
            this.horaLLamada = 0L;
            throw new N38Excepcion("I000");
        }
        try {
            N38Servicio n38Servicio = this.n38ObtenerDireccionServicio();
            if (n38Servicio.getHostName() == null) {
                // empty if block
            }
            String string = n38Servicio.getHostName();
            int n = Integer.parseInt(n38Servicio.getPort());
            socket = new Socket(InetAddress.getByName(string), n);
            socket.setSoTimeout(Integer.parseInt(N38Constantes.n38TimeOutInputStream));
        }
        catch (Exception exception) {
            socket = this.tratarSocketException();
        }
        this.horaLLamada = 0L;
        return socket;
    }

    public void imprimirCola() {
    }
}

