/*********************************************************************/

/**********************   IDIOMA  ************************/

/*********************************************************************/

var CASTELLANO = 1;

var EUSKERA = 2;

//*******************************************************************************

// * Funcin:	validarArrayLLeno (lOArray, lIntDimension)						*

// *                                                                          	*

// * Objetivo:	Valida que un array tenga todas sus posiciones con un valor		*

// *            en caso de que alguna posicin estuviese a null, se escribe     *

// *            un blanco                                                       *

// *                                                                            *

// * Parmetros: lOArray - Array a validar										*

// *			 lIntDimension - dimensin del array							*

// *																			*

// * Retorno:	Devuelve el array con las posiciones que estuviesen a null		*

// *			a blanco														*

//*******************************************************************************

function validarArrayLLeno (lOArray, lIntDimension)

{

	if (lIntDimension==1)

		for (var i=0; i<lOArray.length; i++)

			if (lOArray[i]==null)

			{

				lOArray[i]="";

				break;

			}

	else

		for (var j=0; j<lOArray.length; j++)

			lOArray[j]=validarArrayLLeno(lOArray[j], lIntDimension-1);

	return lOArray;

}





//*******************************************************************************

// * Funcin:	trim (lStrCadena)												*

// *                                                                          	*

// * Objetivo:	Elimina los espacios en blanco que haya al principio y al final *

// *			de la cadena													*

// *                                                                            *

// * Parmetros:lStrCadena - string												*

// *																			*

// * Retorno:	Devuelve la cadena sin espacios en blanco al principio ni al	*

// *			final															*

//*******************************************************************************

function trim (lStrCadena)

{

	while (lStrCadena.toString().indexOf(" ")==0)

		lStrCadena = lStrCadena.toString().substring (1, lStrCadena.length)

	//Eliminar espacios por detrs

	while (lStrCadena.toString().charAt (lStrCadena.toString().length-1) == " ")

		lStrCadena = lStrCadena.toString().substring (0, lStrCadena.toString().length-1);

	return lStrCadena;

}



/*****************************************************************************************/

/********** FUNCIN:  validarLetrasDistintas (lStrCadena)							**************/

/********** ------------------------------------							**************/

/********** 				   						 									 */

/********** Descripcin:		Funcin que trata una cadena de caracteres				 */

/********** Parmetros:			lStrCadena - cadena de texto a validar					 */

/********** Retorno: 			Retorna true si todos sus componentes son letras, vocales*/

/********** 					con acentos,  o ,	false en caso contrario.			 */

/*****************************************************************************************/

function validarLetrasDistintas (lStrCadena){



	var ok=true;

	var i;

	lStrCadena=lStrCadena.toUpperCase();

	for (i=0;i<lStrCadena.length;i++)

	{

		if((lStrCadena.charCodeAt(i)<65&&lStrCadena.charCodeAt(i)!=32)||(lStrCadena.charCodeAt(i)>90&&lStrCadena.charCodeAt(i)!=166&&lStrCadena.charCodeAt(i)!=167&&lStrCadena.charCodeAt(i)!=193&&lStrCadena.charCodeAt(i)!=201&&lStrCadena.charCodeAt(i)!=205&&lStrCadena.charCodeAt(i)!=211&&lStrCadena.charCodeAt(i)!=218&&lStrCadena.charCodeAt(i)!=209&&lStrCadena.charCodeAt(i)!=220))

		{

			ok=false;

			break;

		}

	}

	return ok;

}





/*****************************************************************************************/

/********** FUNCIN:  validarNumeros (lStrCadena)							**************/

/********** --------------------------------------------------------		**************/

/********** 				   						 									 */

/********** Descripcin:		Funcin que trata una cadena numrica					 */

/********** Parmetros:			lStrCadena - cadena de numeros a validar				 */

/********** Retorno: 			Retorna true si todos sus componentes son nmeros		 */

/*****************************************************************************************/

function validarNumeros (lStrCadena){



	var ok=true;

	var i;

	for (i=0;i<lStrCadena.length;i++)

	{

		if((lStrCadena.charCodeAt(i)<48)||(lStrCadena.charCodeAt(i)>57))

		{

			ok=false;

			break;

		}

	}

	return ok;

}





/*****************************************************************************************/

/********** FUNCIN:  validarNumerosDecimales (lStrCadena)					**************/

/********** -----------------------------------------------					**************/

/********** 				   						 									 */

/********** Descripcin:		Funcin que trata una cadena numrica con decimales		 */

/********** Parmetros:			lStrCadena - cadena de numeros a validar				 */

/********** Retorno: 			Retorna true si todos sus componentes son nmeros o si 	 */

/**********			 			tiene un punto o una coma							 	 */

/*****************************************************************************************/

function validarNumerosDecimales (lStrCadena)

{

	var ok=true;

	var contador = 0

	var i;

	for (i=0;i<lStrCadena.length;i++)

	{

		if((lStrCadena.charCodeAt(i)<46 || lStrCadena.charCodeAt(i)>57) &&

			lStrCadena.charCodeAt(i) != 44 && lStrCadena.charCodeAt(i) != 46)

		{

			ok=false;

			break;

		}



		if (lStrCadena.charCodeAt(i) == 44 || lStrCadena.charCodeAt(i) == 46)

		{

			if (contador == 1)

			{

				ok=false;

				break;

			}

			else

				contador++;

		}

	}

	return ok;

}



//Esta funcin valida una fecha en formato dd/mm/yyyy, admite formatos

// con separadores y sin ellos.

function validarFecha(Objeto, Requerida, Avisar, idioma, strMensaje)

{

	var varNumeros = "0123456789";

	var varI;

	var varSeparador = "";	//El separador que se ha introducido

	var varNumSeparadores = 0;



	var varFecha;

        var dia;

        var mes;

        var anio;

	var varDia, varNumDia;

	var varMes, varNumMes;

	var varAnio, varNumAnio;

	var varTemp;

	//Si no es requerida se admite un valor vacio

	//if (Objeto.value == "" && Requerida == false) return true;



        // ** 14/03/2003 ** Los campso requeridos se comprueban al grabar

        if (Objeto.value == "") return true;



        varFecha = Objeto.value;



	for (varI = 0; varI < varFecha.length; varI++)

	{

		if (-1 == varNumeros.indexOf(varFecha.charAt(varI)))

		{

			if (varSeparador == "")

			{

				varSeparador = varFecha.charAt(varI);

				varNumSeparadores = 1;

			}

			else

			{

				if (varSeparador != varFecha.charAt(varI))

				{

					if (Avisar){

						 window.alert(strMensaje);

                                                 Objeto.select();

						 Objeto.focus();

					}

					return false;

				}

				else

				{

					varNumSeparadores = varNumSeparadores + 1

				}

			}

		}

	}



	//Aqu la fecha consta de todo dgitos y puede llevar un tipo de separador



	//Hay que construir una fecha con separadores

	if (varNumSeparadores == 0)

	{

		switch (varFecha.length)

		{

			case 6:	// ddmmyy o yymmdd

                                varFecha = varFecha.substr(0, 2) + "/" + varFecha.substr(2, 2) + "/" + varFecha.substr(4, 2);

				break;

			case 7:	//ddmmyyyy o yyymmdd

                                if (idioma==CASTELLANO){

                                  varFecha = varFecha.substr(0, 2) + "/" + varFecha.substr(2, 2) + "/" + varFecha.substr(4, 3);

				}else{

                                  varFecha = varFecha.substr(0, 3) + "/" + varFecha.substr(3, 2) + "/" + varFecha.substr(5, 2);

                                }

                                break;

			case 8:	// ddmmyyyy o yyyymmdd

                                if (idioma==CASTELLANO){

				  varFecha = varFecha.substr(0, 2) + "/" + varFecha.substr(2, 2) + "/" + varFecha.substr(4, 4);

				}else{

                                  varFecha = varFecha.substr(0, 4) + "/" + varFecha.substr(4, 2) + "/" + varFecha.substr(6, 2);

                                }

                                break;

			default:

				if (Avisar){

					window.alert(strMensaje);

                                        Objeto.select();

					Objeto.focus();

				}

				return false;

		}

	}

	else

	{

		if (varNumSeparadores != 2)

		{

			if (Avisar){

				 window.alert(strMensaje);

                                 Objeto.select();

				 Objeto.focus();

			}

			return false;

		}

		else //Cambiar el separador existente por /

		{

			varTemp = varFecha.split(varSeparador);

			varFecha = varTemp[0] + "/" + varTemp[1] + "/" + varTemp[2];

		}

	}



	//Tengo una fecha con dos separadores, se harn las correcciones

	//necesarias si se considera oportuno

	varTemp = varFecha.split("/");

        if (idioma==CASTELLANO){

          varDia = varTemp[0];

          varMes = varTemp[1];

          varAnio = varTemp[2];

        }else{

          varAnio = varTemp[0];

          varMes = varTemp[1];

          varDia = varTemp[2];

        }



	if (varDia.substr(0, 1) == "0") varDia = varDia.substr(1, 1);

	if (varMes.substr(0, 1) == "0") varMes = varMes.substr(1, 1);



	varNumDia = parseInt(varDia);

	varNumMes = parseInt(varMes);

	varNumAnio = parseInt(varAnio,10);

	if (varNumAnio < 29)

	{

		varNumAnio = varNumAnio + 2000;

	}

	if (varNumAnio <= 99)

	{

		varNumAnio = varNumAnio + 1900;

	}

	if((varNumAnio>99)&&(varAnio.length==3))

	{

		if (Avisar)

		{

			window.alert(strMensaje);

                        Objeto.select();

			Objeto.focus();

		}

		return false;

	}



	varAnio = varNumAnio;



	varTemp = new Date(varNumAnio, varNumMes -1 , varNumDia);

	if (varTemp.getMonth() != (varNumMes - 1))

	{

		if (Avisar){

			 window.alert(strMensaje);

                         Objeto.select();

			 Objeto.focus();

		}

		return false;

	}



	while(varDia.length < 2)

	{

		varDia = "0" + varDia;

	}

	while(varMes.length < 2)

	{

		varMes = "0" + varMes;

	}

	while(varAnio.length < 4)

	{

		varAnio = "0" + varAnio;

	}



        if (idioma==CASTELLANO){

            varFecha = varDia + "/" + varMes + "/" + varAnio;

        }else{

            varFecha = varAnio + "/" + varMes + "/" + varDia;

        }

	Objeto.value = varFecha;

	return true;

}

// funcin que cierra una ventana

function Salir(){

    top.close();

}

/****************************************************************************************/

/********** FUNCIN: aniadirElementoArray (IOArray,indice,valor)                    *****/

/********** ----------------------------------------------------------------------	*****/

/********** 				   						 									*/

/********** Descripcin: Aade un elemento en un array en una posicin determinada	    */

/**********																				*/

/********** Parmetros:			indice - Posicin donde realizamos la insercin			*/

/**********					valor - Valor a insertar									*/

/**********					IOArray - Array a modificar									*/

/********** Retorno: 			Retorna el array con el elemento en esa posicin		*/

/****************************************************************************************/



function aniadirElementoArray(IOArray,indice,valor)

{

var tamanio=IOArray.length;

var indiceValido=(indice!="NaN");

var rangoValido=((indice>=0)&&(indice<=IOArray.length+1));

if (indiceValido && rangoValido){

for (var i=IOArray.length+1;i>indice;i--)

	IOArray[i]=IOArray[i-1];

IOArray[indice]=valor;

IOArray.length=IOArray.length-1;

}

}



/*****************************************************************************************/

/********** FUNCIN:  cogerDiasMes (lIntmes,lIntanno)							**************/

/********** ------------------------------------							**************/

/********** 				   						 									 */

/********** Descripcin:		Funcin que calcula el nmero de dias de un mes		     */

/********** Parmetros:			lIntmes - Nmero del mes					             */

/**********						lIntanno - Anno                                          */

/********** Retorno: 			Retorna el nmero de das de un mes						 */

/*****************************************************************************************/



function cogerDiasMes(lIntmes, lIntanno) {

        // crear un array para contener el numero de dias del mes



        var ar = new Array(12);



        ar[0] = 31; // Enero

        ar[1] = (esBisiestoAnyo(lIntanno)) ? 29 : 28 // Febrero

        ar[2] = 31; // Marzo

        ar[3] = 30; // Abril

        ar[4] = 31; // Mayo

        ar[5] = 30; // Junio

        ar[6] = 31; // Julio

        ar[7] = 31; // Agosto

        ar[8] = 30; // Septiembre

        ar[9] = 31; // Octubre

        ar[10] = 30; // Noviembre

        ar[11] = 31; // Dicienbre



        // devuelve el numero de dias del mes

        return ar[lIntmes-1];

}



function esBisiestoAnyo(lIntanyo){

//****************************************************************************************/

/********** FUNCIN:  esBisiestoAnyo (lIntanyo)									**************/

/********** ------------------------------------							**************/

/********** 				   						 									 */

/********** Descripcin:		Funcin que indica si un ao es bisiesto o no			 */

/********** Parmetros:			lIntanyo -Anyo  									     */

/********** Retorno: 			Devuelve si es o no bisiesto 						     */

//****************************************************************************************/

	//Comprobamos si el ao es bisiesto o no.

	//Si Ao mod 4 == 0 --> Bisiesto

	if ((lIntanyo % 4)==0)

	{

		return true;

	}

	else

		return false;

}



function fncTruncarString (strPfCadena, intPfPosicionDesde, intPfPosicionHasta) {

//*****************************************************************************************************/

/********** FUNCIN:  fncTruncarString (strPfCadena, intPfPosicionDesde, intPfPosicionHasta) **********/

/********** -------------------------------------------------------------------------------  **********/

/********** 				   						 									              */

/********** Descripcin:		Funcin que devuelve el substring del string pasado comprendido entre */

/**********							intPfPosicionDesde y intPfPosicionHasta.                          */

/********** Parmetros:		intPfPosicionDesde : posicion de inicio                                   */

/**********							intPfPosicionHasta : posicion de fin                              */

/********** Retorno: 			String                                                                */

//*****************************************************************************************************/



	//Sidweb

	return strPfCadena.substring (intPfPosicionDesde, intPfPosicionHasta-3)+"...";

}



function fncFiltrar (lOCaracteres, lStrValor) {

//****************************************************************************************/

/********** FUNCIN:  fncFiltrar (lOCaracteres, lStrValor)						**********/

/********** --------------------------------------------------------------------**********/

/********** 				   						 									 */

/********** Descripcin:	Funcin que devuelve un string con los caracteres		     */

/**********							extraos ya eliminados.                              */

/********** Parmetros:		lOCaracteres : array de caracteres extraos					 */

/**********					lStrValor : cadena que se quiere comparar					 */

/********** Retorno: 		String                                                       */

//****************************************************************************************/

	if ((lOCaracteres == null) ||(lOCaracteres == "")) {

		lOCaracteres[0] = '"';

		lOCaracteres[1] = '<';

		lOCaracteres[2] = '>';

	}

	var cadenaDefinitiva ="";

	var valorValido = true;



	for (i=0; i<lStrValor.length; i++){

		valor = lStrValor.substr(i,1);

		valorValido = true;



		for (caracter = 0;caracter<lOCaracteres.length;caracter++){

			if (valor == lOCaracteres[caracter])

				valorValido = false;

		}

		if (valorValido)

			cadenaDefinitiva = cadenaDefinitiva + valor;

	}



	return cadenaDefinitiva;

}



//****************************************************************************************/

/********** FUNCIN:  cambiarEstiloIconoFatoriaP (lBPulsar,lStrIdIcono,lBMouseOver)*******/

/********** --------------------------------------------------------------------**********/

/********** 				   			    					     */

/********** Descripcin:	Funcin que cambia el estilo del borde de los iconos	     */

/********** Parmetros:		lBPulsar : true:marcar en el onclick;false:no		     */

/**********				lStrIdIcono :identificador del icono	     		     */

/**********				lBMouseOver :true:marcar en el onmouseover	           */

/********** Retorno: 			                                                     */

//****************************************************************************************/

function cambiarEstiloIconoFactoriaP (lBPulsar, lStrIdIcono,lBMouseOver)

{

  if (lBPulsar==true)

	 eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #ff8000\" ");

  else if (lBPulsar==false)

	 eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #d6deef\" ");

  else

  {

    if (eval("document.all."+lStrIdIcono+".style.border!='#ff8000 thin solid'"))

		{

		  if (lBMouseOver)

			eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #ffffc0\" ")

		  else

			eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #d6deef\" ")

		}

  }

}



//****************************************************************************************/

/********** FUNCIN:  cambiarEstiloIconoSuperiorFatoriaP (lBPulsar,lStrIdIcono,lBMouseOver)*******/

/********** --------------------------------------------------------------------**********/

/********** 				   			    					     */

/********** Descripcin:	Funcin que cambia el estilo del borde de los iconos	     */

/********** Parmetros:		lBPulsar : true:marcar en el onclick;false:no		     */

/**********				lStrIdIcono :identificador del icono	     		     */

/**********				lBMouseOver :true:marcar en el onmouseover	           */

/********** Retorno: 			                                                     */

//****************************************************************************************/

function cambiarEstiloIconoSuperiorFactoriaP (lBPulsar, lStrIdIcono,lBMouseOver)

{

  if (lBPulsar==true)

	 eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #ff8000\" ");

  else if (lBPulsar==false)

	 eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #3973a5\" ");

  else

  {

    if (eval("document.all."+lStrIdIcono+".style.border!='#ff8000 thin solid'"))

		{

		  if (lBMouseOver)

			eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #ffffc0\" ")

		  else

			eval ("document.all." + lStrIdIcono + ".style.border = \"thin solid #3973a5\" ")

		}

  }

}



function objCampoFechaValidarFormato(lStrFormato,lStrValor){

	var formato=""

	lStrValor=trim(lStrValor);

	var ValorValido=false;

	var lIntDia;

	var lIntMes;

	var lIntAnyo;

	

	if(formato=="")

		formato=lStrFormato;

		

	switch(formato.length)

	{

		case 10:			parte1=formato.substr(0,1);

			

			if((parte1=='D')||(parte1=='M'))

			{			

				separador1=formato.substr(2,1);		

				posicionseparador1=2;

				parte2=formato.substr(3,1);



				if((parte2=='D')||(parte2=='M')){

					separador2=formato.substr(5,1);

					posicionseparador2=5;

					parte3='Y';

				}

				else if(parte2=='Y'){

					separador2=formato.substr(7,1);

					posicionseparador2=7;

					parte3=formato.substr(8,1);

				}

			}

			else if(parte1=='Y'){

				separador1=formato.substr(4,1);

				posicionseparador1=4;

				parte2=formato.substr(5,1);

				separador2=formato.substr(7,1);

				posicionseparador2=7;

				parte3=formato.substr(8,1);

			}

			break;

		case 8:

			parte1=formato.substr(0,1);

			

			separador1=formato.substr(2,1);

			posicionseparador1=2;

			parte2=formato.substr(3,1);

			

			separador2=formato.substr(5,1);

			posicionseparador2=5;

			parte3=formato.substr(6,1);

			break;

	}		



	if(lStrFormato.length==lStrValor.length)

	{

		

		

		

		

		

		valorValido=true;

		switch(formato.length){

			case 10:				parte1=formato.substr(0,1);

				if(parte1=='D') lIntDia=lStrValor.substr(0,2);

				if(parte1=='M') lIntMes=lStrValor.substr(0,2);

				

				if((parte1=='D')||(parte1=='M')){			

					separador1=formato.substr(2,1);		

					posicionseparador1=2;

					parte2=formato.substr(3,1);



					if((parte2=='D')||(parte2=='M')){

						if(parte2=='D') lIntDia=lStrValor.substr(3,2);

						if(parte2=='M') lIntMes=lStrValor.substr(3,2);

						separador2=formato.substr(5,1);

						posicionseparador2=5;

						parte3='Y';

						lIntAnyo=lStrValor.substr(6,4);

					}

					else if(parte2=='Y'){

						lIntAnyo=lStrValor.substr(3,4);

						separador2=formato.substr(7,1);

						posicionseparador2=7;

						parte3=formato.substr(8,1);

						if(parte3=='D') 

							lIntDia=lStrValor.substr(8,2);

						else	

							lIntMes=lStrValor.substr(8,2);

						

					}

				}

				else if(parte1=='Y'){

					lIntAnyo=lStrValor.substr(0,4);

					separador1=formato.substr(4,1);

					posicionseparador1=4;

					parte2=formato.substr(5,1);

					if(parte2=='D'){

						lIntDia=lStrValor.substr(5,2);

						lIntMes=lStrValor.substr(8,2);

					}

					else{

						lIntDia=lStrValor.substr(8,2);

						lIntMes=lStrValor.substr(5,2);

					}

					separador2=formato.substr(7,1);

					posicionseparador2=7;

					parte3=formato.substr(8,1);

				}

				break;

	

			case 8:

				parte1=formato.substr(0,1);

				if(parte1=='D') 	  lIntDia=lStrValor.substr(0,2);

				else if(parte1=='M') lIntMes=lStrValor.substr(0,2);

				else if(parte1=='Y') lIntAnyo=lStrValor.substr(0,2);

				

				separador1=formato.substr(2,1);

				posicionseparador1=2;

				parte2=formato.substr(3,1);

				if(parte2=='D') 	  lIntDia=lStrValor.substr(3,2);

				else if(parte2=='M') lIntMes=lStrValor.substr(3,2);

				else if(parte2=='Y') lIntAnyo=lStrValor.substr(3,2);

				

				separador2=formato.substr(5,1);

				posicionseparador2=5;

				parte3=formato.substr(6,1);

				if(parte3=='D') 	  lIntDia=lStrValor.substr(6,2);

				else if(parte3=='M') lIntMes=lStrValor.substr(6,2);

				else if(parte3=='Y') lIntAnyo=lStrValor.substr(6,2);

				break;

		}		

		if((!isNaN(lIntDia))&&(!isNaN(lIntMes))&&(!isNaN(lIntAnyo)))

		{

			this.diaMas=parseInt(lIntDia,10);

			this.mes=parseInt(lIntMes,10);

			this.anyo=parseInt(lIntAnyo,10);

			if((lIntDia>0)&&(lIntMes>0)&&(lIntAnyo>0))

			{

				if((lStrValor.substr(posicionseparador1,1)!=separador1)||(lStrValor.substr(posicionseparador2,1)!=separador2))

				{

					valorValido=false;

				}

				else{

					if(this.mes>12) 

						valorValido=false;

					else{

						var ndias=cogerDiasMes(this.mes,this.anyo);

						if(this.diaMas>ndias)

							valorValido=false;

					}

				}

			}

			else

				valorValido=false;	



		}else

			valorValido=false;

	}

	else

	{

		valorValido=false;



		if((((lStrValor.length==5)||(lStrValor.length==6)||(lStrValor.length==7)) &&(formato.length==8) )||

		(((lStrValor.length==5)||(lStrValor.length==6)||(lStrValor.length==7)||(lStrValor.length==8)||(lStrValor.length==9)) &&(formato.length==10)) )

		{

			lBValido=false;



			parteFecha1=lStrValor.split(separador1);	

			parteFecha2=new Array();

			parteFecha2[0]=null;

			parteFecha2[1]=null;

			

			if((parteFecha1[0]!=null) &&(parteFecha1[0]!="") &&(parteFecha1[1]!=null) &&(parteFecha1[1]!="") )

			{

				if(separador1 !=separador2 )

				{

					parteFecha2=parteFecha1[1].split(separador2);

				}

				else

				{	

					if((parteFecha1[1]!=null) &&(parteFecha1[1]!="") &&(parteFecha1[2]!=null) &&(parteFecha1[2]!="") )

					{

						parteFecha2[0]=parteFecha1[1];

						parteFecha2[1]=parteFecha1[2];

					}

				}



			}



			if((parteFecha1[0]!=null) &&(trim(parteFecha1[0])!="") &&(parteFecha2[0]!=null) &&(trim(parteFecha2[0])!="") &&(parteFecha2[1]!=null) &&(trim(parteFecha2[1])!="") )

			{

				lBValido=true;

			}



			if(isNaN(lStrValor) &&(lBValido) )

			{



				valorValido=true;



				if(parte1=="D") lIntDia=parteFecha1[0];

				else if(parte1=="M") lIntMes=parteFecha1[0];

				else if(parte1=="Y") lIntAnyo=parteFecha1[0];

				

				if(parte2=="D") lIntDia=parteFecha2[0];

				else if(parte2=="M") lIntMes=parteFecha2[0];

				else if(parte2=="Y") lIntAnyo=parteFecha2[0];

					

				if(parte3=="D") lIntDia=parteFecha2[1];

				else if(parte3=="M") lIntMes=parteFecha2[1];

				else if(parte3=="Y") lIntAnyo=parteFecha2[1];



				if(lIntAnyo.length==3)

					valorValido=false;

			}

		}



		if((valorValido==true) &&(!isNaN(lIntDia)) &&(!isNaN(lIntMes)) &&(!isNaN(lIntAnyo)) 

			&&(lIntDia.length<=2) &&(lIntMes.length<=2) &&(lIntAnyo.length<=4) )

		{	

			lIntDia=parseInt(lIntDia,10);			

			lIntMes=parseInt(lIntMes,10);

			lIntAnyo=parseInt(lIntAnyo,10);

			

			

			if(lIntDia==0||lIntMes==0)

				valorValido=false;

			else

			{

				result=this.crearFormatoFecha(lIntDia,lIntMes,lIntAnyo);

				this.setValorCampoFecha(result);

			}

		}

		else

			valorValido=false;

	}

	return valorValido

}