/**
 * 
 */
package com.ejie.aa21b.service;
import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebParam.Mode;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Use;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.ejie.aa21b.model.ws.ErrorWs;
import com.ejie.aa21b.model.ws.ExpedientesWs;
import com.ejie.aa21b.model.ws.WhereWs;
import com.ejie.aa21b.service.ws.ExpedientesWsService;

/**
 *  
 *
 */
@WebService(name = "AA21BExpedientes", portName = "AA21BExpedientesPort", targetNamespace = "http://com.ejie.aa21b")
@SOAPBinding(parameterStyle = ParameterStyle.BARE,use=Use.LITERAL)
@HandlerChain(file = "server-handlers.xml")

public class OrgDocumentalWebServiceImpl  implements OrgDocumentalWebService{

	private static final Logger logger = LoggerFactory
	.getLogger(OrgDocumentalWebServiceImpl.class);
	
	@Resource
	private WebServiceContext context;

	
	/**
	 * 
	 */
	public OrgDocumentalWebServiceImpl() {
		// TODO Auto-generated constructor stub
	}

	
	@WebMethod
	@WebResult(name = "actualizaExpedientesResponse")
	public ExpedientesWs actualizaExpedientes() {
		
		OrgDocumentalWebServiceImpl.logger.info("INICIO actualizaExpedientes");
		
		ErrorWs error;
		
		// invocar negocio
		ExpedientesWs listaExpedientes =null;
		
		try{
			ExpedientesWsService service = null;
			
			//service = new RTTAConsulCtaServiceImpl();
			ServletContext servletContext = (ServletContext) context.getMessageContext().get("javax.xml.ws.servlet.context");
			WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
			
			AutowireCapableBeanFactory aa=webApplicationContext.getAutowireCapableBeanFactory();
			
			service = (ExpedientesWsService) aa.getBean("expedientesWsService");
						
			listaExpedientes = service.obtenerExpedientesActualiza();
			
			logger.info("actualizaExpedientes  - Fin");
		}catch (Exception e){
	   	 	logger.error("actualizaExpedientes  - ERROR: " + e.getMessage());
			error = new ErrorWs();
			error.setCodigoError(ErrorWs.ERROR_ACTUALIZAEXP);
			error.setDescripcionCastellano(ErrorWs.ERROR_ACTUALIZAEXP);
			error.setDescripcionEuskera(ErrorWs.ERROR_ACTUALIZAEXP);
			listaExpedientes.setError(error);

	    }
		
		
		return listaExpedientes;

	}
	

	@WebMethod
	@WebResult(name = "buscaExpedientesResponse")
	public ExpedientesWs buscaExpedientes(
			@WebParam(mode = Mode.IN) WhereWs whereEntrada) {
		
		
		// invocar negocio
		ExpedientesWs expedientesBuscados =null;
		
		try{
			ExpedientesWsService service = null;
			
			//service = new RTTAConsulCtaServiceImpl();
			ServletContext servletContext = (ServletContext) context.getMessageContext().get("javax.xml.ws.servlet.context");
			WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext);
			
			AutowireCapableBeanFactory aa=webApplicationContext.getAutowireCapableBeanFactory();
			
			service = (ExpedientesWsService) aa.getBean("expedientesWsService");
						
			expedientesBuscados = service.obtenerExpedientesBusca(whereEntrada);
			
		}catch (Exception e){
	   	 	logger.error("buscaExpedientes  - ERROR: " + e.getMessage());
	    }
		
		
		return expedientesBuscados;

	}

}
