var dialogoConsultaEspedientesAsociados = {
//var idioma=$.rup.lang;
 codigoEnvioAsig:null,
 inicializado:false,
 expeId:null,
 expeCod:null,
 configMsgEspera : {
		centerX : true,
		centerY : false,
		css : {
			width : "430px",
			height : "120px",
			top : "240px",
			textAlign : "center",
			backgroundColor : "#FFFFFF",
			color : "#666666",
			cursor : "wait"
		},
		overlayCSS : {
			backgroundColor : '#131313',
			opacity : 0.6
		},
		message : getJQueryWaitWindowMsg(jQuery.rup.i18n.app.comun.msgCargando)
	},
	/**
	 * Abre el dialogo princila de fases. Expediente es el identificados, codigo es la referencia del expediente
	 */
	abrirDialogo:function(expediente,codigo){
		this.expeId=expediente;
		this.expeCod=codigo;
		this.init();
		$("#dialogoExpAsociado").rup_dialog("open");
	},
	/**
	 * inicializa los componentes
	 */
	init:function(){
		if(!this.inicializado){
			this.inicializado=true;

			jQuery("#consultaExpAsociado_feedback").rup_feedback({
				type: "ok",
				closeLink: true,
				fadeSpeed: 600,
				block:false
			});
			$("#ConsultaExpAsociado_toolbar").rup_toolbar({
				buttons:[{
					id:"fases",
					i18nCaption:$.rup.i18n.app.btnExpediente.fases,
					css:"fases",
					click: dialogoConsultaEspedientesAsociados.revisionFasesExpedienteAsig
				},
				{
					id:"documentos",
					i18nCaption:$.rup.i18n.app.btnExpediente.documentos,
					css:"documentos",
					click: dialogoConsultaEspedientesAsociados.handlerDocumentosAsig
				},
				{
					id:"historico",
					i18nCaption:$.rup.i18n.app.btnExpediente.historico,
					css:"historico",
					click: dialogoConsultaEspedientesAsociados.revisionHistoricoResponsablesAsig
				},
				{
					id : "excel",
					i18nCaption:$.rup.i18n.app.btnExpediente.excel,
			        css : "excel right_button",
			        right : true,
			        click : dialogoConsultaEspedientesAsociados.handlerExcelAsig
				},
				{
					id:"imprimir",
					i18nCaption:$.rup.i18n.app.btnExpediente.imprimir,
					css:"imprimir right_button",
					right: true,
					click: dialogoConsultaEspedientesAsociados.handlerImprimirAsig
				}
				]
			});

			//Combo tipos expedientes
			$("#cexpe20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "500",
				blank: "",
				selected:"",
				change:function(){
					/**
					 * Obtención de datos del tipo expediente 
					 * Al cambiar en el combo, obtenemos el valor del campo ctrami02
					 * para saber si es tramitable (1) o no tramitable (!=1)
					 */
					jQuery
					.ajax({
						type : "GET",
						dataType : "json",
						url : "../aa21b02s01/" + $("#cexpe20_consulta_table").val(),
						cache : false,
						success : function(xhr, response) {
							datosTipoExp = xhr;
							if(datosTipoExp != null){
								var tramitable = datosTipoExp.ctrami02;
								$("#cserv20_consulta_table").val(datosTipoExp.cserv02);
								if(tramitable != "1"){
									expedienteNoTramitable();
								}else{
									expedienteTramitable();
								}
							}
						}
					});
					return false;
				}
			});

			//Combo usuarios expedientes
			$("#crespo20_consulta_table").rup_combo({
				source: "../aa21b20s01/comboResponsablesServicio",
				sourceParam : {
					label : "dusu15",
					value : "cusu15"
				},
				parent: ["cexpe20_consulta_table"],
				width : 555,
				showValue: true,
				token: " - ",
				method : 'GET'
			});

			//Combo estados expedientes
			$("#cesta20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "150",
				blank: "",
				selected:"",
				style: "dropdown",
				onLoadSuccess: function(){
					$("#cesta20_consulta_table").rup_combo("selectLabel", $("cesta20_consulta_table").val());
				}
			});

			//Fechas
			$("#faper20_consulta_table").rup_date();
			$("#fcier20_consulta_table").rup_date();
			$("#fvto20_consulta_table").rup_date();

			var idExpe = $("#idExpeAsoc").val();

			$("#cexpe20_consulta_table").rup_combo("disable");

			$("#dialogoExpAsociado").rup_dialog({
					type:$.rup.dialog.DIV,
					//url:"/aa21bOrgDocumentalWar/aa21b20s01/consultarexpedienteasociado?idexpeasoc="+idExpeAsoc,
					modal:true,
					height:850,
					width:950,
					resizable:false,
					title:$.rup.i18n.app.aa21b20s01.consultaExpedienteTit + " ",// + refExp,
					autoOpen:false,
					showLoading:true,
					async:false,
					open:this.cargarDatos
			});

			jQuery("#dialogoExpAsociado").on("dialogclose", function() {
				$("#botoneraConsultaExpAsociado").hide();
				//$("#dialogoExpAsociado").rup_dialog("destroy");
				$("#ConsultaExpAsociado_detail_div").hide();
				$("#dialogoEsperaAsoc").show();
			});

			//Combo ubicacion expedientes
			$("#carchi20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "555",
				blank: "",
				selected:""
			});

			//Combo departamentos expedientes
			$("#depar20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "555",
				blank: "",
				selected:""
			});

			//Combo paises 
			$("#cpais20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "180",
				blank: "",
				selected:""
			});
			
			//Combo provincias 
			$("#cprov20_consulta_table").rup_combo({
				loadFromSelect:true,
				width : "180",
				blank: "",
				selected:""
			});

			//Combo municipios
			$("#cmuni20_consulta_table").rup_combo({
				source : "../nora/municipioExp",
				sourceParam : {label:"dsO", value:"id"},
				parent: ["cprov20_consulta_table"],
				width : "400",
				blank : ""
			});
		}

		$("#botoneraConsultaExpAsociado").show();
		//document.getElementById("objeto20_consulta_table").focus();
		$("#dialogoEsperaAsoc").hide();
		$("#ConsultaExpAsociado_detail_div").show();
	},
	/**
	 * Cierra el díalogo
	 */
	handlerCerrarConsultaAsociado:function(){
		$("#dialogoExpAsociado").rup_dialog("close");
	},
	/**
	 * Carga los datos mediante ajax (se ejectua en el evento open del diálogo.
	 */
	cargarDatos:function(){
		$("#ui-dialog-title-dialogoExpAsociado").html($.rup.i18n.app.aa21b20s01.expAsociado + " "+dialogoConsultaEspedientesAsociados.expeCod);
		/**
		 * Obtención de datos del expediente por medio del id (CSERV'-'CTIPO)
		 */
		jQuery
			.ajax({
				type : "GET",
				dataType : "json",
				url : "../aa21b20s01/" + dialogoConsultaEspedientesAsociados.expeId,
				cache : false,
				success : function(xhr, response) {
					datosExpedienteAsig = xhr;
					//Claves
					$("#refExp_consulta_table").val(datosExpedienteAsig.refExp);
					$("#grupo_consulta_table").val(datosExpedienteAsig.grupo);
					$("#cserv20_consulta_table").val(datosExpedienteAsig.cserv20);
					$("#aexpe20_consulta_table").val(datosExpedienteAsig.aexpe20);
					$("#nexpe20_consulta_table").val(datosExpedienteAsig.nexpe20);
					$("#cexpe20_consulta_table").rup_combo("select",datosExpedienteAsig.cserv20+"-"+datosExpedienteAsig.cexpe20);
					$("#cexpe20_consulta_table").val(datosExpedienteAsig.cserv20+"-"+datosExpedienteAsig.cexpe20);

					$("#faper20_consulta_table").rup_date("setDate",datosExpedienteAsig.faper20);
					$("#fcier20_consulta_table").rup_date("setDate",datosExpedienteAsig.fcier20);
					$("#fvto20_consulta_table").rup_date("setDate",datosExpedienteAsig.fvto20);

					$("#objeto20_consulta_table").val(datosExpedienteAsig.objeto20);
					if(datosExpedienteAsig.eimpor20!=null){
						$("#eimpor20_consulta_table").val(formatearImporte(datosExpedienteAsig.eimpor20+""));
					}
					if(datosExpedienteAsig.eimpora20!=null){
						$("#eimpora20_consulta_table").val(formatearImporte(datosExpedienteAsig.eimpora20+""));
					}
					$("#cesta20_consulta_table").rup_combo("select",datosExpedienteAsig.cesta20);
					$("#refer20_consulta_table").val(datosExpedienteAsig.refer20);
					$("#carchi20_consulta_table").rup_combo("select",datosExpedienteAsig.carchi20);
					$("#ubica20_consulta_table").val(datosExpedienteAsig.ubica20);
					$("#crespo20_consulta_table").rup_combo("setRupValue",datosExpedienteAsig.crespo20);
					
					$("#depar20_consulta_table").rup_combo("select",datosExpedienteAsig.cdepar20);
					$("#obser20_consulta_table").val(datosExpedienteAsig.obser20);
					$("#cpais20_consulta_table").rup_combo("select",datosExpedienteAsig.cpais20);
					$("#cprov20_consulta_table").rup_combo("select",datosExpedienteAsig.cprov20);
					if(datosExpedienteAsig.cmuni20 != null){
						$("#cmuni20_consulta_table").rup_combo("select",datosExpedienteAsig.cmuni20);
						$("#cmuni20_consulta_table").rup_combo("setRupValue",datosExpedienteAsig.cmuni20);
					}

					//MODO CONSULTA
					$("#ConsultaExpAsociado_detail_div :input").attr("readonly","readonly");
					$("#cesta20_consulta_table").rup_combo("disable");
					$("#carchi20_consulta_table").rup_combo("disable");
					$("#crespo20_consulta_table").rup_combo("disable");
					$("#depar20_consulta_table").rup_combo("disable");
					$("#cpais20_consulta_table").rup_combo("disable");
					$("#cprov20_consulta_table").rup_combo("disable");
					$("#cmuni20_consulta_table").rup_combo("disable");
					$("#faper20_consulta_table").rup_date("disable");
					$("#fcier20_consulta_table").rup_date("disable");
					$("#fvto20_consulta_table").rup_date("disable");

					$("[id='ConsultaExpAsociado_consulta_button_volver']").click(function(){
						$("#dialogoExpAsociado").rup_dialog("close");
					});

					//Guardo en variable el código para mandar en los diferentes rup_dialog
					codigoEnvioAsig="?cserv="+datosExpedienteAsig.cserv20+"&cexpe="+$("#cexpe20_consulta_table").val()+"&aexpe="+$("#aexpe20_consulta_table").val()+"&nexpe="+$("#nexpe20_consulta_table").val();
				}
			});
	},
	/**
	 * Llama a dialogo  fase
	 */
	revisionFasesExpedienteAsig:function(){
		dialogoFase.abrirDialogo(dialogoConsultaEspedientesAsociados.expeId,dialogoConsultaEspedientesAsociados.expeCod,"C");
	},
	/**
	 * Llama a dialogoDocumentos
	 */
	handlerDocumentosAsig:function(){
		dialogoDocumentos.abrirDialogo(dialogoConsultaEspedientesAsociados.expeId,dialogoConsultaEspedientesAsociados.expeCod,"C");
	},
	/**
	 * Llama a dialogo historico
	 */
	revisionHistoricoResponsablesAsig:function(){
		dialogoHistorico.abrirDialogo(dialogoConsultaEspedientesAsociados.expeId,dialogoConsultaEspedientesAsociados.expeCod);
	},
	/**
	 * Muestra la ficha del expediente en pdf
	 */
	handlerImprimirAsig:function(){
		$('#idExpePrintDet').val(dialogoConsultaEspedientesAsociados.expeId);
		$("#frmImprimirDet").attr("action","../imprimirMantGenerales/imprimirExpedienteDetalle");
		$("#frmImprimirDet").attr("target","_blank");
		$("#frmImprimirDet").submit();
	},
	/**
	 * Muestra la ficha del expediente en excel
	 */
	handlerExcelAsig:function(){
		$('#idExpePrintDet').val(dialogoConsultaEspedientesAsociados.expeId);
		$("#frmImprimirDet").attr("action","../aa21b20s01/excelFichaExpediente");
		$("#frmImprimirDet").attr("target","_blank");
		$("#frmImprimirDet").submit();
	},
	ocultarElementos:function(){
		  $("#dialogoEsperaAsoc").hide();
	}
}