var fasesExistentes = [];
jQuery(function($){
	
	//Oculto los botones de la capa de filtro de la pantalla de fases expedientes
	$("#FasesExpedienteDetalle_filter_toolbar").hide();
	
	//Campos fechas
	$("#fprevi21_detail_table").rup_date();
	$("#freal21_detail_table").rup_date();
	
	//Botonera pantalla de detalle de fases expediente
	$("#FasesExpedienteDetalle_detail_toolbar").rup_toolbar({
		buttons:[
		         { 
		        	 id: "copiar_doc_faseExp",
		        	 i18nCaption:$.rup.i18n.app.btnFasesExpediente.copiarDocFaseExpAcor,
		        	 css:"copiaDoc", 
		        	 click:handlerCopiarDocOtroExp
		         },
		         { 
		        	 id: "copiar_doc_fase",
		        	 i18nCaption:$.rup.i18n.app.btnFasesExpediente.copiarDocFaseAcor, 
		        	 css:"copiaDoc", 
		        	 click:handlerCopiarDocFase
		         },
		         { 
		        	 id: "verDocFaseAsoc",
		        	 i18nCaption:$.rup.i18n.app.btnFasesExpediente.verDocAsocAcor, 
		        	 css:"verDoc", 
		        	 click:handlerVerDocAsociado
		         },
		         { 
		        	 id: "verDocFase",
		        	 i18nCaption:$.rup.i18n.app.btnFasesExpediente.verDocFaseAcor, 
		        	 css:"verDoc", 
		        	 click:handlerVerDocFase
		         }
		        ]
	});
	$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFaseAsoc']").attr("title",$.rup.i18n.app.btnFasesExpediente.verDocumentoAsociado);
	$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFase']").attr("title",$.rup.i18n.app.btnFasesExpediente.verDocumentoFase);
	$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_fase']").attr("title",$.rup.i18n.app.btnFasesExpediente.copiarDocFase);
	$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_faseExp']").attr("title",$.rup.i18n.app.btnFasesExpediente.copiarDocFaseExp);
	$("#FasesExpedienteDetalle_detail_toolbar").hide();
	$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFaseAsoc']").hide();
	$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_faseExp']").hide();
	$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_fase']").hide();

	//Tabla grid fases expediente detalle
	$("#FasesExpedienteDetalle").rup_table({
		rowNum:20,
		url: "../aa21b21s01",
		colNames: [
			"idFaseExp",
			"cserv21",
			"cexpe21",
			"aexpe21",
			"nexpe21",
			"cfase21",
			 $.rup.i18n.app.aa21b21s01.dfase21,
			 $.rup.i18n.app.aa21b21s01.fprevi21,
			 $.rup.i18n.app.aa21b21s01.freal21,
			 "codPid21"
		],
		colModel: [
		    { 	name: "idFaseExp", 
 				label: "idFaseExp",
 				hidden: true 
			},
			{ 	name: "cserv21", 
			 	label: "cserv21",
				hidden: true 
			},
			{ 	name: "cexpe21", 
			 	label: "cexpe21",
				hidden: true 
			},
			{ 	name: "aexpe21", 
			 	label: "aexpe21",
				hidden: true 
			},
			{ 	name: "nexpe21", 
			 	label: "nexpe21",
				hidden: true 
			},
			{ 	name: "cfase21", 
			 	label: "cfase21",
				hidden: true 
			},
			{ 	name: idioma=='es'?"dfase21":"efase21",
			 	label: idioma=='es'?"dfase21":"efase21",
				align: "left", 
				width: 240, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fprevi21", 
			 	label: "fprevi21",
				align: "left", 
				width: 120, 
				editable: true, 
				formatter:"date",
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "freal21", 
			 	label: "freal21",
				align: "left", 
				width: 120, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "codPid21", 
			 	label: "codPid21",
				hidden: true 
			}
        ],

        model:"Aa21b21s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "idFaseExp",
		sortname: "fprevi21",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteFasesExpedientes,
		toolbar:{
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsulta
			    }
			]
		},
		afterInsertRow : function(rowid, rowdata) {
			fasesExistentes.push(rowdata.cfase21);
		},
        formEdit:{
        	detailForm: "#FasesExpedienteDetalle_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					$("#FasesExpedienteDetalle_detail_link_cancel").css("display","block");
					$("#FasesExpedienteDetalle_detail_button_save").hide();
					
					$("#FasesExpedienteDetalles_detail_div :input").removeAttr("readonly");
					$("#FasesExpedienteDetalle_detail_link_cancel").css("display","block");
					
					$("#cfase21_detail_table").rup_combo("enable");
					$("#cfase21_detail_table").rup_combo("setRupValue","");
					
					$("#fprevi21_detail_table").rup_date("enable");
					$("#freal21_detail_table").rup_date("enable");
					
					$("[id='FasesExpedienteDetalle_detail_toolbar']").hide();
					$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_faseExp']").hide();
					$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_fase']").hide();
					
					$("#labelObligFase").show();
					$(".asterisco").show();
				}	
			},
			editOptions:{
				beforeShowForm:function(){
					$("#FasesExpedienteDetalle_detail_button_save").hide();
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle21").val() == "C"){
						$("#FasesExpedienteDetalle_detail_div :input").attr("readonly","readonly");
						$("#FasesExpedienteDetalle_detail_link_cancel").css("display","none");
						
						$("#cfase21_detail_table").rup_combo("disable");
						
						$("#fprevi21_detail_table").rup_date("disable");
						$("#freal21_detail_table").rup_date("disable");
						
						$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_faseExp']").hide();
						$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_fase']").hide();
						
						$("#labelObligFase").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");

					}else{
						$("#labelObligFase").show();
						$(".asterisco").show();
						
						$("#FasesExpedienteDetalle_detail_div :input").removeAttr("readonly");
						$("#FasesExpedienteDetalle_detail_link_cancel").css("display","block");
						
						$("#cfase21_detail_table").rup_combo("disable");
						
						$("#fprevi21_detail_table").rup_date("enable");
						$("#freal21_detail_table").rup_date("enable");
						
						
						$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_faseExp']").show();
						$("[id='FasesExpedienteDetalle_detail_toolbar##copiar_doc_fase']").show();
						
					}
					$("#fprevi21_detail_table").rup_date("hide");
					$("#freal21_detail_table").rup_date("hide");
					
					validacionExisteDocumentoAsociado();
					
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					
					$("#dialogoEsperaDetalleFasesDetail").hide();
					$("#cserv21_detail_table").val($("#cserv").val());
					$("#cexpe21_detail_table").val($("#cexpe").val());
					$("#aexpe21_detail_table").val($("#aexpe").val());
					$("#nexpe21_detail_table").val($("#nexpe").val());
					
					
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('FasesExpedienteDetalle');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar
					 */
					$("#first_FasesExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('FasesExpedienteDetalle');
					});
					$("#back_FasesExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('FasesExpedienteDetalle');
					});
					$("#forward_FasesExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('FasesExpedienteDetalle');
					});
					$("#last_FasesExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('FasesExpedienteDetalle');
					});
				},
				reloadAfterSubmit:true
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				//afterShowForm:function(){
				//	jQuery("#delmodFasesExpedienteDetalle").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
				//		desbloquear(jQuery("#FasesExpedienteDetalle"), "aa21b21s01");
				//	});
				//},
				reloadAfterSubmit:true
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cserv21":{
						required: true
    					},
    				"cexpe21":{
						required: true
    					},
    				"aexpe21":{
						required: true
    					},
    				"nexpe21":{
						required: true
    					},
   					"cfase21":{
   						required: true
      					}
    				}
    		}
        },
        onPaging: function(){
			$("#FasesExpedienteDetalle").rup_table("deselectAllRows");
		}
	});
	/**
	 * Pongo el action de copiar documento con las variables sin valor, para que no haga la copia del documento de la fase
	 */
	jQuery("#FasesExpedienteDetalle_detail_form").attr("method","POST");
	jQuery("#FasesExpedienteDetalle_detail_form").attr("action","/aa21bOrgDocumentalWar/aa21b21s01/copiarDocumentoFase?idFaseExp=&ndocuFase=");
	
	//Compruebo si ha seleccionado más de un registro que no pueda eliminar
	jQuery("#FasesExpedienteDetalle").on("jqGridSelectRow", function(event, form, oper) {
		comprobacionEliminar('FasesExpedienteDetalle');
	});
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#FasesExpedienteDetalle").on("rupTable_beforeDeleteRow", function(event, row) {
		//Elimino del array de fases el registro eliminado
		fasesExistentes.splice(row.cfase21);
		//return bloquear('edit', $(this), "aa21b21s01", "cfase21");
	});
	//jQuery("#FasesExpedienteDetalle").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
	//	if($("#modoDetalle21").val() != "C"){
	//		return bloquear(oper, $(this), "aa21b21s01", "cfase21");
	//	}else{
	//		return true;
	//	}	
	//});

	/**
	 * Función al cerrar la ventana de detalle de fases expediente
	 * Compruba si tiene todas las fases con fecha de cierre además de
	 * inicializar la pantalla para la siguiente vez que se invoque
	 */
	jQuery("#FasesExpedienteDetalle_detail_div").on("dialogclose", function() {
		if($("#modoDetalle21").val() != "C"){
			
			$("#dialogSeleccionDocFase").rup_dialog("destroy");
			
			//Limpio la pantalla para que cuando vuelva a abrirla este incializada
			$("#FasesExpCopiaDoc_filter_summary").html("<i></i>");
			$("#FasesExpCopiaDoc_filter_toolbar").html("");
			
			$("#FasesExpCopiaDoc").rup_table("resetForm", $("#ExpedientesNuevos_filter_form"));
			$("#FasesExpCopiaDoc").rup_table("clearGridData",true);
			
			$("#dialogSeleccionExpDocFase").rup_dialog("destroy");
			
			$("#FasesExpedienteDetalle").rup_table("filter");
			/**
			 * Si tiene todas las fases con fecha de cierre, actualizaremos el 
			 * estado del expediente a cerrado
			 */
			
			var registros = [];
			registros = $("#FasesExpedienteDetalle").rup_table("getDataIDs");
			
			var cerrar = false;
			if(registros.length != 0){
				for(var i=0;i<registros.length;i++){
					cerrar = true;
					var exp = $("#FasesExpedienteDetalle").rup_table("getRowData")[i];
				
					if($("#freal21_detail_table").val() != ""){
						//Si alguna fecha de cierre esta en blanco
						//no se debe de cerrar el expediente
						if(exp.cfase21 != $("#cfase21_detail_table").val() && (exp.freal21 == null || exp.freal21 == "")){
							cerrar = false;
						}
					}else{
						cerrar = false;
					}
				}
			}else{
				if($("#freal21_detail_table").val() != ""){
					cerrar = true;
				}
			}	
			
			if(cerrar)
			{
				$.rup_messages("msgAlert", { 
					title: $.rup.i18n.app.mensajesMantGenerales.msjExpCerradoTit,
					message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCerrarExpediente,
					beforeClose:function() {
	        			var send = {};
	    				send["refExp"] = $("#refExp_detail_table").val();
	        			send["grupo"] = $("#grupo_detail_table").val();
	        			send["cserv20"] = $("#cserv20_detail_table").val();
	        			send["cexpe20"] = $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1);
	        			send["nexpe20"] = $("#nexpe20_detail_table").val();
	        			send["aexpe20"] = $("#aexpe20_detail_table").val();
	        			send["faper20"] = $("#faper20_detail_table").val();
	        			send["fvto20"] = $("#fvto20_detail_table").val();
	        			send["objeto20"] = $("#objeto20_detail_table").val();
	        			send["eimpor20"] = formatoUpdate($("#eimpor20_detail_table").val());
	        			send["eimpora20"] = formatoUpdate($("#eimpora20_detail_table").val());
	        			send["refer20"] = $("#refer20_detail_table").val();
	        			send["carchi20"] = $("#carchi20_detail_table").val();
	        			send["crespo20"] = $("#crespo20_detail_table").val();
	        			send["cdepar20"] = $("#depar20_detail_table").val();
	        			send["obser20"] = $("#obser20_detail_table").val();
	        			send["cpais20"] = $("#cpais20_detail_table").val();
	        			send["cprov20"] = $("#cprov20_detail_table").val();
	        			send["cmuni20"] = $("#cmuni20_detail_table").val();
	        			
	        			send["cesta20"] = 1;
	        			$("#fcier20_detail_table").rup_date("setDate",new Date());
	        			send["fcier20"] = $("#fcier20_detail_table").val();
	        			
	    				
	    				var dt = jQuery.toJSON(send);
	        			var	url = "/aa21bOrgDocumentalWar/aa21b20s01/actualizarExpediente?respActualizado=false&listaExpAsociados=&listaDesasociar=";
	        			
	        			$.ajax({
	        				type : "POST",
	        				dataType : "json",
	        				data : dt,
	        				contentType : "application/json",
	        				url : url,
	        				beforeSend : function(xhr, settings) {
	        					xhr.setRequestHeader("bean", "Aa21b20s01");
	        				},
	        				success : function(xhr, options) {
	        					//Llamo a la función que pone la pantalla como expediente cerrado
	        					expedienteCerrado();
	        					$("#dialogoFasesExpediente").rup_dialog("close");
	        					$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjExpCerrado + ": " +  $("#refExp_detail_table").val()});
	        					
	        				},
	        				error : function(xhr, ajaxOptions, thrownError) {
	        					 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	        					 if (xhr.responseText != null && xhr.responseText != "") {	
	        						 if (xhr.status === 406) {//si ha habido algun error...
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("option", "delay", null);
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("option", "delay", defaultDelay);
	        						 } else {
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("option", "delay", null);
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("set", errorTXT, "error");								
	        							 $("#FasesExpedienteDetalle_feedback").rup_feedback("option", "delay", defaultDelay);
	        						 }
	        					 }
	        				}
	        			});
	        		}
				});
			}
			
			//desbloquear(jQuery("#FasesExpedienteDetalle"), "aa21b21s01");
			$("#FasesExpedienteDetalle").rup_table("filter");
			
		}
		$("#modoDetalle21").val("");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	/**
	 * Al cerrar la ventana de fases, hago un destroy del formulario edición, añadir de fases
	 * para que al volver a entrar en la pantalla este inicializada
	 */
	jQuery("#dialogoFasesExpediente").on("dialogclose", function() {
		$("#FasesExpedienteDetalle_detail_div").rup_dialog("destroy");
		$("#FasesExpedienteDetalle_div").hide();
		$("#dialogoEsperaDetalleFases").show();
	});
	
	//Combo multiselección Servicios para posterior búsqueda
	$("#cfase21_detail_table").rup_combo(
	{
		source: "../aa21b01s01/comboFasesExpediente?cserv="+$("#cserv").val()+"&cexpe="+$("#cexpe").val()+"&fases="+fasesExistentes,
		sourceParam : {
			label : idioma == 'es' ? "dfase01"
					: "efase01",
			value : "cfase01"
		},
		width : 400,
		showValue: true,
		token: " - ",
		blank:"",
		selected:"",
		change:function(){
			/**
			 * Obtención de datos de la fase 
			 * Al cambiar en el combo, obtenemos el valor del campo ndocu01
			 * para saber si tiene documento asociado o no
			 * 
			 */
			
			if($("#cfase21_detail_table").val() != ""){
				
				/**
				 * Si ha seleccionado una fase que ya existe, mostraremos mensaje en pantalla y no podrá seleccionarla
				 */
				var cfaseSel = $("#cfase21_detail_table").val();
				var existeFase = false;
				for(var i=0; i<fasesExistentes.length;i++){
					if(cfaseSel == fasesExistentes[i]){
						existeFase = true;
					}
				}
				
				if(!existeFase){
					validacionDocumentoFaseOrigen();
				}else{
					$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.faseExiste});
					$("#cfase21_detail_table").val("");
					$("#cfase21_detail_table").rup_combo("setRupValue","");
				}	
			}	
			return false;
		}
	});

	if($("#modo21").val() == "C"){
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").hide();
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").hide();
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.app.botonerasMantGenerales.eliminar+"']").hide();
	}else{
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").show();
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").show();
		$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.app.botonerasMantGenerales.eliminar+"']").show();
	}

	//Ocultamos el botón de clonar
	$("[id='FasesExpedienteDetalle_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").hide();
	
	
	$("#FasesExpedienteDetalle").rup_table("filter");
	
	//Asigno las funciones a los botones
	$("[id='ver_documento_fase']").click(handlerVerDocFase);
	$("[id='ver_documento_fase_asoc']").click(handlerVerDocAsociado);
	$("[id='copiar_doc_fase']").click(handlerCopiarDocFase);
	$("[id='copiar_doc_faseExp']").click(handlerCopiarDocOtroExp);
	
	
	
	//Al cerrar la ventana de seleccion documento limpio los registros de la 
	//tabla fases copia
	jQuery("#dialogSeleccionDocFase").on("dialogclose", function() {
		$("#FasesCopiaDoc").rup_table("clearGridData",true);
	});
	
	
	//Tabla grid fases copia
	$("#FasesCopiaDoc").rup_table({
		rowNum:10,
		//url: "../aa21b21s01",
		colNames: [
			"idFaseExp",
			 $.rup.i18n.app.aa21b21s01.dfase21,
			 "codPid21",
			 "cserv21",
			 "cexpe21",
			 "cfase21",
			 "aexpe21",
			 "nexpe21"
		],
		colModel: [
		    { 	name: "idFaseExp", 
 				label: "idFaseExp",
 				hidden: true 
			},
			{ 	name: idioma=='es'?"dfase21":"efase21",
			 	label: idioma=='es'?"dfase21":"efase21",
				align: "left", 
				width: 350, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "codPid21", 
			 	label: "codPid21",
				hidden: true 
			},
			{ 	name: "cserv21", 
			 	label: "cserv21",
				hidden: true 
			},
			{ 	name: "cexpe21", 
			 	label: "cexpe21",
				hidden: true 
			},
			{ 	name: "cfase21", 
			 	label: "cfase21",
				hidden: true 
			},
			{ 	name: "aexpe21", 
			 	label: "aexpe21",
				hidden: true 
			},
			{ 	name: "nexpe21", 
			 	label: "nexpe21",
				hidden: true 
			}
        ],

        model:"Aa21b21s01",
        usePlugins:[
        			"toolbar",
                	"filter"
                 	],
        filter:{
        		},
		primaryKey: "idFaseExp",
		sortname: "fprevi21",
		sortorder: "asc",
		loadOnStartUp: false,
		toolbar:{
			defaultButtons:[{}]
		}
	});
	
	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados
	$("#FasesCopiaDoc_pager").hide();
	
	
	//Tabla grid Fases exp copia
	$("#FasesExpCopiaDoc").rup_table({
		rowNum:10,
		url: "../aa21b20s01",
		colNames: [
		    "id",
			"cserv20",
			$.rup.i18n.app.aa21b20s01.cexpe20,
			$.rup.i18n.app.aa21b20s01.cexpe20,
			"aexpe20",
			"nexpe20",
			$.rup.i18n.app.aa21b20s01.objeto20,
			$.rup.i18n.app.aa21b20s01.cesta20
		],
		colModel: [
           { 	
		    	name: "idExpe", 
 				label: "id",
				hidden: true 
			},       
			{ 	name: "cserv20", 
			 	label: "cserv20",
				hidden: true 
			},
			{ 	name: "refExp", 
			 	label: "refExp",
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cexpe20", 
			 	label: $.rup.i18n.app.aa21b20s01.cexpe20,
				hidden: true 
			},
			{ 	name: "aexpe20", 
			 	label: "aexpe20",
				hidden: true 
			},
			{ 	name: "nexpe20", 
			 	label: "nexpe20",
				hidden: true 
			},
			{ 	name: "objeto20", 
			 	label: $.rup.i18n.app.aa21b20s01.objeto20,
				align: "left", 
				width: 550, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cesta20", 
			 	label: $.rup.i18n.app.aa21b20s01.cesta20,
				hidden: true 
				
			}
        ],

        model:"Aa21b20s01",
        usePlugins:[
			"feedback",
			"toolbar",
        	"filter"
         	],
         	primaryKey: "idExpe",
    		sortname: "cexpe20",
    		sortorder: "desc",
    		loadOnStartUp: false,
		//loadComplete:fncTableCompleteExpedientesNuevos,
        onPaging: function(){
			$("#FasesExpCopiaDoc").rup_table("deselectAllRows");
		},
		toolbar:{
			defaultButtons:[{}]
		},
		filter:{
			url:"../aa21b20s01/filter"
		}
	});
	
	//Oculto los botones y partes de paginación del grid
	$("#first_FasesExpCopiaDoc_pager").hide();
	$("#last_FasesExpCopiaDoc_pager").hide();
	$("#FasesExpCopiaDoc_pager_left").hide();
	
	
	//Deshabilito las funciones por defecto de UDA
	$("#FasesExpCopiaDoc").on("rupTable_beforeEditRow", function(deleteOptions,selectedRow){
		return false;
	});
	$("#FasesExpCopiaDoc").on("jqGridDblClickRow", function(event, form, oper) {
		return false;
	});
	$("#FasesExpCopiaDoc").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return false;
	});
	
	
	
	//FILTRO Expedientes nuevos
	
	//Combo tipos expedientes detalle
	$("#cexpe20docFase_filter_table").rup_combo(
	{
		source: "../aa21b02s01/comboTiposExpedientes",
		sourceParam : {
			label : idioma == 'es' ? "dtipoe02"
					: "etipoe02",
			value : "ctipoe02"
		},
		width : "400",
		blank: "",
		selected:$("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1)
	});
	
	
	$("#FasesExpedienteDetalle_detail_button_save").click(function(){
		$("#dialogoEsperaDetalleFasesDetail").show();
	});
	
	
	$("#dialogoEsperaDetalleFases").hide();
	$("#FasesExpedienteDetalle_div").show();
	
	
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteFasesExpedientes(e){
	
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ14=="B"){
				$("tr[id='" + fila.carchi14 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.carchi14 + "']").css("font-style","italic");
				$("tr[id='" + fila.carchi14 + "']").css("background","#848484");
			}
		}*/
	}	
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}


function handlerImprimir(){
	
	
};

function handlerExcel(){
	
	
}


function desactivar(){
	$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").prop("disabled",true);
}
function activar(){
	$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='FasesExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").prop("disabled",false);
}

function handlerConsulta(){
	$("#modoDetalle21").val("C");
	$("#FasesExpedienteDetalle").rup_table("editElement");
}
/**
 * Documento asociado al la fase y expediente (tabla 21 con 23)
 */
function handlerVerDocAsociado(){
	
	/**
	 * Pongo el action de copiar documento con las variables sin valor, para que no haga la copia del documento de la fase
	 */
	jQuery("#FasesExpedienteDetalle_detail_form").attr("method","POST");
	jQuery("#FasesExpedienteDetalle_detail_form").attr("action","/aa21bOrgDocumentalWar/aa21b21s01/copiarDocumentoFase?idFaseExp=&ndocuFase=");
	
	var url="../aa21b21s01/getDocumentoFaseExpediente?idFaseExp="+$("#cserv20_detail_table").val() + "-" + $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1) + "-" + $("#aexpe21_detail_table").val() +  "-" + $("#nexpe21_detail_table").val() + "-" + $("#cfase21_detail_table").val();
	window.location.href=url;
}
/**
 * Documento asociado a la fase (tabla 01 con 23)
 * Es el que se hará copia y guardará asociado al expediente (21) en caso de crear la fase 
 */
function handlerVerDocFase(){
	/**
	 * Si la fase tiene documento asociado, meto el valor del ndocu de la (01) en el ndocu de la (21)
	 * Asi cuando vaya al controller, puedo obtener el documento y hacer la copia asignando un nuevo ndocu
	 * correlativo en la tabal 21 con su correspondiente documento en la tabla 23
	 */
	$("#codPid21_detail_table").val($("#ndocuAsociado").val());
	$("#extdocu21_detail_table").val($("#extdocuAsociado").val());
	$("#tdocu21_detail_table").val($("#tdocuAsociado").val());
	$("#FasesExpedienteDetalle_detail_button_save").show();
	
	/**
	 * Pongo el action de copiar documento con las variables sin valor, para que no haga la copia del documento de la fase 
	 */
	jQuery("#FasesExpedienteDetalle_detail_form").attr("method","POST");
	jQuery("#FasesExpedienteDetalle_detail_form").attr("action","/aa21bOrgDocumentalWar/aa21b21s01/copiarDocumentoFase?idFaseExp=&ndocuFase=");
	
	var url="../aa21b01s01/getDocumentoFase?idFaseExp="+$("#cserv20_detail_table").val() + "-" + $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1) + "-" + $("#cfase21_detail_table").val();
	window.location.href=url;
}

function validacionExisteDocumentoAsociado(){
	
	/**
	 * Si tiene documento, mostraremos el botón para ver/descargar el documento
	 */
	if($("#codPid21_detail_table").val() != null && $("#codPid21_detail_table").val() != 0 && $("#codPid21_detail_table").val() != "0"){
		$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFase']").hide();
		$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFaseAsoc']").show();
		$("#FasesExpedienteDetalle_detail_toolbar").show();
	}else{
		//Si la fase asociada el expediente (tabla 21) no tiene expediente asociado, comprobamos si la fase origen (tabla 01)
		//lo tiene.
		validacionDocumentoFaseOrigen();

	}
}

/**
 * Función para copiar el documento adjunto de otra fase de este mismo expediente.
 * 
 */
function handlerCopiarDocFase(){
	$.rup_messages("msgConfirm", { 
		title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
		message: $.rup.i18n.app.mensajesMantGenerales.sustDoc,
		siNo:true,
		OKFunction: function() {
			
			var numReg = $("#FasesExpedienteDetalle").rup_table("getDataIDs").length;
			if(numReg > 1){
				var posicionFaseActPasada = false;
				var mostrarFases = false;
				for(var i=0;i<numReg;i++){
					var idFase = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].idFaseExp;
					var ndocu = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].codPid21;
					var idFaseDetalle = $("#cserv20_detail_table").val() + "-" + $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1) + "-" + $("#aexpe21_detail_table").val() +  "-" + $("#nexpe21_detail_table").val() + "-" + $("#cfase21_detail_table").val();
					
					//Si alguna de las fases del expediente tiene documento, mostraremos la lista para 
					// que pueda copiar el documento de esa fase
					if(idFase != idFaseDetalle && ndocu != "" && ndocu != "0" && ndocu != null){
						mostrarFases = true;
						 var formdata = {};
						formdata["idFaseExp"] = idFase;
						formdata["cserv21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].cserv21;
						formdata["cexpe21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].cexpe21;
						formdata["cfase21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].cfase21;
 					    formdata["dfase21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].dfase21;
 					    formdata["efase21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].efase21;
 					    formdata["aexpe21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].aexpe21;
 					    formdata["nexpe21"] = $("#FasesExpedienteDetalle").rup_table("getRowData")[i].nexpe21;
						formdata["codPid21"] = ndocu;
						$("#FasesCopiaDoc").rup_table("addRowData", idFase, formdata, "last");
					}
				}
				if(mostrarFases){
					$("#dialogSeleccionDocFase").rup_dialog({	
						type:$.rup.dialog.DIV,
						modal:true,
						height:350,
						width:500,	
						resizable:false,
						title:$.rup.i18n.app.btnFasesExpediente.copiarDocFase,
						autoOpen:false,
						showLoading:true,
				        async:false, 
				        zIndex: -1,
				        buttons: [
				         	{
				         	  id:"guardar",
				         	  text:$.rup.i18n.app.botonerasMantGenerales.aniadir, 
				         	  css:"editar",
				         	  click: guardarNdocuFase 
				         	}
				         	,{
				         	  id: "btnCerrarServicio",
				         	  text: $.rup.i18n.base.rup_global.cancel,
				         	  btnType: $.rup.dialog.LINK,
				         	  click: function(){
				         		 $("#dialogSeleccionDocFase").rup_dialog("close");
				         	  }
				         	}]
					});
					
					$("#dialogSeleccionDocFase").rup_dialog("open");
				}else{
					$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noExistenFasesConDoc});
				}
			}else{
				$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noExistenFasesConDoc});
			}
		}
	});
}
/**
 * Función para copiar el documento adjunto de otra fase de otro expediente
 */
function handlerCopiarDocOtroExp(){
	$.rup_messages("msgConfirm", { 
		title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
		message: $.rup.i18n.app.mensajesMantGenerales.sustDoc,
		siNo:true,
		OKFunction: function() {
			
			
			$("#dialogSeleccionExpDocFase").rup_dialog({	
				type:$.rup.dialog.DIV,
				modal:true,
				height:660,
				width:800,	
				resizable:false,
				title:$.rup.i18n.app.btnFasesExpediente.copiarDocFaseExp,
				autoOpen:false,
				showLoading:true,
		        async:false, 
		        zIndex: -1,
		        buttons: [
		         	{
		         	  id:"guardar",
		         	  text:$.rup.i18n.app.botonerasMantGenerales.aniadir, 
		         	  css:"editar",
		         	  click: guardarNdocuFaseExpediente
		         	}
		         	,{
		         	  id: "btnCerrarServicio",
		         	  text: $.rup.i18n.base.rup_global.cancel,
		         	  btnType: $.rup.dialog.LINK,
		         	  click: function(){
		         		 $("#dialogSeleccionExpDocFase").rup_dialog("close");
		         	  }
		         	}]
			});
			
			$("#dialogSeleccionExpDocFase").rup_dialog("open");
			$("#FasesExpCopiaDoc").rup_table("filter");
			
		}
	});
}

l
function guardarNdocuFase(){
	if($("#FasesCopiaDoc").rup_table("getSelectedRows").length == 1){
		var lineaSel = $("#FasesCopiaDoc").rup_table("getSelectedLines");
		//Campos de la fase que obtendremos el documento
		var idFaseFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].idFaseExp;
		var cservFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].cserv21;
		var cexpeFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].cexpe21;
		var cfaseFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].cfase21;
		var ndocuFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].codPid21;
		var aexpeFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].aexpe21;
		var nexpeFase = $("#FasesCopiaDoc").rup_table("getRowData")[lineaSel].nexpe21;
		
		/**
		 * Siempre que guarde, pasará por el controller por la función de copiarDocumentoFase. Si lleva parámetros,
		 * se ejecutará la copia y la update. Si no lleva datos, solo se hará la update normal de UDA
		 * Siempre entrará por los dos sitios al darle a guardar
		 * Es una chapuza para no tener que sustituir todo el formulario de UDA. 
		 */
		jQuery("#FasesExpedienteDetalle_detail_form").attr("method","POST");
		jQuery("#FasesExpedienteDetalle_detail_form").attr("action","/aa21bOrgDocumentalWar/aa21b21s01/copiarDocumentoFase?idFaseExp="+idFaseFase+"&ndocuFase="+ndocuFase);
		
		
		/**
		 * Abro el documento
		 */
		var url="../aa21b21s01/getDocumentoFaseExpediente?idFaseExp="+cservFase+ "-" + cexpeFase.substring(cexpeFase.indexOf("-")+1) + "-" + aexpeFase + "-" + nexpeFase + "-" + cfaseFase;
		window.location.href=url;
		
		//Muestro el botón de guardar y cierro el dialogo de copia de fases
		$("#FasesExpedienteDetalle_detail_button_save").show();
		$("#dialogSeleccionDocFase").rup_dialog("close");
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
}

function guardarNdocuFaseExpediente(){
	if($("#FasesExpCopiaDoc").rup_table("getSelectedRows").length == 1){
		var lineaSel = $("#FasesExpCopiaDoc").rup_table("getSelectedLines");
		
		var cservExp = $("#FasesExpCopiaDoc").rup_table("getRowData")[lineaSel].cserv20;
		var cexpeExp = $("#FasesExpCopiaDoc").rup_table("getRowData")[lineaSel].cexpe20;
		var aexpeExp = $("#FasesExpCopiaDoc").rup_table("getRowData")[lineaSel].aexpe20;
		var nexpeExp = $("#FasesExpCopiaDoc").rup_table("getRowData")[lineaSel].nexpe20;
		var cfaseExp = $("#cfase21_detail_table").val();
		
		var idFaseExp = cservExp+"-"+cexpeExp+"-"+aexpeExp+"-"+nexpeExp+"-"+cfaseExp;
		
		/**
		 * Busco que el expediente seleccionado tenga la misma fase y que la fase tenga documento (codPid21 != 0)
		 */
		jQuery
		.ajax({
			type : "GET",
			dataType : "json",
			url : "../aa21b21s01/" + idFaseExp,
			cache : false,
			success : function(xhr, response) {
				datosFaseExpediente = xhr;
				
				if(datosFaseExpediente != null){
					var ndocuFaseExp = datosFaseExpediente.codPid21;
					if(ndocuFaseExp != null && ndocuFaseExp != "" && ndocuFaseExp != "0"){
						
						/**
						 * Siempre que guarde, pasará por el controller por la función de copiarDocumentoFase. Si lleva parámetros,
						 * se ejecutará la copia y la update. Si no lleva datos, solo se hará la update normal de UDA
						 * Siempre entrará por los dos sitios al darle a guardar
						 * Es una chapuza para no tener que sustituir todo el formulario de UDA. 
						 */
						jQuery("#FasesExpedienteDetalle_detail_form").attr("method","POST");
						jQuery("#FasesExpedienteDetalle_detail_form").attr("action","/aa21bOrgDocumentalWar/aa21b21s01/copiarDocumentoFase?idFaseExp="+idFaseExp+"&ndocuFase="+ndocuFaseExp);
						
						/**
						 * Abro el documento
						 */
						var url="../aa21b21s01/getDocumentoFaseExpediente?idFaseExp="+idFaseExp;
						window.location.href=url;
						
						//Muestro el botón de guardar y cierro el dialogo de copia de fases
						$("#FasesExpedienteDetalle_detail_button_save").show();
						$("#dialogSeleccionExpDocFase").rup_dialog("close");
						
					}else{
						$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.faseSinDoc});
					}
				}else{
					if(idioma=="eu"){
						$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.expSinFase + " " + $("#efase21_detail_table").val()});
					}else{
						$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.expSinFase + " " + $("#dfase21_detail_table").val()});
					}	
				}
				
			}
		});
				
		
		/**
		 * Abro el documento
		 */
		/*var url="../aa21b21s01/getDocumentoFaseExpediente?idFaseExp="+cservFase+ "-" + cexpeFase.substring(cexpeFase.indexOf("-")+1) + "-" + cfaseFase + "-" + aexpeFase + "-" + nexpeFase;
		window.location.href=url;
		
		//Muestro el botón de guardar y cierro el dialogo de copia de fases
		$("#FasesExpedienteDetalle_detail_button_save").show();
		$("#dialogSeleccionExpDocFase").rup_dialog("close");*/
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
}

function validacionDocumentoFaseOrigen(){
	
	
	jQuery
	.ajax({
		type : "GET",
		dataType : "json",
		url : "../aa21b01s01/" + $("#cserv21_detail_table").val() + "-" + $("#cexpe21_detail_table").val() + "-" + $("#cfase21_detail_table").val(),
		cache : false,
		success : function(xhr, response) {
			datosFaseExp = xhr;
			if(datosFaseExp != null){

					var ndocu = datosFaseExp.codPid01;
					if(ndocu != null && ndocu != "" && ndocu != "0"){
						$("#FasesExpedienteDetalle_detail_toolbar").show();
						$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFase']").show();
						$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFaseAsoc']").hide();
						/**
						 * Si la fase tiene documento asociado, meto el valor del ndocu de la (01) en el ndocu de la (21)
						 * Asi cuando vaya al controller, puedo obtener el documento y hacer la copia asignando un nuevo ndocu
						 * correlativo en la tabal 21 con su correspondiente documento en la tabla 23
						 */
						$("#ndocuAsociado").val(ndocu);
						$("#extdocuAsociado").val(datosFaseExp.extdocu01);
						$("#tdocuAsociado").val(datosFaseExp.tdocu01);
					}else{
						$("#FasesExpedienteDetalle_detail_toolbar").hide();
						$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFase']").hide();
						$("[id='FasesExpedienteDetalle_detail_toolbar##verDocFaseAsoc']").hide();
						$("#codPid21_detail_table").val("");
					}
				
			}
		}
	});
	
}

