jQuery(function($){
	
	//Oculto la botonora de la capa filtro en la pantalla documentos expediente
	$("#DocumentosExpedienteDetalle_filter_toolbar").hide();
	
	
	$("#fanot25_detail_table").rup_date();

	//Tabla grid documentos expediente
	$("#DocumentosExpedienteDetalle").rup_table({
		rowNum:20,
		url: "../aa21b25s01",
		colNames: [
		    "idDocExp",
			"cserv25",
			"cexpe25",
			"aexpe25",
			"nexpe25",
			$.rup.i18n.app.aa21b25s01.tdocu25,
			"cdocu25",
			$.rup.i18n.app.aa21b25s01.ddocu25,
			"ndocu25",
			$.rup.i18n.app.aa21b25s01.texto25,
			$.rup.i18n.app.aa21b25s01.fanot25,
			$.rup.i18n.app.aa21b25s01.aanot25,
			$.rup.i18n.app.aa21b25s01.nanot25
		],
		colModel: [
		    { 	name: "idDocExp", 
		    	label: "idDocExp",
		    	hidden: true 
		    },
			{ 	name: "cserv25", 
			 	label: "cserv25",
				hidden: true 
			},
			{ 	name: "cexpe25", 
			 	label: "cexpe25",
				hidden: true 
			},
			{ 	name: "aexpe25", 
			 	label: "aexpe25",
				hidden: true 
			},
			{ 	name: "nexpe25", 
			 	label: "nexpe25",
				hidden: true 
			},
			{ 	name: "tdocu25", 
			 	label: "tdocu25",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true,
				formatter :
		    		 masiveIconFormatter = function(cellval, el, opts) 
		    		 {
		    		 	//cellval = "descFichero";
		    		 	var html = '';
		    		 	if (cellval && cellval == '1'){
		    		 		html = $.rup.i18n.app.aa21b20s01.entrada;
		    		 	}else if(cellval && cellval == '2'){
		    		 		html = $.rup.i18n.app.aa21b20s01.salida;
		    		 	}
		    		 	return html;
		    		 }
			},
			{ 	name: "cdocu25", 
			 	label: "cdocu25",
				hidden: true 
			},
			{ 	name: idioma=='es'?"ddocu25":"edocu25",
			 	label: idioma=='es'?"ddocu25":"edocu25",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "ndocu25", 
			 	label: "ndocu25",
				hidden: true 
			},
			{ 	name: "texto25", 
			 	label: "texto25",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fanot25", 
			 	label: "fanot25",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "aanot25", 
			 	label: "aanot25",
				align: "right", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nanot25", 
			 	label: "nanot25",
				align: "right", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b25s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "idDocExp",
		sortname: "cserv25",
		sortorder: "asc",
		loadOnStartUp: false,
		toolbar:{
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsulta
			    }]
		},
        formEdit:{
        	detailForm: "#DocumentosExpedienteDetalle_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					$("#DocumentosExpedienteDetalle_detail_link_cancel").css("display","block");
					$("#DocumentosExpedienteDetalle_detail_button_save").hide();
					
					$("#DocumentosExpedienteDetalle_detail_div :input").removeAttr("readonly");
					$("#DocumentosExpedienteDetalle_detail_link_cancel").css("display","block");
					
					$("#radio_tdocu25_salida").prop("checked",false);
					$("#radio_tdocu25_entrada").prop("checked",false);
					
					$("tdocu25_detail_table").val("");
					
					$("#cdocu25_detail_table").rup_combo("enable");
					$("#radio_tdocu25_entrada").removeAttr("disabled");
					$("#radio_tdocu25_salida").removeAttr("disabled");
					$("#radio_tdocu25_entrada").val(1);
					$("#radio_tdocu25_salida").val(2);
					
					$("#aanot25_detail_table").attr("readonly","readonly");
					$("#fanot25_detail_table").rup_date("enable");
					
					$("#labelObligDoc").show();
					$(".asterisco").show();
				}
			},
			editOptions:{
				beforeShowForm:function(){
					$("#DocumentosExpedienteDetalle_detail_button_save").hide();
					
					$("#radio_tdocu25_entrada").attr("disabled","disabled");
					$("#radio_tdocu25_salida").attr("disabled","disabled");
					
					if($("#tdocu25_detail_table").val() == 1){
						$("#radio_tdocu25_entrada").prop("checked",true);
						$("#radio_tdocu25_salida").prop("checked",false);
					}else if($("#tdocu25_detail_table").val() == 2){
						$("#radio_tdocu25_salida").prop("checked",true);
						$("#radio_tdocu25_entrada").prop("checked",false);
					}
					
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle25").val() == "C"){
						$("#DocumentosExpedienteDetalle_detail_div :input").attr("readonly","readonly");
						$("#DocumentosExpedienteDetalle_detail_link_cancel").css("display","none");
						
						$("#cdocu25_detail_table").rup_combo("disable");
						
						$("#fanot25_detail_table").rup_date("disable");
						
						$("#labelObligDoc").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
					}else{
						$("#labelObligDoc").show();
						$(".asterisco").show();
						
						$("#DocumentosExpedienteDetalle_detail_div :input").removeAttr("readonly");
						$("#DocumentosExpedienteDetalle_detail_link_cancel").css("display","block");
						
						$("#cdocu25_detail_table").rup_combo("enable");
						
						$("#aanot25_detail_table").attr("readonly","readonly");
						$("#fanot25_detail_table").rup_date("enable");
					}
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					$("#cserv25_detail_table").val($("#cserv25").val());
					$("#cexpe25_detail_table").val($("#cexpe25").val());
					$("#aexpe25_detail_table").val($("#aexpe25").val());
					$("#nexpe25_detail_table").val($("#nexpe25").val());
					
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('DocumentosExpedienteDetalle');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar
					 */
					$("#first_DocumentosExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('DocumentosExpedienteDetalle');
					});
					$("#back_DocumentosExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('DocumentosExpedienteDetalle');
					});
					$("#forward_DocumentosExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('DocumentosExpedienteDetalle');
					});
					$("#last_DocumentosExpedienteDetalle").on('click', function(){
						validacionBotonGuardado('DocumentosExpedienteDetalle');
					});
				},
				reloadAfterSubmit:true
			},
         	validate:{ 
    			rules:{
    				"tdocu25":{
						required: true
    					},
    				"cdocu25":{
						required: true
    					},
    				"texto25":{
						required: true
    					}
    				}
    		}
        },
        onPaging: function(){
			$("#DocumentosExpedienteDetalle").rup_table("deselectAllRows");
		}
	});
	
	/**
	 * Como no me detecta el campo tdocu25 en las validaciones de obligatorio (radio buttons) compruebo
	 * manualmente si tiene dato. Si no tiene dato saco el mensaje de campo obligatorio
	 */
	jQuery("#DocumentosExpedienteDetalle").on("jqGridAddEditBeforeSubmit", function(event, form, oper) {
		if($("#tdocu25_detail_table").val() == ""){
			var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
			$("#DocumentosExpedienteDetalle_detail_feedback").rup_feedback("option", "delay", null);
			$("#DocumentosExpedienteDetalle_detail_feedback").rup_feedback("set",errorTXT + "  <li><b>*"+ $.rup.i18n.app.aa21b25s01.tdocu25 + ":</b><ul><li>" + $.rup.i18nParse($.rup.i18n.base,"rup_grid.edit.msg.required") + ".</li></ul></li>", "error");
			$("#DocumentosExpedienteDetalle_detail_feedback").rup_feedback("option", "delay", defaultDelay);
			return false;
		}	
	});
	
	//
	
	
	/**
	 * Función que carga en el campo año anotación dependiendo de la
	 * fecha seleccionada en el rup_date
	 */
	$("#fanot25_detail_table").on('change', function(){
		$("#aanot25_detail_table").val($("#fanot25_detail_table").rup_date("getDate").substring(6));
	});
	
	
	//Combo multiselección Servicios para posterior búsqueda
	$("#cdocu25_detail_table").rup_combo(
	{
		source: "../aa21b05s01/comboTiposDocumentos",
		sourceParam : {
			label : idioma == 'es' ? "ddocu05"
					: "edocu05",
			value : "cdocu05"
		},
		width : 433,
		showValue: true,
		token: " - "
	});
	
	//Ocultamos el botón de clonar
	$("[id='DocumentosExpedienteDetalle_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").hide();
	
	//Si es consulta ocultamos los botones del mantenimiento
	
	if($("#modo25").val() == "C"){
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").hide();
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").hide();
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.app.botonerasMantGenerales.eliminar+"']").hide();
	}else{
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").show();
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").show();
		$("[id='DocumentosExpedienteDetalle_toolbar##"+$.rup.i18n.app.botonerasMantGenerales.eliminar+"']").show();
	}

	$("#DocumentosExpedienteDetalle").rup_table("filter");
	
	
	/**
	 * Al cerrar la ventana de documentos, hago un destroy del formulario edición, añadir de documentos
	 * para que al volver a entrar en la pantalla este inicializada
	 */
	jQuery("#dialogoDocumentosExpediente").on("dialogclose", function() {
		$("#DocumentosExpedienteDetalle_detail_div").rup_dialog("destroy");
		$("#DocumentosExpedienteDetalle_div").hide();
		$("#dialogoEsperaDetalleDocumentos").show();
	});
	
	
	//Oculto el div de cargando
	$("#dialogoEsperaDetalleDocumentos").hide();
	$("#DocumentosExpedienteDetalle_div").show();
	
});


function handlerConsulta(){
	$("#modoDetalle25").val("C");
	$("#DocumentosExpedienteDetalle").rup_table("editElement");
}

function selTipoDoc(valor){
	$("#tdocu25_detail_table").val(valor);
}