var modo;
var codigoPrincipal;
var codigoEnvio;
var responsableCarga;

jQuery(function($){
	
	var fechaActual = new Date();
	var anioActual = fechaActual.getFullYear();
	var fechaMin = "01/01/" + anioActual;
	var fechaMax = "31/12/" + anioActual;
	if ($.rup.lang=="eu") {
		//EUSKERA
		fechaMin = anioActual + "/01/01";
		fechaMax = anioActual + "/12/31";
	}
	
	jQuery("#altaExpediente_feedback").rup_feedback({
		type: "ok",
		closeLink: true,
		fadeSpeed: 600,
		block:false
	});
	//Inicializo las varibales de listas de expedientes asignados
	$("#listaDesasociar").val();
	$("#listaDesbloquear").val();
	$("#listaAsociar").val();
	
	$("#dialogoAltaExpediente").css("height","740px");
	
	//Botonera pantalla Alta, modificación y consulta de expediente
	$("#AltaExpediente_toolbar").rup_toolbar({
		buttons:[{
			id:"fases",
			i18nCaption:$.rup.i18n.app.btnExpediente.fases, 
			css:"fases",
			click: revisionFasesExpediente
		},
		{
			id:"documentos",
			i18nCaption:$.rup.i18n.app.btnExpediente.documentos, 
			css:"documentos", 
			click: handlerDocumentos
		},
		{
			id:"historico",
			i18nCaption:$.rup.i18n.app.btnExpediente.historico, 
			css:"historico", 
			click: revisionHistoricoResponsables
		},
		{
			id : "excel",
			i18nCaption:$.rup.i18n.app.btnExpediente.excel, 
	        css : "excel right_button",
	        right : true,
	        click : handlerExcelDetalle
		},
		{
			id:"imprimir",
			i18nCaption:$.rup.i18n.app.btnExpediente.imprimir, 
			css:"imprimir right_button", 
			right: true,
			click: handlerImprimirDetalle
		}
		]
	});
	
	//Ventana dialogo de selección de expedientes que se van a asociar 
	//al principal
	$("#dialogSeleccionExpedientes").rup_dialog({	
		type:$.rup.dialog.DIV,
		modal:true,
		height:685,
		width:800,	
		resizable:true,
		title:$.rup.i18n.app.aa21b20s01.aniadirExpAsociadosTit,
		autoOpen:false,
		showLoading:true,
        async:false, 
        zIndex: -1,
        buttons: [
         	{
         	  id:"guardar",
         	  text:$.rup.i18n.app.botonerasMantGenerales.aniadir, 
         	  css:"editar",
         	  click: guardarExpedientesAsociadosTemp 
         	}
         	,{
         	  id: "btnCerrarServicio",
         	  text: $.rup.i18n.base.rup_global.close,
         	  btnType: $.rup.dialog.LINK,
         	  click: function(){
         		 
         		  $("#dialogSeleccionExpedientes").rup_dialog("close");
         		  //$("#dialogSeleccionExpedientes").rup_dialog("destroy");
         	  }
         	}]
	});
	
	//Combo tipos expedientes
	$("#cexpe20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "500",
		blank: "",
		selected:"",
		change:function(){
			/**
			 * Obtención de datos del tipo expediente
			 * Al cambiar en el combo, obtenemos el valor del campo ctrami02
			 * para saber si es tramitable (1) o no tramitable (!=1)
			 * 
			 */
			jQuery
			.ajax({
				type : "GET",
				dataType : "json",
				url : "../aa21b02s01/" + $("#cexpe20_detail_table").val(),
				cache : false,
				success : function(xhr, response) {
					datosTipoExp = xhr;
					if(datosTipoExp != null){
						var tramitable = datosTipoExp.ctrami02;
						
						
						$("#cserv20_detail_table").val(datosTipoExp.cserv02);
						if(tramitable != "1"){
							expedienteNoTramitable();
						}else{
							expedienteTramitable();
						}
					}
				}
			});
			
			
			return false;
		}
	});
	
	//Combo usuarios expedientes
	$("#crespo20_detail_table").rup_combo(
	{
		source: "../aa21b20s01/comboResponsablesServicio",
		sourceParam : {
			label : "dusu15",
			value : "cusu15"
		},
		parent: ["cexpe20_detail_table"],
		width : 555,
		showValue: true,
		token: " - ",
		method : 'GET'
	});
	
	
	//Combo estados expedientes
	$("#cesta20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "150",
		blank: "",
		selected:"",
		style: "dropdown",
		onLoadSuccess: function(){
			$("#cesta20_detail_table").rup_combo("selectLabel", $("cesta20_detail_table").val());
		},
		change:function(){
			
			//Si se selecciona estado cerrado, 
			//mostramos el campo fecha de cierre
			if($("#cesta20_detail_table").val() == 1){
				$("#fcier20_detail_table").rup_date("enable");
				$("#divFcier").show();
			}else if($("#cesta20_detail_table").val() == 2 || $("#cesta20_detail_table").val() == 4){
				$("#divFcier").show();
				$("#fcier20_detail_table").rup_date("enable");
				$("#divArchiva").show();
			}else{
				$("#divFcier").hide();
				$("#divArchiva").hide();
			}
		}
	});
	
	
	//Fechas
	$("#faper20_detail_table").rup_date({
		changeYear:false,
		minDate:fechaMin,
		maxDate:fechaMax
	});
	$("#fcier20_detail_table").rup_date();
	$("#fvto20_detail_table").rup_date();
	
	
	modo = $("#tipo").val();
	
	validacionBotonGuardado('AltaExpediente');

	/**
	 * Si es modo Alta llamamos al controller para que nos devuelva el grid vacio
	 */
	var urlExpAsoc = "";
	if(modo == "A"){
		urlExpAsoc = "../aa21b20s01/findExpediente";
	}else if(modo == "M"){
		urlExpAsoc = "../aa21b20s01";
	}else if(modo == "C"){
		urlExpAsoc = "../aa21b20s01";
	}

	//Tabla grid expedientes asociados
	$("#ExpAsociados").rup_table({
		rowNum:20,
		url: urlExpAsoc,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo"
		],
		colModel: [
		    {  name: "refExp", 
		       label: "refExp",
        	   align: "center", 
        	   width: 75, 
        	   editable: true, 
        	   fixed: false, 
        	   hidden: false, 
        	   resizable: true, 
        	   sortable: false
            },
            {   name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
		    },
			{ 	name: "idExpe", 
			 	label: "idExpe",
				hidden: true 
			},
			{ 	name: "cesta20", 
			 	label: "cesta20",
				hidden: true 
			},
			{ 	name: "cserv20", 
	        	label: "cserv20",
	        	hidden: true 
	        },
	        { 	name: "cexpe20", 
	        	   label: "cexpe20",
	        	   hidden: true 
	        },
	        { 	name: "aexpe20", 
	        	   label: "aexpe20",
	        	   hidden: true 
           },
           { 	name: "nexpe20", 
        	   label: "nexpe20",
        	   hidden: true 
           },   
           { 	name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
           },
	        
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid"
         	],
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		//loadComplete:fncTableCompleteExpAsociados,
		toolbar:{
			defaultButtons:[{}],
			newButtons:[{
				id:"aniadirExpAsociado",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.aniadir, css: "rup-icon aniadir"},
				click: handlerAniadirExpAsociado
			},
		    {
				id:"quitarExpAsociado",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.quitar, css: "rup-icon quitar"},
				click: handlerQuitarExpAsociado
		    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
			var tamanio = $("#dialogoAltaExpediente").css("height");
			tamanio = tamanio.substr(0,tamanio.indexOf("p"));
			var tamanioNuevo = 0;
			tamanioNuevo = parseInt(tamanio) + 9;
			$("#dialogoAltaExpediente").css("height",""+tamanioNuevo+"px"+"");
		},
        formEdit:{
        	detailForm: "#ExpAsociados_detail_div",
			fillDataMethod: "clientSide"
        }
	});
	
	// Pantalla Alta
	if(modo == "A"){
		//Asigno las funciones de alta a los botones
		$("[id='AltaExpediente_detail_button_save']").click(handlerCrearExpediente);
		$("[id='AltaExpediente_detail_link_cancel']").click(handlerCancelarAlta);
		
		$("#labelOblig").show();
		$(".asterisco").show();
		$("#AltaExpediente_toolbar").hide();
		$("#divAexpe").show();
		
		$("#aexpe20_detail_table").val(anioActual);
		
		$("#faper20_detail_table").rup_date("setDate",fechaActual);
		
	// Pantalla modificación	
	}else if(modo == "M" || modo == "C"){
		
		
		var idExpe = $("#idExpe").val();
		modoModificar(idExpe,modo);		
		
	}
	
	//Oculto la paginación de la tabla de expedientes asociados
	$("#ExpAsociados_pager").hide();
	
	//Tabla grid expedientes nuevos (Selección expedientes a asociar)
	$("#ExpedientesNuevos").rup_table({
		rowNum:20,
		url: "../aa21b20s01",
		colNames: [
		    "id",
			"cserv20",
			$.rup.i18n.app.aa21b20s01.cexpe20,
			$.rup.i18n.app.aa21b20s01.cexpe20,
			"aexpe20",
			"nexpe20",
			$.rup.i18n.app.aa21b20s01.objeto20,
			$.rup.i18n.app.aa21b20s01.faper20,
			$.rup.i18n.app.aa21b20s01.fcier20,
			"refer20",
			"crespo20",
			"cpais20",
			"cprov20",
			"cmuni20",
			"obser20",
			"moneda20",
			"eimpor20",
			"pimpor20",
			"eimpora20",
			"pimpora20",
			"cdepar20",
			"carchi20",
			"ubica20",
			$.rup.i18n.app.aa21b20s01.cesta20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"fvto20",
			"grupo"
		],
		colModel: [
           { 	
		    	name: "idExpe", 
 				label: "id",
				hidden: true 
			},       
			{ 	name: "cserv20", 
			 	label: "cserv20",
				hidden: true 
			},
			{ 	name: "refExp", 
			 	label: "refExp",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cexpe20", 
			 	label: $.rup.i18n.app.aa21b20s01.cexpe20,
				hidden: true 
			},
			{ 	name: "aexpe20", 
			 	label: "aexpe20",
				hidden: true 
			},
			{ 	name: "nexpe20", 
			 	label: "nexpe20",
				hidden: true 
			},
			{ 	name: "objeto20", 
			 	label: $.rup.i18n.app.aa21b20s01.objeto20,
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "faper20", 
			 	label: $.rup.i18n.app.aa21b20s01.faper20,
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			
			{ 	name: "fcier20", 
			 	label: $.rup.i18n.app.aa21b20s01.fcier20,
				align: "left", 
				width: 150, 
				editable: true, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "refer20", 
			 	label: "refer20",
				hidden: true 
			},
			{ 	name: "crespo20", 
			 	label: "crespo20",
				hidden: true 
			},
			{ 	name: "cpais20", 
			 	label: "cpais20",
				hidden: true 
			},
			{ 	name: "cprov20", 
			 	label: "cprov20",
				hidden: true 
			},
			{ 	name: "cmuni20", 
			 	label: "cmuni20",
				hidden: true 
			},
			{ 	name: "obser20", 
			 	label: "obser20",
				hidden: true 
			},
			{ 	name: "moneda20", 
			 	label: "moneda20",
				hidden: true 
			},
			{ 	name: "eimpor20", 
			 	label: "eimpor20",
				hidden: true 
			},
			{ 	name: "pimpor20", 
			 	label: "pimpor20",
				hidden: true 
			},
			{ 	name: "eimpora20", 
			 	label: "eimpora20",
				hidden: true 
			},
			{ 	name: "pimpora20", 
			 	label: "pimpora20",
				hidden: true 
			},
			{ 	name: "cdepar20", 
			 	label: "cdepar20",
				hidden: true 
			},
			{ 	name: "carchi20", 
			 	label: "carchi20",
				hidden: true 
			},
			{ 	name: "ubica20", 
			 	label: "ubica20",
				hidden: true 
			},
			{ 	name: "cesta20", 
			 	label: $.rup.i18n.app.aa21b20s01.cesta20,
				hidden: true 
			},
			{ 	
				name: idioma=="es"?"desta":"eesta", 
			 	label: idioma=="es"?"desta":"eesta", 
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "fvto20", 
			 	label: "fvto20",
				hidden: true 
			},
			{
				name: "grupo",
				label: "grupo",
				hidden:true
			}
        ],

        model:"Aa21b20s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
         	primaryKey: "idExpe",
    		sortname: "faper20",
    		sortorder: "desc",
    		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpedientesNuevos,
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
		},
        formEdit:{
        	detailForm: "#ExpedientesNuevos_detail_div"
        },
        multiselection:{
        	rowContextMenu_enabled:false
        },
        onPaging: function(){
			$("#ExpedientesNuevos").rup_table("deselectAllRows");
		},
		filter:{
			url:"../aa21b20s01/filter"
		}
	});
	
	$("#ExpAsociados").on("rupTable_beforeEditRow", function(deleteOptions,selectedRow){
		return false;
	});
	
	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente
	 */
	$("#ExpAsociados").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociados").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociados").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociados").rup_table("getRowData")[posLinea].idExpe;
		mostrarDetalleAsociado(form,refExp,idExpAsoc);
		return false;
	});
	
	/**
	 * Anulo las funciones edición del rup_table de asociados
	 */
	jQuery("#ExpAsociados").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return false;
	});
	
	/**
	 * Función que se ejecuta al cerrar la pantalla de alta/modificación/consulta
	 * del expediente.
	 * Se desbloquea el expediente y sus asociados(en el caso de que se hayan asociado nuevos)
	 * Se inicializa la pantalla
	 */
	jQuery("#dialogoAltaExpediente").on("dialogclose", function() {
		
		if(modo != "C"){
			desbloquearExpedientesAsociados();
			desbloquear(jQuery("#Expedientes"), "aa21b20s01");

			//Limpio la pantalla para que cuando vuelva a abrirla este incializada
			$("#ExpedientesNuevos_filter_summary").html("<i></i>");
			$("#ExpedientesNuevos_filter_toolbar").html("");
			
			$("#dialogSeleccionExpedientes").rup_dialog("destroy");
			
			$("#Expedientes").rup_table("filter");
		}
		$("#AltaExpediente_detail_div").hide();
		$("#dialogoEspera").show();
		$("#dialogoAltaExpediente").rup_dialog("destroy");
		$("#ExpAsociados_div").hide();
		$("#botoneraAltaExpedientes").hide();
		
	});
	
	
	//Combo ubicacion expedientes
	$("#carchi20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "555",
		blank: "",
		selected:""
	});
	
	//Combo departamentos expedientes
	$("#depar20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "555",
		blank: "",
		selected:""
	});
	
		
	//Combo paises 
	$("#cpais20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "180",
		blank: "",
		selected:"",
		change:function(){
			if($("#cpais20_detail_table").rup_combo("getRupValue") == 108){
				$("#divProvincia").show();
				$("#divMunicipio").show();
			}else{
				$("#divProvincia").hide();
				$("#divMunicipio").hide();
			}
		}
	});
	
	//Combo provincias 
	$("#cprov20_detail_table").rup_combo(
	{
		loadFromSelect:true,
		width : "180",
		blank: "",
		selected:""
	});
	
	//Combo municipios
	$("#cmuni20_detail_table").rup_combo({
		source : "../nora/municipioExp",
		sourceParam : {label:"dsO", value:"id"},
		parent: ["cprov20_detail_table"],
		width : "400",
		blank : ""
	});
	
	
	//FILTRO Expedientes nuevos
	
	//Combo tipos expedientes
	$("#cexpe20nuevo_filter_table").rup_combo(
	{
		loadFromSelect:true,
		width : "500",
		blank: "",
		selected:""
	});
	
	/**
	 * Función que se ejecuta al cerrar la pantalla de selección 
	 * de expedientes asociados
	 * resetea el formulario y limpia los registros 
	 */
	jQuery("#dialogSeleccionExpedientes").on("dialogclose", function() {
		
		$("#ExpedientesNuevos").rup_table("resetForm", $("#ExpedientesNuevos_filter_form"));
		$("#ExpedientesNuevos").rup_table("clearGridData",true);
		
		$("#dialogoEsperaSeleccionExp").show();
		
	});
	
	
	//Deshabilito las funciones por defecto de UDA al editar
	$("#ExpedientesNuevos").on("jqGridDblClickRow", function(event, form, oper) {
		return false;
	});
	jQuery("#ExpedientesNuevos").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return false;
	});
	
	$("#dialogoEspera").hide();
	$("#ExpedientesNuevos_toolbar").hide();
	$("#ExpAsociados_div").show();
	$("#botoneraAltaExpedientes").show();
	
	$("#AltaExpediente_detail_div").show();
	$("#eimpor20_detail_table").focus();
	
});

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociados(e){

	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){	
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	}	
	
	
}

/**
 * Función que guarda el nuevo expediente y sus asociados
 * Ajax POST pasando el formulario y un listado de expedientes asociados
 * a agregar.
 */
function handlerCrearExpediente(){
	
	var reqFecCier = false;
	//Si el estado es cerrado o archivado, la fecha de
	//cierre será obligatoria
	if($("#cesta20_detail_table").val() == 6){
		reqFecCier = true;
	}else if($("#cesta20_detail_table").val() == 1){
		reqFecCier = true;
	}
	var properties={
			feedback:$("#altaExpediente_feedback"),
			beforeSubmit:function(data){
				$("#dialogoEspera").show();
			},
			success: function(data) {
				$("#dialogoEspera").hide();
	          	
				$.rup_messages("msgConfirm", { 
					title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
					message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarGuardarExpediente,
					siNo:true,
	        		OKFunction: function() {
	        			/**
	        			 * Se da de alta el nuevo expediente con los expedientes asociados
	        			 */
	        			var send = {};
	        			
	        			send["cserv20"] = $("#cserv20_detail_table").val();
	        			send["cexpe20"] = $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1);
	        			var fechaActual = new Date();
	        			send["aexpe20"] = $("#aexpe20_detail_table").val();
	        			send["faper20"] = $("#faper20_detail_table").val();
	        			send["fvto20"] = $("#fvto20_detail_table").val();
	        			send["objeto20"] = $("#objeto20_detail_table").val();
	        			send["eimpor20"] = formatoUpdate($("#eimpor20_detail_table").val());
	        			send["eimpora20"] = formatoUpdate($("#eimpora20_detail_table").val());
	        			send["cesta20"] = $("#cesta20_detail_table").val();
	        			
	        			send["refer20"] = $("#refer20_detail_table").val();
	        			send["carchi20"] = $("#carchi20_detail_table").val();
	        			send["crespo20"] = $("#crespo20_detail_table").val();
	        			send["cdepar20"] = $("#depar20_detail_table").val();
	        			send["obser20"] = $("#obser20_detail_table").val();
	        			send["cpais20"] = $("#cpais20_detail_table").val();
	        			if($("#cpais20_detail_table").rup_combo("getRupValue") == 108){
	        				send["cprov20"] = $("#cprov20_detail_table").val();
	        				send["cmuni20"] = $("#cmuni20_detail_table").val();
	        			}	
	        			
	        			
	        			send["fcier20"] = $("#fcier20_detail_table").val();
	        			send["ubica20"] = $("#ubica20_detail_table").val();
	        			
	        			/**
	        			 * Añado true o false a la lista de expedientes asociados, dependiendo
	        			 * de si estos ya tienen grupo en la tabla 22 (es decir, estan asociados
	        			 * a algún expediente)
	        			 */
	        			var listaExpAsociados = $("#ExpAsociados").rup_table("getDataIDs");
	        			var listaExpAsociadosEnviar = [];
	        			for(var i=0;i<listaExpAsociados.length;i++){

	    					var exp = $("#ExpAsociados").rup_table("getRowData")[i];
	    					listaExpAsociadosEnviar.push(exp.refExp);
	    					if(exp.grupo != ""){
	    						listaExpAsociadosEnviar.push(true);
	    					}else{
	    						listaExpAsociadosEnviar.push(false);
	    					}
	        			}
	        			
	        			var dt = jQuery.toJSON(send);
	        			var url = "/aa21bOrgDocumentalWar/aa21b20s01/crearExpediente?listaExpAsociados="+listaExpAsociadosEnviar;

	        			//Mensaje creacion
	        			$.ajax({
	        				type : "POST",
	        				dataType : "json",
	        				data : dt,
	        				contentType : "application/json",
	        				url : url,
	        				beforeSend : function(xhr, settings) {
	        					xhr.setRequestHeader("bean", "Aa21b20s01");
	        				},
	        				success : function(xhr, options) {
	        					//$("#dialogoAltaExpediente").rup_dialog("close");
	        					
	        					$("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
	        					$("#AltaExpediente_detail_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.altaExpediente") +" " +  xhr, "ok");
	        					$("#AltaExpediente_detail_feedback").rup_feedback("show");
	        					$.rup_messages("msgOK", {message: $.rup.i18n.app.aa21b20s01.msjCreacionExpediente});
	        					
	        					//Cambiamos la pantalla a modificar
	        					modoModificar(xhr,"M");
	        					
	        					//$("#Expedientes_feedback").rup_feedback("option", "delay", defaultDelay);
	        					//$("#Expedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.altaExpediente") +" " +  xhr, "ok");
	        					//$("#Expedientes_feedback").rup_feedback("show");
	        				},
	        				error : function(xhr, ajaxOptions, thrownError) {
	        					var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	        					if (xhr.responseText != null && xhr.responseText != "") {	
	        						if (xhr.status === 406) {//si ha habido algun error...
	        							$("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
	        							$("#AltaExpediente_detail_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
	        							$("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
	        						} else {
	        							$("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
	        							$("#AltaExpediente_detail_feedback").rup_feedback("set", errorTXT, "error");								
	        							$("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
	        						}
	        					}
	        				}
	        			});
	        			
	        			
	        		}
	        	});
	           	
	         },
	         error:function(xhr, ajaxOptions, thrownError) {
				 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
				 if (xhr.responseText != null && xhr.responseText != "") {	
					 if (xhr.status === 406) {//si ha habido algun error...
						 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
						 $("#AltaExpediente_detail_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
						 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
					 } else {
						 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
						 $("#AltaExpediente_detail_feedback").rup_feedback("set", errorTXT, "error");								
						 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
					 }
				 }
	        	 
	         },
	         validate: {
                rules: {
                    "cexpe20":{required:true},
                    "objeto20":{required:true},
                    "crespo20":{required:true},
            	  	"faper20":{required:true},
            	  	"fcier20":{required:reqFecCier}
                }
            }
		};

	/**
	 * Validaciones formulario guardar
	 */
		$("#AltaExpediente_detail_form").rup_form(properties);
		$("#AltaExpediente_detail_form").submit();
	
	
}
function handlerCancelarAlta(){
	$.rup_messages("msgConfirm", { 
		title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
		message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCancelarAltaServicio,
		siNo:true,
		OKFunction: function() {

			$("#dialogoAltaExpediente").rup_dialog("close");
			
		}
	});
}

/**
 * Función para actualizar los datos del expediente y sus asociados
 * Ajax POST pasando formulario, lista de expedientes a asociar, lista de expedientes a
 * quitar de asociados y true o false dependiendo de si el responsable ha sido actualizado 
 * o no
 */
function handlerGuardarExpediente(){
	var reqFecCier = false;
	//Si el estado es cerrado o archivado, la fecha de
	//cierre será obligatoria
	if($("#cesta20_detail_table").val() == 6){
		reqFecCier = true;
	}else if($("#cesta20_detail_table").val() == 1){
		reqFecCier = true;
	}
	var properties={
			feedback:$("#altaExpediente_feedback"),
			beforeSubmit:function(data){
				$("#dialogoEspera").show();
			},
			success: function(data) {
				$("#dialogoEspera").hide();
	           	
	          	
	          	$.rup_messages("msgConfirm", { 
	        		title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
	        		message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarModificarExpediente,
	        		siNo:true,
	        		OKFunction: function() {
	        			
	        			//Se da guarda el expediente con los expedientes asociados
	        			var send = {};
	        			send["refExp"] = $("#refExp_detail_table").val();
	        			send["grupo"] = $("#grupo_detail_table").val();
	        			send["cserv20"] = $("#cserv20_detail_table").val();
	        			send["cexpe20"] = $("#cexpe20_detail_table").val().substring($("#cexpe20_detail_table").val().indexOf("-")+1);
	        			send["nexpe20"] = $("#nexpe20_detail_table").val();
	        			send["aexpe20"] = $("#aexpe20_detail_table").val();
	        			send["faper20"] = $("#faper20_detail_table").val();
	        			send["fvto20"] = $("#fvto20_detail_table").val();
	        			send["objeto20"] = $("#objeto20_detail_table").val();
	        			send["eimpor20"] = formatoUpdate($("#eimpor20_detail_table").val());
	        			send["eimpora20"] = formatoUpdate($("#eimpora20_detail_table").val());
	        			send["cesta20"] = $("#cesta20_detail_table").val();
	        			
	        			send["refer20"] = $("#refer20_detail_table").val();
	        			send["carchi20"] = $("#carchi20_detail_table").val();
	        			send["crespo20"] = $("#crespo20_detail_table").val();
	        			send["cdepar20"] = $("#depar20_detail_table").val();
	        			send["obser20"] = $("#obser20_detail_table").val();
	        			send["cpais20"] = $("#cpais20_detail_table").val();
	        			if($("#cpais20_detail_table").rup_combo("getRupValue") == 108){
	        				send["cprov20"] = $("#cprov20_detail_table").val();
	        				send["cmuni20"] = $("#cmuni20_detail_table").val();
	        			}	
	        			
	        			send["fcier20"] = $("#fcier20_detail_table").val();
	        			send["ubica20"] = $("#ubica20_detail_table").val();
	        			
	        			/**
	        			 * Si ha cambiado el responsable metemos true en la 
	        			 * variable respActualizado para meter un nuevo registro en 
	        			 * la tabla de histórico responsables
	        			 */
	        			var respActualizado = false;
	        			if(responsableCarga != $("#crespo20_detail_table").val()){
	        				respActualizado = true;
	        			}
	        			
	        			/**
	        			 * Añado true o false a la lista de expedientes asociados, dependiendo
	        			 * de si estos ya tienen grupo en la tabla 22 (es decir, estan asociados
	        			 * a algún expediente)
	        			 */
	        			
	        			var listaExpAsociados = $("#ExpAsociados").rup_table("getDataIDs");
	        			var listaExpAsociadosEnviar = [];
	        			for(var i=0;i<listaExpAsociados.length;i++){

	    					var exp = $("#ExpAsociados").rup_table("getRowData")[i];
	    					listaExpAsociadosEnviar.push(exp.refExp);
	    					
	    					if(exp.grupo != ""){
	    						listaExpAsociadosEnviar.push(true);
	    					}else{
	    						listaExpAsociadosEnviar.push(false);
	    					}
	        			}
	        			
	        			var listaExpEliminar = $("#listaDesasociar").val();
	        			
	        			var dt = jQuery.toJSON(send);
	        			var	url = "/aa21bOrgDocumentalWar/aa21b20s01/actualizarExpediente?respActualizado="+respActualizado+"&listaExpAsociados="+listaExpAsociadosEnviar+"&listaDesasociar="+listaExpEliminar;
	        			
	        			$.ajax({
	        				type : "POST",
	        				dataType : "json",
	        				data : dt,
	        				contentType : "application/json",
	        				url : url,
	        				beforeSend : function(xhr, settings) {
	        					xhr.setRequestHeader("bean", "Aa21b20s01");
	        				},
	        				success : function(xhr, options) {
	        					$("#dialogoAltaExpediente").rup_dialog("close");
	        					
	        				   $("#Expedientes_feedback").rup_feedback("option", "delay", defaultDelay);
							   $("#Expedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjExpActualizado") + " " + xhr, "ok");
							   $("#Expedientes_feedback").rup_feedback("show");
	        				},
	        				error : function(xhr, ajaxOptions, thrownError) {
	        					 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	        					 if (xhr.responseText != null && xhr.responseText != "") {	
	        						 if (xhr.status === 406) {//si ha habido algun error...
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
	        						 } else {
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", null);
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("set", errorTXT, "error");								
	        							 $("#AltaExpediente_detail_feedback").rup_feedback("option", "delay", defaultDelay);
	        						 }
	        					 }
	        				}
	        			});
	        			
	        		}
	        	});
	         },
	         validate: {
                rules: {
                	"cexpe20":{required:true},
              	  	"objeto20":{required:true},
              	  	"crespo20":{required:true},
              	  	"faper20":{required:true},
              	  	"fcier20":{required:reqFecCier}
                }
            }
		};

	/**
	 * Validaciones guardar
	 */
		$("#AltaExpediente_detail_form").rup_form(properties);
		$("#AltaExpediente_detail_form").submit();
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpedientesNuevos(e){
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
			
		}*/
	}	
}



/**
 * Funcion que abre un dialogo con la tabla de expedientes para que el usuario seleccione
 * cuales quiere asociarr al expediente que esta dando de alta o modificando 
 */
function handlerAniadirExpAsociado(){
	$("#dialogSeleccionExpedientes").rup_dialog("open");
	$("#dialogoEsperaSeleccionExp").hide();
}

/**
 * Función que quita de la tabla temporal de expedientes asociados los registros
 * seleccionados
 */
function handlerQuitarExpAsociado(){
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	var regEliminar = [];
	var regDesbloquear = [];
	
	
	if($("#ExpAsociados").rup_table("getDataIDs") != ""){
	
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarQuitarExpedientes,
			siNo:true,
			OKFunction: function() {
				
				registros = $("#ExpAsociados").rup_table("getRowData");
				if($("#listaDesasociar").val() != ""){
					regEliminar.push($("#listaDesasociar").val());
				}	
				//Variable que irá sumando los registros que se van eliminando de la tabla
				//así se le restará al indice ese número
				var cuentaEliminados = 0;
				for(var i=0;i<registros.length;i++){
					var exp = $("#ExpAsociados").rup_table("getRowData")[0];
					var nexperel = exp.refExp;
					var codigo = exp.idExpe;
					
					//Comprobar si el expediente esta bloqueado
					$("#ExpAsociados").rup_table("delRowData", exp.idExpe);
					cuentaEliminados++;
					regEliminar.push(nexperel);
					regDesbloquear.push(codigo);
				} 
				$("[id='ExpAsociados_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").show();
				$("#ExpAsociados").rup_table("deselectAllRows");
				$("#listaDesasociar").val(regEliminar);
				$("#listaDesbloquear").val(regDesbloquear);
			}
		});
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}	
}


//<------------ PANTALLA AUXILIAR (DIALOG DIV) TABLA USUARIOS ---------->
		
		/**
		 * Funcion que guarda en la tabla temporal de expedientes asociados los registros que 
		 * el usuario ha seleccionado en la tabla de expedientes y los asociados de los mismos
		 */
		function guardarExpedientesAsociadosTemp(){
			
			var registros = [];
			var regAgregar = [];
			var regBloqueados = [];
			var indiceBloq = 0;
			var cerrarVentana = true;
			
			if($("#ExpedientesNuevos").rup_table("getSelectedRows") != ""){
				
				$.rup_messages("msgConfirm", { 
					title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
					message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarAsignarExpedientes,
					siNo:true,
					OKFunction: function() {
						   
					   registros = $("#ExpedientesNuevos").rup_table("getSelectedLines");
					   if($("#listaAsociar").val() != ""){
							regAgregar.push($("#listaAsociar").val());
						}	
					   /**
					    * Función que obtiene los expedientes seleccionados y los añade a la tabla de 
					    * expedientes asociados, no se guardarán en la B.D hasta que el usuario no le de a 
					    * Guardar en la ventana de alta de expedientes
					    */
					   for(var i=0;i<registros.length;i++){
						   
						   if(regAgregar.length >= 6){
							   $.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.relacionExp6});
							   cerrarVentana = false;
							   break;
						   }else{
							   var indice = registros[i]-1;
							   var expediente = $("#ExpedientesNuevos").rup_table("getRowData")[indice];
							   var formdataSel = {};
							   var codigo = expediente.idExpe;
							   
							   if(codigo != codigoPrincipal){
								   //Comprobar si el expediente esta bloqueado
								   var noBloqueado = bloquear("change", $("#ExpedientesNuevos"), "aa21b20s01", "objeto20",codigo);
								   if(noBloqueado)
								   {
									   formdataSel["idExpe"] = codigo;
									   formdataSel["refExp"] = expediente.refExp;
									   formdataSel["cesta20"] = expediente.cesta20;
									   formdataSel["cserv20"] = expediente.cserv20;
									   formdataSel["cexpe20"] = expediente.cexpe20;
									   formdataSel["aexpe20"] = expediente.aexpe20;
									   formdataSel["nexpe20"] = expediente.nexpe20;
									   formdataSel["grupo"] = expediente.grupo;
									   
									   var ids = $("#ExpAsociados").rup_table("getDataIDs");
									   
									   //Resto uno a la z porque inexplicablemente cuando sumo al rowN también se esta sumando a la
									   //variable z
									   i--;
								   
									   var existe = false;
									   /*
									    * Comprobación de si el expediente seleccionado para asociar ya esta en la tabla de expedientes asociados
									    * temporal
									    */
									   for(var z=0;z<ids.length;z++){
										   if(codigo == ids[z]){
											   existe = true;
										   }
									   }
								   
									   if(existe){
										   $("#ExpAsociados").rup_table("setRowData", codigo, formdataSel);
									   }else{
										   //Añado el registro a la tabla de usuarios asignados
										   $("#ExpAsociados").rup_table("addRowData", codigo, formdataSel, "last");
										   regAgregar.push(codigo);
									   } 
									   
									   
									   /**
									    * Si el expediente que el usuario ha seleccionado para asociar tiene grupo,
									    * significa que ese expediente puede tener otros asociados. Debemos asociar
									    * todos los expedientes de ese grupo.
									    */
									   if(expediente.grupo != null && expediente.grupo != ""){
												
												jQuery.ajax({
												type : "GET",
												dataType : "json",
												url : "../aa21b20s01/getExpedientesAsociados/" + expediente.grupo,
												cache : false,
												success : function(xhr, response) {
													datosExpAsociados = xhr;
													
													for(var i=0;i<datosExpAsociados.length;i++){
														
														 if(regAgregar.length + datosExpAsociados.length > 6){
															 $.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.relacionExp6});
															   cerrarVentana = false;
															   break;
														 }else{	   
														
															var formdataAsoc = {};
															var codigoAsoc = datosExpAsociados[i].idExpe;
															/**
															 * Comprobación de si el expediente ya esta en la tabla temporal de
															 * asociados
															 */
															if(codigoAsoc != codigoPrincipal && codigoAsoc != codigo){
																
																//Comprobar si el expediente esta bloqueado
																var noBloqueado = bloquear("change", $("#ExpedientesNuevos"), "aa21b20s01", "objeto20",codigoAsoc);
																if(noBloqueado)
																{
																	formdataAsoc["idExpe"] = codigoAsoc;
																	formdataAsoc["refExp"] = datosExpAsociados[i].refExp;
																	formdataAsoc["cesta20"] = datosExpAsociados[i].cesta20;
																	formdataAsoc["cserv20"] = datosExpAsociados[i].cserv20;
																	formdataAsoc["cexpe20"] = datosExpAsociados[i].cexpe20;
																	formdataAsoc["aexpe20"] = datosExpAsociados[i].aexpe20;
																	formdataAsoc["nexpe20"] = datosExpAsociados[i].nexpe20;
																	formdataAsoc["grupo"] = datosExpAsociados[i].grupo;
																		
																	var idsAsoc = $("#ExpAsociados").rup_table("getDataIDs");
																	
																	var existeAsoc = false;
																	//Compruebo si el usuario ya esta en la tabla de usuarios asignados
																	for(var x=0;x<idsAsoc.length;x++){
																		if(codigoAsoc == idsAsoc[x]){
																			existeAsoc = true;
																		}	
																	}
																	/**
																	 * Si no existe en la tabla temporal lo añado también
																	 */
																	if(!existeAsoc){
																		//Añado el registro a la tabla de usuarios asignados
																		$("#ExpAsociados").rup_table("addRowData", codigoAsoc, formdataAsoc, "last");
																		regAgregar.push(codigoAsoc);
																	}	
																}else{
																	regBloqueados[indiceBloq] = codigoAsoc;
																	indiceBloq++;
																}
															}	
														 }	
													}
												}
											});
										}	
									   
									   //Deselecciono de la tabla actual de usuarios el registro que ya se ha asignado
									   $("#ExpedientesNuevos").rup_table("setSelection", [codigo], false);
								   }else{
									   regBloqueados[indiceBloq] = codigo;
									   indiceBloq++;
								   }
							   }else{
								   if(registros.length == 1){
									   //Significa que solo ha seleccionado un registro para añadir y es el mismo que esta editando
									   cerrarVentana = false;
									   $.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjMismoExp});
								   }
							   }
						   }
					   }
					   /**
					    * Deselecciono los expedientes que estan bloqueados
					    */
					   $("#ExpedientesNuevos").rup_table("setSelection", regBloqueados, false);
					   $("#ExpAsociados").rup_table("deselectAllRows");
					   $("#listaAsociar").val(regAgregar);
					   
					   /**
					    * Si no hay ningun registro bloqueado, cierro lo ventana dialogo
					    */
					   if(cerrarVentana){
						   $("[id='AltaExpediente_detail_button_save']").show();
						   //Oculto botón de añadir porque una vez que ya tiene expedientes asociados
						   //no podrá añadir más sin quitar los actuales
						   $("[id='ExpAsociados_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").hide();
						   if(indiceBloq == 0){
							   //Cierro el dialogo
							   $("#dialogSeleccionExpedientes").rup_dialog("close");
						   }
					   } 
					   
					}
				});
			}else{
				$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
			}
	//<!------------------------ ------------------------->
}

		
function desbloquearExpedientesAsociados(){
	/*
	 * Desbloqueo los usuarios que han sido asignados al servicio que había bloqueado al
	 * asignar.
	 */
	if($("#listaAsociar").val() != ""){
		var listaAgregar = $("#listaAsociar").val().split(",");
		
		for(var i=0;i<listaAgregar.length;i++){
			desbloquearExpediente(listaAgregar[i]);
		}
	}	
	
	/*
	 * Desbloqueo los usuarios que han sido quitados dal servicio que finalmente
	 * no se desagregarán
	 */
	if($("#listaDesbloquear").val() != ""){
		var listaDesagregar = $("#listaDesbloquear").val().split(","); 

		for(var i=0;i<listaDesagregar.length;i++){
			desbloquearExpediente(listaDesagregar[i]);
		}
	}	
}		

function expedienteNoTramitable(){
	//No tramitable
	
	//No permite asociar expedientes
	$("#ExpAsociados_toolbar").hide();
	
	if(modo=="A"){
		//Se borran los expedientes de la tabla asociados temporal (Altas)
		$("#ExpAsociados").rup_table("clearGridData",true);
		
		$("#cesta20_detail_table").rup_combo("setRupValue",1);
		//Se pone la fecha actual en fecha de apertura y cierre y se
		//deshabilitan
		var fechaActual = new Date();
	
		$("#faper20_detail_table").rup_date("setDate",fechaActual);
		$("#fcier20_detail_table").rup_date("setDate",fechaActual);
		
		$("#crespo20_detail_table").rup_combo("select","");
	}
	//Se marca estado a Cerrado y se deshabilita el combo
	$("#cesta20_detail_table").rup_combo("disable");
	
	$("#faper20_detail_table").rup_date("disable");
	$("#fcier20_detail_table").show();
	$("#fcier20_detail_table").rup_date("disable");
	
	//Deshabilito el combo responsables
	$("#crespo20_detail_table").rup_combo("disable");
	
	//No puede acceder a la pantalla de fases ni de históricos
	$("[id='AltaExpediente_toolbar##fases']").hide();
	$("[id='AltaExpediente_toolbar##historico']").hide();
}

function expedienteTramitable(){
	//Tramitable
	$("#ExpAsociados_toolbar").show();
	$("#cesta20_detail_table").rup_combo("enable");
	if(modo == "A"){
		$("#cesta20_detail_table").rup_combo("setRupValue",8);
	}	
	$("#faper20_detail_table").rup_date("enable");
	$("#fvto20_detail_table").rup_date("enable");
	$("#crespo20_detail_table").rup_combo("enable");
	
	$("[id='AltaExpediente_toolbar##fases']").show();
	$("[id='AltaExpediente_toolbar##historico']").show();
}


/**
 * Función que abre un dialogo con los datos del expediente asociado
 */
function mostrarDetalleAsociado(idExpePadre,refExp,idExpeAsoc){
	
	$("#dialogoExpAsociado").rup_dialog({	
		type:$.rup.dialog.AJAX,
		url:"/aa21bOrgDocumentalWar/aa21b20s01/consultarexpedienteasociado?idexpeasoc="+idExpeAsoc,
		modal:true,
		height:850,
		width:950,	
		resizable:false,
		title:$.rup.i18n.app.aa21b20s01.consultaExpedienteTit + " " + refExp,
		autoOpen:false,
		showLoading:true,
		async:false 
	});
	$("#dialogoExpAsociado").rup_dialog("open");
}

/**
 * Función que abre ventana dialogo con la pantalla de fases de expediente
 */
function revisionFasesExpediente(){
	
	$("#dialogoFasesExpediente").rup_dialog({
		type:$.rup.dialog.AJAX,
		url:"/aa21bOrgDocumentalWar/aa21b20s01/consultarfasesexpediente"+codigoEnvio+"&modo="+modo,
		modal:true,
		height:625,
		width:935,	
		resizable:false,
		title:$.rup.i18n.app.aa21b20s01.consultaFasesExpedienteTit + " " + $("#refExp_detail_table").val(),
		autoOpen:false,
		showLoading:true,
		async:false 
	});

	$("#dialogoFasesExpediente").rup_dialog("open");
	
	
}

/**
 * Función que abre ventana dialogo de la pantalla de documentos del expediente
 */
function handlerDocumentos(){
	
	$("#dialogoDocumentosExpediente").rup_dialog({
		type:$.rup.dialog.AJAX,
		url:"/aa21bOrgDocumentalWar/aa21b20s01/consultardocumentosexpediente"+codigoEnvio+"&modo="+modo,
		modal:true,
		height:625,
		width:935,	
		resizable:false,
		title:$.rup.i18n.app.aa21b20s01.consultaDocumentosExpedienteTit + " " + $("#refExp_detail_table").val(),
		autoOpen:false,
		showLoading:true,
		async:false 
	});

	$("#dialogoDocumentosExpediente").rup_dialog("open");
	
}
/**
 * Función que abre dialogo con la pantalla de histórico de responsables
 */
function revisionHistoricoResponsables(){
	
	$("#dialogoHistoricoRespExpediente").rup_dialog({
		type:$.rup.dialog.AJAX,
		url:"/aa21bOrgDocumentalWar/aa21b20s01/consultarhistoricorespexpediente"+codigoEnvio+"&modo="+modo,
		modal:true,
		height:625,
		width:935,	
		resizable:false,
		title:$.rup.i18n.app.aa21b20s01.consultaHistoricoExpedienteTit + " " + $("#refExp_detail_table").val(),
		autoOpen:false,
		showLoading:true,
		async:false 
	});

	$("#dialogoHistoricoRespExpediente").rup_dialog("open");
}

/**
 * Función imprimir detalle expediente PDF
 */
function handlerImprimirDetalle(){
	
	$('#idExpePrint').val($('#idExpe').val());

	$("#frmImprimir").attr("action","../imprimirMantGenerales/imprimirExpedienteDetalle");
	$("#frmImprimir").attr("target","_blank");

	var form = document.forms["frmImprimir"];
	form.submit();
}
/**
 * Función generación Excel detalle expediente
 */
function handlerExcelDetalle(){
	$('#idExpePrint').val($('#idExpe').val());

	$("#frmImprimir").attr("action","../aa21b20s01/excelFichaExpediente");
	$("#frmImprimir").attr("target","_blank");

	var form = document.forms["frmImprimir"];
	form.submit();
}

/**
 * Función que pone toda la pantalla de detalle de expediente
 * en modo consulta
 */
function modoConsulta(){
	//MODO CONSULTA
	$(".rup-maint_validateIcon").hide();
	$("#botoneraAltaExpedientes").hide();
	$("#labelOblig").hide();
	$(".asterisco").hide();
	$("[id='AltaExpediente_detail_button_save']").hide();
	$("[id='AltaExpediente_detail_link_cancel']").hide();
	$("#ExpAsociados_toolbar").hide();
	$("#AltaExpediente_detail_div :input").attr("readonly","readonly");
	$(".ui-selectmenu-status").css("color","black");
	
	$("#cesta20_detail_table").rup_combo("disable");
	$("#carchi20_detail_table").rup_combo("disable");
	$("#crespo20_detail_table").rup_combo("disable");
	$("#depar20_detail_table").rup_combo("disable");
	$("#cpais20_detail_table").rup_combo("disable");
	$("#cprov20_detail_table").rup_combo("disable");
	$("#cmuni20_detail_table").rup_combo("disable");
	
	$("#faper20_detail_table").rup_date("disable");
	$("#fvto20_detail_table").rup_date("disable");
	
}

function modoModificar(idExpMostrar,modoVista){
	
	
	$("#divAexpe").hide();
	$("#AltaExpediente_toolbar").show();
	var idExpe = idExpMostrar;
	$("#idExpe").val(idExpMostrar);
	$("#cexpe20_detail_table").rup_combo("disable");
	$("#crespo20_detail_table").rup_combo("enable");
	
	/**
	 * Obtención de datos del expediente por medio del id (CSERV'-'CTIPO)
	 * 
	 */
	jQuery
	.ajax({
		type : "GET",
		dataType : "json",
		url : "../aa21b20s01/" + idExpe,
		cache : false,
		success : function(xhr, response) {
			datosExpediente = xhr;
			//Claves
			$("#refExp_detail_table").val(datosExpediente.refExp);
			$("#grupo_detail_table").val(datosExpediente.grupo);
			$("#cserv20_detail_table").val(datosExpediente.cserv20);
			$("#aexpe20_detail_table").val(datosExpediente.aexpe20);
			$("#nexpe20_detail_table").val(datosExpediente.nexpe20);
			$("#cexpe20_detail_table").rup_combo("select",datosExpediente.cserv20+"-"+datosExpediente.cexpe20);
			$("#cexpe20_detail_table").val(datosExpediente.cserv20+"-"+datosExpediente.cexpe20);
			
			codigoPrincipal = datosExpediente.cserv20+"-"+datosExpediente.cexpe20+"-"+datosExpediente.aexpe20+"-"+datosExpediente.nexpe20;
			
			$("#faper20_detail_table").rup_date("setDate",datosExpediente.faper20);
			$("#fvto20_detail_table").rup_date("setDate",datosExpediente.fvto20);
			
			$("#objeto20_detail_table").val(datosExpediente.objeto20);
			if(datosExpediente.eimpor20!=null){
				$("#eimpor20_detail_table").val(formatearImporte(datosExpediente.eimpor20+""));
			}
			if(datosExpediente.eimpora20!=null){
				$("#eimpora20_detail_table").val(formatearImporte(datosExpediente.eimpora20+""));
			}	
			$("#cesta20_detail_table").rup_combo("select",datosExpediente.cesta20);
			
			//Si esta cerrado el expediente
			if(datosExpediente.cesta20 == "1"){
				$("#fcier20_detail_table").rup_date("setDate",datosExpediente.fcier20);
				expedienteCerrado();
			}else if(datosExpediente.cesta20 == "6"){
				//Archivado
				$("#ubica20_detail_table").val(datosExpediente.ubica20);
				expedienteArchivado();
			}
			
			$("#refer20_detail_table").val(datosExpediente.refer20);
			$("#carchi20_detail_table").rup_combo("select",datosExpediente.carchi20);
			$("#crespo20_detail_table").rup_combo("select",datosExpediente.crespo20);
			$("#crespo20_detail_table").rup_combo("setRupValue",datosExpediente.crespo20);
			
			responsableCarga = datosExpediente.crespo20;
			$("#depar20_detail_table").rup_combo("select",datosExpediente.cdepar20);
			$("#obser20_detail_table").val(datosExpediente.obser20);
			$("#cpais20_detail_table").rup_combo("select",datosExpediente.cpais20);
			if(datosExpediente.cpais20 == 108){
				$("#cprov20_detail_table").rup_combo("select",datosExpediente.cprov20);
				if(datosExpediente.cmuni20 != null){
					$("#cmuni20_detail_table").rup_combo("select",datosExpediente.cmuni20);
					$("#cmuni20_detail_table").rup_combo("setRupValue",datosExpediente.cmuni20);
				}
			}else{
				$("#divProvincia").hide();
				$("#divMunicipio").hide();
			}	
			
			/**
			 * Obtengo los expedientes asociados
			 */
			if(datosExpediente.grupo != null && datosExpediente.grupo != "")
			{
				jQuery
				.ajax({
					type : "GET",
					dataType : "json",
					url : "../aa21b20s01/getExpedientesAsociados/" + datosExpediente.grupo,
					cache : false,
					success : function(xhr, response) {
						datosExpAsociados = xhr;
						/**
						 * Si ya tiene expedientes asociados, oculto el botón de añadir
						 * (Solo se podrán añadir cuando haya quitado previamente los que tiene)
						 */
						if(datosExpAsociados.length > 1){
							$("[id='ExpAsociados_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").hide();
						}
						
						for(var i=0;i<datosExpAsociados.length;i++){
							var formdata = {};
							var codigo = datosExpAsociados[i].idExpe;
							/**
							 * Como en la tabla de expedientes asociados también existe el registro del expediente padre preguntamos
							 * para no mostrarlo en la pantalla de expedientes asociados.
							 */
							if(codigo != codigoPrincipal){
								formdata["idExpe"] = codigo;
								formdata["refExp"] = datosExpAsociados[i].refExp;
								formdata["cesta20"] = datosExpAsociados[i].cesta20;
								formdata["cserv20"] = datosExpAsociados[i].cserv20;
								formdata["cexpe20"] = datosExpAsociados[i].cexpe20;
								formdata["aexpe20"] = datosExpAsociados[i].aexpe20;
								formdata["nexpe20"] = datosExpAsociados[i].nexpe20;
								formdata["grupo"] = datosExpAsociados[i].grupo;
							
								//Añado el registro a la tabla de usuarios asignados
								$("#ExpAsociados").rup_table("addRowData", codigo, formdata, "last");
							}	
						}
					}
				});
			}
			
			if(modoVista == "M"){
				$("#ui-dialog-title-dialogoAltaExpediente").text($.rup.i18n.app.aa21b20s01.modificacionExpedienteTit + " " + $("#refExp_detail_table").val());
				
				//Asigno a los botones las funciones si es modificar
				$("[id='AltaExpediente_detail_button_save']").unbind("click");
				$("[id='AltaExpediente_detail_link_cancel']").unbind("click");
				$("[id='AltaExpediente_detail_button_save']").click(handlerGuardarExpediente);
				$("[id='AltaExpediente_detail_link_cancel']").click(handlerCancelarAlta);
				
				$("#labelOblig").show();
				$(".asterisco").show();
				
				//Obtener si el tipo de expediente es tramitable o no
				/**
				 * Obtención de datos del tipo expediente
				 * 
				 */
				jQuery
				.ajax({
					type : "GET",
					dataType : "json",
					url : "../aa21b02s01/" + $("#cexpe20_detail_table").val(),
					cache : false,
					success : function(xhr, response) {
						datosTipoExp = xhr;
						if(datosTipoExp != null){
							var tramitable = datosTipoExp.ctrami02;
							if(tramitable != "1"){
								expedienteNoTramitable();
							}else{
								expedienteTramitable();
							}
						}
					}
				});
				
			}else{
				modoConsulta();
			}
			
			//Guardo en variable el código para mandar
			//en los diferentes rup_dialog
			codigoEnvio="?cserv="+datosExpediente.cserv20+"&cexpe="+$("#cexpe20_detail_table").val()+"&aexpe="+$("#aexpe20_detail_table").val()+"&nexpe="+$("#nexpe20_detail_table").val();
			
			
		}
	});
	
	$("#crespo20_detail_table").rup_combo("enable");
	validacionBotonGuardado('AltaExpediente');
	
	$("#eimpor20_detail_table").focus();
}

/**
 * Función que se ejecuta al marcar el expediente como cerrado
 */
function expedienteCerrado(){
	$("#divFcier").show();
	$("#cesta20_detail_table").rup_combo("select","1");
	$("#fcier20_detail_table").rup_date("disable");
}
/**
 * Función que se ejecuta al marcar el expediente como arhcivado
 */
function expedienteArchivado(){
	$("#divArchiva").show();
	$("#divFcier").show();

}

