var dialogoDetalleModificacionEspecial = {
		inicializado:false,  
		//Oculta los elementos visibles
		ocultarElementos:function(){
			$("#dialogoEspera").hide();  
		},
		modoVista:"",
		nombreRupTable:null,
		expedienteActual:null,
		validador:null,
		//Inicializa todos los componentes de la pantalla del dialogo del detalle expediente
		inicializar:function(){
			$("#ModificacionEspecial_detail_form2").rup_form("resetForm");
			if(dialogoDetalleModificacionEspecial.validador!=null){
				dialogoDetalleModificacionEspecial.validador.resetForm();
				$("#ModificacionEspecial_detail_feedback2").hide();
			}
			if(!this.inicializado){
				
				this.inicializado=true;	

				var fechaActual = new Date();
				var anioActual = fechaActual.getFullYear();
				var fechaMin = "01/01/" + anioActual;
				var fechaMax = "31/12/" + anioActual;
				if ($.rup.lang=="eu") {
					//EUSKERA
					fechaMin = anioActual + "/01/01";
					fechaMax = anioActual + "/12/31";
				}
				jQuery("#ModificacionEspecial_detail_feedback2").rup_feedback({
					type: "ok",
					closeLink: true,
					fadeSpeed: 600,
					block:false
				});
				
				//Fechas
				$("#faper20_detail_table").rup_date({
					changeYear:false,
					minDate:fechaMin,
					maxDate:fechaMax
				});
				
				
				
				/**
				 * Función que se ejecuta al cerrar la pantalla de alta/modificación/consulta
				 * del expediente.
				 * Se desbloquea el expediente y sus asociados(en el caso de que se hayan asociado nuevos)
				 * Se inicializa la pantalla
				 */
				jQuery("#ModificacionEspecial_detail_div2").on("dialogclose", function() {
					
					var nombre="";
					if(dialogoDetalleModificacionEspecial.nombreRupTable==null)
						nombre="#ModificacionEspecial";
					else nombre=dialogoDetalleModificacionEspecial.nombreRupTable;
						desbloquear(jQuery(nombre), "aa21b20s01");
		
					$(nombre).rup_table("filter");

					$("#dialogoEspera").show();
					$("#ModificacionEspecial_detail_div2").rup_dialog("destroy");
				});
				
				jQuery(window).bind('beforeunload', function() {
			        // Aquí iría la función que desbloquea : 
					desbloquear(jQuery("#ModificacionEspecial"), "aa21b20s01");
				});
			}
		},
		abrirExpediente:function(expediente,modo){
			
			dialogoDetalleModificacionEspecial.expedienteActual=expediente;
			dialogoDetalleModificacionEspecial.modoVista=modo;
			var titulo="";
			if(modo=="M")
				titulo=$.rup.i18n.app.aa21b20s01.consultaExpedienteTit2 + " " + expediente.refExp;
			else
				titulo=$.rup.i18n.app.aa21b20s01.consultaExpedienteTit + " " + expediente.refExp;
			this.inicializar();
			$("#ModificacionEspecial_detail_div2").rup_dialog({	
				type:$.rup.dialog.DIV,
				modal:true,
				height:210,
				minHeight:200,
				width:525,	
				minWidth:525,	
				resizable:false,
				title:titulo,
				autoOpen:false,
				showLoading:true,
				async:true ,
				open:this.obtenerDatosExpediente
			});
			
			$("#ModificacionEspecial_detail_div2").rup_dialog("open");
		},
		/*
		 *Vacía los valores y selecciona los valores por defecto
		 * */
		 vaciarDialogo:function(){
			$("#aexpe20_detail_table").val("");
			$("#faper20_detail_table").val("");
		},
		
		/**
		 * establece algunas opciones del diálogo para que pueda modificar correctamente el expediente
		 */
		 modoModificar:function(modoVistaEntrada){
			 dialogoDetalleModificacionEspecial.dialogoDetalleModificacionEspecial=modoVistaEntrada;
			 if(modoVistaEntrada == "M"){
					$("#ui-dialog-title-dialogoAltaExpediente").text($.rup.i18n.app.aa21b20s01.modificacionExpedienteTit + " " + $("#refExp_detail_table").val());
					
					//Asigno a los botones las funciones si es modificar
					$("[id='ModificacionEspecial_detail_button_save2']").unbind("click");
					$("[id='ModificacionEspecial_detail_link_cancel2']").unbind("click");
					$("[id='ModificacionEspecial_detail_button_save2']").click(this.handlerGuardarExpediente);
					$("[id='ModificacionEspecial_detail_link_cancel2']").click(this.handlerCancelarAlta);
					
					$("#labelOblig").show();
					$(".asterisco").show();
			
					$(".ui-selectmenu-status").css("color","black");
					$("#ModificacionEspecial_detail_button_save2").show();
					$("#ModificacionEspecial_detail_link_cancel2").show();
			}
		},
		
		/**
		 * Función para actualizar los datos del expediente y sus asociados
		 * Ajax POST pasando formulario, lista de expedientes a asociar, lista de expedientes a
		 * quitar de asociados y true o false dependiendo de si el responsable ha sido actualizado 
		 * o no
		 */
		 obtenerDatosExpediente:function(){
			/**
			 * -Llamada a ajax para obtener los datos del expediente
			 * --Cuando se obtienen los datos
			 * ---Llamada se rellenan los datos del formulario
			 * ---Automaticamente se cargan los combos de personas y municipios
			 * ---Se llama al ajax para calcular los expedientes relacionados
			 *
			 */
			 //console.log("obtener datos");
			 var nombre="";
			 if(dialogoDetalleModificacionEspecial.nombreRupTable==null)
				 nombre="#ModificacionEspecial";
			 else nombre=dialogoDetalleModificacionEspecial.nombreRupTable;
				 
			var indice = $(nombre).rup_table("getSelectedLines");
			

			var expediente = $(nombre).rup_table("getRowData")[indice];
			var url="/aa21bOrgDocumentalWar/aa21b20s01/"+expediente.idExpe;
			//console.log("llamada ajax1");
			$.ajax({
				type : "GET",
				dataType : "json",		
				contentType : "application/json",
				url : url,
				success : function(xhr, options) {
					//console.log("success");
					$("#refExp_detail_table").val(xhr.refExp);
					$("#grupo_detail_table").val(xhr.grupo);
					$("#cserv20_detail_table").val(xhr.cserv20);
					$("#aexpe20_detail_table").val(xhr.aexpe20);
					$("#nexpe20_detail_table").val(xhr.nexpe20);
					$("#cexpe20Hidden").val(xhr.cserv20+"-"+xhr.cexpe20);
					$("#faper20_detail_table").val(xhr.faper20);
					
					dialogoDetalleModificacionEspecial.modoModificar(dialogoDetalleModificacionEspecial.modoVista);
					$("#dialogoEspera").hide();
					
				},
				error : function(xhr, ajaxOptions, thrownError) {
					var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
					if (xhr.responseText != null && xhr.responseText != "") {	
						if (xhr.status === 406) {//si ha habido algun error...
							$("#ModificacionEspecial_detail_feedback").rup_feedback("option", "delay", null);
							$("#ModificacionEspecial_detail_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
							$("#ModificacionEspecial_detail_feedback").rup_feedback("option", "delay", defaultDelay);
						} else {
							$("#ModificacionEspecial_detail_feedback").rup_feedback("option", "delay", null);
							$("#ModificacionEspecial_detail_feedback").rup_feedback("set", errorTXT, "error");								
							$("#ModificacionEspecial_detail_feedback").rup_feedback("option", "delay", defaultDelay);
						}
					}
				}
			});
			
		 },
		 /**
		  * evento del botón Expedientes_detail_link_cancel2, cuando el  diálogo está en modo alta
		  */
		 handlerCancelarAlta:function(){
			 $("#ModificacionEspecial_detail_div2").rup_dialog("close");
			 $("#ModificacionEspecial_detail_div2").rup_dialog("destroy");
		 },
		 /**
		  * Función para actualizar los datos del expediente y sus asociados
		  * Ajax POST pasando formulario, lista de expedientes a asociar, lista de expedientes a
		  * quitar de asociados y true o false dependiendo de si el responsable ha sido actualizado   
		  * o no
		  */
		 handlerGuardarExpediente:function(){
			 //añadimos un validador si no existe
			 if(dialogoDetalleModificacionEspecial.validador==null){
				 dialogoDetalleModificacionEspecial.validador = $("#ModificacionEspecial_detail_form2").rup_validate({
					 focusInvalid:true,
					 invalidHandler: function(form, validator) {
						 var errors = validator.numberOfInvalids();
						 if (errors) {                    
							 validator.errorList[0].element.focus();
						 }
					 },
					 submitHandler:function(){
						 $(".rup-maint_validateIcon").hide();
					 },
					 rules:{                      
						 "aexpe20":{required:true,noMenosUno:true},
						 "faper20":{required:true},
					 }
				 });
			 }
		            
			 if ($("#ModificacionEspecial_detail_form2").valid()) {
				 $(".rup-maint_validateIcon").hide();
				 $.rup_messages("msgConfirm", { 
					 title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
					 message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarModificarExpediente,
					 siNo:true,
					 OKFunction: function() {
						 //Se da guarda el expediente con los expedientes asociados
						 var send = {};
						 send["refExp"] = $("#refExp_detail_table").val();
						 send["cserv20"] = $("#cserv20_detail_table").val();
						 send["cexpe20"] = $("#cexpe20Hidden").val().substring($("#cexpe20Hidden").val().indexOf("-")+1);
						 send["nexpe20"] = $("#nexpe20_detail_table").val();
						 send["aexpe20"] = $("#aexpe20_detail_table").val();
						 send["faper20"] = $("#faper20_detail_table").val();
			        			
						 var dt = jQuery.toJSON(send);
						 var	url = "/aa21bOrgDocumentalWar/modificacionEspecial/actualizarExpedienteEsp";
			        			
						 $.ajax({
							 type : "POST",
							 dataType : "json",
							 data : dt,
							 contentType : "application/json",
							 url : url,
							 beforeSend : function(xhr, settings) {
								 xhr.setRequestHeader("bean", "Aa21b20s01");
							 },
							 success : function(xhr, options) {
								 
								 $("#ModificacionEspecial_detail_div2").rup_dialog("close");
								 
								 $("#ModificacionEspecial_feedback").rup_feedback("option", "delay", defaultDelay);
								 $("#ModificacionEspecial_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjExpActualizado") + " " + xhr, "ok");
								 $("#ModificacionEspecial_feedback").rup_feedback("show");
							 },
							 error : function(xhr, ajaxOptions, thrownError) {
								 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
								 if (xhr.responseText != null && xhr.responseText != "") {	
									 if (xhr.status === 406) {//si ha habido algun error...
										 $("#ModificacionEspecial_feedback").rup_feedback("option", "delay", null);
										 $("#ModificacionEspecial_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
										 $("#ModificacionEspecial_feedback").rup_feedback("option", "delay", defaultDelay);
									 } else {
										 $("#ModificacionEspecial_feedback").rup_feedback("option", "delay", null);
										 $("#ModificacionEspecial_feedback").rup_feedback("set", errorTXT, "error");								
										 $("#ModificacionEspecial_feedback").rup_feedback("option", "delay", defaultDelay);
									 }
								 }
							 }
						 });
					 }
				 });
			 }
		 }
}