var idioma=$.rup.lang;

jQuery(function($) {
	
	//Campo autocomplete para obtener la denominación del departamento en el campo de búsqueda
	/*$("#desc97_filter_table").rup_autocomplete({
		source : "../desbloqueosTablas/autocompleteDenoTablaCas",
		sourceParam : {
			label : "desc97",
			value : "desc97"
		},
		method : 'GET',
		width: "100",
		minLength : "3",
		change : function() {
			if ($("#desc97_filter_table_label").val() == "") {
				$("#desc97_filter_table").attr("value", "");
			}
		}
	});
	
	$("#dese97_filter_table").rup_autocomplete({
		source : "../desbloqueosTablas/autocompleteDenoTablaEusk",
		sourceParam : {
			label : "dese97",
			value : "dese97"
		},
		method : 'GET',
		width: "100",
		minLength : "3",
		change : function() {
			if ($("#dese97_filter_table_label").val() == "") {
				$("#dese97_filter_table").attr("value", "");
			}
		}
	});*/
	
	
	$("#DesbloqueosTablas").rup_table({
		rowNum:20,
		url: "../desbloqueosTablas",
		colNames: [
			$.rup.i18n.app.desbloqueoTablas.tabla97,
			$.rup.i18n.app.desbloqueoTablas.desc97,
			$.rup.i18n.app.desbloqueoTablas.dese97,
			$.rup.i18n.app.desbloqueoTablas.dese97,
			$.rup.i18n.app.desbloqueoTablas.dese97,
			$.rup.i18n.app.desbloqueoTablas.numBloqueados
		],
		colModel: [
			{ 	name: "tabla97", 
			 	label: $.rup.i18n.app.desbloqueoTablas.tabla97,
				hidden: true 
			},
			{ 	name: ($.rup_utils.capitalizedLang()=="Es"?"desc97":"dese97"), 
			 	label: $.rup.i18n.app.desbloqueoTablas.desc97,
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "dese97", 
			 	label: $.rup.i18n.app.desbloqueoTablas.dese97,
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "campo97", 
				hidden: true
			},
			{
				name: "cserv97",
				hidden: true
			},
			{ 	name: "numBloqueados", 
			 	label: $.rup.i18n.app.desbloqueoTablas.numBloqueados,
				align: "right", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			}
        ],

        model:"Aa21b97s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	//"search",
        	"multiselection"
         	],
		primaryKey: "tabla97",
		sortname: "desc97",
		sortorder: "asc",
		loadOnStartUp: true,
		ondblClickRow: handlerDetalle,
		loadComplete:fncTableCompleteDesbloqueosTablas,
		toolbar:{
			defaultButtons:[],
			newButtons:[
			    {
					id:"desbloquear",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.desbloquear, css: "desbloquear"},
					click: handlerDesbloquear
				},
				{
					id:"detalle",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
					click: handlerDetalle
				},
				{
					id:"refrescar",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.recargar, css: "recargar"},
					click: handlerRecargar
				},
			    {
					id:"imprimir",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					click: handlerImprimir
			    }]
		},
		formEdit:{
        	detailForm: "#DesbloqueosTablas_detail_div",
			fillDataMethod: "clientSide"
		},
        onPaging: function(){
			$("#DesbloqueosTablas").rup_table("deselectAllRows");
		}
	});
	
	/**
	 * Cambio de títulos y textos filtrar
	 */
	$("#DesbloqueosTablas_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#DesbloqueosTablas_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	
	$("#DesbloqueosTablas").on("rupTable_beforeEditRow", function(deleteOptions,selectedRow){
		return false;
	});
	
	jQuery("#DesbloqueosTablas").on("jqGridDblClickRow", function(event, form, oper) {
		handlerDetalle();
		return false;
	});
	
	jQuery("#dialogoDesbloqueoDetalle").on("dialogclose", function() {
		$("#DesbloqueosTablas").rup_table("filter");
	});
	
	
	//Ocultamos el botón de clonar
	$("[id='DesbloqueosTablas_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	 $("#DesbloqueosTablas_cb div").hide();
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteDesbloqueosTablas(e){

	$('[aria-describedby="DesbloqueosTablas_tabla97"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="DesbloqueosTablas_desc97"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="DesbloqueosTablas_dese97"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="DesbloqueosTablas_campo97"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="DesbloqueosTablas_numBloqueados"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	//Recorremos la tabla comprobando el campo numBloqueados. Si es mayor que 0, le asignaremos el color de la fuente a rojo
	if (e.rows != undefined && e.rows.length>0){					
		for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.numBloqueados>0){
				$("[aria-describedby='DesbloqueosTablas_numBloqueados']",$("tr[id='" + fila.tabla97 + "']")).css("color","#FF0000");
			}
		}
	}	
	
	
	/**
	 * Recorremos todos las celdas para asignarle el menu contextual (botón derecho) con los botones que 
	 * nosotros queremos. Al hacer click con el botón derecho se seleccionará la fila y deseleccionarán las demás
	 */
	$.each ($('[aria-describedby="DesbloqueosTablas_tabla97"]'), function(index, object){
		var codTabla97 = $(object).attr("grid_tooltip");
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
		
		
		$(object).attr("id", "tabla97_"+index );
		
		$("#tabla97_"+index).rup_contextMenu({
			items:{
				'detalle' : {name:"Detalle", icon: "detalle", disabled:false,
					callback: function (index, cell){
						handlerDetalle();
					}},
				'desbloquear' : {name: "Desbloquear", icon: "desbloquear", disabled:false,
					callback: function (index, cell){
						handlerDesbloquear();
					}}
			},
			className: "currently-showing-menu",
			trigger: 'right',
			autoHide: false,
			events: {
				show: function(opt){
					$("#DesbloqueosTablas").rup_table("resetSelection");
					$("#DesbloqueosTablas").rup_table("setSelection",[codTabla97],true);
					
				                
					//Funcion Escape
					$("#DesbloqueosTablas").keydown(function(e) {
						// ESCAPE key pressed
						if (e.keyCode == 27) {
							$("#jqContextMenu").next().hide(); $("#jqContextMenu").hide();
						}
					});
				}
			}
		});
		
	});
	
	$.each ($('[aria-describedby="DesbloqueosTablas_desc97"]'), function(index, object){
		var codTabla97 = $(object).attr("grid_tooltip");
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
		
		
		$(object).attr("id", "tabla97_"+index );
		
		$("#tabla97_"+index).rup_contextMenu({
			items:{
				'detalle' : {name:"Detalle", icon: "detalle", disabled:false,
					callback: function (index, cell){
						handlerDetalle();
					}},
				'desbloquear' : {name: "Desbloquear", icon: "desbloquear", disabled:false,
					callback: function (index, cell){
						handlerDesbloquear();
					}}
			},
			className: "currently-showing-menu",
			trigger: 'right',
			autoHide: false,
			events: {
				show: function(opt){
					$("#DesbloqueosTablas").rup_table("resetSelection");
					$("#DesbloqueosTablas").rup_table("setSelection",[codTabla97],true);
					
				                
					//Funcion Escape
					$("#DesbloqueosTablas").keydown(function(e) {
						// ESCAPE key pressed
						if (e.keyCode == 27) {
							$("#jqContextMenu").next().hide(); $("#jqContextMenu").hide();
						}
					});
				}
			}
		});
	});
	
	$.each ($('[aria-describedby="DesbloqueosTablas_dese97"]'), function(index, object){
		var codTabla97 = $(object).attr("grid_tooltip");
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
		
		
		$(object).attr("id", "tabla97_"+index );
		
		$("#tabla97_"+index).rup_contextMenu({
			items:{
				'detalle' : {name:"Detalle", icon: "detalle", disabled:false,
					callback: function (index, cell){
						handlerDetalle();
					}},
				'desbloquear' : {name: "Desbloquear", icon: "desbloquear", disabled:false,
					callback: function (index, cell){
						handlerDesbloquear();
					}}
			},
			className: "currently-showing-menu",
			trigger: 'right',
			autoHide: false,
			events: {
				show: function(opt){
					$("#DesbloqueosTablas").rup_table("resetSelection");
					$("#DesbloqueosTablas").rup_table("setSelection",[codTabla97],true);
					
				                
					//Funcion Escape
					$("#DesbloqueosTablas").keydown(function(e) {
						// ESCAPE key pressed
						if (e.keyCode == 27) {
							$("#jqContextMenu").next().hide(); $("#jqContextMenu").hide();
						}
					});
				}
			}
		});
	});

	$.each ($('[aria-describedby="DesbloqueosTablas_campo97"]'), function(index, object){
		var codTabla97 = $(object).attr("grid_tooltip");
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
		
		
		$(object).attr("id", "tabla97_"+index );
		
		$("#tabla97_"+index).rup_contextMenu({
			items:{
				'detalle' : {name:"Detalle", icon: "detalle", disabled:false,
					callback: function (index, cell){
						handlerDetalle();
					}},
				'desbloquear' : {name: "Desbloquear", icon: "desbloquear", disabled:false,
					callback: function (index, cell){
						handlerDesbloquear();
					}}
			},
			className: "currently-showing-menu",
			trigger: 'right',
			autoHide: false,
			events: {
				show: function(opt){
					$("#DesbloqueosTablas").rup_table("resetSelection");
					$("#DesbloqueosTablas").rup_table("setSelection",[codTabla97],true);
					
				                
					//Funcion Escape
					$("#DesbloqueosTablas").keydown(function(e) {
						// ESCAPE key pressed
						if (e.keyCode == 27) {
							$("#jqContextMenu").next().hide(); $("#jqContextMenu").hide();
						}
					});
				}
			}
		});
	});
	
	$.each ($('[aria-describedby="DesbloqueosTablas_numBloqueados"]'), function(index, object){
		var codTabla97 = $(object).attr("grid_tooltip");
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
		
		
		$(object).attr("id", "tabla97_"+index );
		
		$("#tabla97_"+index).rup_contextMenu({
			items:{
				'detalle' : {name:"Detalle", icon: "detalle", disabled:false,
					callback: function (index, cell){
						handlerDetalle();
					}},
				'desbloquear' : {name: "Desbloquear", icon: "desbloquear", disabled:false,
					callback: function (index, cell){
						handlerDesbloquear();
					}}
			},
			className: "currently-showing-menu",
			trigger: 'right',
			autoHide: false,
			events: {
				show: function(opt){
					$("#DesbloqueosTablas").rup_table("resetSelection");
					$("#DesbloqueosTablas").rup_table("setSelection",[codTabla97],true);
					
				                
					//Funcion Escape
					$("#DesbloqueosTablas").keydown(function(e) {
						// ESCAPE key pressed
						if (e.keyCode == 27) {
							$("#jqContextMenu").next().hide(); $("#jqContextMenu").hide();
						}
					});
				}
			}
		});
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}

function handlerDetalle(){
	
	var registros = [];
	if($("#DesbloqueosTablas").rup_table("getSelectedRows") != ""){
				
		registros = $("#DesbloqueosTablas").rup_table("getSelectedLines");
		if(registros.length == 1)
		{
			var indice = registros[0]-1;
			var tabla = $("#DesbloqueosTablas").rup_table("getRowData")[indice];
			var codigo = tabla.tabla97;
			var campoBloqueo = tabla.campo97;
			var campoServicio = tabla.cserv97;
			
			var descTabla = "";
			if(idioma == "es"){
				descTabla = tabla.desc97;
			}else{
				descTabla = tabla.dese97;
			}
			
			
			
			if(codigo != "")
			{
				$("#dialogoDesbloqueoDetalle").rup_dialog({	
					type:$.rup.dialog.AJAX,
					url:"/aa21bOrgDocumentalWar/desbloqueosTablasDetalle/mantDesbloqueosDetalle?tablaID=" + codigo + "&bloqueoID=" +campoBloqueo+"&campoServicio="+campoServicio+"&serviciousu="+$("#servicioLogueado").val(),
					modal:true,
					height:500,
					width:1100,	
					resizable:true,
					title:$.rup.i18n.app.desbloqueoTablas.desbloqueoDetalleTit + "" + descTabla,
					autoOpen:true,
					showLoading:true,
			        async:false, 
			        zIndex: -1,
			        buttons: [{
			             text: $.rup.i18n.base.rup_global.close,
			             click: function () {
			                 $("#dialogoDesbloqueoDetalle").rup_dialog("close");
			             }
			         }]
				});
			}else{
				$.rup_messages("msgAlert", {message: $.rup.i18n.base.rup_grid.nav.alerttext});
			}
		}else{
			$.rup_messages("msgAlert", {message: $.rup.i18n.base.rup_grid.nav.alerttext});
		}
	}
}
function handlerRecargar(){
	
	$("#DesbloqueosTablas").rup_table("filter");
}
function handlerImprimir(){
	if($("#DesbloqueosTablas").rup_table("getDataIDs").length > 0){
		$('#itabla97').val($('#tabla97_filter_table').val());
		$('#idesc97').val($('#desc97_filter_table').val());
		$('#idese97').val($('#dese97_filter_table').val());
	
		var form = document.forms["frmImprimir"];
		form.submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}
};


/**
 * 
 * Función que desbloquea los registros seleccionados de la tabla de la que se están mostrando los detalles.
 * Para ello paso en la url la tabla en minúsculas, que corresponde a su controller. Se llama al método updateBloqueos.
 * Creo un objeto json mediante el array de campos de la tabla 98 y le asigno a cada uno su valor, excepto al campo BLOQ(num tabla) y
 * USUB(num tabla) a los que asignaré 0 y null respectivamente
 */
function handlerDesbloquear(){
	var registros = [];
	if($("#DesbloqueosTablas").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarDesbloqueoTablas,
			siNo:true,
			OKFunction: function() {
			   registros = $("#DesbloqueosTablas").rup_table("getSelectedLines");
			   desbloquearTabla(registros);
			   
			   $("#DesbloqueosTablas").rup_table("filter");
			}
		});
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
};

function desbloquearTabla(registros) {

	for(var i=0;i<registros.length;i++) {
		   //Resto uno al índice para coger el registro que esta seleccionado.
		   var indice = registros[i]-1;
		   var registro = $("#DesbloqueosTablas").rup_table("getRowData")[indice];
		   var codigo = registro.tabla97;
		   var tablaDesbloquear = registro.tabla97.toLowerCase();

		   var url = "../"+tablaDesbloquear+"/updateBloqueos";

		   //Mandamos el objeto send a null para que haga desbloqueo de toda la tabla, sin filtrar por código
		   var send = null;

		   var dt = jQuery.toJSON(send);
		   $.ajax({
			   url:url,
			   type: "POST",
			   contentType: "application/json; charset=utf-8",
			   dataType: "json",
			   data: dt,
			   async:false,
			   cache:false,
			   error: callback_error,
			   success: function(data) {
				   $("#DesbloqueosTablas_feedback").rup_feedback("option", "delay", defaultDelay);
				   if(registros.length > 1) {
					   $("#DesbloqueosTablas_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.desbloqueoOK"), "ok");
				   } else {
					   $("#DesbloqueosTablas_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.desbloqueoOK"), "ok");
				   }
				   $("#DesbloqueosTablas").rup_table("setSelection", codigo, false);
				   $("#DesbloqueosTablas_feedback").rup_feedback("show");
				   registros = $("#DesbloqueosTablas").rup_table("getSelectedLines");
				   desbloquearTabla(registros);
			   }
		   });
	   }
};

function callback_error(xhr, ajaxOptions, thrownError) {
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#DesbloqueosTablas_feedback").rup_feedback("option", "delay", null);
			 $("#DesbloqueosTablas_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#DesbloqueosTablas_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#DesbloqueosTablas_feedback").rup_feedback("option", "delay", null);
			 $("#DesbloqueosTablas_feedback").rup_feedback("set", errorTXT, "error");
			 $("#DesbloqueosTablas_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}

function openHelp() {
	crearAyuda($.rup.i18n.app.ayudaDesbloqueo,"ayuda_feedback");
}

//20161020 INI - INIGO
function limpiarDesbloqueoTablas() {
	//Limpiamos los campos del filtro...
	$("#DesbloqueosTablas_filter_summary").html("<i></i>");
	$("#DesbloqueosTablas").rup_table("deselectAllRows");
	$("#DesbloqueosTablas").rup_table("cleanFilterForm");
	//Limpiamos el grid...
	$("#DesbloqueosTablas").rup_table("clearGridData", false);
	$("#DesbloqueosTablas").rup_table("resetForm", $("#DesbloqueosTablas_filter_form"));
}
//20161020 FIN - INIGO