jQuery(function($){
	
	
	$("#FasesExpedientes").rup_table({
		rowNum:20,
		url: "../aa21b21s01",
		colNames: [
		    "idFaseExp",
			"cserv21",
			"cexpe21",
			"aexpe21",
			"nexpe21",
			"cfase21",
			"codPid21",
			"tdocu21",
			"fprevi21",
			"freal21"
		],
		colModel: [
		    { 	
		    	name: "idFaseExp", 
		    	label: "idFaseExp",
		    	hidden: true 
		    },
			{ 	name: "cserv21", 
			 	label: "cserv21",
				hidden: true 
			},
			{ 	name: "cexpe21", 
			 	label: "cexpe21",
				hidden: true 
			},
			{ 	name: "aexpe21", 
			 	label: "aexpe21",
				hidden: true 
			},
			{ 	name: "nexpe21", 
			 	label: "nexpe21",
				hidden: true 
			},
			{ 	name: "cfase21", 
			 	label: "cfase21",
				align: "right", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "codPid21", 
			 	label: "codPid21",
				hidden: true 
			},
			{ 	name: "tdocu21", 
			 	label: "tdocu21",
				hidden: true 
			},
			{ 	name: "fprevi21", 
			 	label: "fprevi21",
				align: "left", 
				width: 150, 
				editable: true, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "freal21", 
			 	label: "freal21",
				align: "left", 
				width: 150, 
				editable: true, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b21s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	//"search",
        	"multiselection"
         	],
		primaryKey: "idFaseExp",
		multiplePkToken:";",
		sortname: "cserv21",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteFasesExpedientes,
		toolbar:{
			newButtons:[
			    {
					id:"imprimir",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					click: handlerImprimir
			    }]
		},
        formEdit:{
        	detailForm: "#FasesExpedientes_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					//$("#divCtipoe02").css("display","none");
					$("#cexpe02_detail_table").attr("class","formulario_linea_input");
				}	
			},
			editOptions:{
				beforeShowForm:function(){
					$("#divCcexpe21").css("display","block");
					$("#cserv21_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cserv21_detail_table").attr("readonly","readonly");
					$("#cexpe21_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cexpe21_detail_table").attr("readonly","readonly");
					$("#aexpe21_detail_table").attr("class","formulario_linea_input_disabled");
					$("#aexpe21_detail_table").attr("readonly","readonly");
					$("#nexpe21_detail_table").attr("class","formulario_linea_input_disabled");
					$("#nexpe21_detail_table").attr("readonly","readonly");
					$("#cfase21_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cfase21_detail_table").attr("readonly","readonly");
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				//afterShowForm:function(){
				//	jQuery("#delmodFasesExpedientes").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
				//		desbloquear(jQuery("#FasesExpedientes"), "aa21b21s01");
				//	});
				//}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cserv21":{
						required: true
    					},
    				"cexpe21":{
						required: true
    					},
    				"aexpe21":{
						required: true
    					},
    				"nexpe21":{
						required: true
    					},
    				"cfase21":{
						required: true
    					},
    				"codPid21":{
						required: false
    					},
    				"tdocu21":{
						required: false
    					},
    				"fprevi21":{
						required: false
    					},
    				"freal21":{
						required: false
    					}
    				}
    		}
        },
        onPaging: function(){
			$("#FasesExpedientes").rup_table("deselectAllRows");
		}
	});
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	//jQuery("#FasesExpedientes").on("rupTable_beforeDeleteRow", function(event, row) {
	//	return bloquear('edit', $(this), "aa21b21s01", "cexpe21");
	//});
	//jQuery("#FasesExpedientes").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
	//	return bloquear(oper, $(this), "aa21b21s01", "cexpe21");
	//});
	//jQuery("#FasesExpedientes_detail_div").on("dialogclose", function() {
	//	desbloquear(jQuery("#FasesExpedientes"), "aa21b21s01");
	//});
	//jQuery(window).bind('beforeunload', function() {
	//    // Aquí iría la función que desbloquea : 
	//	desbloquear(jQuery("#FasesExpedientes"), "aa21b21s01");
	//});
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	
	
	//Ocultamos el botón de clonar
	$("[id='FasesExpedientes_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	
	
	
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteFasesExpedientes(){
	
	
	$('[aria-describedby="FasesExpedientes_cserv21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_cexpe21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_aexpe21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_nexpe21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_cfase21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_codPid21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_tdocu21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_fprevi21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="FasesExpedientes_freal21"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	
	
	$.each ($('[aria-describedby="FasesExpedientes_cserv21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_cexpe21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_aexpe21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_nexpe21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_cfase21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="FasesExpedientes_codPid21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_tdocu21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_fprevi21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="FasesExpedientes_freal21"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}



function limpiarFases(){
	
	$("#FasesExpedientes").rup_table("clearGridData");
}