var idioma=$.rup.lang;
var modo;
var codigoPrincipal;
var servicioSel;
jQuery(function($){

	//Combo situación en pantalla búsqueda
	$("#situ15_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function() {
			$("#situ15_filter_table").rup_combo("selectLabel", $("situ15_filter_table").val());
		}
	});
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ15_filter_table").rup_combo("select","A");

	$("#bt_seleccionarResponsable").click(seleccionarUsuarioXLNETs);

	$("#tipoUsuario").click(function() {
		$("#bt_seleccionarResponsable").show();
		$("#label_dusu15").hide();
		$("#dusu15_detail_table").attr("readonly","readonly");
		//$("#cserv15_detail_table").val("");
		$("#dusu15_detail_table").val("");
	});

	$("#tipoResponsable").click(function() {
		$("#label_dusu15").show();
		$("#bt_seleccionarResponsable").hide();
		//$("#cserv15_detail_table").val("");
		$("#dusu15_detail_table").val("");
		$("#dusu15_detail_table").removeAttr("readonly");
	});

	//Tabla grid usuarios
	$("#Usuarios").rup_table({
		rowNum:20,
		url: "../aa21b15s01",
		colNames: [
			$.rup.i18n.app.aa21b15s01.cusu15,
			$.rup.i18n.app.aa21b15s01.dusu15,
			$.rup.i18n.app.aa21b15s01.cserv15,
			$.rup.i18n.app.aa21b15s01.cserv15,
			$.rup.i18n.app.aa21b15s01.situ15
		],
		colModel: [
			{ 	name: "cusu15",
			 	label: "cusu15",
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "dusu15",
			 	label: "dusu15",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "cserv15",
			 	label: "cserv15",
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{
				name: idioma=="es"?"dserv15":"eserv15",
				label: $.rup.i18n.app.aa21b15s01.cserv15,
				index: idioma=="es"?"dserv15":"eserv15",
				width: 150,
				align: "left",
				editable:false,
				sortable:true
			},
			{ 	name: "situ15",
			 	label: "situ15",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			}
        ],

        model:"Aa21b15s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "cusu15",
		sortname: "situ15,dusu15",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteUsuarios,
		toolbar: {
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsulta
			    },
			    {
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					ocultar:true,
					comportamiento:"delete",
					click: handlerCambioEstado
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: handlerImprimirUsuarios
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: handlerExcelUsuarios
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ15");
		},
        formEdit: {
        	detailForm: "#Usuarios_detail_div",
			fillDataMethod: "clientSide",
			addOptions: {
				beforeShowForm:function() {
					//Ponemos el titulo en modo añadir y mostramos las marcas de obligatorio
					$("#ui-dialog-title-Usuarios_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjNuevoUsuario"));
					$("#labelOblig").show();
					$(".asterisco").show();
					$("#bt_seleccionarResponsable").show();
					$("#label_dusu15").hide();
					//$("#cserv15_detail_table").val("");
					$("#dusu15_detail_table").val("");
					$("#dusu15_detail_table").attr("readonly","readonly");
					$("#divCusu15").css("display","none");
					$("#cusu15_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cusu15_detail_table").attr("readonly","readonly");
					$("#cserv15_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cserv15_detail_table").attr("readonly","readonly");
					$("#Usuarios_detail_link_cancel").css("display","block");
					//$("#cserv15_detail_table").rup_combo("setRupValue","");
					//Por defecto la situación la marco en Alta para la pantalla de nuevo
					$("#divSituacion").hide();
					$("#situ15_detail_table").val("A");
					$("#selecTipo").show();
					$("#tipoUsuario").attr("checked","true");
					$("#fieldExpAsoc").hide();
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			editOptions: {
				beforeShowForm:function() {
					//Cargo expedientes asociados
					cargaAsociadosUsuarios();
					$("#bt_seleccionarResponsable").hide();
					$("#label_dusu15").show();
					$("#cserv15_detail_table").attr("class","formulario_linea_input_disabled");
					$("#cserv15_detail_table").attr("readonly","readonly");
					$("#divSituacion").show();
					$("#situ15_detail_table").rup_combo("disable");
					$("#dusu15_detail_table").attr("readonly","readonly");
					$("#selecTipo").hide();
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle").val() == "C") {
						$("#Usuarios_detail_div :input").attr("readonly","readonly");
						$("#Usuarios_detail_link_cancel").css("display","none");
						//Ponemos el titulo en modo modificar y mostramos las marcas de obligatorio
						$("#ui-dialog-title-Usuarios_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjVerUsuario"));
						$("#labelOblig").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
					} else {
						//Ponemos el titulo en modo consulta y ocultamos las marcas de obligatorio
						$("#ui-dialog-title-Usuarios_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjEditarUsuario"));
						$("#labelOblig").show();
						$(".asterisco").show();
						$("#Usuarios_detail_div :input").removeAttr("readonly");
						$("#Usuarios_detail_link_cancel").css("display","block");
						servicioSel = $("#cserv15_detail_table").val();
					}
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions: {
				afterShowForm:function() {
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('Usuarios');

					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar y el check tramitable
					 */
					$("#first_TiposExpedientes").on('click', function() {
						validacionBotonGuardado('Usuarios');
					});
					$("#back_TiposExpedientes").on('click', function() {
						validacionBotonGuardado('Usuarios');
					});
					$("#forward_TiposExpedientes").on('click', function() {
						validacionBotonGuardado('Usuarios');
					});
					$("#last_TiposExpedientes").on('click', function() {
						validacionBotonGuardado('Usuarios');
					});

					$("#cserv15_detail_table").val($("#servicioXLNET").val());
					$("#cserv15_detail_table").rup_combo("select",$("#servicioXLNET").val());
					$("#cserv15_detail_table").rup_combo("setRupValue",$("#servicioXLNET").val());
				}
			},
			deleteOptions: {
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function() {
					jQuery("#delmodUsuarios").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#Usuarios"), "aa21b15s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate: { 
    			rules: {
    				"cusu15": { required: true },
    				"dusu15": { required: true },
    				"cserv15":{ required: true },
    				"situ15": {	required: true }
    			}
    		}
        },
        onPaging: function() {
			$("#Usuarios").rup_table("deselectAllRows");
		}
	});

	/**
	 * Cambio de títulos y textos filtrar
	 */
	$("#Usuarios_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#Usuarios_filter_filterButton").val($.rup.i18n.app.comun.buscar);

	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#Usuarios").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa21b15s01", "dusu15");
	});
	jQuery("#Usuarios").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		if($("#modoDetalle").val() != "C") {
			return bloquear(oper, $(this), "aa21b15s01", "dusu15");
		} else {
			return true;
		}
	});
	jQuery("#Usuarios_detail_div").on("dialogclose", function() {
		if($("#modoDetalle").val() != "C") {
			desbloquear(jQuery("#Usuarios"), "aa21b15s01");
		}
		$("#modoDetalle").val("");
		$("#ExpAsociadosUsuario").rup_table("clearGridData",true);
		$("#Usuarios").rup_table("deselectAllRows");
	});

	jQuery(window).bind('beforeunload', function() {
        // Aquí iría la función que desbloquea:
		if($("#modoDetalle").val() != "C") {
			desbloquear(jQuery("#Usuarios"), "aa21b15s01");
		}
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	/*
	 * Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#Usuarios").on("jqGridSelectRow", function(event, form, oper) {
		if(oper) {
			if(!todosEnAlta($(this),"situ15")) {
				desactivar('Usuarios');
		 	 } else {
		 		activar('Usuarios');
		 	 }
		}
		comprobacionEliminar('Usuarios');
	});
	jQuery("#Usuarios").on("rupTable_beforeEditRow", function(event, form, oper) {
		if($("#modoDetalle").val() != "C") {
			return  todosEnAlta($(this),"situ15");
		} else {
			return true;
		}
	});
	/*
	 * Fin funciones control si estado es baja no pueda editar 
	 */

	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente en modo Consulta
	 */
	$("#ExpAsociadosUsuario").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociadosUsuario").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociadosUsuario").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociadosUsuario").rup_table("getRowData")[posLinea].idExpe;
		dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
		return false;
	});

	$("#ExpAsociadosUsuario").on("rupTable_beforeEditRow", function(event, form, oper) {
		return false;
	});

	/* Se llama a la función para refrescar la descripción del servicio al pulsar en los botones de paginación*/
	jQuery("#Usuarios").on("jqGridAddEditAfterClickPgButtons", function(event, form, oper) {
		cargaAsociadosUsuarios();
		if($("#dserv15").val().trim() == "-") {
			$("#cserv15_detail_table").val("");
			$("#cserv15_detail_table").rup_combo("select","");
		}
		return;
	});

	//Combo situación en pantalla detalle
	$("#situ15_detail_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		blank: "",
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function() {
			$("#situ15_detail_table").rup_combo("selectLabel", $("situ15_detail_table").val());
		}
	});

	//Campo autocomplete para buscar por descripción de servicios en la pantalla detalle
	/*$("#desc_serv_detail_table").rup_autocomplete({
		source : idioma=="es"?"../aa21b15s01/autocompleteDserv15cas":"../aa21b15s01/autocompleteDserv15eusk",
		sourceParam : {
			label : idioma=="es"?"DServ13":"EServ13",
			value : "CServ13"
		},
		method : 'GET',
		width: "100",
		getText:false,
		minLength : "3",
		change : function() {
			if ($("#desc_serv_detail_table_label").val() == "") {
				$("#desc_serv_detail_table").attr("value", "");
				$("#cserv15_detail_table").val("");
			}else{
				$("#cserv15_detail_table").val($("#desc_serv_detail_table").val());
			}
		}
	});*/

	//Combo Servicios pantalla detalle
	$("#cserv15_detail_table").rup_combo({
		source: "../aa21b13s01/comboServicios",
		sourceParam : {
			label : idioma == 'es' ? "DServ13"	: "EServ13",
			value : "CServ13"
		},
		width : "500",
		blank: "",
		selected:""
	});

	$("#cserv15_detail_table").on("change",function(event) {
		setTimeout(function() {
			if($("#cserv15_detail_table").val() != null && $("#cserv15_detail_table").val() != servicioSel) {
				$("#cambioServ15").val('S');
			} else {
				$("#cambioServ15").val('N');
			}
		}, 100);
	});

	//Ocultamos el botón de clonar
	$("[id='Usuarios_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");

	//Meto en el apartado filtro el literal de que esta en situación Alta
	//$("#Usuarios_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b15s01.situ15 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");

	//Tabla expedientes asociados al usuario
	$("#ExpAsociadosUsuario").rup_table({
		rowNum:6,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo",
			"objeto20"
		],
		colModel: [
		    {  name: "refExp",
		       label: "refExp",
        	   align: "center",
        	   width:280,
        	   editable: true,
        	   fixed: false,
        	   hidden: false,
        	   resizable: false,
        	   sortable: true
            },
            {  name: "grupo",
        	   label: "grupo",
        	   hidden: true
		    },
			{  name: "idExpe",
			   label: "idExpe",
			   editable: true,
			   fixed: false,
			   hidden: true,
			   resizable: true,
			   sortable: true
			},
			{  name: "cesta20",
			   label: "cesta20",
			   editable: true,
			   fixed: false,
			   hidden: true,
			   resizable: true,
			   sortable: true
			},
			{  name: "cserv20",
	           label: "cserv20",
	           hidden: true
	        },
	        {  name: "cexpe20",
	           label: "cexpe20",
	           hidden: true
	        },
	        {  name: "aexpe20",
	           label: "aexpe20",
	           hidden: true
            },
            {  name: "nexpe20",
        	   label: "nexpe20",
        	   hidden: true
            },
            {  name: "grupo",
        	   label: "grupo",
        	   hidden: true
            },
            {  name: "objeto20",
        	   label: "objeto20",
        	   hidden: true
           }
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"toolbar",
        	"filter",
        	"formEdit",
           	"fluid",
           	"feedback"
         	],
     	filter:{
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");

			/**
			 * Cambiamos el tooltip para que al posicionarse encima de la celda en vez de aparecer el titulo con la referencia
			 * aparezca el objeto
			 */
			var ref = rowdata["refExp"];
			var objeto20 = rowdata["objeto20"];
			$("td[rup_tooltip='" + ref + "'").attr("rup_tooltip",objeto20);
		},
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpAsociadosUsuario,
		toolbar:{
			defaultButtons:{
				   add: false,
				   edit: false,
				   cancel: false,
				   save: false,
				   clone: false,
				   "delete": false
				},
				newButtons:[{
					id:"detalleExpAsociadoUbicacion",
					obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "rup-icon detalle"},
					click:function(event, form, oper){
						handlerDetalleExpAsociadoUsuario();
					}
				}]
		}
	});

	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados Depar
	$(".ui-paging-info").hide();
	$(".ui-pg-selbox").hide();
	$("#first_ExpAsociadosUsuario_pager").hide();
	$("#last_ExpAsociadosUsuario_pager").hide();
	$("#ExpAsociadosUsuario_pager_left").hide();

	$("#Usuarios_filter_cleanLink").unbind("click");
	$("#Usuarios_filter_cleanLink").click(limpiar);
	$("#Usuarios_cb div").hide();
	$("#Usuarios").unbind("dblclick");

	dialogoConsultaEspedientesAsociados.ocultarElementos();
	dialogoFase.ocultarElementos();
	dialogoHistorico.ocultarElementos();
	dialogoDocumentos.ocultarElementos();

	/**
	 * Función al hacer click en el botón guardar
	 */
	$("#Usuarios_detail_button_save").on("click", function(event) {
		if($("#modoDetalle").val() == "M") {
			var properties = {
				feedback:$("#Usuarios_detail_feedback"),
			 	success: function(data) {
			 		$("#Usuarios_detail_div").rup_dialog("close");
			 		$("#Usuarios_feedback").rup_feedback("option", "delay", defaultDelay);
			 		$("#Usuarios_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.base,"rup_table.modifyOK"), "ok");
			 		$("#Usuarios_feedback").rup_feedback("show");
			 	},
			 	error : function(xhr, ajaxOptions, thrownError) {
		        	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
		        	 if (xhr.responseText != null && xhr.responseText != "") {
		        		 if (xhr.status === 406) {//si ha habido algun error...
		        			 $("#Usuarios_detail_feedback").rup_feedback("option", "delay", null);
		        			 $("#Usuarios_detail_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
		        			 $("#Usuarios_detail_feedback").rup_feedback("option", "delay", defaultDelay);
		        		 } else {
		        			 $("#Usuarios_detail_feedback").rup_feedback("option", "delay", null);
		        			 $("#Usuarios_detail_feedback").rup_feedback("set", errorTXT, "error");
		        			 $("#Usuarios_detail_feedback").rup_feedback("option", "delay", defaultDelay);
		        		 }
		        	 }
	      		},
	      		validate: {
	    			rules: {
	    				"cusu15": { required: true },
	    				"dusu15": { required: true },
	    				"cserv15":{ required: true },
	    				"situ15": { required: true }
	    			}
	    		}};

				$("#Usuarios_detail_form").rup_form("destroy");
				$("#Usuarios_detail_form").rup_form(properties);

				jQuery("#Usuarios_detail_form").attr("method","POST");

				jQuery("#Usuarios_detail_form").attr("action","../aa21b15s01/guardarFaseExpediente");
				jQuery("#Usuarios_detail_form").submit();
		} else {
			return false;
		}
	});

	//Combo multiselección Servicios para posterior búsqueda
	$("#cserv15_filter_table").rup_combo({
		source: "../aa21b15s01/comboServiciosResponsables",
		sourceParam: {
			label : idioma == 'es' ? "DServ13" : "EServ13",
			value : "CServ13"
		},
		width: 400,
		showValue: true,
		token: " - ",
		multiselect: true,
		multiOptgroupIconText : true,
		submitAsString : true,
		method : 'GET',
		filterMultiple:true,
		selected: [""+$("#servicioXLNET").val()],
		onLoadSuccess: function() {
			//$("#Usuarios").rup_table("cleanFilterForm");
			//Limpiamos el grid...
			//$("#Usuarios").rup_table("clearGridData", false);
			//$("#cserv15_filter_table").rup_combo("select",[$("#servicioXLNET").val()]);
			//$("#cserv15_filter_table").rup_combo("setRupValue",[$("#servicioXLNET").val()]);
			//$("#Usuarios").html("");
			
			$("#Usuarios").rup_table("filter");
		}
	});
	
	$("#Usuarios").on("rupTable_beforeFilter", function(){ 
		var txtFilterSummary = "";
		if ($("#dusu15_filter_table").val()!=undefined && $("#dusu15_filter_table").val()!= null && $("#dusu15_filter_table").val().length) {
			txtFilterSummary += $.rup.i18n.app.aa21b15s01.dusu15 + " = " + $("#dusu15_filter_table").val() + ", ";
		}
		if ($("#servicioXLNET").val()!=undefined && $("#servicioXLNET").val()!= null && $("#servicioXLNET").val().length) {
			txtFilterSummary += $.rup.i18n.app.aa21b15s01.cserv15 + " = [" + $("#cserv15_filter_table").rup_combo("label") + "], ";
		}
		txtFilterSummary += $.rup.i18n.app.aa21b15s01.situ15 + " = " + $("#situ15_filter_table").rup_combo("label");
		$("#Usuarios_filter_summary").html("<span style='font-style:italic;'>" + txtFilterSummary + "</span>");
	});
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función.
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteUsuarios(e) {
	$('[aria-describedby="Usuarios_cusu15"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default");
	$('[aria-describedby="Usuarios_dusu15"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default");
	$('[aria-describedby="Usuarios_cserv15"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default");
	$('[aria-describedby="Usuarios_situ15"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default");

	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0) {
		/*for (var i=0; i<e.rows.length; i++) {
			var fila = e.rows[i];
			if(fila.situ15=="B"){
				$("tr[id='" + fila.cusu15 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.cusu15 + "']").css("font-style","italic");
				$("tr[id='" + fila.cusu15 + "']").css("background","#848484");
			}
		}*/
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='Usuarios_toolbar##imprimir']").show();
		$("[id='Usuarios_toolbar##excel']").show();
	} else {
		//Si hay registros, ocultamos los botones de Imprimir y de Excel
		$("[id='Usuarios_toolbar##imprimir']").hide();
		$("[id='Usuarios_toolbar##excel']").hide();
	}

	$.each ($('[aria-describedby="Usuarios_cusu15"]'), function(index, object) {
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>";
	});
	$.each ($('[aria-describedby="Usuarios_dusu15"]'), function(index, object) {
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>";
	});
	$.each ($('[aria-describedby="Usuarios_cserv15"]'), function(index, object) {
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>";
	});
	$.each ($('[aria-describedby="Usuarios_situ15"]'), function(index, object) {
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>";
	});
	$(".rup-icon-clone").parent().css("display","none");
}

/**
 * Función que cambia la situación de alta a baja y viceversa
 */
function handlerCambioEstado() {
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	if($("#Usuarios").rup_table("getSelectedRows") != "") {
		$.rup_messages("msgConfirm", {
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			OKFunction: function() {
				registros = $("#Usuarios").rup_table("getSelectedLines");
				cambiarEstadoLinea(registros);
				$("#Usuarios").rup_table("filter");
				$("#Usuarios").rup_table("setSelection", regBloqueados, true);
			}
		});
	} else {
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
};

function cambiarEstadoLinea(registros) {

	for(var i=0;i<registros.length;i++) {
		var indice = registros[i]-1;
		var exp = $("#Usuarios").rup_table("getRowData")[indice];
		var codigo = exp.cusu15;
		var noBloqueado = bloquear("change", $("#Usuarios"), "aa21b15s01", "dusu15",codigo);
		if(noBloqueado) {
			var send = {};
			send["cusu15"] = exp.cusu15;
			send["dusu15"] = exp.dusu15;
			send["cserv15"] = exp.cserv15;
			if(exp.situ15 == "Alta") {
				send["situ15"] = "B";
			} else if(exp.situ15 == "Baja") {
				send["situ15"] = "A";
			}
			var dt = jQuery.toJSON(send);
			$.ajax({
				url: "../aa21b15s01/cambioEstadoUsuario",
				type: "POST",
				contentType: "application/json; charset=utf-8",
				dataType: "json",
				data: dt,
				async:false,
				cache:false,
				error: function(data) {
					desbloquear(jQuery("#Usuarios"), "aa21b15s01");
					callback_error();
				},
				success: function(data) {
					desbloquear(jQuery("#Usuarios"), "aa21b15s01");
					$("#Usuarios_feedback").rup_feedback("option", "delay", defaultDelay);
					if(registros.length > 1) {
						$("#Usuarios_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b15s01.cambioEstadoOK"), "ok");
					} else {
						$("#Usuarios_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b15s01.cambioEstadoOK"), "ok");
					}
					$("#Usuarios_feedback").rup_feedback("show");
					$("#Usuarios").rup_table("setSelection", codigo, false);

					registros = $("#Usuarios").rup_table("getSelectedLines");
					cambiarEstadoLinea(registros);
				}
			});
		} else {
			regBloqueados[indiceBloq] = codigo;
			indiceBloq++;
		}
	}
};

function callback_error(xhr, ajaxOptions, thrownError) {
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#Usuarios_feedback").rup_feedback("option", "delay", null);
			 $("#Usuarios_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#Usuarios_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#Usuarios_feedback").rup_feedback("option", "delay", null);
			 $("#Usuarios_feedback").rup_feedback("set", errorTXT, "error");
			 $("#Usuarios_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}

/**
 * Función imprimir usuarios PDF
 */
function handlerImprimirUsuarios() {
	if($("#Usuarios").rup_table("getDataIDs").length > 0) {
		$('#icusu15').val($('#cusu15_filter_table').val());
		$('#idusu15').val($('#dusu15_filter_table').val());
		$('#isitu15').val($('#situ15_filter_table').val());
		$('#icserv15').val($('#cserv15_filter_table').val());
		$("#frmImprimirUsuarios").attr("action","../imprimirMantGenerales/imprimirUsuarios");
		$("#frmImprimirUsuarios").attr("target","_blank");
		var form = document.forms["frmImprimirUsuarios"];
		form.submit();
	} else {
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}
}

/**
 * Función generación Excel usuarios
 */
function handlerExcelUsuarios() {
	if($("#Usuarios").rup_table("getDataIDs").length > 0) {
		$('#icusu15').val($('#cusu15_filter_table').val());
		$('#idusu15').val($('#dusu15_filter_table').val());
		$('#isitu15').val($('#situ15_filter_table').val());
		$('#icserv15').val($('#cserv15_filter_table').val());
		$("#frmImprimirUsuarios").attr("action","../aa21b15s01/excelUsuarios");
		$("#frmImprimirUsuarios").attr("target","_blank");
		$("#frmImprimirUsuarios").submit();
	} else {
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}
}

function limpiar() {
	$("#situ15_filter_table").val("");
	$("#Usuarios").rup_table("deselectAllRows");
	$("#Usuarios_filter_summary").html("<i></i>");
	$("#Usuarios").rup_table("clearGridData",true);
	$("#Usuarios").rup_table("resetForm", $("#Usuarios_filter_form"));
	
	$("#cserv15_filter_table").rup_combo("select", [""+$("#servicioXLNET").val()]);
}

function handlerConsulta() {
	$("#modoDetalle").val("C");
	$("#Usuarios").rup_table("editElement");
}

function cargaAsociadosUsuarios() {
	$("#ExpAsociadosUsuario").rup_table("setGridParam", {url: "../aa21b15s01/obtenerExpedientesUsuarioServ/" + $("#cusu15_detail_table").val()});
	$("#ExpAsociadosUsuario").rup_table("filter");
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociadosUsuario(e) {
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0) {
		$("#fieldExpAsoc").show();
		/*for (var i=0; i<e.rows.length; i++) {
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	} else {
		$("#fieldExpAsoc").hide();
	}
}

function openHelp() {
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}

/*DIÁLOGO BUSCAR PERSONA XLNETS INI*/
function seleccionarUsuarioXLNETs() {
	var ventanaDialogoAprobar = $("#dialogoBuscarPersonaXLNETs").rup_dialog({
		type:$.rup.dialog.DIV,
		//url:"/aa21bOrgDocumentalWar/xlnets/xlnetsBuscaUsuario",
		autoOpen: false,
		modal: true,
		resizable: false,
		minWidth: 600,
		minHeight: 300,
		title:$.rup.i18n.app.aa21b15s01.seleccionUsuarioTit,
		buttons: [{
			text: "Cancelar",
			click: function () {
				$("#dialogoBuscarPersonaXLNETs").rup_dialog("close");
			},
			btnType: $.rup.dialog.LINK
		}]
	});
	limpiarBusqXLNET();
	$("#dialogoBuscarPersonaXLNETs").rup_dialog("open");
}

function buscar() {
	var parametros='?nombreFiltro=' + $("#nombreResp").val() +'&apellidosFiltro=' + $("#apellidosResp").val() +'&dniFiltro=' + $("#dniResp").val();
	var url="../xlnets/personas"+parametros;
	$("#dialogoEsperaXLNET").show();
	$.ajax({
		type: "GET",
		url: url,
		success: function(data) {
			var str="";
			for(i=0;i<data.length;i++) {
				str+="<option value='"+data[i].codigo+"#"+data[i].telefono+"'>"+data[i].apellidos+", "+data[i].nombre+"</option>";
			}
			$("#personas").html(str);
			$("#dialogoEsperaXLNET").hide();
		},
		error:function() {
			$("#dialogoEsperaXLNET").hide();
		},
		dataType: "json"
		});
}

function seleccionar() {
	var val=$("#personas option:selected").val();
	var text=$("#personas option:selected").text();
	if(val!=null && val!=undefined) {
		var text2=text.split(", ");
		fncSeleccionar(val,text2[0]+", "+text2[1]);
	}
}

function fncSeleccionar (  codigotelefono, nombreapellidos) {
	var array=codigotelefono.split("#");
	var codigo=array[0];
	var telef=array[1];
	//Los siguientes campos los cargamos de XLNETs
	$("#dusu15_detail_table").val(nombreapellidos.toUpperCase());
	$("#uxlnet15_detail_table").val(codigo);
	try {
		$("#dialogoBuscarPersonaXLNETs").rup_dialog("close");
		$("#Usuarios_detail_button_save").show();
	} catch(e) {}
}

function limpiarBusqXLNET() {
	$("#dniResp").val("");
	$("#nombreResp").val("");
	$("#apellidosResp").val("");
	$("#personas").html("");
}

/*DIÁLOGO BUSCAR PERSONA XLNETS FIN*/
function handlerDetalleExpAsociadoUsuario() {
	var posLinea = $("#ExpAsociadosUsuario").rup_table("getSelectedLines");
	var refExp = $("#ExpAsociadosUsuario").rup_table("getRowData")[posLinea].refExp;
	var idExpAsoc = $("#ExpAsociadosUsuario").rup_table("getRowData")[posLinea].idExpe;
	dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
}