var idioma=$.rup.lang;
var modo;
var codigoPrincipal;
jQuery(function($){

	//Combo situación en pantalla búsqueda
	$("#situ14_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ14_filter_table").rup_combo("selectLabel", $("situ14_filter_table").val());
		}
	});
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ14_filter_table").rup_combo("select","A");
	
	//Tabla grid ubicación expedientes
	$("#UbicacionExpedientes").rup_table({
		rowNum:20,
		url: "../aa21b14s01",
		colNames: [
			$.rup.i18n.app.aa21b14s01.carchi14,
			$.rup.i18n.app.aa21b14s01.darchi14,
			$.rup.i18n.app.aa21b14s01.earchi14,
			$.rup.i18n.app.aa21b14s01.situ14
		],
		colModel: [
			{ 	name: "carchi14", 
			 	label: "carchi14",
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name:  "darchi14" , 
			 	label: "darchi14",
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden:false,
				resizable: true, 
				sortable: true
			},
			{ 	name: "earchi14", 
			 	label: "earchi14",
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "situ14", 
			 	label: "situ14",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b14s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "carchi14",
		sortname: idioma=="es"?"situ14,darchi14":"situ14,earchi14",
		sortorder: "asc",
		loadOnStartUp: true,
		loadComplete:fncTableCompleteUbicacionExpedientes,
		toolbar:{
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsulta
			    },
			    {
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					ocultar:true,
					comportamiento:"delete",
					click: handlerCambioEstado
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: handlerImprimirUbicaciones
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: handlerExcelUbicaciones
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ14");
		},
        formEdit:{
        	detailForm: "#UbicacionExpedientes_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					//Ponemos el titulo en modo añadir y mostramos las marcas de obligatorio
					$("#ui-dialog-title-UbicacionExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjNuevaUbicacion"));
					$("#labelOblig").show();
					$(".asterisco").show();
					
					$("#UbicacionExpedientes_detail_link_cancel").css("display","block");
					$("#divSituacion").hide();
					$("#situ14_detail_table").val("A");
					
					$("#fieldExpAsoc").hide();
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			editOptions:{
				beforeShowForm:function(){
					//Cargo expedientes asociados
					cargaAsociadosUbicacion();
					$("#divSituacion").show();
					$("#situ14_detail_table").rup_combo("disable");
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle").val() == "C"){
						$("#UbicacionExpedientes_detail_div :input").attr("readonly","readonly");
						
						$("#UbicacionExpedientes_detail_link_cancel").css("display","none");
						
						//Ponemos el titulo en modo modificar y mostramos las marcas de obligatorio
						$("#ui-dialog-title-UbicacionExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjVerUbicacion"));
						$("#labelOblig").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
					}else{
						//Ponemos el titulo en modo consulta y ocultamos las marcas de obligatorio
						$("#ui-dialog-title-UbicacionExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjEditarUbicacion"));
						$("#labelOblig").show();
						$(".asterisco").show();
						
						$("#UbicacionExpedientes_detail_div :input").removeAttr("readonly");
						
						$("#UbicacionExpedientes_detail_link_cancel").css("display","block");
					}
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('UbicacionExpedientes');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar
					 */
					$("#first_UbicacionExpedientes").on('click', function(){
						validacionBotonGuardado('UbicacionExpedientes');
					});
					$("#back_UbicacionExpedientes").on('click', function(){
						validacionBotonGuardado('UbicacionExpedientes');
					});
					$("#forward_UbicacionExpedientes").on('click', function(){
						validacionBotonGuardado('UbicacionExpedientes');
					});
					$("#last_UbicacionExpedientes").on('click', function(){
						validacionBotonGuardado('UbicacionExpedientes');
					});
				}
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodUbicacionExpedientes").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#UbicacionExpedientes"), "aa21b14s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"carchi14":{
						required: true
    					},
    				"darchi14":{
						required: true
    					},
    				"earchi14":{
						required: false
    					},
    				"situ14":{
						required: true
    					}
    				}
    		}
    		
        },
        onPaging: function(){
			$("#UbicacionExpedientes").rup_table("deselectAllRows");
		}
	});
	
	
	/**
	 * Cambio de títulos y textos filtrar
	 */
	$("#UbicacionExpedientes_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#UbicacionExpedientes_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#UbicacionExpedientes").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa21b14s01", "darchi14");
	});
	jQuery("#UbicacionExpedientes").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return bloquear(oper, $(this), "aa21b14s01", "darchi14");
		}else{
			return true;
		}	
	});
	jQuery("#UbicacionExpedientes_detail_div").on("dialogclose", function() {
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#UbicacionExpedientes"), "aa21b14s01");
		}
		$("#modoDetalle").val("");
		$("#ExpAsociadosUbicacion").rup_table("clearGridData",true);
		$("#UbicacionExpedientes").rup_table("deselectAllRows");
	});
	
	jQuery(window).bind('beforeunload', function() {
        // Aquí iría la función que desbloquea : 
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#UbicacionExpedientes"), "aa21b14s01");
		}	
	});

	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	
	/* Se llama a la función para refrescar la tabla de expedientes asignados al pulsar en los botones de paginación*/
	jQuery("#UbicacionExpedientes").on("jqGridAddEditAfterClickPgButtons", function(event, form, oper) {
		cargaAsociadosUbicacion();
		return;
	});
	/*/
	
	/* 
	 * INI: Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#UbicacionExpedientes").on("jqGridSelectRow", function(event, form, oper) {
		if(oper){
			if(!todosEnAlta($(this),"situ14")){
				desactivar('UbicacionExpedientes');
		 	 }
		 	 else{
		 		activar('UbicacionExpedientes');
		 	 }
		}	
		comprobacionEliminar('UbicacionExpedientes');
	});
	jQuery("#UbicacionExpedientes").on("rupTable_beforeEditRow", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return  todosEnAlta($(this),"situ14");
		}else{
			return true;
		}	
	});
	/*
	 * FIN: funciones control si estado es baja no pueda editar 
	 */
	
	//Combo situación en pantalla detalle
	$("#situ14_detail_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		blank: "",
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ14_detail_table").rup_combo("selectLabel", $("situ14_detail_table").val());
		}
	});
	
	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente en modo Consulta
	 */
	$("#ExpAsociadosUbicacion").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociadosUbicacion").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociadosUbicacion").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociadosUbicacion").rup_table("getRowData")[posLinea].idExpe;
		dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
		return false;
	});
	
	$("#ExpAsociadosUbicacion").on("rupTable_beforeEditRow", function(event, form, oper) {
		return false;
	});
	
	
	//Ocultamos el botón de clonar
	$("[id='UbicacionExpedientes_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	//Meto en el apartado filtro el literal de que esta en situación Alta
	$("#UbicacionExpedientes_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b12s01.situ12 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");
	
	
	//Tabla expedientes asociados al departamento
	$("#ExpAsociadosUbicacion").rup_table({
		rowNum:6,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo",
			"objeto"
		],
		colModel: [
		    {  name: "refExp", 
		       label: "refExp",
        	   align: "center", 
        	   width:280, 
        	   editable: true, 
        	   fixed: false, 
        	   hidden: false, 
        	   resizable: false, 
        	   sortable: true
            },
            {   name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
		    },
			{ 	name: "idExpe", 
			 	label: "idExpe",
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cesta20", 
			 	label: "cesta20",
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cserv20", 
	        	label: "cserv20",
	        	hidden: true 
	        },
	        { 	name: "cexpe20", 
	        	   label: "cexpe20",
	        	   hidden: true 
	        },
	        { 	name: "aexpe20", 
	        	   label: "aexpe20",
	        	   hidden: true 
           },
           { 	name: "nexpe20", 
        	   label: "nexpe20",
        	   hidden: true 
           },   
           { 	name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
           }, 
           { 	name: "objeto20", 
        	   label: "objeto20",
        	   hidden: true 
           },
	        
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"toolbar",
        	"filter",
        	"formEdit",
        	"fluid",
        	"feedback"
         	],
     	filter:{
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
			
			/**
			 * Cambiamos el tooltip para que al posicionarse encima de la celda en vez de aparecer el titulo con la referencia
			 * aparezca el objeto
			 */
			var ref = rowdata["refExp"];
			var objeto20 = rowdata["objeto20"];
			$("td[rup_tooltip='" + ref + "'").attr("rup_tooltip",objeto20);
			
		},
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpAsociadosUbicacion,
		toolbar:{
			defaultButtons:{
			   add: false,
			   edit: false,
			   cancel: false,
			   save: false,
			   clone: false,
			   "delete": false
			},
			newButtons:[{
				id:"detalleExpAsociadoUbicacion",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "rup-icon detalle"},
				click:function(event, form, oper){
					handlerDetalleExpAsociadoUbicacion();
				}
			}]
		}
	});
	
	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados Depar
	$(".ui-paging-info").hide();
	$(".ui-pg-selbox").hide();
	$("#first_ExpAsociadosUbicacion_pager").hide();
	$("#last_ExpAsociadosUbicacion_pager").hide();
	$("#ExpAsociadosUbicacion_pager_left").hide();
	
	
	$("#UbicacionExpedientes_filter_cleanLink").unbind("click");
	$("#UbicacionExpedientes_filter_cleanLink").click(limpiar);
	$("#UbicacionExpedientes_cb div").hide();
	 
	$("#UbicacionExpedientes").unbind("dblclick");
	 
	 //dialogoConsultaEspedientesAsociados.inicializar();
	 
	dialogoConsultaEspedientesAsociados.ocultarElementos();
	dialogoFase.ocultarElementos();
	dialogoHistorico.ocultarElementos();
	dialogoDocumentos.ocultarElementos();
	 
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteUbicacionExpedientes(e){
	
	
	$('[aria-describedby="UbicacionExpedientes_carchi14"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="UbicacionExpedientes_darchi14"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="UbicacionExpedientes_earchi14"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="UbicacionExpedientes_situ14"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ14=="B"){
				$("tr[id='" + fila.carchi14 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.carchi14 + "']").css("font-style","italic");
				$("tr[id='" + fila.carchi14 + "']").css("background","#848484");
			}
		}*/
		
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='UbicacionExpedientes_toolbar##imprimir']").show();
		$("[id='UbicacionExpedientes_toolbar##excel']").show();
	}else{
		//Si no hay registros, ocultamos los botones de imprimir y de Excel
		$("[id='UbicacionExpedientes_toolbar##imprimir']").hide();
		$("[id='UbicacionExpedientes_toolbar##excel']").hide();
	}	
	
	$.each ($('[aria-describedby="UbicacionExpedientes_carchi14"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="UbicacionExpedientes_darchi14"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="UbicacionExpedientes_earchi14"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="UbicacionExpedientes_situ14"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}

/**
 * Función que cambia la situación de alta a baja y viceversa
 */
function handlerCambioEstado(){
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	if($("#UbicacionExpedientes").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			siNo:true,
			OKFunction: function() {
				   
			   registros = $("#UbicacionExpedientes").rup_table("getSelectedLines");
			   cambiarEstadoLinea(registros);
				   
			   $("#UbicacionExpedientes").rup_table("filter");
			   $("#UbicacionExpedientes").rup_table("setSelection", regBloqueados, true);
			}
		});
		
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
};

function cambiarEstadoLinea(registros){
	
	for(var i=0;i<registros.length;i++){
		var indice = registros[i]-1;
		var exp = $("#UbicacionExpedientes").rup_table("getRowData")[indice];
		var codigo = exp.carchi14;
		   
		   
		var noBloqueado = bloquear("change", $("#UbicacionExpedientes"), "aa21b14s01", "darchi14",codigo);
		if(noBloqueado)
		{
			   
			var send = {};
			send["carchi14"] = exp.carchi14;
			send["darchi14"] = exp.darchi14;
			send["earchi14"] = exp.earchi14;
			if(exp.situ14 == "Alta"){
				send["situ14"] = "B";
			}else if(exp.situ14 == "Baja"){
				send["situ14"] = "A";
			}
			var dt = jQuery.toJSON(send);
			$.ajax({
			   url: "../aa21b14s01/cambioEstadoUbicacionExpediente",
			   type: "POST",
			   contentType: "application/json; charset=utf-8",
			   dataType: "json",
			   data: dt,
			   async:false,
			   cache:false,
			   error: callback_error,
			   success: function(data) {
				   desbloquear(jQuery("#UbicacionExpedientes"), "aa21b14s01");
				   $("#UbicacionExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
				   if(registros.length > 1){
					   $("#UbicacionExpedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b14s01.cambioEstadoOK"), "ok");
				   }else{
					   $("#UbicacionExpedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b14s01.cambioEstadoOK"), "ok");
				   } 
				   $("#UbicacionExpedientes_feedback").rup_feedback("show");
				   $("#UbicacionExpedientes").rup_table("setSelection", codigo, false);
				   
				   registros = $("#UbicacionExpedientes").rup_table("getSelectedLines");
				   cambiarEstadoLinea(registros);
			   }
		   });
	   }else{
		   regBloqueados[indiceBloq] = codigo;
		   indiceBloq++;
	   }	
	}
	
};

function handlerDetalleExpAsociadoUbicacion(){
	var posLinea = $("#ExpAsociadosUbicacion").rup_table("getSelectedLines");
	var refExp = $("#ExpAsociadosUbicacion").rup_table("getRowData")[posLinea].refExp;
	var idExpAsoc = $("#ExpAsociadosUbicacion").rup_table("getRowData")[posLinea].idExpe;
	dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
}

function callback_error(xhr, ajaxOptions, thrownError){
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {	
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#UbicacionExpedientes_feedback").rup_feedback("option", "delay", null);
			 $("#UbicacionExpedientes_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#UbicacionExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#UbicacionExpedientes_feedback").rup_feedback("option", "delay", null);
			 $("#UbicacionExpedientes_feedback").rup_feedback("set", errorTXT, "error");								
			 $("#UbicacionExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}
/**
 * Función imprimir ubicaciones PDF
 */
function handlerImprimirUbicaciones(){
	if($("#UbicacionExpedientes").rup_table("getDataIDs").length > 0){
		$('#icarchi14').val($('#carchi14_filter_table').val());
		$('#idarchi14').val($('#darchi14_filter_table').val());
		$('#iearchi14').val($('#earchi14_filter_table').val());
		$('#isitu14').val($('#situ14_filter_table').val());
	
		$("#frmImprimirUbicaciones").attr("action","../imprimirMantGenerales/imprimirUbicacionExpedientes");
		$("#frmImprimirUbicaciones").attr("target","_blank");
	
		var form = document.forms["frmImprimirUbicaciones"];
		form.submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
};

/**
 * Función generación Excel ubicaciones
 */
function handlerExcelUbicaciones(){
	if($("#UbicacionExpedientes").rup_table("getDataIDs").length > 0){
		$('#icarchi14').val($('#carchi14_filter_table').val());
		$('#idarchi14').val($('#darchi14_filter_table').val());
		$('#iearchi14').val($('#earchi14_filter_table').val());
		$('#isitu14').val($('#situ14_filter_table').val());
	
		$("#frmImprimirUbicaciones").attr("action","../aa21b14s01/excelUbicacionesExpedientes");
		$("#frmImprimirUbicaciones").attr("target","_blank");
		$("#frmImprimirUbicaciones").submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
}


function limpiar(){
	$("#situ14_filter_table").val("");
	$("#UbicacionExpedientes").rup_table("deselectAllRows");
	$("#UbicacionExpedientes_filter_summary").html("<i></i>");
	$("#UbicacionExpedientes").rup_table("clearGridData",true);
	$("#UbicacionExpedientes").rup_table("resetForm", $("#UbicacionExpedientes_filter_form"));
}



function handlerConsulta(){
	$("#modoDetalle").val("C");
	$("#UbicacionExpedientes").rup_table("editElement");
}

function cargaAsociadosUbicacion(){
	$("#ExpAsociadosUbicacion").rup_table("setGridParam", {url: "../aa21b14s01/obtenerExpedientesUbicacionServ/" + $("#carchi14_detail_table").val()});
	$("#ExpAsociadosUbicacion").rup_table("filter");
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociadosUbicacion(e){
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){
		$("#fieldExpAsoc").show();
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	}else{
		$("#fieldExpAsoc").hide();
	}	
	
}

function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}