function inicializar13(){
	//console.log(13);
	
	//Combo situación en pantalla búsqueda
	$("#situ13_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
	
		onLoadSuccess: function(){
			$("#situ13_filter_table").rup_combo("selectLabel", $("situ13_filter_table").val());
		}
	});
	$("#Servicios2_feedback").rup_feedback({
		fadeSpeed: 600,
		delay:defaultDelay,
		block:false
	});
	//$("#Servicios2_feedback").css("width","94%");
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ13_filter_table").rup_combo("select","A");
	
	//Tabla grid servicios
	$("#Servicios").rup_table({
		rowNum:20,
		url: "../aa21b13s01",
		colNames: [
			$.rup.i18n.app.aa21b13s01.cserv13,
			$.rup.i18n.app.aa21b13s01.dserv13,
			$.rup.i18n.app.aa21b13s01.eserv13,
			$.rup.i18n.app.aa21b13s01.situ13
		],
		colModel: [
			{ 	name: "cserv13", 
			 	label: $.rup.i18n.app.aa21b13s01.cserv13,
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "dserv13", 
			 	label: $.rup.i18n.app.aa21b13s01.gserv13,
				align: "left", 
				width: 250, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "eserv13", 
			 	label: $.rup.i18n.app.aa21b13s01.eserv13,
				align: "left", 
				width: 250, 
				editable: false, 
				fixed: false, 
				hidden:  false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "situ13", 
			 	label: $.rup.i18n.app.aa21b13s01.situ13,
				align: "left", 
				width: 100, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b13s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	//"search",
        	"multiselection"
         	],
		primaryKey: "cserv13",
		sortname:  $.rup.lang=="es"?"situ13,dserv13":"situ13,eserv13",
		//sortname: idioma=="es"?"situ12,cserv13":"situ12,edepar12",
		sortorder: "asc",
		loadOnStartUp: true,
		loadComplete:fncTableCompleteServicios,
		toolbar:{
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsultaServicio
			    },
			    {
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					click: handlerCambioEstadoServicios,
					ocultar:true,
					comportamiento:"delete"
					
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: function() { handlerImprimirServTipoFase('13'); }
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: function() { handlerExcelServTipoFase('13'); }
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ13");
		},
        formEdit:{
        	detailForm: "#Servicios_detail_div",
			fillDataMethod: "clientSide",
			
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodServicios").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#Servicios"), "aa21b13s01");
						
						$("#cserv02_filter_table").rup_combo("reload");
						$("#cserv02_detail_table").rup_combo("reload");
						$("#TiposExpedientes_filter_filterButton").click();
						$("#cserv01_filter_table").rup_combo("reload");
						$("#cserv01_detail_table").rup_combo("reload");
						$("#FasesExpedientes_filter_filterButton").click();
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},			
		
         	validate:{ 
    			rules:{
    				"dserv13":{
						required: true
    					},
    				"eserv13":{
						required: false
    					}
    				
    				}
    		}	
        },
        feedback:{
        	id:"Servicios2_feedback"
        },
        onPaging: function(){
			$("#Servicios").rup_table("deselectAllRows");
		}
	});
	
	
	
	//Cambio de títulos y textos filtrar
	$("#Servicios_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#Servicios_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	

	
	/* INI: BLOQUEO Y DESBLOQUEO */
		jQuery("#Servicios").on("rupTable_beforeDeleteRow", function(event, row, oper) {
			return bloquear('edit', $(this), "aa21b13s01", "dserv13");
		});
		jQuery("#Servicios").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
				return false;
		});
		
		jQuery("#Servicios").on("jqGridAddEditBeforeShowForm", function(event, form, oper) {
			
			return bloquear(oper, $(this), "aa21b13s01", "dserv13");
		});
		
		jQuery(window).bind('beforeunload', function() {
	        // Aquí iría la función que desbloquea : 
			desbloquear(jQuery("#Servicios"), "aa21b13s01");
	
		});

	/* FIN: BLOQUEO Y DESBLOQUEO */
		
		
	
	//Asigno las funciones a los botones añadir y editar
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.new+"']").click(handlerNuevoServicio);
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").click(handlerModificarServicio);
	
	//Ocultamos el botón de clonar
	$("[id='Servicios_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	/* 
	 * Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#Servicios").on("jqGridSelectRow", function(event, form, oper) {
		if(oper){
			if(!todosEnAlta($(this),"situ13")){
				desactivar('Servicios');
		 	 }
		 	 else{
		 		activar('Servicios');
		 	 }
		}	
		comprobacionEliminar('Servicios');
		comprobacionEditarConsulta('Servicios');
	});
	jQuery("#Servicios").on("rupTable_beforeEditRow", function(event, form, oper) {
	 	return  todosEnAlta($(this),"situ13");
	});
	/*
	 * Fin funciones control si estado es baja no pueda editar 
	 */
	
	/*
	 * Funciones para inhabilitar el doble click de edición y la función edición por
	 * defecto
	 */
	$("#Servicios").on("rupTable_beforeAddRow", function(deleteOptions,selectedRow){
		return false;
	});
	
	jQuery("#Servicios").on("jqGridDblClickRow", function(event, form, oper) {
		return false;
	});
	/*
	 * Fin funcion inhabilitar
	 */
	
	$("#Servicios").unbind("dblclick");
	
	//Meto en el apartado filtro el literal de que esta en situación Alta
	$("#Servicios_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b12s01.situ12 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");
	
	
	 $("#Servicios_cb div").hide();
};


/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteServicios(e){
	
	$('[aria-describedby="Servicios_cserv13"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Servicios_dserv13"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Servicios_eserv13"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Servicios_situ13"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ13=="B"){
				$("tr[id='" + fila.cserv13 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.cserv13 + "']").css("font-style","italic");
				$("tr[id='" + fila.cserv13 + "']").css("background","#848484");
			}
		}*/
		
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='Servicios_toolbar##imprimir']").show();
		$("[id='Servicios_toolbar##excel']").show();
	}else{
		//Si no hay registros, ocultamos los botones de imprimir y de Excel
		$("[id='Servicios_toolbar##imprimir']").hide();
		$("[id='Servicios_toolbar##excel']").hide();
	}	
	
	
	/*$.each ($('[aria-describedby="Servicios_cserv13"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="Servicios_dserv13"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="Servicios_eserv13"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="Servicios_situ13"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});*/
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}
/**
 * Función cambio de situación de alta a baja y viceversa
 */
function handlerCambioEstadoServicios(){
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	if($("#Servicios").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			siNo:true,
			OKFunction: function() {
				   
			   registros = $("#Servicios").rup_table("getSelectedLines");
			   cambiarEstadoLineaServicio(registros);
			   
			   
			   $("#Servicios").rup_table("filter");
			   $("#Servicios").rup_table("setSelection", regBloqueados, true);
			}
		});
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.seleccionFila});
	}
};

function cambiarEstadoLineaServicio(registros){
	
	for(var i=0;i<registros.length;i++){
		   var indice = registros[i]-1;
		   var exp = $("#Servicios").rup_table("getRowData")[indice];
		   var codigo = exp.cserv13;
		   
		   
		   var noBloqueado = bloquear("change", $("#Servicios"), "aa21b13s01", "dserv13",codigo);
		   if(noBloqueado)
		   {
			   
			   var send = {};
			   send["cserv13"] = exp.cserv13;
			   send["dserv13"] = exp.dserv13;
			   send["eserv13"] = exp.eserv13;
			   if(exp.situ13 == "Alta"){
				   send["situ13"] = "B";
			   }else if(exp.situ13 == "Baja"){
				   send["situ13"] = "A";
			   }
			   var dt = jQuery.toJSON(send);
			   $.ajax({
				   url: "../aa21b13s01/cambioEstadoServicio",
				   type: "POST",
				   contentType: "application/json; charset=utf-8",
				   dataType: "json",
				   data: dt,
				   async:false,
				   cache:false,
				   error: callback_error,
				   success: function(data) {
					   desbloquear(jQuery("#Servicios"), "aa21b12s01");
					   $("#Servicios2_feedback").rup_feedback("option", "delay", defaultDelay);
					   if(registros.length > 1){
						   $("#Servicios2_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b13s01.cambioEstadoOK"), "ok");
					   }else{
						   $("#Servicios2_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b13s01.cambioEstadoOK"), "ok");
					   } 
					   $("#Servicios2_feedback").rup_feedback("show");
					   $("#Servicios").rup_table("setSelection", codigo, false);
					   
					   registros = $("#Servicios").rup_table("getSelectedLines");
					   cambiarEstadoLineaServicio(registros);
				   }
			   });
		   }else{
			   regBloqueados[indiceBloq] = codigo;
			   indiceBloq++;
		   }	
	   }
	
};

function callback_error(xhr, ajaxOptions, thrownError){
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {	
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#Servicios2_feedback").rup_feedback("option", "delay", null);
			 $("#Servicios2_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#Servicios2_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#Servicios2_feedback").rup_feedback("option", "delay", null);
			 $("#Servicios2_feedback").rup_feedback("set", errorTXT, "error");								
			 $("#Servicios2_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}

function limpiarServicios(){
	$("#Servicios").rup_table("deselectAllRows");
	$("#Servicios_filter_summary").html("<i></i>");
	$("#Servicios").rup_table("clearGridData",true);
	$("#Servicios").rup_table("resetForm", $("#Servicios_filter_form"));
	$("#cserv13_filter_table").val($("#servicioUsuario").val());
	$("#situ13_filter_table").rup_combo("select","A");
	//20161020 - INIGO
	//$("#Servicios").rup_table("filter");
}

/**
 * Función creación nuevo Servicio. En vez de utilizar la pantalla de detalle
 * de UDA, llamaremos a un dialogo (dialogoAltaServicio).
 */
function handlerNuevoServicio(){
	
	var registros = [];
	if($("#Servicios").rup_table("getSelectedRows") != ""){
		registros = $("#Servicios").rup_table("getSelectedLines");
		for(var i=0;i<registros.length;i++){
		   var indice = registros[i]-1;
		   var linea = $("#Servicios").rup_table("getRowData")[indice];
		   var codigo = linea.cserv13;
		   $("#Servicios").rup_table("setSelection", [codigo], false);
		}
	}	
	
	//Creación dialogo alta servicio
	$("#dialogoAltaServicio").rup_dialog({	
		type:$.rup.dialog.AJAX,
		url:"/aa21bOrgDocumentalWar/aa21b13s01/altaservicio",
		modal:true,
		height:690,
		minHeight:400,
		width:950,	
		minWidth:435,	
		resizable:false,
		title:$.rup.i18n.app.aa21b13s01.altaServicioTit,
		autoOpen:false,
		showLoading:true,
	    async:false
	});
	
	//Apertura del dialogo alta servicio
	$("#dialogoAltaServicio").rup_dialog("open");
	
}
/**
 * Función modificación servicio. Utilizo un dialogo propio en vez
 * de la pantalla creada por UDA. Pasándole como parámetro el código del
 * servicio.
 */
function handlerModificarServicio(){
	
	if($("#Servicios").rup_table("getSelectedRows") != ""){
		var registros = $("#Servicios").rup_table("getSelectedLines");
		
		if(registros.length == 1){
			var indice = registros-1;
			var servicio = $("#Servicios").rup_table("getRowData")[indice];
			if(servicio.situ13 != "B"){
				var bloqueado =  bloquear("edit", $("#Servicios"), "aa21b13s01", "dserv13");
				if(bloqueado){
					$("#dialogoAltaServicio").rup_dialog({	
						type:$.rup.dialog.AJAX,
						url:"/aa21bOrgDocumentalWar/aa21b13s01/modificarservicio?cserv13="+servicio.cserv13,
						modal:true,
						height:700,
						width:850,
						resizable:false,
						title:$.rup.i18n.app.aa21b13s01.modificacionServicioTit,
						autoOpen:false,
						showLoading:true,
						async:false 
					});
					$("#dialogoAltaServicio").rup_dialog("open");
				
				}else{
					return bloqueado;
				}
			}	
		}else{
			$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.seleccionFila});
		}
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.seleccionFila});
	}
	
	
}
/**
 * Función consulta servicio. Utilizando el dialogo de alta y modificación
 * deshabilitando los campos, cambiando titulos, etc. Paso como parámetro 
 * el código de servicio a consultar
 */
function handlerConsultaServicio(){
	
	if($("#Servicios").rup_table("getSelectedRows") != ""){
		var registros = $("#Servicios").rup_table("getSelectedLines");
		
		if(registros.length == 1){
			var indice = registros-1;
			var servicio = $("#Servicios").rup_table("getRowData")[indice];

			$("#dialogoAltaServicio").rup_dialog({	
				type:$.rup.dialog.AJAX,
				url:"/aa21bOrgDocumentalWar/aa21b13s01/consultarservicio?cserv13="+servicio.cserv13,
				modal:true,
				height:630,
				width:850,	
				resizable:false,
				title:$.rup.i18n.app.aa21b13s01.verServicioTit,
				autoOpen:false,
				showLoading:true,
				async:false 
			});
			$("#dialogoAltaServicio").rup_dialog("open");
		}else{
			$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.seleccionFila});
		}
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.seleccionFila});
	}
	
	
}

function desactivarServicio(){
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").prop("disabled",true);
}
function activarServicio(){
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='Servicios_toolbar##"+$.rup.i18n.base.rup_maint.edit+"']").prop("disabled",false);
}

/*function handlerCrearServicioM(){
	handlerCrearServicio();
}
function handlerCancelarAltaM(){
	handlerCancelarAlta();
}*/