var idioma=$.rup.lang;
var modo;
var codigoPrincipal;
jQuery(function($){
	
	
	
	
	//Combo situación en pantalla búsqueda
	$("#situ12_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ12_filter_table").rup_combo("selectLabel", $("situ12_filter_table").val());
		}
	});
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ12_filter_table").rup_combo("select","A");
	
	//Tabla grid departamentos
	$("#Departamentos").rup_table({
		rowNum:20,
		url: "../aa21b12s01",
		colNames: [
			$.rup.i18n.app.aa21b12s01.cdepar12,
			$.rup.i18n.app.aa21b12s01.ddepar12,
			$.rup.i18n.app.aa21b12s01.edepar12,
			$.rup.i18n.app.aa21b12s01.situ12
		],
		colModel: [
			{ 	name: "cdepar12", 
			 	label: $.rup.i18n.app.aa21b12s01.cdepar12,
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "ddepar12", 
			 	label: $.rup.i18n.app.aa21b12s01.ddepar12,
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "edepar12", 
			 	label: $.rup.i18n.app.aa21b12s01.edepar12,
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "situ12", 
			 	label: $.rup.i18n.app.aa21b12s01.situ,
				align: "left", 
				width: 100, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b12s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "cdepar12",
		sortname: idioma=="es"?"situ12,ddepar12":"situ12,edepar12",
		sortorder: "asc",
		loadOnStartUp: true,
		loadComplete:fncTableCompleteDepartamentos,
		toolbar:{
			newButtons:[{
				id:"detalle",
				obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
				ocultar:true,
				comportamiento:"edit",
				click:handlerConsulta
			},
			            {
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					ocultar:true,
					comportamiento:"delete",
					click: handlerCambioEstado
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: handlerImprimirDepar
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: handlerExcelDepar
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ12");
		},
        formEdit:{
        	detailForm: "#Departamentos_detail_div",
			fillDataMethod: "clientSide",
			
			addOptions:{
				beforeShowForm:function(){
					//Ponemos el titulo en modo añadir y mostramos las marcas de obligatorio
					$("#ui-dialog-title-Departamentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjNuevoDepartamento"));
					$("#labelOblig").show();
					$(".asterisco").show();
					
					$("#Departamentos_detail_link_cancel").css("display","block");
					$("#divSituacion").hide();
					$("#situ12_detail_table").val("A");
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			editOptions:{
				beforeShowForm:function(){
					//Cargo expedientes asociados
					cargaAsociados();
					$("#divSituacion").show();
					$("#situ12_detail_table").rup_combo("disable");
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle").val() == "C"){
						$("#Departamentos_detail_div :input").attr("readonly","readonly");
						
						$("#Departamentos_detail_link_cancel").css("display","none");
						
						//Ponemos el titulo en modo modificar y mostramos las marcas de obligatorio
						$("#ui-dialog-title-Departamentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjVerDepartamento"));
						$("#labelOblig").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
							
					}else{
						//Ponemos el titulo en modo consulta y ocultamos las marcas de obligatorio
						$("#ui-dialog-title-Departamentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjEditarDepartamento"));
						$("#labelOblig").show();
						$(".asterisco").show();
						
						//Deshabilito campos
						$("#Departamentos_detail_div :input").removeAttr("readonly");
						
						$("#Departamentos_detail_link_cancel").css("display","block");
					}
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('Departamentos');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar
					 */
					$("#first_Departamentos").on('click', function(){
						validacionBotonGuardado('Departamentos');
					});
					$("#back_Departamentos").on('click', function(){
						validacionBotonGuardado('Departamentos');
					});
					$("#forward_Departamentos").on('click', function(){
						validacionBotonGuardado('Departamentos');
					});
					$("#last_Departamentos").on('click', function(){
						validacionBotonGuardado('Departamentos');
					});
				}
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodDepartamentos").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#Departamentos"), "aa21b12s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cdepar12":{
						required: true
    					},
    				"ddepar12":{
						required: true
    					},
    				"edepar12":{
						required: false
    					},
    				"situ12":{
						required: true
    					}
    				}
    		}
        },
        onPaging: function(){
			$("#Departamentos").rup_table("deselectAllRows");
		}
	});

	// Cambio de títulos y textos filtrar
	$("#Departamentos_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#Departamentos_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	
	//Combo situación en pantalla detalle
	$("#situ12_detail_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		blank: "",
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ12_detail_table").rup_combo("selectLabel", $("situ12_detail_table").val());
		}
	});
	
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#Departamentos").on("rupTable_beforeDeleteRow", function(event, row) {
			return bloquear('edit', $(this), "aa21b12s01", "ddepar12");
	});
	jQuery("#Departamentos").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return bloquear(oper, $(this), "aa21b12s01", "ddepar12");
		}else{
			return true;
		}
	});
	//Al cerrar la ventana de detalle
	jQuery("#Departamentos_detail_div").on("dialogclose", function() {
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#Departamentos"), "aa21b12s01");
		}	
		$("#modoDetalle").val("");
		$("#ExpAsociadosDepar").rup_table("clearGridData",true);
		$("#Departamentos").rup_table("deselectAllRows");
		//$("#Departamentos").rup_table("filter");
	});
	
	jQuery(window).bind('beforeunload', function() {
        // Aquí iría la función que desbloquea : 
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#Departamentos"), "aa21b12s01");
		}	
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	
	/* Se llama a la función para refrescar la tabla de expedientes asignados al pulsar en los botones de paginación*/
	jQuery("#Departamentos").on("jqGridAddEditAfterClickPgButtons", function(event, form, oper) {
		cargaAsociados();
		return;
	});
	/*/
	
	/* 
	 * Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#Departamentos").on("jqGridSelectRow", function(event, form, oper) {
		if(oper){
			if(!todosEnAlta($(this),"situ12")){
				desactivar('Departamentos');
		 	 }
		 	 else{
		 		activar('Departamentos');
		 	 }
		}
		comprobacionEliminar('Departamentos');
		
	});
	jQuery("#Departamentos").on("rupTable_beforeEditRow", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return  todosEnAlta($(this),"situ12");
		}else{
			return true;
		}	
	});
	/*
	 * Fin funciones control si estado es baja no pueda editar 
	 */
	

	
	
	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente en modo Consulta
	 */
	$("#ExpAsociadosDepar").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociadosDepar").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociadosDepar").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociadosDepar").rup_table("getRowData")[posLinea].idExpe;
		dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
		return false;
	});
	
	$("#ExpAsociadosDepar").on("rupTable_beforeEditRow", function(event, form, oper) {
		return false;
	});
	
	
	//Ocultamos el botón de clonar
	$("[id='Departamentos_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	//Meto en el apartado filtro el literal de que esta en situación Alta
	$("#Departamentos_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b12s01.situ12 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");
	
	//Tabla expedientes asociados al departamento
	$("#ExpAsociadosDepar").rup_table({
		rowNum:6,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo",
			"objeto20"
		],
		colModel: [
		    {  name: "refExp", 
		       label: "refExp",
        	   align: "center", 
        	   width:280, 
        	   editable: true, 
        	   fixed: false, 
        	   hidden: false, 
        	   resizable: false, 
        	   sortable: true
            },
            {   name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
		    },
			{ 	name: "idExpe", 
			 	label: "idExpe",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cesta20", 
			 	label: "cesta20",
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cserv20", 
	        	label: "cserv20",
	        	hidden: true 
	        },
	        { 	name: "cexpe20", 
	        	   label: "cexpe20",
	        	   hidden: true 
	        },
	        { 	name: "aexpe20", 
	        	   label: "aexpe20",
	        	   hidden: true 
           },
           { 	name: "nexpe20", 
        	   label: "nexpe20",
        	   hidden: true 
           },   
           { 	name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
           },
           {
        	   name: "objeto20",
        	   label: "objeto20",
        	   hidden:true
           },
	        
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"toolbar",
        	"filter",
        	"formEdit",
           	"fluid",
           	"feedback"
         	],
     	filter:{
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
			
			/**
			 * Cambiamos el tooltip para que al posicionarse encima de la celda en vez de aparecer el titulo con la referencia
			 * aparezca el objeto
			 */
			var ref = rowdata["refExp"];
			var objeto20 = rowdata["objeto20"];
			$("td[rup_tooltip='" + ref + "'").attr("rup_tooltip",objeto20);
		},
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpAsociadosDepar,
		toolbar:{
			defaultButtons:{
				   add: false,
				   edit: false,
				   cancel: false,
				   save: false,
				   clone: false,
				   "delete": false
				},
				newButtons:[{
				id:"detalleExpAsociadoUbicacion",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "rup-icon detalle"},
				click:function(event, form, oper){
					handlerDetalleExpAsociadoDepar();
				}
			}]
		}
	});
	
	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados Depar
	$(".ui-paging-info").hide();
	$(".ui-pg-selbox").hide();
	$("#first_ExpAsociadosDepar_pager").hide();
	$("#last_ExpAsociadosDepar_pager").hide();
	$("#ExpAsociadosDepar_pager_left").hide();
	
	
	$("#Departamentos_filter_cleanLink").unbind("click");
	$("#Departamentos_filter_cleanLink").click(limpiar);
	 $("#Departamentos_cb div").hide();
	 
	 
	$("#Departamentos").unbind("dblclick");
		
	
	 
	dialogoConsultaEspedientesAsociados.ocultarElementos();
	dialogoFase.ocultarElementos();
	dialogoHistorico.ocultarElementos();
	dialogoDocumentos.ocultarElementos();
});

/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteDepartamentos(e){
	
	
	$('[aria-describedby="Departamentos_cdepar12"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Departamentos_ddepar12"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Departamentos_edepar12"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="Departamentos_situ12"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ12=="B"){
				//$("tr[id='" + fila.cdepar12 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				//$("tr[id='" + fila.cdepar12 + "']").css("font-style","italic");
				//$("tr[id='" + fila.cdepar12 + "']").css("background","#848484");
			}
		}*/
		
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='Departamentos_toolbar##imprimir']").show();
		$("[id='Departamentos_toolbar##excel']").show();
		
		
	}else{
		//Si no hay registros, ocultamos los botones de imprimir y de Excel
		$("[id='Departamentos_toolbar##imprimir']").hide();
		$("[id='Departamentos_toolbar##excel']").hide();
	}
	
	
	$.each ($('[aria-describedby="Departamentos_cdepar12"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="Departamentos_ddepar12"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="Departamentos_edepar12"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="Departamentos_situ12"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}



/**
 * Función para cambiar la situación de alta a baja y viceversa
 */
function handlerCambioEstado(){
	var regSel = [];
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	if($("#Departamentos").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			siNo:true,
			OKFunction: function() {
			   //Obtención de las líneas seleccionadas
			   registros = $("#Departamentos").rup_table("getSelectedLines");
			   cambiarEstadoLinea(registros);
			   
			   //Una vez cambiados todos los estados se refresca la tabla
			   $("#Departamentos").rup_table("filter");
			   $("#Departamentos").rup_table("setSelection", regBloqueados, true);
			}
		});

	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
};

function cambiarEstadoLinea(registros){
	//Se recorren los registro seleccionados
	for(var i=0;i<registros.length;i++){
	   var indice = registros[i]-1;
	   var exp = $("#Departamentos").rup_table("getRowData")[indice];
	   var codigo = exp.cdepar12;
		   
	   var noBloqueado = bloquear("change", $("#Departamentos"), "aa21b12s01", "ddepar12",codigo);
	   if(noBloqueado)
	   {
			   
		   var send = {};
		   send["cdepar12"] = exp.cdepar12;
		   send["ddepar12"] = exp.ddepar12;
		   send["edepar12"] = exp.edepar12;
		   if(exp.situ12 == "Alta"){
			   send["situ12"] = "B";
		   }else if(exp.situ12 == "Baja"){
			   send["situ12"] = "A";
		   }
		   var dt = jQuery.toJSON(send);
		   $.ajax({
			   url: "../aa21b12s01/cambioEstadoDepartamento",
			   type: "POST",
			   contentType: "application/json; charset=utf-8",
			   dataType: "json",
			   data: dt,
			   async:false,
			   cache:false,
			   error: callback_error,
			   success: function(data) {
				   desbloquear(jQuery("#Departamentos"), "aa21b12s01");
				   $("#Departamentos_feedback").rup_feedback("option", "delay", defaultDelay);
				   if(registros.length > 1){
					   $("#Departamentos_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b12s01.cambioEstadoOK"), "ok");
				   }else{
					   $("#Departamentos_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b12s01.cambioEstadoOK"), "ok");
				   } 
				   $("#Departamentos_feedback").rup_feedback("show");
				   //Se deselecciona de la tabla el registro que se ha actualizado
				   $("#Departamentos").rup_table("setSelection", codigo, false);
				   //Volvemos a llamar a la función de cambio de estado pasandole los demás registros seleccionados
				   //Así se evita que al ser una ejecución sincrona, se deje algún registro sin actualizar
				   registros = $("#Departamentos").rup_table("getSelectedLines");
				   cambiarEstadoLinea(registros);
			   }
		   });
	   }else{
		   regBloqueados[indiceBloq] = codigo;
		   indiceBloq++;
	   }	
   }
	
};

function callback_error(xhr, ajaxOptions, thrownError){
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {	
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#Departamentos_feedback").rup_feedback("option", "delay", null);
			 $("#Departamentos_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#Departamentos_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#Departamentos_feedback").rup_feedback("option", "delay", null);
			 $("#Departamentos_feedback").rup_feedback("set", errorTXT, "error");								
			 $("#Departamentos_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}
/**
 * Función imprimir departamentos
 */
function handlerImprimirDepar(){
	if($("#Departamentos").rup_table("getDataIDs").length > 0){
		$('#icdepar12').val($('#cdepar12_filter_table').val());
		$('#iddepar12').val($('#ddepar12_filter_table').val());
		$('#iedepar12').val($('#edepar12_filter_table').val());
		$('#isitu12').val($('#situ12_filter_table').val());
	
		$("#frmImprimirDepar").attr("action","../imprimirMantGenerales/imprimirDepartamentos");
		$("#frmImprimirDepar").attr("target","_blank");
	
		var form = document.forms["frmImprimirDepar"];
		form.submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}
};

/**
 * Función generación Excel departamentos
 */
function handlerExcelDepar(){
	if($("#Departamentos").rup_table("getDataIDs").length > 0){
		$('#icdepar12').val($('#cdepar12_filter_table').val());
		$('#iddepar12').val($('#ddepar12_filter_table').val());
		$('#iedepar12').val($('#edepar12_filter_table').val());
		$('#isitu12').val($('#situ12_filter_table').val());
	
		$("#frmImprimirDepar").attr("action","../aa21b12s01/excelDepartamentos");
		$("#frmImprimirDepar").attr("target","_blank");
		$("#frmImprimirDepar").submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
}

function limpiar(){
	$("#situ12_filter_table").val("");
	$("#Departamentos_filter_summary").html("<i></i>");
	$("#Departamentos").rup_table("deselectAllRows");
	$("#Departamentos").rup_table("clearGridData",true);
	$("#Departamentos").rup_table("resetForm", $("#Departamentos_filter_form"));
}

function handlerConsulta(){
	$("#modoDetalle").val("C");
	$("#Departamentos").rup_table("editElement");
}

function cargaAsociados(){
	$("#ExpAsociadosDepar").rup_table("setGridParam", {url: "../aa21b12s01/obtenerExpedientesDeparYServ/" + $("#cdepar12_detail_table").val()});
	$("#ExpAsociadosDepar").rup_table("filter");
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociadosDepar(e){
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){	
		$("#fieldExpAsoc").show();
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	}else{
		$("#fieldExpAsoc").hide();
	}	
	
}


function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}

function handlerDetalleExpAsociadoDepar(){
	var posLinea = $("#ExpAsociadosDepar").rup_table("getSelectedLines");
	var refExp = $("#ExpAsociadosDepar").rup_table("getRowData")[posLinea].refExp;
	var idExpAsoc = $("#ExpAsociadosDepar").rup_table("getRowData")[posLinea].idExpe;
	dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
}