var idioma=$.rup.lang;
var modo;
var codigoPrincipal;

jQuery(function($){

	//Combo situación en pantalla búsqueda
	$("#situ07_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ07_filter_table").rup_combo("selectLabel", $("situ07_filter_table").val());
		}
	});
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ07_filter_table").rup_combo("select","A");
	
	//Tabla grid estados expedientes
	$("#EstadosExpedientes").rup_table({
		rowNum:20,
		url: "../aa21b07s01",
		colNames: [
			$.rup.i18n.app.aa21b07s01.cesta07,
			$.rup.i18n.app.aa21b07s01.desta07,
			$.rup.i18n.app.aa21b07s01.eesta07,
			$.rup.i18n.app.aa21b07s01.situ07
		],
		colModel: [
			{ 	name: "cesta07", 
			 	label: "cesta07",
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desta07", 
			 	label: "desta07",
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden:false,
				resizable: true, 
				sortable: true
			},
			{ 	name: "eesta07", 
			 	label: "eesta07",
				align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden:false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "situ07", 
			 	label: "situ07",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b07s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "cesta07",
		sortname: idioma=="es"?"situ07,desta07":"situ07,eesta07",
		sortorder: "asc",
		loadOnStartUp: true,
		loadComplete:fncTableCompleteEstadosExpedientes,
		toolbar:{
			newButtons:[{
				id:"detalle",
				obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
				ocultar:true,
				comportamiento:"edit",
				click:handlerConsulta
			},
			{
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					ocultar:true,
					comportamiento:"delete",
					click: handlerCambioEstado
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: handlerImprimirEstadosExp
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: handlerExcelEstadosExp
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ07");
		},
        formEdit:{
        	detailForm: "#EstadosExpedientes_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					//Ponemos el titulo en modo añadir y mostramos las marcas de obligatorio
					$("#ui-dialog-title-EstadosExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjNuevoEstado"));
					$("#labelOblig").show();
					$(".asterisco").show();
					
					$("#EstadosExpedientes_detail_link_cancel").css("display","block");
					$("#divSituacion").hide();
					$("#situ07_detail_table").val("A");
					
					$("#fieldExpAsoc").hide();
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			editOptions:{
				beforeShowForm:function(){
					//Cargo expedientes asociados
					cargaAsociadosEstadoExp();
					$("#divSituacion").show();
					$("#situ07_detail_table").rup_combo("disable");
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle").val() == "C"){
						$("#EstadosExpedientes_detail_div :input").attr("readonly","readonly");
						
						$("#EstadosExpedientes_detail_link_cancel").css("display","none");
						
						//Ponemos el titulo en modo modificar y mostramos las marcas de obligatorio
						$("#ui-dialog-title-EstadosExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjVerEstado"));
						$("#labelOblig").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
					}else{
						//Ponemos el titulo en modo consulta y ocultamos las marcas de obligatorio
						$("#ui-dialog-title-EstadosExpedientes_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjEditarEstado"));
						$("#labelOblig").show();
						$(".asterisco").show();
						
						$("#EstadosExpedientes_detail_div :input").removeAttr("readonly");
						
						$("#EstadosExpedientes_detail_link_cancel").css("display","block");
					}
					
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('EstadosExpedientes');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar
					 */
					$("#first_EstadosExpedientes").on('click', function(){
						validacionBotonGuardado('EstadosExpedientes');
					});
					$("#back_EstadosExpedientes").on('click', function(){
						validacionBotonGuardado('EstadosExpedientes');
					});
					$("#forward_EstadosExpedientes").on('click', function(){
						validacionBotonGuardado('EstadosExpedientes');
					});
					$("#last_EstadosExpedientes").on('click', function(){
						validacionBotonGuardado('EstadosExpedientes');
					});
				}
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodEstadosExpedientes").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#EstadosExpedientes"), "aa21b07s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cesta07":{
						required: true
    					},
    				"desta07":{
						required: true
    					},
    				"eesta07":{
						required: false
    					},
    				"situ07":{
						required: true
    					}
    				}
    		}
    		
        },
        onPaging: function(){
			$("#EstadosExpedientes").rup_table("deselectAllRows");
		}
	});
	
	
	
	/**
	 * Cambio de títulos y textos filtrar
	 */
	$("#EstadosExpedientes_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#EstadosExpedientes_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#EstadosExpedientes").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa21b07s01", "desta07");
	});
	jQuery("#EstadosExpedientes").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return bloquear(oper, $(this), "aa21b07s01", "desta07");
		}else{
			return true;
		}	
	});
	jQuery("#EstadosExpedientes_detail_div").on("dialogclose", function() {
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#EstadosExpedientes"), "aa21b07s01");
		}
		$("#modoDetalle").val("");
		$("#EstadosExpedientes").rup_table("deselectAllRows");
		$("#ExpAsociadosEstadoExp").rup_table("clearGridData",true);
	});
	
	jQuery(window).bind('beforeunload', function() {
        // Aquí iría la función que desbloquea : 
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#EstadosExpedientes"), "aa21b07s01");
		}	
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	
	jQuery("#EstadosExpedientes").on("jqGridAddEditAfterClickPgButtons", function(event, form, oper) {
		cargaAsociadosEstadoExp();
		return;
	});
	/* 
	 * INI: Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#EstadosExpedientes").on("jqGridSelectRow", function(event, form, oper) {
		if(oper){
			if(!todosEnAlta($(this),"situ07")){
				desactivar('EstadosExpedientes');
		 	 }
		 	 else{
		 		activar('EstadosExpedientes');
		 	 }
		}	
		comprobacionEliminar('EstadosExpedientes');
	});
	jQuery("#EstadosExpedientes").on("rupTable_beforeEditRow", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return  todosEnAlta($(this),"situ07");
		}else{
			return true;
		}	
	});
	/*
	 * FIN: funciones control si estado es baja no pueda editar 
	 */
	
	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente en modo Consulta
	 */
	$("#ExpAsociadosEstadoExp").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociadosEstadoExp").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociadosEstadoExp").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociadosEstadoExp").rup_table("getRowData")[posLinea].idExpe;
		dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
		return false;
	});
	
	$("#ExpAsociadosEstadoExp").on("rupTable_beforeEditRow", function(event, form, oper) {
		return false;
	});
	
	
	
	
	//Combo situación en pantalla detalle
	$("#situ07_detail_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		blank: "",
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ07_detail_table").rup_combo("selectLabel", $("situ07_detail_table").val());
		}
	});
	
	
	
	//Ocultamos el botón de clonar
	$("[id='EstadosExpedientes_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	//Meto en el apartado filtro el literal de que esta en situación Alta
	$("#EstadosExpedientes_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b12s01.situ12 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");
	
	
	//Tabla expedientes asociados al departamento
	$("#ExpAsociadosEstadoExp").rup_table({
		rowNum:6,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo",
			"objeto20"
		],
		colModel: [
		    {  name: "refExp", 
		       label: "refExp",
        	   align: "center", 
        	   width:280, 
        	   editable: true, 
        	   fixed: false, 
        	   hidden: false, 
        	   resizable: false, 
        	   sortable: true
            },
            {   name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
		    },
			{ 	name: "idExpe", 
			 	label: "idExpe",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cesta20", 
			 	label: "cesta20",
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cserv20", 
	        	label: "cserv20",
	        	hidden: true 
	        },
	        { 	name: "cexpe20", 
	        	   label: "cexpe20",
	        	   hidden: true 
	        },
	        { 	name: "aexpe20", 
	        	   label: "aexpe20",
	        	   hidden: true 
           },
           { 	name: "nexpe20", 
        	   label: "nexpe20",
        	   hidden: true 
           },   
           { 	name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
           },
           {
        	 name: "objeto20",
        	 lable: "objeto20",
        	 hidden: true
           },
	        
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"toolbar",
        	"filter",
        	"formEdit",
           	"fluid",
           	"feedback"
         	],
     	filter:{
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
			
			/**
			 * Cambiamos el tooltip para que al posicionarse encima de la celda en vez de aparecer el titulo con la referencia
			 * aparezca el objeto
			 */
			var ref = rowdata["refExp"];
			var objeto20 = rowdata["objeto20"];
			$("td[rup_tooltip='" + ref + "'").attr("rup_tooltip",objeto20);
		},
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpAsociadosEstadoExp,
		toolbar:{
			defaultButtons:{
				   add: false,
				   edit: false,
				   cancel: false,
				   save: false,
				   clone: false,
				   "delete": false
				},
				newButtons:[{
				id:"detalleExpAsociadoUbicacion",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "rup-icon detalle"},
				click:function(event, form, oper){
					handlerDetalleExpAsociadoEstadoExp();
				}
			}]
		}
	});
	
	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados Depar
	$(".ui-paging-info").hide();
	$(".ui-pg-selbox").hide();
	$("#first_ExpAsociadosEstadoExp_pager").hide();
	$("#last_ExpAsociadosEstadoExp_pager").hide();
	$("#ExpAsociadosEstadoExp_pager_left").hide();
	
	
	$("#EstadosExpedientes_filter_cleanLink").unbind("click");
	$("#EstadosExpedientes_filter_cleanLink").click(limpiar);
	$("#EstadosExpedientes_cb div").hide();
	 
	$("#EstadosExpedientes").unbind("dblclick");
	 
	 
	dialogoConsultaEspedientesAsociados.ocultarElementos();
	dialogoFase.ocultarElementos();
	dialogoHistorico.ocultarElementos();
	dialogoDocumentos.ocultarElementos();
	
});


/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteEstadosExpedientes(e){
	
	
	$('[aria-describedby="EstadosExpedientes_cesta07"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="EstadosExpedientes_desta07"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="EstadosExpedientes_eesta07"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="EstadosExpedientes_situ07"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ07=="B"){
				$("tr[id='" + fila.cesta07 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.cesta07 + "']").css("font-style","italic");
				$("tr[id='" + fila.cesta07 + "']").css("background","#848484");
			}
		}*/
		
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='EstadosExpedientes_toolbar##imprimir']").show();
		$("[id='EstadosExpedientes_toolbar##excel']").show();
	}else{
		//Si no hay registros, ocultamos los botones de imprimir y de Excel
		$("[id='EstadosExpedientes_toolbar##imprimir']").hide();
		$("[id='EstadosExpedientes_toolbar##excel']").hide();
	}	
	
	
	$.each ($('[aria-describedby="EstadosExpedientes_cesta07"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="EstadosExpedientes_desta07"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="EstadosExpedientes_eesta07"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="EstadosExpedientes_situ07"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}

/**
 * Función que cambia la situación de alta a baja y viceversa
 */
function handlerCambioEstado(){
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	
	if($("#EstadosExpedientes").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			siNo:true,
			OKFunction: function() {
				//Obtención de las líneas seleccionadas				   
			   registros = $("#EstadosExpedientes").rup_table("getSelectedLines");
			   cambiarEstadoLinea(registros);
			  
			 //Una vez cambiados todos los estados se refresca la tabla
			   $("#EstadosExpedientes").rup_table("filter");
			   $("#EstadosExpedientes").rup_table("setSelection", regBloqueados, true);
			}
		});
		
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
};

function cambiarEstadoLinea(registros){
	//Se recorren los registro seleccionados
	for(var i=0;i<registros.length;i++){
		var indice = registros[i]-1;
		var exp = $("#EstadosExpedientes").rup_table("getRowData")[indice];
		var codigo = exp.cesta07;
		   
		   
		var noBloqueado = bloquear("change", $("#EstadosExpedientes"), "aa21b07s01", "desta07",codigo);
		if(noBloqueado)
		{
			var send = {};
			send["cesta07"] = exp.cesta07;
			send["desta07"] = exp.desta07;
			send["eesta07"] = exp.eesta07;
			if(exp.situ07 == "Alta"){
				send["situ07"] = "B";
			}else if(exp.situ07 == "Baja"){
				send["situ07"] = "A";
			}
			var dt = jQuery.toJSON(send);
			$.ajax({
			   url: "../aa21b07s01/cambioEstadoEstadoExpediente",
			   type: "POST",
			   contentType: "application/json; charset=utf-8",
			   dataType: "json",
			   data: dt,
			   async:false,
			   cache:false,
			   error: callback_error,
			   success: function(data) {
				   desbloquear(jQuery("#EstadosExpedientes"), "aa21b07s01");
				   $("#EstadosExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
				   if(registros.length > 1){
					   $("#EstadosExpedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b07s01.cambioEstadoOK"), "ok");
				   }else{
					   $("#EstadosExpedientes_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b07s01.cambioEstadoOK"), "ok");
				   } 
				   $("#EstadosExpedientes_feedback").rup_feedback("show");
				   //Se deselecciona de la tabla el registro que se ha actualizado
				   $("#EstadosExpedientes").rup_table("setSelection", codigo, false);
 				   //Volvemos a llamar a la función de cambio de estado pasandole los demás registros seleccionados
				   //Así se evita que al ser una ejecución sincrona, se deje algún registro sin actualizar
				   registros = $("#EstadosExpedientes").rup_table("getSelectedLines");
				   cambiarEstadoLinea(registros);
			   }
		   });
	   }else{
		   regBloqueados[indiceBloq] = codigo;
		   indiceBloq++;
	   }	
	}

};

function callback_error(xhr, ajaxOptions, thrownError){
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {	
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#EstadosExpedientes_feedback").rup_feedback("option", "delay", null);
			 $("#EstadosExpedientes_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#EstadosExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#EstadosExpedientes_feedback").rup_feedback("option", "delay", null);
			 $("#EstadosExpedientes_feedback").rup_feedback("set", errorTXT, "error");								
			 $("#EstadosExpedientes_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}
/**
 * Función imprimir estados expediente
 */
function handlerImprimirEstadosExp(){
	if($("#EstadosExpedientes").rup_table("getDataIDs").length > 0){
		$('#icesta07').val($('#cesta07_filter_table').val());
		$('#idesta07').val($('#desta07_filter_table').val());
		$('#ieesta07').val($('#eesta07_filter_table').val());
		$('#isitu07').val($('#situ07_filter_table').val());

		$("#frmImprimirEstadosExp").attr("action","../imprimirMantGenerales/imprimirEstadosExpedientes");
		$("#frmImprimirEstadosExp").attr("target","_blank");
	
		var form = document.forms["frmImprimirEstadosExp"];
		form.submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
};

/**
 * Función generación Excel estados expedientes
 */
function handlerExcelEstadosExp(){
	if($("#EstadosExpedientes").rup_table("getDataIDs").length > 0){
		$('#icesta07').val($('#cesta07_filter_table').val());
		$('#idesta07').val($('#desta07_filter_table').val());
		$('#ieesta07').val($('#eesta07_filter_table').val());
		$('#isitu07').val($('#situ07_filter_table').val());
	
		$("#frmImprimirEstadosExp").attr("action","../aa21b07s01/excelEstadosExpedientes");
		$("#frmImprimirEstadosExp").attr("target","_blank");
		$("#frmImprimirEstadosExp").submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
}


function limpiar(){
	$("#situ07_filter_table").val("");
	$("#EstadosExpedientes_filter_summary").html("<i></i>");
	$("#EstadosExpedientes").rup_table("deselectAllRows");
	$("#EstadosExpedientes").rup_table("clearGridData",true);
	$("#EstadosExpedientes").rup_table("resetForm", $("#EstadosExpedientes_filter_form"));
}


function handlerConsulta(){
	$("#modoDetalle").val("C");
	$("#EstadosExpedientes").rup_table("editElement");
}


function cargaAsociadosEstadoExp(){
	$("#ExpAsociadosEstadoExp").rup_table("setGridParam", {url: "../aa21b07s01/obtenerExpedientesEstadoExpServ/" + $("#cesta07_detail_table").val()});
	$("#ExpAsociadosEstadoExp").rup_table("filter");
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociadosEstadoExp(e){
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){
		$("#fieldExpAsoc").show();
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	}else{
		$("#fieldExpAsoc").hide();
	}	
	
}

function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}


function handlerDetalleExpAsociadoEstadoExp(){
	var posLinea = $("#ExpAsociadosEstadoExp").rup_table("getSelectedLines");
	var refExp = $("#ExpAsociadosEstadoExp").rup_table("getRowData")[posLinea].refExp;
	var idExpAsoc = $("#ExpAsociadosEstadoExp").rup_table("getRowData")[posLinea].idExpe;
	dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
}