var idioma=$.rup.lang;
var modo;
var codigoPrincipal;
jQuery(function($){

	//Combo situación en pantalla búsqueda
	$("#situ05_filter_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.todas, value:""},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ05_filter_table").rup_combo("selectLabel", $("situ05_filter_table").val());
		}
	});
	//Ponemos por defecto el filtro de búsqueda en situación Alta
	$("#situ05_filter_table").rup_combo("select","A");
	
	//Tabla grid de tipos de documentos
	$("#TiposDocumentos").rup_table({
		rowNum:20,
		url: "../aa21b05s01",
		colNames: [
		           $.rup.i18n.app.aa21b05s01.cdocu05,
		           $.rup.i18n.app.aa21b05s01.ddocu05,
		           $.rup.i18n.app.aa21b05s01.edocu05,
		           $.rup.i18n.app.aa21b05s01.situ05,
		],
		colModel: [
			{ 	name: "cdocu05", 
			 	label: $.rup.i18n.app.aa21b05s01.cdocu05,
			 	align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "ddocu05", 
			 	label:  $.rup.i18n.app.aa21b05s01.ddocu05,
			 	align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden:false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "edocu05", 
			 	label:  $.rup.i18n.app.aa21b05s01.edocu05,
			 	align: "left", 
				width: 200, 
				editable: true, 
				fixed: false, 
				hidden:false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "situ05", 
			 	label: $.rup.i18n.app.aa21b05s01.situ,
			 	align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa21b05s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "cdocu05",
		sortname: idioma=="es"?"situ05,ddocu05":"situ05,edocu05",
		sortorder: "asc",
		loadOnStartUp: true,
		loadComplete:fncTableCompleteTiposDocumentos,
		toolbar:{
			newButtons:[
			    {
			    	id:"detalle",
			    	obj: {id:"detalle",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "detalle"},
			    	ocultar:true,
			    	comportamiento:"edit",
			    	click:handlerConsulta
			    },
			    {
					id:"cambioEstado",
					obj: {id:"cambioEstado",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.cambioEstado, css: "cambioEstado"},
					ocultar:true,
					comportamiento:"delete",
					click: handlerCambioEstado
				},
			    {
					id:"imprimir",
					obj: {id:"imprimir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.imprimir, css: "rup-icon rup-icon-print"},
					comportamiento:"add",
					click: handlerImprimirTiposDoc
			    },
			    {
			    	id:"excel",
			    	obj: {id:"excel",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.excel, css: "excel"},
			    	comportamiento:"add",
			    	click: handlerExcelTiposDoc
			    }]
		},
		afterInsertRow : function(rowid, rowdata) {
			//Función que pinta en el registro Alta o Baja según sea A o B
			pintarFilaSituacion(rowid, rowdata, $(this), "situ05");
		},
        formEdit:{
        	detailForm: "#TiposDocumentos_detail_div",
			fillDataMethod: "clientSide",
			addOptions:{
				beforeShowForm:function(){
					//Ponemos el titulo en modo añadir y mostramos las marcas de obligatorio
					$("#ui-dialog-title-TiposDocumentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjNuevoTipoDocumento"));
					$("#labelOblig").show();
					$(".asterisco").show();
					
					//Situación será por defecto a Alta al añadir registro
					$("#TiposDocumentos_detail_link_cancel").css("display","block");
					$("#divSituacion").hide();
					$("#situ05_detail_table").val("A");
					$("#fieldExpAsoc").hide();
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			editOptions:{
				beforeShowForm:function(){
					//Cargo expedientes asociados
					cargaAsociadosTipoDoc();
					$("#divSituacion").show();
					$("#situ05_detail_table").rup_combo("disable");
					//Si es consulta deshabilitaremos los campos
					if($("#modoDetalle").val() == "C"){
						$("#TiposDocumentos_detail_div :input").attr("readonly","readonly");
						
						$("#TiposDocumentos_detail_link_cancel").css("display","none");
						
						
						//Ponemos el titulo en modo modificar y mostramos las marcas de obligatorio
						$("#ui-dialog-title-TiposDocumentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjVerTipoDocumento"));
						$("#labelOblig").hide();
						$(".asterisco").hide();
						$(".ui-selectmenu-status").css("color","black");
					}else{
						
						//Ponemos el titulo en modo consulta y ocultamos las marcas de obligatorio
						$("#ui-dialog-title-TiposDocumentos_detail_div").text($.rup.i18nParse($.rup.i18n.app,"mensajesMantGenerales.msjEditarTipoDocumento"));
						$("#labelOblig").show();
						$(".asterisco").show();
						
						$("#TiposDocumentos_detail_div :input").removeAttr("readonly");
						
						$("#TiposDocumentos_detail_link_cancel").css("display","block");
					}
					
				},
				reloadAfterSubmit:true,
				width:"660"
			},
			addEditOptions:{
				afterShowForm:function(){
					
					/**Funcion para que aparezca el botón guardar o no detalle**/
					validacionBotonGuardado('TiposDocumentos');
					
					/**
					 * Hacer que cuando haga click en los botones de navegación recargue
					 * correctamente la validacion del botón guardar 
					 */
					$("#first_TiposDocumentos").on('click', function(){
						validacionBotonGuardado('TiposDocumentos');
					});
					$("#back_TiposDocumentos").on('click', function(){
						validacionBotonGuardado('TiposDocumentos');
					});
					$("#forward_TiposDocumentos").on('click', function(){
						validacionBotonGuardado('TiposDocumentos');
					});
					$("#last_TiposDocumentos").on('click', function(){
						validacionBotonGuardado('TiposDocumentos');
					});
				}
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodTiposDocumentos").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#TiposDocumentos"), "aa21b05s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cdocu05":{
						required: true
    					},
    				"ddocu05":{
						required: true
    					},
    				"edocu05":{
						required: false
    					},
    				"situ05":{
						required: true
    					}
    				}
    		}
    			
        },
        onPaging: function(){
			$("#TiposDocumentos").rup_table("deselectAllRows");
		}
	});
	
	
	
	/**
	 * Cambio de títulos y textos filtrar
	 */
	$("#TiposDocumentos_filter_toggle_label").text($.rup.i18n.app.comun.critBusq);
	$("#TiposDocumentos_filter_filterButton").val($.rup.i18n.app.comun.buscar);
	
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#TiposDocumentos").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa21b05s01", "ddocu05");
	});
	jQuery("#TiposDocumentos").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return bloquear(oper, $(this), "aa21b05s01", "ddocu05");
		}else{
			return true;
		}	
	});
	
	/**
	 * Función al cerrar la ventana dialogo. Limpia los registros de la tabla
	 * y desbloquea el registro si es necesario
	 */
	jQuery("#TiposDocumentos_detail_div").on("dialogclose", function() {
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#TiposDocumentos"), "aa21b05s01");
		}
		$("#modoDetalle").val("");
		$("#TiposDocumentos").rup_table("deselectAllRows");
		$("#ExpAsociadosTipoDoc").rup_table("clearGridData",true);
	});
	
	jQuery(window).bind('beforeunload', function() {
        // Aquí iría la función que desbloquea : 
		if($("#modoDetalle").val() != "C"){
			desbloquear(jQuery("#TiposDocumentos"), "aa21b05s01");
		}	
	});
	
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	
	/* Se llama a la función para refrescar la tabla de expedientes asignados al pulsar en los botones de paginación*/
	jQuery("#TiposDocumentos").on("jqGridAddEditAfterClickPgButtons", function(event, form, oper) {
		cargaAsociadosTipoDoc();
		return;
	});
	
	/* 
	 * Funciones para controlar si el estado es baja que no pueda editar
	 */
	jQuery("#TiposDocumentos").on("jqGridSelectRow", function(event, form, oper) {
		if(oper){
			if(!todosEnAlta($(this),"situ05")){
				desactivar('TiposDocumentos');
		 	 }
		 	 else{
		 		activar('TiposDocumentos');
		 	 }
		}	
		comprobacionEliminar('TiposDocumentos');
	});
	jQuery("#TiposDocumentos").on("rupTable_beforeEditRow", function(event, form, oper) {
		if($("#modoDetalle").val() != "C"){
			return  todosEnAlta($(this),"situ05");
		}else{
			return true;
		}	
	});
	/*
	 * Fin funciones control si estado es baja no pueda editar 
	 */
	
	
	//Combo situación en pantalla detalle
	$("#situ05_detail_table").rup_combo({
		source:[
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.alta, value:"A"},
		        {i18nCaption:$.rup.i18n.app.situ_detail_table.baja, value:"B"}
		],
		sourceParam:{},
		ordered: false,
		blank: "",
		method: 'GET',
		style: "dropdown",
		onLoadSuccess: function(){
			$("#situ05_detail_table").rup_combo("selectLabel", $("situ05_detail_table").val());
		}
	});
	
	/**
	 * Función al hacer doble click en la tabla asociados
	 * muestra un dialog con los datos del expediente en modo Consulta
	 */
	$("#ExpAsociadosTipoDoc").on("jqGridDblClickRow", function(event, form, oper) {
		var posLinea = $("#ExpAsociadosTipoDoc").rup_table("getSelectedLines");
		var refExp = $("#ExpAsociadosTipoDoc").rup_table("getRowData")[posLinea].refExp;
		var idExpAsoc = $("#ExpAsociadosTipoDoc").rup_table("getRowData")[posLinea].idExpe;
		dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
		return false;
	});
	
	$("#ExpAsociadosTipoDoc").on("rupTable_beforeEditRow", function(event, form, oper) {
		return false;
	});
	
	//Ocultamos el botón de clonar
	$("[id='TiposDocumentos_toolbar"+$.rup.i18n.base.rup_maint.clone+"']").css("display","none");
	
	
	//Meto en el apartado filtro el literal de que esta en situación Alta
	$("#TiposDocumentos_filter_summary").html("<span style='font-style:italic;'>" + $.rup.i18n.app.aa21b12s01.situ12 + " = " + $.rup.i18n.app.situ_detail_table.alta + "</span>");
	
	
	//Tabla expedientes asociados al tipo documento
	$("#ExpAsociadosTipoDoc").rup_table({
		rowNum:6,
		colNames: [
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
		    $.rup.i18n.app.aa21b20s01.refer20,
			$.rup.i18n.app.aa21b20s01.cesta20,
			"cserv20",
			"cexpe20",
			"aexpe20",
			"nexpe20",
			"grupo",
			"objeto20"
		],
		colModel: [
		    {  name: "refExp", 
		       label: "refExp",
        	   align: "center", 
        	   width:280, 
        	   editable: true, 
        	   fixed: false, 
        	   hidden: false, 
        	   resizable: false, 
        	   sortable: true
            },
            {   name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
		    },
			{ 	name: "idExpe", 
			 	label: "idExpe",
				align: "left", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cesta20", 
			 	label: "cesta20",
				align: "right", 
				width: 75, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "cserv20", 
	        	label: "cserv20",
	        	hidden: true 
	        },
	        { 	name: "cexpe20", 
	        	   label: "cexpe20",
	        	   hidden: true 
	        },
	        { 	name: "aexpe20", 
	        	   label: "aexpe20",
	        	   hidden: true 
           },
           { 	name: "nexpe20", 
        	   label: "nexpe20",
        	   hidden: true 
           },   
           { 	name: "grupo", 
        	   label: "grupo",
        	   hidden: true 
           },
           {
        	 name: "objeto20",
        	 label: "objeto20",
        	 hidden: true
           },
	        
        ],
        model:"Aa21b20s01",
        usePlugins:[
			"toolbar",
        	"filter",
        	"formEdit",
           	"fluid",
           	"feedback"
         	],
     	filter:{
		},
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacionExpediente(rowid, rowdata, $(this), "cesta20");
			
			/**
			 * Cambiamos el tooltip para que al posicionarse encima de la celda en vez de aparecer el titulo con la referencia
			 * aparezca el objeto
			 */
			var ref = rowdata["refExp"];
			var objeto20 = rowdata["objeto20"];
			$("td[rup_tooltip='" + ref + "'").attr("rup_tooltip",objeto20);
		},
		primaryKey: "idExpe",
		sortname: "faper20",
		sortorder: "asc",
		loadOnStartUp: false,
		loadComplete:fncTableCompleteExpAsociadosTipoDoc,
		toolbar:{
			defaultButtons:{
				   add: false,
				   edit: false,
				   cancel: false,
				   save: false,
				   clone: false,
				   "delete": false
				},
			newButtons:[{
				id:"detalleExpAsociadoUbicacion",
				obj: {i18nCaption:$.rup.i18n.app.botonerasMantGenerales.detalle, css: "rup-icon detalle"},
				click:function(event, form, oper){
					handlerDetalleExpAsociadoTipoDoc();
				}
			}]
		}
	});
	
	//Oculto de la barra de paginación lo que no me interesa de la tabla asociados Depar
	$(".ui-paging-info").hide();
	$(".ui-pg-selbox").hide();
	$("#first_ExpAsociadosTipoDoc_pager").hide();
	$("#last_ExpAsociadosTipoDoc_pager").hide();
	$("#ExpAsociadosTipoDoc_pager_left").hide();
	
	
	$("#TiposDocumentos_filter_cleanLink").unbind("click");
	$("#TiposDocumentos_filter_cleanLink").click(limpiar);
	 $("#TiposDocumentos_cb div").hide();
	 
	 $("#TiposDocumentos").unbind("dblclick");
	 
	 dialogoConsultaEspedientesAsociados.ocultarElementos();
		dialogoFase.ocultarElementos();
		dialogoHistorico.ocultarElementos();
		dialogoDocumentos.ocultarElementos();
});


/**
 * Función que añade el icono al cursor para indicar que el botón secundario tiene una función. 
 * También para cambiar el tooltip indicando instrucciones.
 */
function fncTableCompleteTiposDocumentos(e){
	
	
	$('[aria-describedby="TiposDocumentos_cdocu05"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="TiposDocumentos_ddocu05"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="TiposDocumentos_edocu05"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	$('[aria-describedby="TiposDocumentos_situ05"]').css("cursor", "url("+$.rup.RUP+"/basic-theme/cursors/context-menu.cur),default" );
	
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){					
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.situ05=="B"){
				$("tr[id='" + fila.cdocu05 + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.cdocu05 + "']").css("font-style","italic");
				$("tr[id='" + fila.cdocu05 + "']").css("background","#848484");
			}
		}*/
		
		//Si hay registros, mostramos los botones de Imprimir y de Excel
		$("[id='TiposDocumentos_toolbar##imprimir']").show();
		$("[id='TiposDocumentos_toolbar##excel']").show();
	}else{
		//Si no hay registros, ocultamos los botones de imprimir y de Excel
		$("[id='TiposDocumentos_toolbar##imprimir']").hide();
		$("[id='TiposDocumentos_toolbar##excel']").hide();
	}
	
	
	$.each ($('[aria-describedby="TiposDocumentos_cdocu05"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="TiposDocumentos_ddocu05"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$.each ($('[aria-describedby="TiposDocumentos_edocu05"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});

	$.each ($('[aria-describedby="TiposDocumentos_situ05"]'), function(index, object){
		$(object).attr("grid_tooltip", "<b>"+$(object).attr("grid_tooltip") + "</b><br/><i>" + $.rup.i18n.app.comun.tooltipMenuContextual)+ "<i/>" ;
	});
	
	$(".rup-icon-clone").parent().css("display","none");
	
	
}

/**
 * Función que cambia la situación de alta a baja y viceversa
 */
function handlerCambioEstado(){
	var registros = [];
	var regBloqueados = [];
	var indiceBloq = 0;
	if($("#TiposDocumentos").rup_table("getSelectedRows") != ""){
		
		$.rup_messages("msgConfirm", { 
			title: $.rup.i18n.app.mensajesMantGenerales.titPreguntaConfirmar,
			message: $.rup.i18n.app.mensajesMantGenerales.msjConfirmarCambioSit,
			siNo:true,
			OKFunction: function() {
			   //Obtención de las líneas seleccionadas
			   registros = $("#TiposDocumentos").rup_table("getSelectedLines");
			   cambiarEstadoLinea(registros);
			
			   //Una vez cambiados todos los estados se refresca la tabla
			   $("#TiposDocumentos").rup_table("filter");
			   //Dejo seleccionado los registros que estan bloqueados
			   $("#TiposDocumentos").rup_table("setSelection", regBloqueados, true);
			   
			}
		});
		
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.msjNoRegistro});
	}
	
	
};

function cambiarEstadoLinea(registros){
	//Se recorren los registro seleccionados
	for(var i=0;i<registros.length;i++){
	   var indice = registros[i]-1;
	   var exp = $("#TiposDocumentos").rup_table("getRowData")[indice];
	   var codigo = exp.cdocu05;
		   
	   var noBloqueado = bloquear("change", $("#TiposDocumentos"), "aa21b05s01", "ddocu05",codigo);
	   if(noBloqueado)
	   {
		   var send = {};
		   send["cdocu05"] = exp.cdocu05;
		   send["ddocu05"] = exp.ddocu05;
		   send["edocu05"] = exp.edocu05;
		   if(exp.situ05 == "Alta"){
			   send["situ05"] = "B";
		   }else if(exp.situ05 == "Baja"){
			   send["situ05"] = "A";
		   }
		   var dt = jQuery.toJSON(send);
		   $.ajax({
			   url: "../aa21b05s01/cambioEstadoTipoDocumento",
			   type: "POST",
			   contentType: "application/json; charset=utf-8",
			   dataType: "json",
			   data: dt,
			   async:false,
			   cache:false,
			   error: callback_error,
			   success: function(data) {
				   desbloquear(jQuery("#TiposDocumentos"), "aa21b05s01");
				   $("#TiposDocumentos_feedback").rup_feedback("option", "delay", defaultDelay);
				   if(registros.length > 1){
					   $("#TiposDocumentos_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b05s01.cambioEstadoOK"), "ok");
				   }else{
					   $("#TiposDocumentos_feedback").rup_feedback("set",$.rup.i18nParse($.rup.i18n.app,"aa21b05s01.cambioEstadoOK"), "ok");
				   } 
				   $("#TiposDocumentos_feedback").rup_feedback("show");
				   //Se deselecciona de la tabla el registro que se ha actualizado
				   $("#TiposDocumentos").rup_table("setSelection", codigo, false);
				   //Volvemos a llamar a la función de cambio de estado pasandole los demás registros seleccionados
				   //Así se evita que al ser una ejecución sincrona, se deje algún registro sin actualizar
				   registros = $("#TiposDocumentos").rup_table("getSelectedLines");
				   cambiarEstadoLinea(registros);
			   }
		   });
	   }else{
		   regBloqueados[indiceBloq] = codigo;
		   indiceBloq++;
	   }	
   }
	
};

function callback_error(xhr, ajaxOptions, thrownError){
	 var errorTXT = $.rup.i18nParse($.rup.i18n.base,"rup_maint.validateError"), errors = null, errorKey = null, causedErrors = null, errMsg = "", errorMesg = "";
	 if (xhr.responseText != null && xhr.responseText != "") {	
		 if (xhr.status === 406) {//si ha habido algun error en las validaciones...
			 $("#TiposDocumentos_feedback").rup_feedback("option", "delay", null);
			 $("#TiposDocumentos_feedback").rup_feedback("set",errorTXT + " " + xhr.responseText,"error");
			 $("#TiposDocumentos_feedback").rup_feedback("option", "delay", defaultDelay);
		 } else {
			 $("#TiposDocumentos_feedback").rup_feedback("option", "delay", null);
			 $("#TiposDocumentos_feedback").rup_feedback("set", errorTXT, "error");								
			 $("#TiposDocumentos_feedback").rup_feedback("option", "delay", defaultDelay);
		 }
	 }
}

/**
 * Función para imprimir
 */
function handlerImprimirTiposDoc(){
	if($("#TiposDocumentos").rup_table("getDataIDs").length > 0){
		$('#icdocu05').val($('#cdocu05_filter_table').val());
		$('#iddocu05').val($('#ddocu05_filter_table').val());
		$('#edocu05').val($('#edocu05_filter_table').val());
		$('#isitu05').val($('#situ05_filter_table').val());
	
		$("#frmImprimirTiposDoc").attr("action","../imprimirMantGenerales/imprimirTiposDocumentos");
		$("#frmImprimirTiposDoc").attr("target","_blank");
	
		var form = document.forms["frmImprimirTiposDoc"];
		form.submit();
	}else{
		alert($.rup.i18n.app.mensajesMantGenerales.noRegistros);
	}	
};

/**
 * Función para generación del Excel con los datos de tipos de documentos
 */
function handlerExcelTiposDoc(){
	if($("#TiposDocumentos").rup_table("getDataIDs").length > 0){
		$('#icdocu05').val($('#cdocu05_filter_table').val());
		$('#iddocu05').val($('#ddocu05_filter_table').val());
		$('#edocu05').val($('#edocu05_filter_table').val());
		$('#isitu05').val($('#situ05_filter_table').val());
	
		$("#frmImprimirTiposDoc").attr("action","../aa21b05s01/excelTiposDocumentos");
		$("#frmImprimirTiposDoc").attr("target","_blank");
		$("#frmImprimirTiposDoc").submit();
	}else{
		$.rup_messages("msgAlert", {message: $.rup.i18n.app.mensajesMantGenerales.noRegistros});
	}	
}

function limpiar(){
	$("#situ05_filter_table").val("");
	$("#TiposDocumentos_filter_summary").html("<i></i>");
	$("#TiposDocumentos").rup_table("deselectAllRows");
	$("#TiposDocumentos").rup_table("clearGridData",true);
	$("#TiposDocumentos").rup_table("resetForm", $("#TiposDocumentos_filter_form"));
}

function handlerConsulta(){
	$("#modoDetalle").val("C");
	$("#TiposDocumentos").rup_table("editElement");
}

function cargaAsociadosTipoDoc(){
	$("#ExpAsociadosTipoDoc").rup_table("setGridParam", {url: "../aa21b05s01/obtenerExpedientesTipoDocServ/" + $("#cdocu05_detail_table").val()});
	$("#ExpAsociadosTipoDoc").rup_table("filter");
}

/**
 * Función que cambia el color de la línea de registro si el estado de baja 
 */
function fncTableCompleteExpAsociadosTipoDoc(e){
	
	//Recorremos la tabla comprobando el campo situación. Si es Baja, le asignaremos el color de fondo a rojo
	if (e.rows != undefined && e.rows.length>0){		
		$("#fieldExpAsoc").show();
		/*for (var i=0; i<e.rows.length; i++) {	
			var fila = e.rows[i];
			if(fila.cesta20=="4"){
				$("tr[id='" + fila.idExpe + "']").attr("class","ui-widget-content jqgrow ui-row-ltr");
				$("tr[id='" + fila.idExpe + "']").css("font-style","italic");
				$("tr[id='" + fila.idExpe + "']").css("background","#848484");
			}
		}*/
	}else{
		$("#fieldExpAsoc").hide();
	}	
	
}

function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}

function handlerDetalleExpAsociadoTipoDoc(){
	var posLinea = $("#ExpAsociadosTipoDoc").rup_table("getSelectedLines");
	var refExp = $("#ExpAsociadosTipoDoc").rup_table("getRowData")[posLinea].refExp;
	var idExpAsoc = $("#ExpAsociadosTipoDoc").rup_table("getRowData")[posLinea].idExpe;
	dialogoConsultaEspedientesAsociados.abrirDialogo(idExpAsoc,refExp);
}