/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
	$.ajaxSetup({ cache: false });
	
	$(document).ajaxError(function(event, jqXHR, ajaxSettings, thrownError) {
		if (jqXHR.status === 401 || jqXHR.status === 403){
			window.location.href=$.rup.CTX_PATH + jqXHR.getResponseHeader("LOCATION");
		} 
	});
	
	jQuery.rup.i18n.base.rup_combo.blankNotDefined="&nbsp;";
	//logo
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
	
	
	var breadCrumbData = {
			"inicio" : {"i18nCaption" : "inicio"},
			"aa21bServiciosTiposFases" : {"i18nCaption" : "serviciosTiposFases"},
			"aa21b14s01" : {"i18nCaption": "ubicacionExpedientes"},
			"aa21b07s01" : {"i18nCaption": "estadosExpedientes"},
			"aa21b05s01" : {"i18nCaption": "tiposDocumentos"},
			"aa21b15s01" : {"i18nCaption": "usuarios"},
			"aa21b12s01" : {"i18nCaption" : "departamentos"},
			"aa21b20s01" : {"i18nCaption" : "expedientes"},
			"aa21bConsultas" : {"i18nCaption": "consultas"},
			"desbloqueosTablas" : {"i18nCaption" : "desbloqueoTablas"}
			//--------------------------------------
	};
	
		
	//rastro de migas
	$("#aa21bOrgDocumentalWar_migas").rup_breadCrumb({
		//logOutUrl: 		"/aa21bOrgDocumental/logout",
		breadCrumb: breadCrumbData	
	});
	
	//idioma
	$("#aa21bOrgDocumentalWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY, modo: ""});
	
	//menu
	$("#aa21bOrgDocumentalWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal'),
		verticalWidth:"100"
	});
	if ($.rup.LAYOUT === "mixto") {
		$("#aa21bOrgDocumentalWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	$('[aria-labelledby="aa21bOrgDocumentalWar_menu-1"]').css("width","100px");
	$('[aria-labelledby="aa21bOrgDocumentalWar_menu-2"]').css("width","200px");
	$('[aria-labelledby="aa21bOrgDocumentalWar_menu-3"]').css("width","150px");
	$('[aria-labelledby="aa21bOrgDocumentalWar_menu-4"]').css("width","150px");
	
	
	$(".ui-menu.ui-widget.ui-widget-content.ui-corner-all.rup_menu_vertical_horizontal").css("width","");
	
	//pie
	$(".footer [title]").rup_tooltip();
	
	  if($("h2#titulo").length!==0){
	    	$("h2#titulo").hide();
	    $("#tituloAplicacion").html( $("#tituloAplicacion").html()+" - "+$("h2#titulo").html());
	    }
	  jQuery.validator.addMethod("noMenosUno", function(value, element, param) {
			
			return(value+""!="-1");
			
				
		});	
});