package com.ejie.aa21b.view;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Esta clase permite filtrar en el un directorio por nombre de fichero
 * 
 *  
 * 
 */
public class FiltroNombre implements FilenameFilter {
	private String nombre;
	private String idioma;

	/**
	 * 
	 * @param nombre
	 *            String
	 * @param idioma
	 *            String
	 */
	public FiltroNombre(String nombre, String idioma) {
		this.nombre = nombre;
		this.idioma = idioma + ".xls";
	}

	@Override
	public boolean accept(File dir, String name) {
		if (name.startsWith(nombre) && name.endsWith(idioma)) {
			return true;
		} else {
			return false;
		}
	}

}
