package com.ejie.aa21b.view;

import java.io.File;

import java.text.SimpleDateFormat;
import java.util.Arrays;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.util.Aa21bConstantes;

/**
 * Crea el excel de listado de expedientes (Consultas y listados)
 * 
 *  
 * 
 */
public class ExcelAa21bTramitacionExpedientesView extends AbstractExcelView {
	private static final Logger logger = LoggerFactory
			.getLogger(ExcelAa21bTramitacionExpedientesView.class);
	/** Message source for i18n lookups */
	@Autowired
	private MessageSource messageSource;

	/**
	 * 
	 * @return MessageSource
	 */
	public MessageSource getMessageSource() {
		return messageSource;
	}

	/**
	 * 
	 * @param messageSource
	 *            MessageSource
	 */
	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	/**
	 * 
	 */
	public ExcelAa21bTramitacionExpedientesView() {

	}

	/**
	 * 
	 * @param msgSource
	 *            MessageSource
	 */
	public ExcelAa21bTramitacionExpedientesView(MessageSource msgSource) {
		this.messageSource = msgSource;

	}

	/**
	 * Calcula las celdas tipo fórmula para que se muestren los resultados
	 * correctamente
	 * 
	 * @param wb
	 *            HSSFWorkbook
	 */
	public void evaluateAllFormulaCells(HSSFWorkbook wb) {
		HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(wb);
		Iterator rit;
		Iterator cit;
		for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
			HSSFSheet sheet = wb.getSheetAt(i);

			for (rit = sheet.rowIterator(); rit.hasNext();) {
				Row r = (Row) rit.next();

				for (cit = r.cellIterator(); cit.hasNext();) {
					Cell c = (Cell) cit.next();
					if (c.getCellType() == 2)
						try {
							evaluator.evaluateFormulaCell(c);
						} catch (Exception e) {
						}
				}
			}
		}
	}

	Map<String, HSSFCellStyle> estilos;

	/**
	 * Obtener el nombre de fichero que corresponde al año y el idioma
	 * 
	 * @param anio
	 *            int
	 * @param file
	 *            String
	 * @param idioma
	 *            String
	 * @return String
	 */
	public String obtenerNombreFichero(String file, String idioma) {
		String res = "";
		File folder = new File(Aa21bConstantes.DATOSDIR);
		ExcelAa21bTramitacionExpedientesView.logger
				.info("Obteniendo plantilla correspondiente");
		FiltroNombre fil = new FiltroNombre(file, idioma);
		File[] listOfFiles = folder.listFiles(fil);
		File f = null;

		// String dname = "";
		Arrays.sort(listOfFiles);
		for (int i = 0; i < listOfFiles.length; i++) {
			f = listOfFiles[i];
			// dname = f.getName();
			// dname = f.getName().substring(file.length(), file.length() + 4);
			// fileanio = Integer.parseInt(dname);
			if (i == 0) {
				res = f.getName();
				// break;
			}
		}
		if (res.equals(""))
			res = f.getName();
		return res.substring(0, res.length() - 4);
	}

	/**
	 * Establece la plantilla antes de que comenzar la creación del excel
	 * 
	 * @param model
	 *            Map<String, ?>
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	public void render(Map<String, ?> model, HttpServletRequest request,
			HttpServletResponse response) {
		Locale locale = RequestContextUtils.getLocale(request);
		String file = Aa21bConstantes.EXCELTRAMITACIONEXPEDIENTES;
		String idioma = "ES";
		if (!locale.getDisplayLanguage().contains("es")
				&& !locale.getDisplayLanguage().contains("Spanish"))
			idioma = "EU";
		ExcelAa21bTramitacionExpedientesView.logger.info("buscando plantilla->"
				+ locale.getDisplayLanguage());
		String ff = file.substring(Aa21bConstantes.DATOSDIR.length() + 5,
				file.length());
		String s = "file:" + Aa21bConstantes.DATOSDIR
				+ obtenerNombreFichero(ff, idioma);
		this.setUrl(s);
		try {
			super.render(model, request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Crea el excel
	 * 
	 * @param model
	 *            Map<String, Object>
	 * @param book
	 *            HSSFWorkbook
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse Exception Exception
	 * @throws Exception
	 *             Exception
	 */
	@Override
	protected void buildExcelDocument(Map<String, Object> model,
			HSSFWorkbook book, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		ExcelAa21bTramitacionExpedientesView.logger.info("Creando fichero");

		Locale locale = RequestContextUtils.getLocale(request);
		String idioma = "ES";
		if (!locale.getDisplayLanguage().contains("es")
				&& !locale.getDisplayLanguage().contains("Spanish"))
			idioma = "EU";
		// rellenamos las hojas dat(d)

		rellenarDAT(
				(List<Aa21b20s01Consultas>) model.get("listadoExpedientes"),
				(List<String>) model.get("listaFiltros"), book, idioma, locale);

		evaluateAllFormulaCells(book);
		ExcelAa21bTramitacionExpedientesView.logger.info("fin de fichero");
	}

	/**
	 * 
	 * @param datos
	 *            List<Aa21b15s01>
	 * @param book
	 *            HSSFWorkbook
	 */
	private void rellenarDAT(List<Aa21b20s01Consultas> datos,
			List<String> listaFiltros, HSSFWorkbook book, String idioma,
			Locale locale) {
		// TODO Auto-generated method stub
		HSSFSheet sheetal = book.getSheet("Tramitacion");
		Map<String, HSSFCellStyle> estilos = createStyles(book);

		if (datos != null) {
			Iterator<Aa21b20s01Consultas> iter = datos.iterator();
			Iterator<String> iterFiltros = listaFiltros.iterator();
			int row = 0;
			// create a cell object reference
			HSSFCell c = null;

			Aa21b20s01Consultas actual = new Aa21b20s01Consultas();

			String cservAnt = "";
			int contador = 0;
			while (iter.hasNext()) {
				actual = iter.next();
				contador++;

				if (actual.getCserv20() != null
						&& !cservAnt.equals(actual.getCserv20().toString())) {
					contador = 1;
					row = row + 4;

					// Filtros

					while (iterFiltros.hasNext()) {
						String filtro = iterFiltros.next();
						sheetal.createRow(row);
						CellRangeAddress range = new CellRangeAddress(row, row,
								2, 8);
						sheetal.addMergedRegion(range);
						c = getCell(sheetal, row, 2);
						c.setCellStyle(estilos.get("filtro"));
						setText(c, filtro);
						// setLine(sheetal, row, 2, filtro);
						row++;
					}

					// Servicio

					sheetal.createRow(row);
					CellRangeAddress range = new CellRangeAddress(row, row, 2,
							3);
					sheetal.addMergedRegion(range);
					c = getCell(sheetal, row, 2);
					c.setCellStyle(estilos.get("cabecera"));
					setText(c, messageSource.getMessage("tramitacion.servicio",
							null, locale));
					// setLine(sheetal, row, 2, "Servicio:");
					range = new CellRangeAddress(row, row, 4, 8);
					sheetal.addMergedRegion(range);
					c = getCell(sheetal, row, 4);
					c.setCellStyle(estilos.get("cabeceraDesc"));
					if (Aa21bConstantes.AA21B_IDIOMA_EUS
							.equalsIgnoreCase(locale.getLanguage())) {
						setText(c,
								actual.getCserv20() + " - "
										+ actual.getEserv20());
					} else {
						setText(c,
								actual.getCserv20() + " - "
										+ actual.getDserv20());
					}

					row++;
					sheetal.createRow(row);
					range = new CellRangeAddress(row, row, 1, 22);
					sheetal.addMergedRegion(range);
					for (int i = 1; i < 23; i++) {
						c = getCell(sheetal, row, i);
						c.setCellStyle(estilos.get("lineaCabecera"));
						setText(c, "");
					}

					row++;

				} else if (actual.getCserv20() == null && cservAnt != null) {
					contador = 1;
					row = row + 3; // Servicio
					sheetal.createRow(row);
					CellRangeAddress range = new CellRangeAddress(row, row, 2,
							3);
					sheetal.addMergedRegion(range);
					c = getCell(sheetal, row, 2);
					c.setCellStyle(estilos.get("cabecera"));
					setText(c, messageSource.getMessage(
							"tramitacion.sinservicio", null, locale));

					row++;
					sheetal.createRow(row);
					range = new CellRangeAddress(row, row, 1, 22);
					sheetal.addMergedRegion(range);
					c = getCell(sheetal, row, 22);
					c.setCellStyle(estilos.get("lineaCabecera"));
					setText(c, "");

					row++;

				}

				// Expediente
				sheetal.createRow(row);
				CellRangeAddress range = new CellRangeAddress(row, row, 1, 1);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 1);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, Integer.valueOf(contador).toString());

				range = new CellRangeAddress(row, row, 2, 3);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 2);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, actual.getRefExp());

				range = new CellRangeAddress(row, row, 4, 5);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 4);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.objeto", null,
						locale));

				range = new CellRangeAddress(row, row, 6, 20);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 6);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, actual.getObjeto20());

				row++;
				range = new CellRangeAddress(row, row, 4, 5);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 4);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.estado", null,
						locale));
				range = new CellRangeAddress(row, row, 6, 8);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 6);
				c.setCellStyle(estilos.get("detalle"));
				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					setText(c, actual.getEesta20());
				} else {
					setText(c, actual.getDesta20());
				}

				range = new CellRangeAddress(row, row, 9, 10);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 9);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.depar", null,
						locale));

				range = new CellRangeAddress(row, row, 11, 20);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 11);
				c.setCellStyle(estilos.get("detalle"));
				if (idioma.equals("ES")) {
					setText(c, actual.getDdepar20());
				} else {
					setText(c, actual.getEdepar20());
				}

				row++;
				range = new CellRangeAddress(row, row, 4, 5);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 4);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.faper", null,
						locale));

				String fechaApertura = "";
				String fechaCierre = "";
				try {
					SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
					SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

					if (Aa21bConstantes.AA21B_IDIOMA_EUS
							.equalsIgnoreCase(idioma)) {
						if (fechaApertura != null) {
							fechaApertura = sdf_eu.format(actual.getFaper20());
						}
						if (fechaCierre != null) {
							fechaCierre = sdf_eu.format(actual.getFcier20());
						}
					} else {
						if (fechaApertura != null) {
							fechaApertura = sdf.format(actual.getFaper20());
						}
						if (fechaCierre != null) {
							fechaCierre = sdf.format(actual.getFcier20());
						}
					}
				} catch (Exception e) {
					logger.error("getXml - Error formateando fecha de apertura y cierre : "
							+ e.toString());
				}

				range = new CellRangeAddress(row, row, 6, 8);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 6);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, fechaApertura);

				range = new CellRangeAddress(row, row, 9, 10);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 9);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.fcier", null,
						locale));

				range = new CellRangeAddress(row, row, 11, 20);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 11);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, fechaCierre);

				row++;

				range = new CellRangeAddress(row, row, 4, 5);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 4);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.observ", null,
						locale));

				range = new CellRangeAddress(row, row, 6, 20);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 6);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, actual.getObser20());

				row++;

				range = new CellRangeAddress(row, row, 4, 5);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 4);
				c.setCellStyle(estilos.get("cabeceraDetalle"));
				setText(c, messageSource.getMessage("listadoExp.respo", null,
						locale));

				range = new CellRangeAddress(row, row, 6, 20);
				sheetal.addMergedRegion(range);
				c = getCell(sheetal, row, 6);
				c.setCellStyle(estilos.get("detalle"));
				setText(c, actual.getDrespo20());

				cservAnt = actual.getCserv20().toString();
				row++;
			}
		}

	}

	/**
	 * Añade una línea con dos
	 * 
	 * @param sheet
	 *            HSSFSheet
	 * @param row
	 *            int
	 * @param col
	 *            int
	 * @param col1
	 *            String
	 */
	/*
	 * private void setLine(HSSFSheet sheet, int row, int col, String col1) {
	 * HSSFCell c = getCell(sheet, row, col);
	 * 
	 * c.setCellValue(col1);
	 * 
	 * }
	 */

	/**
	 * Method 'Map'
	 * 
	 * @param wb
	 *            HSSFWorkbook
	 * 
	 * @return Map<String, HSSFCellStyle>
	 */
	private static Map<String, HSSFCellStyle> createStyles(HSSFWorkbook wb) {
		Map<String, HSSFCellStyle> styles = new HashMap<String, HSSFCellStyle>();
		// // titulo principal
		HSSFDataFormat dfImporte = wb.createDataFormat();

		HSSFFont fontcabecera = wb.createFont();
		// cabecera tablas
		fontcabecera.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontcabecera.setColor(HSSFColor.BLACK.index);
		fontcabecera.setItalic(true);
		fontcabecera.setFontHeightInPoints((short) 12);
		HSSFCellStyle cabecera = wb.createCellStyle();
		cabecera.setFillForegroundColor(HSSFColor.WHITE.index);
		cabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cabecera.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		cabecera.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		cabecera.setFont(fontcabecera);
		cabecera.setWrapText(true);
		styles.put("cabecera", cabecera);

		HSSFFont fontcabeceraDetalle = wb.createFont();
		// cabecera tablas
		fontcabeceraDetalle.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontcabeceraDetalle.setColor(HSSFColor.BLACK.index);
		fontcabeceraDetalle.setItalic(true);
		fontcabeceraDetalle.setFontHeightInPoints((short) 12);
		HSSFCellStyle cabeceraDetalle = wb.createCellStyle();
		cabeceraDetalle.setFillForegroundColor(HSSFColor.WHITE.index);
		cabeceraDetalle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cabeceraDetalle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		cabeceraDetalle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		cabeceraDetalle.setFont(fontcabeceraDetalle);
		cabeceraDetalle.setWrapText(true);
		styles.put("cabeceraDetalle", cabeceraDetalle);

		HSSFFont fontcabeceraDesc = wb.createFont();
		// cabecera tablas
		fontcabeceraDesc.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
		fontcabeceraDesc.setColor(HSSFColor.BLACK.index);
		fontcabeceraDesc.setItalic(true);
		fontcabeceraDesc.setFontHeightInPoints((short) 12);
		HSSFCellStyle cabeceraDesc = wb.createCellStyle();
		cabeceraDesc.setFillForegroundColor(HSSFColor.WHITE.index);
		cabeceraDesc.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cabeceraDesc.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		cabeceraDesc.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		cabeceraDesc.setFont(fontcabeceraDesc);
		cabeceraDesc.setWrapText(true);
		styles.put("cabeceraDesc", cabeceraDesc);

		HSSFFont lineaCabeFont = wb.createFont();
		// cabecera tablas
		lineaCabeFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		lineaCabeFont.setColor(HSSFColor.BLACK.index);
		lineaCabeFont.setFontHeightInPoints((short) 8);
		HSSFCellStyle lineaCabe = wb.createCellStyle();
		lineaCabe.setBorderTop(HSSFCellStyle.BORDER_MEDIUM);
		lineaCabe.setTopBorderColor(HSSFColor.BLACK.index);
		lineaCabe.setBorderRight(HSSFCellStyle.BORDER_NONE);
		lineaCabe.setBorderLeft(HSSFCellStyle.BORDER_NONE);
		lineaCabe.setBorderBottom(HSSFCellStyle.BORDER_NONE);
		lineaCabe.setFont(lineaCabeFont);

		styles.put("lineaCabecera", lineaCabe);

		HSSFFont fontFiltro = wb.createFont();
		// cabecera tablas
		fontFiltro.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontFiltro.setColor(HSSFColor.BLACK.index);
		fontFiltro.setFontHeightInPoints((short) 12);
		HSSFCellStyle filtro = wb.createCellStyle();
		filtro.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		filtro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		filtro.setFont(fontFiltro);
		filtro.setWrapText(true);
		styles.put("filtro", filtro);

		HSSFFont fontDetalle = wb.createFont();
		// cabecera tablas
		fontDetalle.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
		fontDetalle.setColor(HSSFColor.BLACK.index);
		fontDetalle.setFontHeightInPoints((short) 12);
		HSSFCellStyle detalle = wb.createCellStyle();
		detalle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		detalle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		detalle.setFont(fontDetalle);
		detalle.setWrapText(true);
		styles.put("detalle", detalle);

		HSSFFont fontFiltroDesc = wb.createFont();
		// cabecera tablas
		fontFiltroDesc.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
		fontFiltroDesc.setColor(HSSFColor.BLACK.index);
		fontFiltroDesc.setItalic(true);
		fontFiltroDesc.setFontHeightInPoints((short) 12);
		HSSFCellStyle filtroDesc = wb.createCellStyle();
		filtroDesc.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		filtroDesc.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);

		filtroDesc.setFont(fontFiltroDesc);
		filtroDesc.setWrapText(true);
		styles.put("filtroDesc", filtro);

		HSSFCellStyle propdat = wb.createCellStyle();
		propdat.cloneStyleFrom(cabecera);
		propdat.setBorderRight(HSSFCellStyle.BORDER_THIN);
		propdat.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		propdat.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderTop(HSSFCellStyle.BORDER_THIN);
		propdat.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		propdat.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		styles.put("cabecera2", propdat);
		HSSFFont fontter = wb.createFont();
		// cabecera tablas
		fontter.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontter.setColor(HSSFColor.WHITE.index);
		fontter.setFontHeightInPoints((short) 10);
		//
		// // datos
		HSSFFont fontdatos = wb.createFont();
		fontdatos.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
		fontdatos.setColor(HSSFColor.BLACK.index);
		fontdatos.setFontHeightInPoints((short) 8);
		fontdatos.setFontName("Times New Roman");
		HSSFCellStyle datos = wb.createCellStyle();
		datos.setFillForegroundColor(HSSFColor.WHITE.index);
		datos.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		datos.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		datos.setFont(fontdatos);
		datos.setWrapText(true);
		datos.setBorderRight(HSSFCellStyle.BORDER_THIN);
		datos.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		datos.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderTop(HSSFCellStyle.BORDER_THIN);
		datos.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		datos.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setDataFormat(dfImporte.getFormat("#,##0"));
		styles.put("datos", datos);
		//
		HSSFCellStyle suma = wb.createCellStyle();
		suma.cloneStyleFrom(datos);
		suma.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		suma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
		suma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		styles.put("datossuma", suma);

		HSSFCellStyle porcentaje = wb.createCellStyle();
		porcentaje.cloneStyleFrom(datos);
		porcentaje.setDataFormat(dfImporte.getFormat("#,##0.0"));
		styles.put("datosporcentaje", porcentaje);
		//
		HSSFCellStyle porcentajesuma = wb.createCellStyle();
		porcentajesuma.cloneStyleFrom(porcentaje);
		porcentajesuma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
		porcentajesuma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		styles.put("datosporcentajesuma", porcentajesuma);
		//
		// // Años y meses (negrita y centrado)
		HSSFFont font = wb.createFont();
		font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		font.setColor(HSSFColor.BLACK.index);
		font.setFontHeightInPoints((short) 8);
		font.setFontName("Times New Roman");
		HSSFCellStyle bold = wb.createCellStyle();
		bold.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		bold.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		bold.setFont(font);
		//
		styles.put("negrita", bold);
		//
		HSSFCellStyle boldcoma1lima = wb.createCellStyle();
		boldcoma1lima.cloneStyleFrom(datos);
		boldcoma1lima.setDataFormat(dfImporte.getFormat("#,##0"));
		boldcoma1lima.setFillForegroundColor(HSSFColor.LIME.index);
		boldcoma1lima.setFont(font);
		styles.put("formatlima", boldcoma1lima);
		//
		HSSFCellStyle boldcoma1 = wb.createCellStyle();
		boldcoma1.cloneStyleFrom(bold);
		boldcoma1.setDataFormat(dfImporte.getFormat("#,##0"));
		styles.put("negritaformat", boldcoma1);
		//
		HSSFCellStyle boldcoma = wb.createCellStyle();
		boldcoma.cloneStyleFrom(bold);
		boldcoma.setDataFormat(dfImporte.getFormat("#,##0.0"));
		styles.put("negritacoma", boldcoma);
		//
		HSSFCellStyle boldcomalima = wb.createCellStyle();
		boldcomalima.cloneStyleFrom(datos);
		boldcomalima.setDataFormat(dfImporte.getFormat("#,##0.0"));
		boldcomalima.setFillForegroundColor(HSSFColor.LIME.index);
		boldcomalima.setFont(font);
		styles.put("comalima", boldcomalima);
		//
		HSSFCellStyle hiddenstyle = wb.createCellStyle();
		hiddenstyle.setHidden(true);
		styles.put("oculta", bold);
		return styles;
	}

}
