package com.ejie.aa21b.view;

import java.io.File;

import java.util.Arrays;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.aa21b.util.Aa21bConstantes;

/**
 * Crea el excel de mantenimiento general de Tipos de documentos
 * 
 *  
 * 
 */
public class ExcelAa21b05s01View extends AbstractExcelView {
	private static final Logger logger = LoggerFactory
			.getLogger(ExcelAa21b05s01View.class);
	/** Message source for i18n lookups */
	@Autowired
	private MessageSource messageSource;

	/**
	 * 
	 * @return MessageSource
	 */
	public MessageSource getMessageSource() {
		return messageSource;
	}

	/**
	 * 
	 * @param messageSource
	 *            MessageSource
	 */
	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	/**
	 * 
	 */
	public ExcelAa21b05s01View() {

	}

	/**
	 * 
	 * @param msgSource
	 *            MessageSource
	 */
	public ExcelAa21b05s01View(MessageSource msgSource) {
		this.messageSource = msgSource;

	}

	/**
	 * Calcula las celdas tipo fórmula para que se muestren los resultados
	 * correctamente
	 * 
	 * @param wb
	 *            HSSFWorkbook
	 */
	public void evaluateAllFormulaCells(HSSFWorkbook wb) {
		HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(wb);
		Iterator rit;
		Iterator cit;
		for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
			HSSFSheet sheet = wb.getSheetAt(i);

			for (rit = sheet.rowIterator(); rit.hasNext();) {
				Row r = (Row) rit.next();

				for (cit = r.cellIterator(); cit.hasNext();) {
					Cell c = (Cell) cit.next();
					if (c.getCellType() == 2)
						try {
							evaluator.evaluateFormulaCell(c);
						} catch (Exception e) {
						}
				}
			}
		}
	}

	Map<String, HSSFCellStyle> estilos;

	/**
	 * Obtener el nombre de fichero que corresponde al año y el idioma
	 * 
	 * @param anio
	 *            int
	 * @param file
	 *            String
	 * @param idioma
	 *            String
	 * @return String
	 */
	public String obtenerNombreFichero(String file, String idioma) {
		String res = "";
		File folder = new File(Aa21bConstantes.DATOSDIR);
		ExcelAa21b05s01View.logger.info("Obteniendo plantilla correspondiente");
		FiltroNombre fil = new FiltroNombre(file, idioma);
		File[] listOfFiles = folder.listFiles(fil);
		File f = null;

		// String dname = "";
		Arrays.sort(listOfFiles);
		for (int i = 0; i < listOfFiles.length; i++) {
			f = listOfFiles[i];
			// dname = f.getName();
			// dname = f.getName().substring(file.length(), file.length() + 4);
			// fileanio = Integer.parseInt(dname);
			if (i == 0) {
				res = f.getName();
				// break;
			}
		}
		if (res.equals(""))
			res = f.getName();
		return res.substring(0, res.length() - 4);
	}

	/**
	 * Establece la plantilla antes de que comenzar la creación del excel
	 * 
	 * @param model
	 *            Map<String, ?>
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	public void render(Map<String, ?> model, HttpServletRequest request,
			HttpServletResponse response) {
		Locale locale = RequestContextUtils.getLocale(request);
		String file = Aa21bConstantes.EXCELTIPOSDOCUMENTOS;
		String idioma = "ES";
		if (!locale.getDisplayLanguage().contains("es")
				&& !locale.getDisplayLanguage().contains("Spanish"))
			idioma = "EU";
		ExcelAa21b05s01View.logger.info("buscando plantilla->"
				+ locale.getDisplayLanguage());
		String ff = file.substring(Aa21bConstantes.DATOSDIR.length() + 5,
				file.length());
		String s = "file:" + Aa21bConstantes.DATOSDIR
				+ obtenerNombreFichero(ff, idioma);
		this.setUrl(s);
		try {
			super.render(model, request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Crea el excel
	 * 
	 * @param model
	 *            Map<String, Object>
	 * @param book
	 *            HSSFWorkbook
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse Exception Exception
	 * @throws Exception
	 *             Exception
	 */
	@Override
	protected void buildExcelDocument(Map<String, Object> model,
			HSSFWorkbook book, HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		ExcelAa21b05s01View.logger.info("Creando fichero");
		// rellenamos las hojas dat(d)

		Locale locale = RequestContextUtils.getLocale(request);
		String idioma = "ES";
		if (!locale.getDisplayLanguage().contains("es")
				&& !locale.getDisplayLanguage().contains("Spanish"))
			idioma = "EU";
		rellenarDAT((List<Aa21b05s01>) model.get("tiposDocumentos"), book,
				idioma);

		evaluateAllFormulaCells(book);
		ExcelAa21b05s01View.logger.info("fin de fichero");
	}

	/**
	 * 
	 * @param datos
	 *            List<Aa21b05s01>
	 * @param book
	 *            HSSFWorkbook
	 */
	private void rellenarDAT(List<Aa21b05s01> datos, HSSFWorkbook book,
			String idioma) {
		// TODO Auto-generated method stub
		HSSFSheet sheetal = book.getSheet("Tiposdocumentos");

		if (datos != null) {
			Iterator<Aa21b05s01> iter = datos.iterator();
			int row = 7;

			Aa21b05s01 actual = new Aa21b05s01();

			while (iter.hasNext()) {
				actual = iter.next();

				setLine(sheetal, row, 1, actual.getDdocu05());
				setLine(sheetal, row, 7, actual.getEdocu05());
				if (actual.getSitu05() != null
						&& actual.getSitu05().equals("A")) {
					if (idioma.equals("ES")) {
						setLine(sheetal, row, 13, "Alta");
					} else {
						setLine(sheetal, row, 13, "Alta");
					}
				} else if (actual.getSitu05() != null
						&& actual.getSitu05().equals("B")) {
					if (idioma.equals("ES")) {
						setLine(sheetal, row, 13, "Baja");
					} else {
						setLine(sheetal, row, 13, "Baja");
					}
				}

				row++;
			}
		}

	}

	/**
	 * Relena los las hojas de datos ocultas Álava,Bizkaia, Gipuzkoa
	 * 
	 * @param datos
	 * @param presupuestos
	 * @param anio
	 * @param book
	 */
	/*
	 * public void rellenarDAT(List<ProviciasValores> datos,
	 * List<ProviciasValoresMensuales> presupuestos, int anio, HSSFWorkbook
	 * book) { HSSFSheet sheetal = book.getSheet("\u00c1lava(d)"); HSSFSheet
	 * sheetbiz = book.getSheet("Bizkaia(d)"); HSSFSheet sheetgip =
	 * book.getSheet("Gipuzkoa(d)"); Iterator<ProviciasValores> iter =
	 * datos.iterator(); HSSFCell c = getCell(sheetal, 3, 7);
	 * c.setCellValue(anio); int row = 0;
	 * 
	 * ProviciasValores actual;
	 * 
	 * // Primera tabla en las 3 hojas while (iter.hasNext()) { actual =
	 * iter.next();
	 * 
	 * setLine(sheetal, row, 0, actual.getEstructura(), actual.getAraba());
	 * setLine(sheetbiz, row, 0, actual.getEstructura(), actual.getBizkaia());
	 * setLine(sheetgip, row, 0, actual.getEstructura(), actual.getGipuzkoa());
	 * row++;
	 * 
	 * } Iterator<ProviciasValoresMensuales> presu = presupuestos.iterator();
	 * ProviciasValoresMensuales actual2; row = 0; while (presu.hasNext()) {
	 * actual2 = presu.next();
	 * 
	 * setLine(sheetal, row, 3, actual2.getEstructura(), actual2.getAraba(),
	 * actual2.getAraba2()); setLine(sheetbiz, row, 3, actual2.getEstructura(),
	 * actual2.getBizkaia(), actual2.getBizkaia2()); setLine(sheetgip, row, 3,
	 * actual2.getEstructura(), actual2.getGipuzkoa(), actual2.getGipuzkoa2());
	 * 
	 * row++;
	 * 
	 * } }
	 */

	/**
	 * Añade una línea con dos
	 * 
	 * @param sheet
	 *            HSSFSheet
	 * @param row
	 *            int
	 * @param col
	 *            int
	 * @param col1
	 *            String
	 */
	private void setLine(HSSFSheet sheet, int row, int col, String col1) {
		HSSFCell c = getCell(sheet, row, col);
		c.setCellValue(col1);
	}

	/*
	 * private void setLine(HSSFSheet sheet, int row, int col, String col1,
	 * BigDecimal col2, BigDecimal col3) { HSSFCell c = getCell(sheet, row,
	 * col); c.setCellValue(col1); c = getCell(sheet, row, col + 1);
	 * c.setCellValue(col2.doubleValue()); c = getCell(sheet, row, col + 2);
	 * c.setCellValue(col3.doubleValue()); }
	 */

	/**
	 * Method 'Map'
	 * 
	 * @param wb
	 *            HSSFWorkbook
	 * 
	 * @return Map<String, HSSFCellStyle>
	 */
	// private static Map<String, HSSFCellStyle> createStyles(HSSFWorkbook wb) {
	// Map<String, HSSFCellStyle> styles = new HashMap<String, HSSFCellStyle>();
	// // titulo principal
	// HSSFDataFormat dfImporte = wb.createDataFormat();
	//
	// HSSFFont fontcabecera = wb.createFont();
	// // cabecera tablas
	// fontcabecera.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// fontcabecera.setColor(HSSFColor.BLACK.index);
	// fontcabecera.setFontHeightInPoints((short) 8);
	// HSSFCellStyle cabecera = wb.createCellStyle();
	// cabecera.setFillForegroundColor(HSSFColor.WHITE.index);
	// cabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// cabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// cabecera.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	// cabecera.setBorderRight(HSSFCellStyle.BORDER_THIN);
	// cabecera.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// cabecera.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	// cabecera.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// cabecera.setBorderTop(HSSFCellStyle.BORDER_THIN);
	// cabecera.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// cabecera.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// cabecera.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
	//
	// cabecera.setFont(fontcabecera);
	// cabecera.setWrapText(true);
	// styles.put("cabecera", cabecera);
	//
	// HSSFCellStyle propdat = wb.createCellStyle();
	// propdat.cloneStyleFrom(cabecera);
	// propdat.setBorderRight(HSSFCellStyle.BORDER_THIN);
	// propdat.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// propdat.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	// propdat.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// propdat.setBorderTop(HSSFCellStyle.BORDER_THIN);
	// propdat.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// propdat.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// propdat.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// propdat.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	// styles.put("cabecera2", propdat);
	// HSSFFont fontter = wb.createFont();
	// // cabecera tablas
	// fontter.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// fontter.setColor(HSSFColor.WHITE.index);
	// fontter.setFontHeightInPoints((short) 10);
	//
	// // datos
	// HSSFFont fontdatos = wb.createFont();
	// fontdatos.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
	// fontdatos.setColor(HSSFColor.BLACK.index);
	// fontdatos.setFontHeightInPoints((short) 8);
	// fontdatos.setFontName("Times New Roman");
	// HSSFCellStyle datos = wb.createCellStyle();
	// datos.setFillForegroundColor(HSSFColor.WHITE.index);
	// datos.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// datos.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
	// datos.setFont(fontdatos);
	// datos.setWrapText(true);
	// datos.setBorderRight(HSSFCellStyle.BORDER_THIN);
	// datos.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// datos.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	// datos.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// datos.setBorderTop(HSSFCellStyle.BORDER_THIN);
	// datos.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// datos.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	// datos.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
	// datos.setDataFormat(dfImporte.getFormat("#,##0"));
	// styles.put("datos", datos);
	//
	// HSSFCellStyle suma = wb.createCellStyle();
	// suma.cloneStyleFrom(datos);
	// suma.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
	// suma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
	// suma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	// styles.put("datossuma", suma);
	//
	// HSSFCellStyle porcentaje = wb.createCellStyle();
	// porcentaje.cloneStyleFrom(datos);
	// porcentaje.setDataFormat(dfImporte.getFormat("#,##0.0"));
	// styles.put("datosporcentaje", porcentaje);
	//
	// HSSFCellStyle porcentajesuma = wb.createCellStyle();
	// porcentajesuma.cloneStyleFrom(porcentaje);
	// porcentajesuma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
	// porcentajesuma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	// styles.put("datosporcentajesuma", porcentajesuma);
	//
	// // Años y meses (negrita y centrado)
	// HSSFFont font = wb.createFont();
	// font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	// font.setColor(HSSFColor.BLACK.index);
	// font.setFontHeightInPoints((short) 8);
	// font.setFontName("Times New Roman");
	// HSSFCellStyle bold = wb.createCellStyle();
	// bold.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	// bold.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	// bold.setFont(font);
	//
	// styles.put("negrita", bold);
	//
	// HSSFCellStyle boldcoma1lima = wb.createCellStyle();
	// boldcoma1lima.cloneStyleFrom(datos);
	// boldcoma1lima.setDataFormat(dfImporte.getFormat("#,##0"));
	// boldcoma1lima.setFillForegroundColor(HSSFColor.LIME.index);
	// boldcoma1lima.setFont(font);
	// styles.put("formatlima", boldcoma1lima);
	//
	// HSSFCellStyle boldcoma1 = wb.createCellStyle();
	// boldcoma1.cloneStyleFrom(bold);
	// boldcoma1.setDataFormat(dfImporte.getFormat("#,##0"));
	// styles.put("negritaformat", boldcoma1);
	//
	// HSSFCellStyle boldcoma = wb.createCellStyle();
	// boldcoma.cloneStyleFrom(bold);
	// boldcoma.setDataFormat(dfImporte.getFormat("#,##0.0"));
	// styles.put("negritacoma", boldcoma);
	//
	// HSSFCellStyle boldcomalima = wb.createCellStyle();
	// boldcomalima.cloneStyleFrom(datos);
	// boldcomalima.setDataFormat(dfImporte.getFormat("#,##0.0"));
	// boldcomalima.setFillForegroundColor(HSSFColor.LIME.index);
	// boldcomalima.setFont(font);
	// styles.put("comalima", boldcomalima);
	//
	// HSSFCellStyle hiddenstyle = wb.createCellStyle();
	// hiddenstyle.setHidden(true);
	// styles.put("oculta", bold);
	// return styles;
	// }
}
