package com.ejie.aa21b.control;

import java.util.ArrayList;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.ldap.Aa21bPersonaXLNET;
import com.ejie.aa21b.ldap.SecurityHelpperException;
import com.ejie.aa21b.ldap.SecurityHelpperXLNets;

//import com.ejie.aa21b.ldap.SecurityHelpperXLNets;

/**
 * 
 *  
 * 
 */
@Controller
@RequestMapping(value = "/xlnets")
public class XlnetsController {

	/**
	 * 
	 * @param nombreFiltro
	 *            String
	 * @param apellidosFiltro
	 *            String
	 * @param dniFiltro
	 *            String
	 * @param model
	 *            Model
	 * @return ArrayList<Aa21bPersonaXLNET>
	 * @throws SecurityHelpperException
	 *             Exception
	 */
	@RequestMapping(value = "/personas", method = RequestMethod.GET)
	public @ResponseBody
	ArrayList<Aa21bPersonaXLNET> getPersonas(@RequestParam String nombreFiltro,
			@RequestParam String apellidosFiltro,
			@RequestParam String dniFiltro, Model model)
			throws SecurityHelpperException {
		ArrayList<Aa21bPersonaXLNET> personas;

		SecurityHelpperXLNets xlnets = new SecurityHelpperXLNets();
		personas = xlnets.getPersonasXLNETs("", dniFiltro, nombreFiltro,
				apellidosFiltro, "");

		return personas;

	}

}