package com.ejie.aa21b.control;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;

public class UserInterceptor extends HandlerInterceptorAdapter {
	private static final Logger logger = LoggerFactory
			.getLogger(UserInterceptor.class);

	public boolean preHandle(HttpServletRequest request,
			HttpServletResponse response, Object handler) throws Exception {

		String urlHacia = request.getRequestURL().toString();
		boolean resultado = true;
		if (urlHacia.contains("/maint")) {
			Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
			if (ps.getServicio() == null
					&& !(ps.isEsDeDireccion() || ps.isEsConsultador())) {
				resultado = false;
				response.sendRedirect("/aa21bOrgDocumentalWar/sinServicio");
				logger.info("El usuario no tiene servicio y no es de direccion no consultador. Codigo="
						+ ps.getPersonaXLNET().getCodigo());
			}
		}
		return resultado;
	}
	//
	// @Override
	// public void postHandle(HttpServletRequest request,
	// HttpServletResponse response, Object handler,
	// ModelAndView modelAndView) throws Exception {
	//
	// // we can add attributes in the modelAndView and use that in the view
	// // page
	// String urlHacia = request.getRequestURL().toString();
	// this.logger.info("MI URL=" + urlHacia);
	// if (urlHacia.contains("/maint")) {
	// if (new Aa21bSeguridad().getUsuario().getServicio() == null)
	// modelAndView.setViewName("usuarioSinServicio");
	// }
	// }
}
