package com.ejie.aa21b.control;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.model.Aa21b23s01;
import com.ejie.aa21b.service.ProcesoPidService;

/**
 * ProcesoPIDController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/procesoPID")
public class ProcesoPIDController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProcesoPIDController.class);

	@Autowired
	private ProcesoPidService servicio;

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ProcesoPIDController.logger.info("[GET - View] : main");
		model.addAttribute("listado", servicio.obtenerLista());
		return "procesoPID";
	}

	@RequestMapping(value = "/procesar/{idFaseExp}", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b23s01 procesar(@PathVariable int idFaseExp) {
		ProcesoPIDController.logger.info("[GET - View] : main");
		/*
		 * Aa21b23s01 res = new Aa21b23s01();
		 * 
		 * res = servicio.eliminarDocumento(idFaseExp);
		 */

		Aa21b23s01 res = servicio.obtenerDocumento(idFaseExp);
		res = servicio.guardarCodPid(res);

		return res;
	}

}