package com.ejie.aa21b.control;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.service.NoraAutonomiaService;
import com.ejie.aa21b.service.NoraMunicipioService;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;

@Controller
@RequestMapping(value = "/nora")
public class NoraController {

	@Autowired
	private NoraPaisService paisService;

	@Autowired
	private NoraProvinciaService provinciaService;

	@Autowired
	private NoraAutonomiaService autonomiaService;

	@Autowired
	private NoraMunicipioService municipioService;

	/**
	 * 
	 * @return List<NoraPais>
	 */
	@RequestMapping(value = "pais", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraPais> getPaises() {
		return this.paisService.findAll(null, null);

	}

	/**
	 * 
	 * @return List<NoraAutonomia>
	 */
	@RequestMapping(value = "autonomia", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraAutonomia> getAutonomias() {
		return this.autonomiaService.findAll(null, null);
	}

	/*
	 * @RequestMapping(value = "provincia", method = RequestMethod.GET) public
	 * 
	 * @ResponseBody List<NoraProvincia> getProvincias(
	 * 
	 * @RequestParam(value = "autonomia.id", required = false) String
	 * autonomiaId) {
	 * 
	 * NoraProvincia filtroProvincia = new NoraProvincia(); NoraAutonomia
	 * filtroAutonomia = new NoraAutonomia();
	 * filtroAutonomia.setId(autonomiaId);
	 * filtroProvincia.setAutonomia(filtroAutonomia);
	 * 
	 * List<NoraProvincia> findAll = provinciaService.findAll(filtroProvincia,
	 * null); return findAll; }
	 */

	/**
	 * 
	 * @return List<NoraProvincia>
	 */
	@RequestMapping(value = "provincia", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraProvincia> getProvincias() {

		return this.provinciaService.findAll(null, null);
	}

	/**
	 * 
	 * @param provinciaId
	 *            String
	 * @return List<NoraMunicipio>
	 */
	@RequestMapping(value = "municipio", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraMunicipio> getMunicipios(
			@RequestParam(value = "provincias.id", required = false) String provinciaId) {

		NoraMunicipio filterMunicipio = new NoraMunicipio();
		filterMunicipio.setProvinciaId(provinciaId);
		return this.municipioService.findAll(filterMunicipio, null);

	}

	/**
	 * 
	 * @param provinciaId
	 *            String
	 * @return List<NoraMunicipio>
	 */
	@RequestMapping(value = "municipioExp", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraMunicipio> getMunicipiosExp(
			@RequestParam(value = "cprov20", required = false) String provinciaId) {

		NoraMunicipio filterMunicipio = new NoraMunicipio();
		filterMunicipio.setProvinciaId(provinciaId);
		return this.municipioService.findAll(filterMunicipio, null);

	}

	@RequestMapping(value = "municipioExpAutocomplete", method = RequestMethod.GET)
	public @ResponseBody
	List<NoraMunicipio> getMunicipiosExpAutocomplete(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "cprov20", required = false) String provinciaId) {

		NoraMunicipio filterMunicipio = new NoraMunicipio();
		filterMunicipio.setDsO(q);
		if (provinciaId != null && !"".equals(provinciaId)) {
			filterMunicipio.setProvinciaId(provinciaId);
		}
		List<NoraMunicipio> findAll = municipioService.findAllLike(
				filterMunicipio, null, !c);
		return findAll;
	}

}
