// @formatter:off
package com.ejie.aa21b.control;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21bServiciosTiposFases;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21bServiciosTiposFasesService;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Aa21b05s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21bServiciosTiposFases")
public class Aa21bServiciosTiposFasesExpedientesController {

	private static final Logger logger = LoggerFactory.getLogger(Aa21bServiciosTiposFasesExpedientesController.class);

	@Autowired
	private Aa21bServiciosTiposFasesService aa21bServiciosTiposFasesService;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21bServiciosTiposFasesExpedientesController.logger.info("[GET - View] : Servicios Tipos y Fases Expedientes");
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		Aa21b13s01 aa21b13s01 = new Aa21b13s01();
		aa21b13s01.setCServ13(ps.getServicio());
		model.addAttribute("servicio", ps.getServicio());

		Aa21b02s01 filtroTipos = new Aa21b02s01();
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes", this.aa21b02s01Service.findAll(filtroTipos, null));

		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes", this.aa21b07s01Service.findAll(null, null));

		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones", this.aa21b14s01Service.findAll(null, null));

		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos", this.aa21b12s01Service.findAll(null, null));
		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(null, null);
		model.addAttribute("provincias", provincias);

		return "aa21bServiciosTiposFasesExp";
	}

	/**
	 * Crear excel servicios, tipos fases expedientes
	 * 
	 * @param model Model
	 * @param filterServiciosTiposFases Aa21bServiciosTiposFases
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "excelServiciosTiposFases", method = RequestMethod.POST)
	public String informeExcelServiciosTiposFases(Model model, @ModelAttribute Aa21bServiciosTiposFases filterServiciosTiposFases, HttpServletRequest request) {
		Aa21bServiciosTiposFasesExpedientesController.logger.info("Creando informe Excel Usuarios");
		String view = "";
		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (request.getParameter("icserv13") != null
				&& !request.getParameter("icserv13").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv13").equals("null")) {
			String[] arrayServicios = request.getParameter("icserv13").split(",");
			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD
				servicio.setCServ13(arrayServicios[x]);
				listaServicios.add(servicio);
			}
		}
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		vacio = "";
		if (request.getParameter("ictipoe02") != null
				&& !request.getParameter("ictipoe02").equals(vacio)
				// NULL como string...
				&& !request.getParameter("ictipoe02").equals("null")) {
			String[] arrayTiposExpedientes = request.getParameter("ictipoe02").split(",");
			Aa21b02s01 tipoExp = null;
			for (int x = 0; x < arrayTiposExpedientes.length; x++) {
				tipoExp = new Aa21b02s01();// NOPMD
				tipoExp.setCtipoe02(arrayTiposExpedientes[x]);
				listaTiposExpedientes.add(tipoExp);
			}
		}

		// Parametros formulario filtrado responsables
		if (request.getParameter("idserv13") != null && !request.getParameter("idserv13").equals("")) {
			filterServiciosTiposFases.setDServ13(request.getParameter("idserv13"));
		}

		if (request.getParameter("ieserv13") != null && !request.getParameter("ieserv13").equals("")) {
			filterServiciosTiposFases.setEServ13(request.getParameter("ieserv13"));
		}

		if (request.getParameter("isitu13") != null && !request.getParameter("isitu13").equals("")) {
			filterServiciosTiposFases.setSitu13(request.getParameter("isitu13"));
		}
		if (request.getParameter("ictrami02") != null && !request.getParameter("ictrami02").equals("")) {
			filterServiciosTiposFases.setCtrami02(request.getParameter("ictrami02"));
		}

		if (request.getParameter("idtipoe02") != null && !request.getParameter("idtipoe02").equals("")) {
			filterServiciosTiposFases.setDtipoe02(request.getParameter("idtipoe02"));
		}
		if (request.getParameter("ietipoe02") != null && !request.getParameter("ietipoe02").equals("")) {
			filterServiciosTiposFases.setEtipoe02(request.getParameter("ietipoe02"));
		}

		if (request.getParameter("isitu02") != null && !request.getParameter("isitu02").equals("")) {
			filterServiciosTiposFases.setSitu02(request.getParameter("isitu02"));
		}

		if (request.getParameter("icfase01") != null && !request.getParameter("icfase01").equals("")) {
			filterServiciosTiposFases.setCfase01(new Long(request.getParameter("icfase01")));
		}

		if (request.getParameter("idfase01") != null && !request.getParameter("idfase01").equals("")) {
			filterServiciosTiposFases.setDfase01(request.getParameter("idfase01"));
		}

		if (request.getParameter("icodPif01") != null && !request.getParameter("icodPif01").equals("")) {
			filterServiciosTiposFases.setCodPid01(request.getParameter("icodPif01"));
		}

		if (request.getParameter("itdocu01") != null && !request.getParameter("itdocu01").equals("")) {
			filterServiciosTiposFases.setTdocu01(request.getParameter("itdocu01"));
		}

		if (request.getParameter("iefase01") != null && !request.getParameter("iefase01").equals("")) {
			filterServiciosTiposFases.setEfase01(request.getParameter("iefase01"));
		}

		if (request.getParameter("isitu01") != null && !request.getParameter("isitu01").equals("")) {
			filterServiciosTiposFases.setSitu01(request.getParameter("isitu01"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv13");
		jqGridRequestDto.setSord("asc");

		model.addAttribute("serviciosTiposFases",
				aa21bServiciosTiposFasesService.findAll(filterServiciosTiposFases, jqGridRequestDto, listaServicios, listaTiposExpedientes));

		view = "reporteExcelServiciosTiposFases";
		return view;
	}
}