package com.ejie.aa21b.control;

import java.text.ParseException;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.aa21b.util.Aa21bConstantes;

/**
 * Aa21bDesbloqueosTablasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/modificacionEspecial")
public class Aa21bModificacionEspecialController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bModificacionEspecialController.class);

	@Autowired
	private Aa21b15s01Service aa21b15s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21bModificacionEspecialController.logger
				.info("[GET - View] : modificacionEspecial");

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		// String usuario = "VDIAZSAN";

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		// aa21b15s01busqUsuario.setUxlnet15(usuario);
		logger.info("Buscar el usuario en la tabla 15");

		// aa21b15s01busqUsuario = this.aa21b15s01Service
		// .findXLNET(aa21b15s01busqUsuario);
		Aa21b15s01 usuarioFiltro = new Aa21b15s01();
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		// usuarioFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		// filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		if (!ps.isEsDeDireccion()) {

			logger.info("El usuario no es direccion.");
			logger.info("El usuario está en la tabla de usuarios Servicio="
					+ aa21b15s01busqUsuario.getCserv15());

			usuarioFiltro.setCserv15(aa21b15s01busqUsuario.getCserv15());
			filtroTipos.setCserv02(aa21b15s01busqUsuario.getCserv15());

		}
		model.addAttribute("servicioLogueado",
				aa21b15s01busqUsuario.getCserv15());
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(filtroTipos, null));

		filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("tiposExpedientesAlta",
				this.aa21b02s01Service.findAll(filtroTipos, null));

		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		Aa21b07s01 estadosExpe = new Aa21b07s01();
		estadosExpe.setSitu07(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("estadosExpedientesAlta",
				this.aa21b07s01Service.findAll(estadosExpe, null));

		logger.info("Cargar usuarios en el modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(usuarioFiltro, null));
		usuarioFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("usuariosAlta",
				this.aa21b15s01Service.findAll(usuarioFiltro, null));
		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		Aa21b14s01 ubicacionesFilter = new Aa21b14s01();
		ubicacionesFilter.setSitu14(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("ubicacionesAlta",
				this.aa21b14s01Service.findAll(ubicacionesFilter, null));
		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		Aa21b12s01 departamentoFiltro = new Aa21b12s01();
		departamentoFiltro.setSitu12(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("departamentosAlta",
				this.aa21b12s01Service.findAll(departamentoFiltro, null));
		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		logger.info("Cargar vista");

		return "modificacionEspecial";
	}

	/**
	 * Method 'actualizarExpedienteEsp'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "/actualizarExpedienteEsp", method = RequestMethod.POST)
	public @ResponseBody
	String actualizarExpedienteEsp(@RequestBody Aa21b20s01 expediente,
			Locale locale) throws ParseException {
		Aa21bModificacionEspecialController.logger
				.info("Entra en actualizarExpediente");
		if (expediente.getRefExp() == null
				|| expediente.getRefExp().length() == 0)
			expediente.setRefExp(expediente.getReferenciaGrupo());
		this.aa21b20s01Service.updateModificacionEspecial(expediente);

		Aa21bModificacionEspecialController.logger
				.info("[POST] : Aa21b20s01 actualizado correctamente");

		return expediente.getRefExp();
	}

}