package com.ejie.aa21b.control;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.MimeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.model.Aa21b21s01;
import com.ejie.aa21b.model.Aa21b25s01;
import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.aa21b.model.Aa21b97s01;
import com.ejie.aa21b.model.Aa21bServiciosTiposFases;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.pdf.Aa21bPDF;
import com.ejie.aa21b.pdf.PdfInformeListado;
import com.ejie.aa21b.pdf.PdfInformeTramitacion;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b05s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b13s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.Aa21b21s01Service;
import com.ejie.aa21b.service.Aa21b25s01Service;
import com.ejie.aa21b.service.Aa21b29s01Service;
import com.ejie.aa21b.service.Aa21bDesbloqueosTablasService;
import com.ejie.aa21b.service.Aa21bServiciosTiposFasesService;
import com.ejie.aa21b.service.NoraMunicipioService;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bFormatoFecha;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Aa21bImprimirMantGeneralesController  
 * 11:23:11.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/imprimirMantGenerales")
public class Aa21bImprimirMantGeneralesController {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bImprimirMantGeneralesController.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b12s01Service departamentosService;

	@Autowired
	private Aa21b15s01Service usuariosService;

	@Autowired
	private Aa21b05s01Service tiposDocumentosService;

	@Autowired
	private Aa21b07s01Service estadosExpedientesService;

	@Autowired
	private Aa21b14s01Service ubicacionExpedientesService;

	@Autowired
	private Aa21bDesbloqueosTablasService desbloqueosTablasService;

	@Autowired
	private Aa21bServiciosTiposFasesService serviciosTiposFasesService;

	@Autowired
	private Aa21b20s01Service expedientesService;

	@Autowired
	private Aa21b21s01Service fasesExpService;

	@Autowired
	private Aa21b29s01Service respExpService;

	@Autowired
	private Aa21b25s01Service documentosExpService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraMunicipioService noraMunicipioService;

	@Autowired
	private Aa21b13s01Service aa21b13s01Service;

	/**
	 * 
	 * @param filterDepartamentos
	 *            Aa21b12s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirDepartamentos", method = RequestMethod.POST)
	public void imprimirDepartamentos(
			@ModelAttribute Aa21b12s01 filterDepartamentos,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosDepartamentos - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("icdepar12") != null
				&& !request.getParameter("icdepar12").equals("")) {
			filterDepartamentos.setCDepar12(new Long(request
					.getParameter("icdepar12")));
		}

		if (request.getParameter("iddepar12") != null
				&& !request.getParameter("iddepar12").equals("")) {
			filterDepartamentos.setDDepar12(request.getParameter("iddepar12"));
		}

		if (request.getParameter("iedepar12") != null
				&& !request.getParameter("iedepar12").equals("")) {
			filterDepartamentos.setEDepar12(request.getParameter("iedepar12"));
		}

		if (request.getParameter("isitu12") != null
				&& !request.getParameter("isitu12").equals("")) {
			filterDepartamentos.setSitu12(request.getParameter("isitu12"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cdepar12");
		jqGridRequestDto.setSord("asc");

		List<Aa21b12s01> aa21bDepartamentos = this.departamentosService
				.findAllLike(filterDepartamentos, jqGridRequestDto, false);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bDepartamentosPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bDepartamentos);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosDepartamentos - Fin");

	}

	/**
	 * 
	 * @param filterTiposDocumentos
	 *            Aa21b05s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirTiposDocumentos", method = RequestMethod.POST)
	public void imprimirTiposDocumentos(
			@ModelAttribute Aa21b05s01 filterTiposDocumentos,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosTiposDocumentos - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("icdocu05") != null
				&& !request.getParameter("icdocu05").equals("")) {
			filterTiposDocumentos.setCdocu05(new Integer(request
					.getParameter("icdocu05")));
		}

		if (request.getParameter("iddocu05") != null
				&& !request.getParameter("iddocu05").equals("")) {
			filterTiposDocumentos.setDdocu05(request.getParameter("iddocu05"));
		}

		if (request.getParameter("iedocu05") != null
				&& !request.getParameter("iedocu05").equals("")) {
			filterTiposDocumentos.setEdocu05(request.getParameter("iedocu05"));
		}

		if (request.getParameter("isitu05") != null
				&& !request.getParameter("isitu05").equals("")) {
			filterTiposDocumentos.setSitu05(request.getParameter("isitu05"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cdocu05");
		jqGridRequestDto.setSord("asc");

		List<Aa21b05s01> aa21bTiposDocumentos = this.tiposDocumentosService
				.findAllLike(filterTiposDocumentos, jqGridRequestDto, false);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bTiposDocumentosPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bTiposDocumentos);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosTiposDocumentos - Fin");

	}

	/**
	 * 
	 * @param filterEstadosExpedientes
	 *            Aa21b07s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirEstadosExpedientes", method = RequestMethod.POST)
	public void imprimirEstadosExpedientes(
			@ModelAttribute Aa21b07s01 filterEstadosExpedientes,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosTiposDocumentos - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("icesta07") != null
				&& !request.getParameter("icesta07").equals("")) {
			filterEstadosExpedientes.setCesta07(request
					.getParameter("icesta07"));
		}

		if (request.getParameter("idesta07") != null
				&& !request.getParameter("idesta07").equals("")) {
			filterEstadosExpedientes.setDesta07(request
					.getParameter("idesta07"));
		}

		if (request.getParameter("ieesta07") != null
				&& !request.getParameter("ieesta07").equals("")) {
			filterEstadosExpedientes.setEesta07(request
					.getParameter("ieesta07"));
		}

		if (request.getParameter("isitu07") != null
				&& !request.getParameter("isitu07").equals("")) {
			filterEstadosExpedientes.setSitu07(request.getParameter("isitu07"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cesta07");
		jqGridRequestDto.setSord("asc");

		List<Aa21b07s01> aa21bEstadosExpedientes = this.estadosExpedientesService
				.findAllLike(filterEstadosExpedientes, jqGridRequestDto, false);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bEstadosExpedientesPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bEstadosExpedientes);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosEstadosExpedientes - Fin");

	}

	/**
	 * 
	 * @param filterUbicacionExpedientes
	 *            Aa21b14s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirUbicacionExpedientes", method = RequestMethod.POST)
	public void imprimirUbicacionExpedientes(
			@ModelAttribute Aa21b14s01 filterUbicacionExpedientes,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosTiposDocumentos - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("icarchi14") != null
				&& !request.getParameter("icarchi14").equals("")) {
			filterUbicacionExpedientes.setCarchi14(request
					.getParameter("icarchi14"));
		}

		if (request.getParameter("idarchi14") != null
				&& !request.getParameter("idarchi14").equals("")) {
			filterUbicacionExpedientes.setDarchi14(request
					.getParameter("idarchi14"));
		}

		if (request.getParameter("iearchi14") != null
				&& !request.getParameter("iearchi14").equals("")) {
			filterUbicacionExpedientes.setEarchi14(request
					.getParameter("iearchi14"));
		}

		if (request.getParameter("isitu14") != null
				&& !request.getParameter("isitu14").equals("")) {
			filterUbicacionExpedientes.setSitu14(request
					.getParameter("isitu14"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("carchi14");
		jqGridRequestDto.setSord("asc");

		List<Aa21b14s01> aa21bUbicacionExpedientes = this.ubicacionExpedientesService
				.findAllLike(filterUbicacionExpedientes, jqGridRequestDto,
						false);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bUbicacionExpedientesPDF")
				.newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bUbicacionExpedientes);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosEstadosExpedientes - Fin");

	}

	/**
	 * 
	 * @param filterUsuarios
	 *            Aa21b15s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirUsuarios", method = RequestMethod.POST)
	public void imprimirUsuarios(@ModelAttribute Aa21b15s01 filterUsuarios,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosUsuarios - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("icusu15") != null
				&& !request.getParameter("icusu15").equals("")) {
			filterUsuarios.setCusu15(request.getParameter("icusu15"));
		}

		if (request.getParameter("idusu15") != null
				&& !request.getParameter("idusu15").equals("")) {
			filterUsuarios.setDusu15(request.getParameter("idusu15"));
		}

		if (request.getParameter("isitu15") != null
				&& !request.getParameter("isitu15").equals("")) {
			filterUsuarios.setSitu15(request.getParameter("isitu15"));
		}

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (request.getParameter("icserv15") != null
				&& !request.getParameter("icserv15").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv15").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv15").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);
			}

		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv15");
		jqGridRequestDto.setSord("asc");

		List<Aa21b15s01> aa21bUsuarios = this.usuariosService.findAllLike(
				filterUsuarios, jqGridRequestDto, listaServicios, false);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bUsuariosPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bUsuarios);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosDepartamentos - Fin");

	}

	/**
	 * 
	 * @param filterUsuarios
	 *            Aa21b15s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirServiciosTiposFases", method = RequestMethod.POST)
	public void imprimirServiciosTiposFases(
			@ModelAttribute Aa21bServiciosTiposFases filterAa21bServiciosTiposFases,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirServiciosTiposFases - Inicio");

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (request.getParameter("icserv13") != null
				&& !request.getParameter("icserv13").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv13").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv13").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);
			}

		}

		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		vacio = "";
		if (request.getParameter("ictipoe02") != null
				&& !request.getParameter("ictipoe02").equals(vacio)
				// NULL como string...
				&& !request.getParameter("ictipoe02").equals("null")) {

			String[] arrayTiposExpedientes = request.getParameter("ictipoe02")
					.split(",");

			Aa21b02s01 tipoExp = null;
			for (int x = 0; x < arrayTiposExpedientes.length; x++) {
				tipoExp = new Aa21b02s01();// NOPMD

				tipoExp.setCtipoe02(arrayTiposExpedientes[x]);

				listaTiposExpedientes.add(tipoExp);
			}

		}

		// Parametros formulario filtrado responsables
		if (request.getParameter("idserv13") != null
				&& !request.getParameter("idserv13").equals("")) {
			filterAa21bServiciosTiposFases.setDServ13(request
					.getParameter("idserv13"));
		}
		// Parametros formulario filtrado responsables
		if (request.getParameter("ictipoe02Text") != null
				&& !request.getParameter("ictipoe02Text").equals("")) {
			filterAa21bServiciosTiposFases.setIctipoe02Text(request
					.getParameter("ictipoe02Text"));
		}
		if (request.getParameter("ieserv13") != null
				&& !request.getParameter("ieserv13").equals("")) {
			filterAa21bServiciosTiposFases.setEServ13(request
					.getParameter("ieserv13"));
		}

		if (request.getParameter("isitu13") != null
				&& !request.getParameter("isitu13").equals("")) {
			filterAa21bServiciosTiposFases.setSitu13(request
					.getParameter("isitu13"));
		}
		if (request.getParameter("ictrami02") != null
				&& !request.getParameter("ictrami02").equals("")) {
			filterAa21bServiciosTiposFases.setCtrami02(request
					.getParameter("ictrami02"));
		}

		if (request.getParameter("idtipoe02") != null
				&& !request.getParameter("idtipoe02").equals("")) {
			filterAa21bServiciosTiposFases.setDtipoe02(request
					.getParameter("idtipoe02"));
		}
		if (request.getParameter("ietipoe02") != null
				&& !request.getParameter("ietipoe02").equals("")) {
			filterAa21bServiciosTiposFases.setEtipoe02(request
					.getParameter("ietipoe02"));
		}

		if (request.getParameter("isitu02") != null
				&& !request.getParameter("isitu02").equals("")) {
			filterAa21bServiciosTiposFases.setSitu02(request
					.getParameter("isitu02"));
		}

		if (request.getParameter("icfase01") != null
				&& !request.getParameter("icfase01").equals("")) {
			filterAa21bServiciosTiposFases.setCfase01(new Long(request
					.getParameter("icfase01")));
		}

		if (request.getParameter("idfase01") != null
				&& !request.getParameter("idfase01").equals("")) {
			filterAa21bServiciosTiposFases.setDfase01(request
					.getParameter("idfase01"));
		}

		if (request.getParameter("icodPif01") != null
				&& !request.getParameter("icodPif01").equals("")) {
			filterAa21bServiciosTiposFases.setCodPid01(request
					.getParameter("icodPif01"));
		}

		if (request.getParameter("itdocu01") != null
				&& !request.getParameter("itdocu01").equals("")) {
			filterAa21bServiciosTiposFases.setTdocu01(request
					.getParameter("itdocu01"));
		}

		if (request.getParameter("iefase01") != null
				&& !request.getParameter("iefase01").equals("")) {
			filterAa21bServiciosTiposFases.setEfase01(request
					.getParameter("iefase01"));
		}

		if (request.getParameter("isitu01") != null
				&& !request.getParameter("isitu01").equals("")) {
			filterAa21bServiciosTiposFases.setSitu01(request
					.getParameter("isitu01"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv13");
		jqGridRequestDto.setSord("asc");

		List<Aa21bServiciosTiposFases> aa21bServiciosTiposFases = this.serviciosTiposFasesService
				.findAll(filterAa21bServiciosTiposFases, jqGridRequestDto,
						listaServicios, listaTiposExpedientes);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bServiciosTiposFasesPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bServiciosTiposFases);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirServiciosTiposFases - Fin");

	}

	/**
	 * 
	 * @param filterBloqueos
	 *            Aa21b97s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirDesbloqueosTablas", method = RequestMethod.POST)
	public void imprimirDesbloqueosTablas(
			@ModelAttribute Aa21b97s01 filterBloqueos,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException {
		logger.info("imprimirDatosBloqueosTablas - Inicio");

		// Parametros formulario filtrado responsables
		if (request.getParameter("itabla97") != null
				&& !request.getParameter("itabla97").equals("")) {
			filterBloqueos.setTabla97(request.getParameter("itabla97"));
		}

		if (request.getParameter("idesc97") != null
				&& !request.getParameter("idesc97").equals("")) {
			filterBloqueos.setDesc97(request.getParameter("idesc97"));
		}

		if (request.getParameter("idese97") != null
				&& !request.getParameter("idese97").equals("")) {
			filterBloqueos.setDese97(request.getParameter("idese97"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("tabla97");
		jqGridRequestDto.setSord("asc");

		List<Aa21b97s01> aa21bBloqueos = this.desbloqueosTablasService.findAll(
				filterBloqueos, jqGridRequestDto);

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bDesbloqueosTablasPDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21bBloqueos);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosBloqueosTablas - Fin");

	}

	/**
	 * 
	 * @param idExpe
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	@RequestMapping(value = "/imprimirExpedienteDetalle", method = RequestMethod.POST)
	public void imprimirExpedienteDetalle(HttpServletRequest request,
			HttpServletResponse response, Locale locale)
			throws InstantiationException, IllegalAccessException,
			ClassNotFoundException, TransformerException, IOException,
			FOPException {

		logger.info("imprimirExpedienteDetalle - Inicio");

		String idExpe = "";
		if (request.getParameter("idExpePrint") != null
				&& !request.getParameter("idExpePrint").equals("")) {
			idExpe = request.getParameter("idExpePrint");
		}

		Aa21b20s01 aa21b20s01 = new Aa21b20s01();

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		String[] listaCamposClave = null;
		if (idExpe != null && !idExpe.trim().equals("")) {

			listaCamposClave = idExpe.split("-");
		}

		if (listaCamposClave != null && listaCamposClave.length > 0) {

			aa21b20s01.setCserv20(listaCamposClave[0]);
			aa21b20s01.setCexpe20(listaCamposClave[1]);
			aa21b20s01.setAexpe20(new Long(listaCamposClave[2]));
			aa21b20s01.setNexpe20(new Integer(listaCamposClave[3]));
		}

		Aa21b20s01 aa21b20s01aux = this.expedientesService.find(aa21b20s01);

		List<NoraProvincia> provincias = null;
		List<NoraMunicipio> municipios = null;

		if (aa21b20s01aux != null && aa21b20s01aux.getCprov20() != null) {
			NoraProvincia provinciaAux = new NoraProvincia();
			provinciaAux.setId(aa21b20s01aux.getCprov20());
			provincias = this.noraProvinciaService.findAll(provinciaAux, null);
		}

		if (aa21b20s01aux != null && aa21b20s01aux.getCmuni20() != null) {
			NoraMunicipio municipioAux = new NoraMunicipio();
			municipioAux.setId(aa21b20s01aux.getCmuni20());
			municipioAux.setProvinciaId(aa21b20s01aux.getCprov20());
			municipios = this.noraMunicipioService.findAll(municipioAux, null);
		}

		List<Aa21b15s01> aa21b15s01aux = null;
		if (aa21b20s01aux.getCrespo20() != null) {
			Aa21b15s01 responsable = new Aa21b15s01();
			responsable.setCusu15(aa21b20s01aux.getCrespo20().toString());
			aa21b15s01aux = this.usuariosService.findAll(responsable, null);
		}

		List<Aa21b13s01> aa21b13s01aux = null;
		if (aa21b20s01aux.getCserv20() != null) {
			Aa21b13s01 servicio = new Aa21b13s01();
			servicio.setCServ13(aa21b20s01aux.getCserv20().toString());
			aa21b13s01aux = this.aa21b13s01Service.findAll(servicio, null);
		}

		List<Aa21b14s01> aa21b14s01aux = null;
		if (aa21b20s01aux.getCarchi20() != null
				&& aa21b20s01aux.getCarchi20().length() > 0) {
			Aa21b14s01 ubicacion = new Aa21b14s01();
			ubicacion.setCarchi14(aa21b20s01aux.getCarchi20());
			aa21b14s01aux = this.ubicacionExpedientesService.findAll(ubicacion,
					null);
		}

		List<Aa21b12s01> departamentoAux = null;
		if (aa21b20s01aux.getCdepar20() != null) {
			Aa21b12s01 departamento = new Aa21b12s01();
			departamento.setCDepar12(new Long(aa21b20s01aux.getCdepar20()));
			departamentoAux = this.departamentosService.findAll(departamento,
					null);
		}

		Aa21b25s01 filterDocumentosExp = new Aa21b25s01();

		filterDocumentosExp.setCserv25(new Long(aa21b20s01aux.getCserv20()));
		filterDocumentosExp.setCexpe25(aa21b20s01aux.getCexpe20());
		filterDocumentosExp.setAexpe25(aa21b20s01aux.getAexpe20());
		filterDocumentosExp.setNexpe25(aa21b20s01aux.getNexpe20());

		List<Aa21b25s01> aa21b25s01aux = this.documentosExpService.findAll(
				filterDocumentosExp, null);

		Aa21b21s01 filterFasesExp = new Aa21b21s01();
		filterFasesExp.setCserv21(aa21b20s01aux.getCserv20().toString());
		filterFasesExp.setCexpe21(aa21b20s01aux.getCexpe20());
		filterFasesExp.setAexpe21(aa21b20s01aux.getAexpe20().toString());
		filterFasesExp.setNexpe21(aa21b20s01aux.getNexpe20());

		List<Aa21b21s01> aa21b21s01aux = this.fasesExpService.findAll(
				filterFasesExp, null);

		Aa21b29s01 filterRespExp = new Aa21b29s01();
		filterRespExp.setCserv29(aa21b20s01aux.getCserv20().toString());
		filterRespExp.setCexpe29(aa21b20s01aux.getCexpe20());
		filterRespExp.setAexpe29(aa21b20s01aux.getAexpe20().toString());
		filterRespExp.setNexpe29(aa21b20s01aux.getNexpe20());

		List<Aa21b29s01> aa21b29s01aux = this.respExpService.findAll(
				filterRespExp, null);

		List<Aa21b20s01> listaExpAsociados = this.expedientesService
				.findExpAsociados(aa21b20s01aux.getReferenciaGrupo());

		Aa21bPDF pdfClass = (Aa21bPDF) Class.forName(
				"com.ejie.aa21b.pdf.Aa21bExpedienteDetallePDF").newInstance();

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21b20s01aux);
		listaServices.add(aa21b25s01aux);
		listaServices.add(listaExpAsociados);
		listaServices.add(provincias);
		listaServices.add(municipios);
		if (aa21b15s01aux != null && aa21b15s01aux.isEmpty())
			listaServices.add(null);
		else
			listaServices.add(aa21b15s01aux);
		listaServices.add(aa21b13s01aux);
		listaServices.add(aa21b14s01aux);
		listaServices.add(aa21b21s01aux);
		listaServices.add(aa21b29s01aux);
		listaServices.add(departamentoAux);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);

		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirDatosBloqueosTablas - Fin");

	}

	/**
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 * @throws ParseException
	 */
	@RequestMapping(value = "/imprimirListadosExpedientes", method = RequestMethod.POST)
	public void imprimirListadosExpedientes(
			@ModelAttribute Aa21b20s01Consultas filterAa21b20s01,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException, ParseException {
		logger.info("imprimirListadosExpedientes - Inicio");

		List<String> listaFiltros = new ArrayList<String>();

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		Aa21b02s01 tipoExpDescFiltro = null;
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (request.getParameter("icserv20") != null
				&& !request.getParameter("icserv20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv20").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv20").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);

				vacio = "";
				if (request.getParameter("icexpe20") != null
						&& !request.getParameter("icexpe20").equals(vacio)
						// NULL como string...
						&& !request.getParameter("icexpe20").equals("null")) {

					String[] arrayTiposExpedientes = request.getParameter(
							"icexpe20").split(",");

					Aa21b02s01 tipoExp = null;
					for (int z = 0; z < arrayTiposExpedientes.length; z++) {
						tipoExp = new Aa21b02s01();// NOPMD

						tipoExp.setCtipoe02(arrayTiposExpedientes[z]);

						listaTiposExpedientes.add(tipoExp);

						tipoExpDescFiltro = new Aa21b02s01();
						tipoExpDescFiltro.setCtipoe02(arrayTiposExpedientes[z]);
						tipoExpDescFiltro.setCserv02(arrayServicios[x]);
						tipoExpDescFiltro = this.aa21b02s01Service
								.find(tipoExpDescFiltro);

						if (Aa21bConstantes.AA21B_IDIOMA_EUS
								.equalsIgnoreCase(locale.getLanguage())) {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getEtipoe02());
						} else {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getDtipoe02());
						}

					}

				}

			}

		}

		Aa21b15s01 respDescFiltro = null;
		List<Aa21b15s01> listaResponsables = new ArrayList<Aa21b15s01>();
		vacio = "";
		if (request.getParameter("icrespo20") != null
				&& !request.getParameter("icrespo20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icrespo20").equals("null")) {

			String[] arrayResponsablesExpedientes = request.getParameter(
					"icrespo20").split(",");

			Aa21b15s01 respExp = null;
			for (int x = 0; x < arrayResponsablesExpedientes.length; x++) {
				respExp = new Aa21b15s01();// NOPMD

				respExp.setCusu15(arrayResponsablesExpedientes[x]);

				listaResponsables.add(respExp);

				respDescFiltro = new Aa21b15s01();
				respDescFiltro.setCusu15(arrayResponsablesExpedientes[x]);
				respDescFiltro = this.usuariosService.find(respDescFiltro);

				listaFiltros.add(this.appMessageSource.getMessage(
						"responsableConsulta", null,
						LocaleContextHolder.getLocale())
						+ ": " + respDescFiltro.getDusu15());
			}

		}

		Aa21b14s01 archiDescFiltro = null;
		List<Aa21b14s01> listaArchivos = new ArrayList<Aa21b14s01>();
		vacio = "";
		if (request.getParameter("iarchi20") != null
				&& !request.getParameter("iarchi20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iarchi20").equals("null")) {

			String[] arrayArchivosExpedientes = request
					.getParameter("iarchi20").split(",");

			Aa21b14s01 archivExp = null;
			for (int x = 0; x < arrayArchivosExpedientes.length; x++) {
				archivExp = new Aa21b14s01();// NOPMD

				archivExp.setCarchi14(arrayArchivosExpedientes[x]);

				listaArchivos.add(archivExp);

				archiDescFiltro = new Aa21b14s01();
				archiDescFiltro.setCarchi14(arrayArchivosExpedientes[x]);
				archiDescFiltro = this.ubicacionExpedientesService
						.find(archiDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getEarchi14());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getDarchi14());
				}
			}
		}

		Aa21b07s01 estadoDescFiltro = null;
		List<Aa21b07s01> listaEstados = new ArrayList<Aa21b07s01>();
		vacio = "";
		if (request.getParameter("iesta20") != null
				&& !request.getParameter("iesta20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iesta20").equals("null")) {

			String[] arrayEstadosExpedientes = request.getParameter("iesta20")
					.split(",");

			Aa21b07s01 archivExp = null;
			for (int x = 0; x < arrayEstadosExpedientes.length; x++) {
				archivExp = new Aa21b07s01();// NOPMD

				archivExp.setCesta07(arrayEstadosExpedientes[x]);

				listaEstados.add(archivExp);

				estadoDescFiltro = new Aa21b07s01();
				estadoDescFiltro.setCesta07(arrayEstadosExpedientes[x]);
				estadoDescFiltro = this.estadosExpedientesService
						.find(estadoDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getEesta07());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getDesta07());
				}
			}

		}

		if (request.getParameter("iaexpe20") != null
				&& !request.getParameter("iaexpe20").equals("")) {
			filterAa21b20s01.setAexpe20(new Long(request
					.getParameter("iaexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("aexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iaexpe20"));

		}

		if (request.getParameter("inexpe20") != null
				&& !request.getParameter("inexpe20").equals("")) {
			filterAa21b20s01.setNexpe20(Integer.valueOf(request
					.getParameter("inexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("nexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("inexpe20"));
		}

		if (request.getParameter("ictrami20") != null
				&& !request.getParameter("ictrami20").equals("")) {
			filterAa21b20s01.setCtrami20(request.getParameter("ictrami20"));
			String tramitable = "";
			if (request.getParameter("ictrami20").equals("1")) {
				tramitable = this.appMessageSource.getMessage("si", null,
						LocaleContextHolder.getLocale());
			} else if (request.getParameter("ictrami20").equals("2")) {
				tramitable = this.appMessageSource.getMessage("no", null,
						LocaleContextHolder.getLocale());
			} else {
				tramitable = this.appMessageSource.getMessage("todos", null,
						LocaleContextHolder.getLocale());
			}
			listaFiltros.add(this.appMessageSource.getMessage("tramiConsulta",
					null, LocaleContextHolder.getLocale()) + ": " + tramitable);
		}

		if (request.getParameter("iubica20") != null
				&& !request.getParameter("iubica20").equals("")) {
			filterAa21b20s01.setUbica20(request.getParameter("iubica20"));

			listaFiltros.add(this.appMessageSource.getMessage("expBaja", null,
					LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iubica20"));
		}

		if (request.getParameter("idepar20") != null
				&& !request.getParameter("idepar20").equals("")) {
			filterAa21b20s01.setCdepar20(request.getParameter("idepar20"));

			Aa21b12s01 departamento = new Aa21b12s01();
			departamento
					.setCDepar12(new Long(request.getParameter("idepar20")));

			departamento = this.departamentosService.find(departamento);

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getEDepar12());
			} else {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getDDepar12());
			}
		}

		if (request.getParameter("iobjeto20") != null
				&& !request.getParameter("iobjeto20").equals("")) {
			filterAa21b20s01.setObjeto20(request.getParameter("iobjeto20"));

			listaFiltros.add(this.appMessageSource.getMessage("objetoConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobjeto20"));
		}

		if (request.getParameter("iobser20") != null
				&& !request.getParameter("iobser20").equals("")) {
			filterAa21b20s01.setObser20(request.getParameter("iobser20"));

			listaFiltros.add(this.appMessageSource.getMessage("obserConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobser20"));
		}

		if (request.getParameter("icpais20") != null
				&& !request.getParameter("icpais20").equals("")) {
			filterAa21b20s01.setCpais20(request.getParameter("icpais20"));

			NoraPais pais = new NoraPais();
			pais.setId(request.getParameter("icpais20"));

			pais = this.noraPaisService.find(pais);

			listaFiltros.add(this.appMessageSource.getMessage("paisConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ pais.getDsO());
		}

		if (request.getParameter("icprov20") != null
				&& !request.getParameter("icprov20").equals("")) {
			filterAa21b20s01.setCprov20(request.getParameter("icprov20"));

			NoraProvincia provincia = new NoraProvincia();

			provincia.setId(request.getParameter("icprov20"));

			provincia = this.noraProvinciaService.find(provincia);

			listaFiltros.add(this.appMessageSource.getMessage("provConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ provincia.getDsO());

			if (request.getParameter("icmuni20") != null
					&& !request.getParameter("icmuni20").equals("")) {
				filterAa21b20s01.setCmuni20(request.getParameter("icmuni20"));

				NoraMunicipio municipio = new NoraMunicipio();
				municipio.setId(request.getParameter("icmuni20"));
				municipio.setProvinciaId(provincia.getId());
				municipio = this.noraMunicipioService.find(municipio);

				listaFiltros.add(this.appMessageSource.getMessage(
						"muniConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + municipio.getDsO());
			}
		}

		Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(false);

		if (request.getParameter("ifvto20desde") != null
				&& !request.getParameter("ifvto20desde").equals("")) {
			filterAa21b20s01.setFvto20desde(formateadorFecha.parse(
					request.getParameter("ifvto20desde"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtodesdeConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20desde"));
		}

		if (request.getParameter("ifvto20hasta") != null
				&& !request.getParameter("ifvto20hasta").equals("")) {
			filterAa21b20s01.setFvto20hasta(formateadorFecha.parse(
					request.getParameter("ifvto20hasta"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtohastaConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20hasta"));
		}

		if (request.getParameter("ifaper20desde") != null
				&& !request.getParameter("ifaper20desde").equals("")) {
			filterAa21b20s01.setFaper20desde(formateadorFecha.parse(
					request.getParameter("ifaper20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20desde"));
		}

		if (request.getParameter("ifaper20hasta") != null
				&& !request.getParameter("ifaper20hasta").equals("")) {
			filterAa21b20s01.setFaper20hasta(formateadorFecha.parse(
					request.getParameter("ifaper20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20hasta"));
		}

		if (request.getParameter("ifcier20desde") != null
				&& !request.getParameter("ifcier20desde").equals("")) {
			filterAa21b20s01.setFcier20desde(formateadorFecha.parse(
					request.getParameter("ifcier20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20desde"));
		}

		if (request.getParameter("ifcier20hasta") != null
				&& !request.getParameter("ifcier20hasta").equals("")) {
			filterAa21b20s01.setFcier20hasta(formateadorFecha.parse(
					request.getParameter("ifcier20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20hasta"));
		}
		if (request.getParameter("conTareas") != null
				&& !request.getParameter("conTareas").equals("")) {
			filterAa21b20s01.setConTareas(request.getParameter("conTareas"));
			listaFiltros
					.add(this.appMessageSource.getMessage("fTareasSinRealizar",
							null, LocaleContextHolder.getLocale()));
		}
		/*
		 * if (request.getParameter("ictrami02") != null &&
		 * !request.getParameter("ictrami02").equals("")) {
		 * filterAa21bServiciosTiposFases.setCtrami02(request
		 * .getParameter("ictrami02")); }
		 */

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv20");
		jqGridRequestDto.setSord("asc");

		List<Aa21b20s01Consultas> aa21b20s01aux = this.expedientesService
				.findAllLikeConsultas(filterAa21b20s01, jqGridRequestDto,
						listaServicios, listaTiposExpedientes,
						listaResponsables, listaArchivos, listaEstados, false);

		Aa21bPDF pdfClass = null;
		if (request.getParameter("tipoListadoExpediente") != null
				&& request.getParameter("tipoListadoExpediente").equals(
						"tramitacion")) {
			pdfClass = (Aa21bPDF) Class.forName(
					"com.ejie.aa21b.pdf.Aa21bInformeTramitacionExpedientesPDF")
					.newInstance();
		} else {
			pdfClass = (Aa21bPDF) Class.forName(
					"com.ejie.aa21b.pdf.Aa21bListadosExpedientesPDF")
					.newInstance();
		}

		// Crear la lista con los servicios para pasarsela al método que
		// obtiene el xml
		List<Object> listaServices = new ArrayList<Object>();
		listaServices.add(aa21b20s01aux);
		listaServices.add(listaFiltros);

		String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		String xsltFichero = pdfClass.getXsltFichero(request, locale);
		logger.info(xmlPdf);
		imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);

		logger.info("imprimirListadosExpedientes - Fin");

	}

	/**
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param locale
	 *            Locale
	 * @throws InstantiationException
	 *             Exception
	 * @throws IllegalAccessException
	 *             Exception
	 * @throws ClassNotFoundException
	 *             Exception
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 * @throws ParseException
	 */
	@RequestMapping(value = "/imprimirListadosExpedientes2", method = RequestMethod.POST)
	public void imprimirListadosExpedientes2(
			@ModelAttribute Aa21b20s01Consultas filterAa21b20s01,
			HttpServletRequest request, HttpServletResponse response,
			Locale locale) throws InstantiationException,
			IllegalAccessException, ClassNotFoundException,
			TransformerException, IOException, FOPException, ParseException {
		logger.info("imprimirListadosExpedientes - Inicio");

		List<String> listaFiltros = new ArrayList<String>();

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		Aa21b02s01 tipoExpDescFiltro = null;
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (request.getParameter("icserv20") != null
				&& !request.getParameter("icserv20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv20").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv20").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);

				vacio = "";
				if (request.getParameter("icexpe20") != null
						&& !request.getParameter("icexpe20").equals(vacio)
						// NULL como string...
						&& !request.getParameter("icexpe20").equals("null")) {

					String[] arrayTiposExpedientes = request.getParameter(
							"icexpe20").split(",");

					Aa21b02s01 tipoExp = null;
					for (int z = 0; z < arrayTiposExpedientes.length; z++) {
						tipoExp = new Aa21b02s01();// NOPMD

						tipoExp.setCtipoe02(arrayTiposExpedientes[z]);

						listaTiposExpedientes.add(tipoExp);

						tipoExpDescFiltro = new Aa21b02s01();
						tipoExpDescFiltro.setCtipoe02(arrayTiposExpedientes[z]);
						tipoExpDescFiltro.setCserv02(arrayServicios[x]);
						tipoExpDescFiltro = this.aa21b02s01Service
								.find(tipoExpDescFiltro);

						if (Aa21bConstantes.AA21B_IDIOMA_EUS
								.equalsIgnoreCase(locale.getLanguage())) {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getEtipoe02());
						} else {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getDtipoe02());
						}

					}

				}

			}

		}

		Aa21b15s01 respDescFiltro = null;
		List<Aa21b15s01> listaResponsables = new ArrayList<Aa21b15s01>();
		vacio = "";
		if (request.getParameter("icrespo20") != null
				&& !request.getParameter("icrespo20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icrespo20").equals("null")) {

			String[] arrayResponsablesExpedientes = request.getParameter(
					"icrespo20").split(",");

			Aa21b15s01 respExp = null;
			for (int x = 0; x < arrayResponsablesExpedientes.length; x++) {
				respExp = new Aa21b15s01();// NOPMD

				respExp.setCusu15(arrayResponsablesExpedientes[x]);

				listaResponsables.add(respExp);

				respDescFiltro = new Aa21b15s01();
				respDescFiltro.setCusu15(arrayResponsablesExpedientes[x]);
				respDescFiltro = this.usuariosService.find(respDescFiltro);

				listaFiltros.add(this.appMessageSource.getMessage(
						"responsableConsulta", null,
						LocaleContextHolder.getLocale())
						+ ": " + respDescFiltro.getDusu15());
			}

		}

		Aa21b14s01 archiDescFiltro = null;
		List<Aa21b14s01> listaArchivos = new ArrayList<Aa21b14s01>();
		vacio = "";
		if (request.getParameter("iarchi20") != null
				&& !request.getParameter("iarchi20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iarchi20").equals("null")) {

			String[] arrayArchivosExpedientes = request
					.getParameter("iarchi20").split(",");

			Aa21b14s01 archivExp = null;
			for (int x = 0; x < arrayArchivosExpedientes.length; x++) {
				archivExp = new Aa21b14s01();// NOPMD

				archivExp.setCarchi14(arrayArchivosExpedientes[x]);

				listaArchivos.add(archivExp);

				archiDescFiltro = new Aa21b14s01();
				archiDescFiltro.setCarchi14(arrayArchivosExpedientes[x]);
				archiDescFiltro = this.ubicacionExpedientesService
						.find(archiDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getEarchi14());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getDarchi14());
				}
			}
		}

		Aa21b07s01 estadoDescFiltro = null;
		List<Aa21b07s01> listaEstados = new ArrayList<Aa21b07s01>();
		vacio = "";
		if (request.getParameter("iesta20") != null
				&& !request.getParameter("iesta20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iesta20").equals("null")) {

			String[] arrayEstadosExpedientes = request.getParameter("iesta20")
					.split(",");

			Aa21b07s01 archivExp = null;
			for (int x = 0; x < arrayEstadosExpedientes.length; x++) {
				archivExp = new Aa21b07s01();// NOPMD

				archivExp.setCesta07(arrayEstadosExpedientes[x]);

				listaEstados.add(archivExp);

				estadoDescFiltro = new Aa21b07s01();
				estadoDescFiltro.setCesta07(arrayEstadosExpedientes[x]);
				estadoDescFiltro = this.estadosExpedientesService
						.find(estadoDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getEesta07());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getDesta07());
				}
			}

		}

		if (request.getParameter("iaexpe20") != null
				&& !request.getParameter("iaexpe20").equals("")) {
			filterAa21b20s01.setAexpe20(new Long(request
					.getParameter("iaexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("aexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iaexpe20"));

		}

		if (request.getParameter("inexpe20") != null
				&& !request.getParameter("inexpe20").equals("")) {
			filterAa21b20s01.setNexpe20(Integer.valueOf(request
					.getParameter("inexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("nexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("inexpe20"));
		}

		if (request.getParameter("ictrami20") != null
				&& !request.getParameter("ictrami20").equals("")) {
			filterAa21b20s01.setCtrami20(request.getParameter("ictrami20"));
			String tramitable = "";
			if (request.getParameter("ictrami20").equals("1")) {
				tramitable = this.appMessageSource.getMessage("si", null,
						LocaleContextHolder.getLocale());
			} else if (request.getParameter("ictrami20").equals("2")) {
				tramitable = this.appMessageSource.getMessage("no", null,
						LocaleContextHolder.getLocale());
			} else {
				tramitable = this.appMessageSource.getMessage("todos", null,
						LocaleContextHolder.getLocale());
			}
			listaFiltros.add(this.appMessageSource.getMessage("tramiConsulta",
					null, LocaleContextHolder.getLocale()) + ": " + tramitable);
		}

		if (request.getParameter("iubica20") != null
				&& !request.getParameter("iubica20").equals("")) {
			filterAa21b20s01.setUbica20(request.getParameter("iubica20"));

			listaFiltros.add(this.appMessageSource.getMessage("expBaja", null,
					LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iubica20"));
		}

		if (request.getParameter("idepar20") != null
				&& !request.getParameter("idepar20").equals("")) {
			filterAa21b20s01.setCdepar20(request.getParameter("idepar20"));

			Aa21b12s01 departamento = new Aa21b12s01();
			departamento
					.setCDepar12(new Long(request.getParameter("idepar20")));

			departamento = this.departamentosService.find(departamento);

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getEDepar12());
			} else {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getDDepar12());
			}
		}

		if (request.getParameter("iobjeto20") != null
				&& !request.getParameter("iobjeto20").equals("")) {
			filterAa21b20s01.setObjeto20(request.getParameter("iobjeto20"));

			listaFiltros.add(this.appMessageSource.getMessage("objetoConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobjeto20"));
		}

		if (request.getParameter("iobser20") != null
				&& !request.getParameter("iobser20").equals("")) {
			filterAa21b20s01.setObser20(request.getParameter("iobser20"));

			listaFiltros.add(this.appMessageSource.getMessage("obserConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobser20"));
		}

		if (request.getParameter("icpais20") != null
				&& !request.getParameter("icpais20").equals("")) {
			filterAa21b20s01.setCpais20(request.getParameter("icpais20"));

			NoraPais pais = new NoraPais();
			pais.setId(request.getParameter("icpais20"));

			pais = this.noraPaisService.find(pais);

			listaFiltros.add(this.appMessageSource.getMessage("paisConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ pais.getDsO());
		}

		if (request.getParameter("icprov20") != null
				&& !request.getParameter("icprov20").equals("")) {
			filterAa21b20s01.setCprov20(request.getParameter("icprov20"));

			NoraProvincia provincia = new NoraProvincia();

			provincia.setId(request.getParameter("icprov20"));

			provincia = this.noraProvinciaService.find(provincia);

			listaFiltros.add(this.appMessageSource.getMessage("provConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ provincia.getDsO());

			if (request.getParameter("icmuni20") != null
					&& !request.getParameter("icmuni20").equals("")) {
				filterAa21b20s01.setCmuni20(request.getParameter("icmuni20"));

				NoraMunicipio municipio = new NoraMunicipio();
				municipio.setId(request.getParameter("icmuni20"));
				municipio.setProvinciaId(provincia.getId());
				municipio = this.noraMunicipioService.find(municipio);

				listaFiltros.add(this.appMessageSource.getMessage(
						"muniConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + municipio.getDsO());
			}
		}

		Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(false);

		if (request.getParameter("ifvto20desde") != null
				&& !request.getParameter("ifvto20desde").equals("")) {
			filterAa21b20s01.setFvto20desde(formateadorFecha.parse(
					request.getParameter("ifvto20desde"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtodesdeConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20desde"));
		}

		if (request.getParameter("ifvto20hasta") != null
				&& !request.getParameter("ifvto20hasta").equals("")) {
			filterAa21b20s01.setFvto20hasta(formateadorFecha.parse(
					request.getParameter("ifvto20hasta"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtohastaConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20hasta"));
		}

		if (request.getParameter("ifaper20desde") != null
				&& !request.getParameter("ifaper20desde").equals("")) {
			filterAa21b20s01.setFaper20desde(formateadorFecha.parse(
					request.getParameter("ifaper20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20desde"));
		}

		if (request.getParameter("ifaper20hasta") != null
				&& !request.getParameter("ifaper20hasta").equals("")) {
			filterAa21b20s01.setFaper20hasta(formateadorFecha.parse(
					request.getParameter("ifaper20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20hasta"));
		}

		if (request.getParameter("ifcier20desde") != null
				&& !request.getParameter("ifcier20desde").equals("")) {
			filterAa21b20s01.setFcier20desde(formateadorFecha.parse(
					request.getParameter("ifcier20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20desde"));
		}

		if (request.getParameter("ifcier20hasta") != null
				&& !request.getParameter("ifcier20hasta").equals("")) {
			filterAa21b20s01.setFcier20hasta(formateadorFecha.parse(
					request.getParameter("ifcier20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20hasta"));
		}
		if (request.getParameter("conTareas") != null
				&& !request.getParameter("conTareas").equals("")) {
			filterAa21b20s01.setConTareas(request.getParameter("conTareas"));
			listaFiltros
					.add(this.appMessageSource.getMessage("fTareasSinRealizar",
							null, LocaleContextHolder.getLocale()));
		}
		logger.info("Filtros establecidos, comenzamos la búsqueda");
		/*
		 * if (request.getParameter("ictrami02") != null &&
		 * !request.getParameter("ictrami02").equals("")) {
		 * filterAa21bServiciosTiposFases.setCtrami02(request
		 * .getParameter("ictrami02")); }
		 */

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv20");
		jqGridRequestDto.setSord("asc");

		List<Aa21b20s01Consultas> aa21b20s01aux = this.expedientesService
				.findAllLikeConsultas(filterAa21b20s01, jqGridRequestDto,
						listaServicios, listaTiposExpedientes,
						listaResponsables, listaArchivos, listaEstados, false);

		logger.info("Datos obtenidos comenzamos a imprimir");
		// Aa21bPDF pdfClass = null;
		// if (request.getParameter("tipoListadoExpediente") != null
		// && request.getParameter("tipoListadoExpediente").equals(
		// "tramitacion")) {
		// pdfClass = (Aa21bPDF) Class.forName(
		// "com.ejie.aa21b.pdf.Aa21bInformeTramitacionExpedientesPDF")
		// .newInstance();
		// } else {
		// pdfClass = (Aa21bPDF) Class.forName(
		// "com.ejie.aa21b.pdf.Aa21bListadosExpedientesPDF")
		// .newInstance();
		// }
		//
		// // Crear la lista con los servicios para pasarsela al método que
		// // obtiene el xml
		// List<Object> listaServices = new ArrayList<Object>();
		// listaServices.add(aa21b20s01aux);
		// listaServices.add(listaFiltros);
		//
		// String xmlPdf = pdfClass.getXmlPdf(request, listaServices, locale);
		// String xsltFichero = pdfClass.getXsltFichero(request, locale);
		// logger.info(xmlPdf);
		// imprimir(response, xsltFichero, xmlPdf);
		// generarPDF(response, xmlPdf, xsltFichero);
		response.setContentType("application/pdf");
		if (request.getParameter("tipoListadoExpediente") != null
				&& request.getParameter("tipoListadoExpediente").equals(
						"tramitacion")) {
			PdfInformeTramitacion pp = new PdfInformeTramitacion(
					this.appMessageSource, locale);

			try {

				pp.crearListado(aa21b20s01aux, listaFiltros,
						response.getOutputStream());

			} catch (IOException e) {
				// TODO Auto-generated catch block
				logger.error(e.getMessage());
				StackTraceElement[] els = e.getStackTrace();
				for (StackTraceElement el : els) {
					logger.error(el.toString());
				}

			}
		} else {
			PdfInformeListado pp = new PdfInformeListado(this.appMessageSource,
					locale);

			try {

				pp.crearListado(aa21b20s01aux, listaFiltros,
						response.getOutputStream());

			} catch (IOException e) {
				// TODO Auto-generated catch block
				logger.error(e.getMessage());
				StackTraceElement[] els = e.getStackTrace();
				for (StackTraceElement el : els) {
					logger.error(el.toString());
				}
			}
		}
		logger.info("imprimirListadosExpedientes2 - Fin");

	}

	/**
	 * Method 'imprimir'.
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param astrXSLTFichero
	 *            String
	 * @param aXML
	 *            String
	 * 
	 * @throws TransformerException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 * @throws FOPException
	 *             Exception
	 */
	protected void imprimir(HttpServletResponse response,
			String astrXSLTFichero, String aXML) throws TransformerException,
			IOException, FOPException {

		FopFactory fopFactory = FopFactory.newInstance();
		FOUserAgent userAgent = fopFactory.newFOUserAgent();
		ByteArrayOutputStream out = new ByteArrayOutputStream();

		TransformerFactory tFactory = TransformerFactory.newInstance();
		Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, userAgent, out);
		Result res = new SAXResult(fop.getDefaultHandler());

		Source foXslSource = new StreamSource(getClass().getResourceAsStream(
				"/impresos/" + astrXSLTFichero));

		Transformer pdfTransformer = tFactory.newTransformer(foXslSource);

		Source xmlSource = new StreamSource(new StringReader(aXML));

		pdfTransformer.transform(xmlSource, res);
		out.close();

		byte[] content = out.toByteArray();

		response.setContentType("application/pdf");
		response.setContentLength(content.length);
		response.setHeader("Content-Disposition", "inline; filename="
				+ astrXSLTFichero.substring(0, astrXSLTFichero.length() - 4)
				+ ".pdf");
		response.getOutputStream().write(content);
		response.getOutputStream().flush();
		response.flushBuffer();

	}

}