package com.ejie.aa21b.control;

import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa21b.model.Aa21b98s01;
import com.ejie.aa21b.service.Aa21bDesbloqueosTablasService;

/**
 * Aa21bDesbloqueosTablasDetalleController  
 * 15:50
 * 
 *  
 */

@Controller
@RequestMapping(value = "/desbloqueosTablasDetalle")
public class Aa21bDesbloqueosTablasDetalleController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bDesbloqueosTablasController.class);

	@Autowired
	private Aa21bDesbloqueosTablasService aa21bDesbloqueosTablasService;

	@Autowired(required = false)
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ModelAndView
	 */
	@RequestMapping(value = "mantDesbloqueosDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		logger.info("[GET - jqGrid] : Obtener Detalle desbloqueo tablas ");

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("tablaID", request.getParameter("tablaID"));
		model.addAttribute("bloqueoID", request.getParameter("bloqueoID"));
		model.addAttribute("campoServ97", request.getParameter("campoServicio"));
		model.addAttribute("serviciousu", request.getParameter("serviciousu"));

		return new ModelAndView("detalleDesbloqueoTabla", "model", model);

	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param tabla97
	 *            String
	 * @return Aa21b98s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{tabla97}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b98s01> get(@PathVariable String tabla97) {
		Aa21b98s01 filterAa21b98s01 = new Aa21b98s01();
		filterAa21b98s01.setTabla98(tabla97);
		logger.info("[GET - findBy_PK] : Obtener Aa21b97s01 por PK");

		return this.aa21bDesbloqueosTablasService.findDetalle(filterAa21b98s01);

	}

}