package com.ejie.aa21b.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b97s01;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21bDesbloqueosTablasService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * Aa21bDesbloqueosTablasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/desbloqueosTablas")
public class Aa21bDesbloqueosTablasController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bDesbloqueosTablasController.class);

	@Autowired
	private Aa21bDesbloqueosTablasService aa21bDesbloqueosTablasService;

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param tabla97
	 *            String
	 * @return Aa21b97s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{tabla97}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b97s01 get(@PathVariable String tabla97) {
		Aa21b97s01 aa21b97s01 = new Aa21b97s01();
		aa21b97s01.setTabla97(tabla97);
		aa21b97s01 = this.aa21bDesbloqueosTablasService.find(aa21b97s01);
		Aa21bDesbloqueosTablasController.logger
				.info("[GET - findBy_PK] : Obtener Aa21b97s01 por PK");
		return aa21b97s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21bDesbloqueosTablasController.logger
				.info("[GET - View] : desbloqueosTablas");

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");

		Aa21b15s01 usuarioFiltro = new Aa21b15s01();
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		if (!ps.isEsDeDireccion()) {

			logger.info("El usuario no es direccion.");
			logger.info("El usuario está en la tabla de usuarios Servicio="
					+ aa21b15s01busqUsuario.getCserv15());

			usuarioFiltro.setCserv15(aa21b15s01busqUsuario.getCserv15());
			filtroTipos.setCserv02(aa21b15s01busqUsuario.getCserv15());

		}
		model.addAttribute("servicioLogueado",
				aa21b15s01busqUsuario.getCserv15());

		return "desbloqueosTablas";
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b97s01
	 *            Aa21b97s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b97s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b97s01> getAll(@ModelAttribute Aa21b97s01 filterAa21b97s01) {
		Aa21bDesbloqueosTablasController.logger
				.info("[GET - find_ALL] : Obtener Aa21b97s01 por filtro");
		return this.aa21bDesbloqueosTablasService.findAll(filterAa21b97s01,
				null);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b97s01
	 *            Aa21b12s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b97s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b97s01> filter(
			@RequestJsonBody(param = "filter") Aa21b97s01 filterAa21b97s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21bDesbloqueosTablasController.logger
				.info("[POST - filter] : Obtener Aa21b12s01s");

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");

		Aa21b15s01 usuarioFiltro = new Aa21b15s01();
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		if (!ps.isEsDeDireccion()) {

			logger.info("El usuario no es direccion.");
			logger.info("El usuario está en la tabla de usuarios Servicio="
					+ aa21b15s01busqUsuario.getCserv15());

			usuarioFiltro.setCserv15(aa21b15s01busqUsuario.getCserv15());
			filtroTipos.setCserv02(aa21b15s01busqUsuario.getCserv15());

		}
		filterAa21b97s01.setCservusu(aa21b15s01busqUsuario.getCserv15());

		return this.aa21bDesbloqueosTablasService.filter(filterAa21b97s01,
				jqGridRequestDto, false);
	}

	/**
	 * Method 'getAutocompleteNombreTablas'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b97s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTablaCas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b97s01> getAutocompleteNombreTablasCas(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa21b97s01 aa21b97s01 = new Aa21b97s01();

		aa21b97s01.setDesc97(q);

		return this.aa21bDesbloqueosTablasService.findTabla(aa21b97s01, c);

	}

	/**
	 * Method 'getAutocompleteNombreTablas'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b97s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTablaEusk", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b97s01> getAutocompleteNombreTablasEusk(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa21b97s01 aa21b97s01 = new Aa21b97s01();

		aa21b97s01.setDese97(q);

		return this.aa21bDesbloqueosTablasService.findTabla(aa21b97s01, c);

	}

}