package com.ejie.aa21b.control;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.NoraMunicipioService;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bFormatoFecha;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * Aa21bConsultasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21bConsultas")
public class Aa21bConsultasController {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bConsultasController.class);

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b15s01Service aa21b15s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	@Autowired
	private NoraMunicipioService noraMunicipioService;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {

		Aa21bConsultasController.logger.info("[GET - View] : aa21bConsultas");
		// tipos de expediente
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(null, null));
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("tiposExpedientesAlta",
				this.aa21b02s01Service.findAll(filtroTipos, null));
		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		Aa21b07s01 estadosExpe = new Aa21b07s01();
		estadosExpe.setSitu07(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("estadosExpedientesAlta",
				this.aa21b07s01Service.findAll(estadosExpe, null));

		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		Aa21b14s01 ubicacionesFilter = new Aa21b14s01();
		ubicacionesFilter.setSitu14(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("ubicacionesAlta",
				this.aa21b14s01Service.findAll(ubicacionesFilter, null));

		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		Aa21b12s01 departamentoFiltro = new Aa21b12s01();
		model.addAttribute("departamentosAlta",
				this.aa21b12s01Service.findAll(departamentoFiltro, null));

		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);

		// Responsables
		logger.info("Cargar usuarios en el modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(null, null));
		Aa21b15s01 usuariosFiltro = new Aa21b15s01();
		usuariosFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("usuariosAlta",
				this.aa21b15s01Service.findAll(usuariosFiltro, null));
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		model.addAttribute("servicioLogueado",
				aa21b15s01busqUsuario.getCserv15());

		logger.info("Cargar vista");

		return "aa21bConsultas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b20s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b20s01> filter(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21bConsultasController.logger
				.info("[POST - filter] : Obtener Aa21b20s01s");

		// Compruebo si ha introducido en el criterio de búsqueda por Expediente
		// Asociado.
		// Si es así, obtendré el CGRUPO del exp asociado y lo pasaré al filtro
		// para que devuelva
		// todos los expedientes asociados

		if (filterAa21b20s01.getRefExpAsociado() != null
				&& !filterAa21b20s01.getRefExpAsociado().trim().equals("")) {

			// Recorro el String getRefExpAsociado que trae el valor de los
			// campos de la clave // primaria // separados por el carácter "-"

			Aa21b20s01 expAsociado = new Aa21b20s01();
			expAsociado.setRefExp(filterAa21b20s01.getRefExpAsociado());
			expAsociado = this.aa21b20s01Service.findPorReferencia(expAsociado);
			if (expAsociado != null) {
				filterAa21b20s01.setGrupo(expAsociado.getGrupo());
			}

		}

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (filterAa21b20s01.getCserv20() != null
				&& !filterAa21b20s01.getCserv20().toString().equals(vacio)
				// NULL como string...
				&& !filterAa21b20s01.getCserv20().toString().equals("null")) {

			String[] arrayServicios = filterAa21b20s01.getCserv20().toString()
					.split(",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);

				vacio = "";
				if (filterAa21b20s01.getCexpe20() != null
						&& !filterAa21b20s01.getCexpe20().equals(vacio)
						// NULL como string...
						&& !filterAa21b20s01.getCexpe20().equals("null")) {

					String[] arrayTiposExpedientes = filterAa21b20s01
							.getCexpe20().split(",");

					Aa21b02s01 tipoExp = null;
					for (int z = 0; z < arrayTiposExpedientes.length; z++) {
						tipoExp = new Aa21b02s01();// NOPMD

						tipoExp.setCtipoe02(arrayTiposExpedientes[z]);

						listaTiposExpedientes.add(tipoExp);
					}

				}

			}

		}

		List<Aa21b15s01> listaResponsables = new ArrayList<Aa21b15s01>();
		vacio = "";
		if (filterAa21b20s01.getScrespo20() != null
				&& !filterAa21b20s01.getScrespo20().toString().equals(vacio)
				// NULL como string...
				&& !filterAa21b20s01.getScrespo20().toString().equals("null")) {

			String[] arrayResponsablesExpedientes = filterAa21b20s01
					.getScrespo20().toString().split(",");

			Aa21b15s01 respExp = null;
			for (int x = 0; x < arrayResponsablesExpedientes.length; x++) {
				respExp = new Aa21b15s01();// NOPMD

				respExp.setCusu15(arrayResponsablesExpedientes[x]);

				listaResponsables.add(respExp);
			}

		}

		List<Aa21b14s01> listaArchivos = new ArrayList<Aa21b14s01>();
		vacio = "";
		if (filterAa21b20s01.getCarchi20() != null
				&& !filterAa21b20s01.getCarchi20().equals(vacio)
				// NULL como string...
				&& !filterAa21b20s01.getCarchi20().equals("null")) {

			String[] arrayArchivosExpedientes = filterAa21b20s01.getCarchi20()
					.split(",");

			Aa21b14s01 archivExp = null;
			for (int x = 0; x < arrayArchivosExpedientes.length; x++) {
				archivExp = new Aa21b14s01();// NOPMD

				archivExp.setCarchi14(arrayArchivosExpedientes[x]);

				listaArchivos.add(archivExp);

			}
		}

		List<Aa21b07s01> listaEstados = new ArrayList<Aa21b07s01>();
		vacio = "";
		if (filterAa21b20s01.getCesta20() != null
				&& !filterAa21b20s01.getCesta20().equals(vacio)
				// NULL como string...
				&& !filterAa21b20s01.getCesta20().equals("null")) {

			String[] arrayEstadosExpedientes = filterAa21b20s01.getCesta20()
					.split(",");

			Aa21b07s01 archivExp = null;
			for (int x = 0; x < arrayEstadosExpedientes.length; x++) {
				archivExp = new Aa21b07s01();// NOPMD

				archivExp.setCesta07(arrayEstadosExpedientes[x]);

				listaEstados.add(archivExp);

			}

		}

		return this.aa21b20s01Service.filterConsultas(filterAa21b20s01,
				listaServicios, listaTiposExpedientes, listaResponsables,
				listaArchivos, listaEstados, jqGridRequestDto, false);
	}

	/**
	 * Method 'getComboArchivo'.
	 * 
	 * @return List<Aa21b14s01>
	 */
	@RequestMapping(value = "/comboArchivo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b14s01> getComboArchivo() {
		return this.aa21b14s01Service.findAll(null, null);
	}

	/**
	 * Method 'getComboEstados'.
	 * 
	 * @return List<Aa21b07s01>
	 */
	@RequestMapping(value = "/comboEstados", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b07s01> getComboEstados() {
		return this.aa21b07s01Service.findAll(null, null);
	}

	/**
	 * Method 'getComboTiposExpedienteConsultas'.
	 * 
	 * @param q
	 *            String
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/comboTiposExpedienteConsultas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b02s01> getComboTiposExpedienteConsultas(
			@RequestParam(value = "cserv20", required = true) String q) {

		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (q != null && !q.equals(vacio)
		// NULL como string...
				&& !q.equals("null")) {
			String[] arrayTiposExp = q.split(",");
			Aa21b02s01 tipoExp = null;
			for (int x = 0; x < arrayTiposExp.length; x++) {
				tipoExp = new Aa21b02s01();// NOPMD
				tipoExp.setCserv02(arrayTiposExp[x]);
				listaTiposExpedientes.add(tipoExp);
			}
		}

		return this.aa21b02s01Service.findAllComboTiposExpServicioConsulta(
				listaTiposExpedientes, null);
	}

	/**
	 * Crear excel listado expedientes
	 * 
	 * @param model
	 *            Model
	 * @param filterConsultas
	 *            Aa21b20s01Consultas
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "excelListadoExpedientes", method = RequestMethod.POST)
	public String informeExcelUsuarios(Model model,
			@ModelAttribute Aa21b20s01Consultas filterConsultas,
			HttpServletRequest request, Locale locale) throws ParseException {
		Aa21bConsultasController.logger
				.info("Creando informe Excel listado expedientes");
		String view = "";

		List<String> listaFiltros = new ArrayList<String>();
		// Parametros formulario filtrado usuarios
		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		Aa21b02s01 tipoExpDescFiltro = null;
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (request.getParameter("icserv20") != null
				&& !request.getParameter("icserv20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv20").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv20").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);

				vacio = "";
				if (request.getParameter("icexpe20") != null
						&& !request.getParameter("icexpe20").equals(vacio)
						// NULL como string...
						&& !request.getParameter("icexpe20").equals("null")) {

					String[] arrayTiposExpedientes = request.getParameter(
							"icexpe20").split(",");

					Aa21b02s01 tipoExp = null;
					for (int z = 0; z < arrayTiposExpedientes.length; z++) {
						tipoExp = new Aa21b02s01();// NOPMD

						tipoExp.setCtipoe02(arrayTiposExpedientes[z]);

						listaTiposExpedientes.add(tipoExp);

						tipoExpDescFiltro = new Aa21b02s01();
						tipoExpDescFiltro.setCtipoe02(arrayTiposExpedientes[z]);
						tipoExpDescFiltro.setCserv02(arrayServicios[x]);

						tipoExpDescFiltro = this.aa21b02s01Service
								.find(tipoExpDescFiltro);

						if (Aa21bConstantes.AA21B_IDIOMA_EUS
								.equalsIgnoreCase(locale.getLanguage())) {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getEtipoe02());
						} else {
							listaFiltros.add(this.appMessageSource.getMessage(
									"tipoExpedienteConsulta", null,
									LocaleContextHolder.getLocale())
									+ ": "
									+ tipoExpDescFiltro.getCtipoe02()
									+ " - " + tipoExpDescFiltro.getDtipoe02());
						}

					}

				}

			}

		}

		Aa21b15s01 respDescFiltro = null;
		List<Aa21b15s01> listaResponsables = new ArrayList<Aa21b15s01>();
		vacio = "";
		if (request.getParameter("icrespo20") != null
				&& !request.getParameter("icrespo20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icrespo20").equals("null")) {

			String[] arrayResponsablesExpedientes = request.getParameter(
					"icrespo20").split(",");

			Aa21b15s01 respExp = null;
			for (int x = 0; x < arrayResponsablesExpedientes.length; x++) {
				respExp = new Aa21b15s01();// NOPMD

				respExp.setCusu15(arrayResponsablesExpedientes[x]);

				listaResponsables.add(respExp);

				respDescFiltro = new Aa21b15s01();
				respDescFiltro.setCusu15(arrayResponsablesExpedientes[x]);
				respDescFiltro = this.aa21b15s01Service.find(respDescFiltro);

				listaFiltros.add(this.appMessageSource.getMessage(
						"responsableConsulta", null,
						LocaleContextHolder.getLocale())
						+ ": " + respDescFiltro.getDusu15());
			}

		}

		Aa21b14s01 archiDescFiltro = null;
		List<Aa21b14s01> listaArchivos = new ArrayList<Aa21b14s01>();
		vacio = "";
		if (request.getParameter("iarchi20") != null
				&& !request.getParameter("iarchi20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iarchi20").equals("null")) {

			String[] arrayArchivosExpedientes = request
					.getParameter("iarchi20").split(",");

			Aa21b14s01 archivExp = null;
			for (int x = 0; x < arrayArchivosExpedientes.length; x++) {
				archivExp = new Aa21b14s01();// NOPMD

				archivExp.setCarchi14(arrayArchivosExpedientes[x]);

				listaArchivos.add(archivExp);

				archiDescFiltro = new Aa21b14s01();
				archiDescFiltro.setCarchi14(arrayArchivosExpedientes[x]);
				archiDescFiltro = this.aa21b14s01Service.find(archiDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getEarchi14());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"archivoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + archiDescFiltro.getDarchi14());
				}
			}
		}

		Aa21b07s01 estadoDescFiltro = null;
		List<Aa21b07s01> listaEstados = new ArrayList<Aa21b07s01>();
		vacio = "";
		if (request.getParameter("iesta20") != null
				&& !request.getParameter("iesta20").equals(vacio)
				// NULL como string...
				&& !request.getParameter("iesta20").equals("null")) {

			String[] arrayEstadosExpedientes = request.getParameter("iesta20")
					.split(",");

			Aa21b07s01 archivExp = null;
			for (int x = 0; x < arrayEstadosExpedientes.length; x++) {
				archivExp = new Aa21b07s01();// NOPMD

				archivExp.setCesta07(arrayEstadosExpedientes[x]);

				listaEstados.add(archivExp);

				estadoDescFiltro = new Aa21b07s01();
				estadoDescFiltro.setCesta07(arrayEstadosExpedientes[x]);
				estadoDescFiltro = this.aa21b07s01Service
						.find(estadoDescFiltro);

				if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
						.getLanguage())) {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getEesta07());
				} else {
					listaFiltros.add(this.appMessageSource.getMessage(
							"estadoConsulta", null,
							LocaleContextHolder.getLocale())
							+ ": " + estadoDescFiltro.getDesta07());
				}
			}

		}

		if (request.getParameter("iaexpe20") != null
				&& !request.getParameter("iaexpe20").equals("")) {
			filterConsultas.setAexpe20(new Long(request
					.getParameter("iaexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("aexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iaexpe20"));

		}

		if (request.getParameter("inexpe20") != null
				&& !request.getParameter("inexpe20").equals("")) {
			filterConsultas.setNexpe20(Integer.valueOf(request
					.getParameter("inexpe20")));

			listaFiltros.add(this.appMessageSource.getMessage("nexpeConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("inexpe20"));
		}

		if (request.getParameter("ictrami20") != null
				&& !request.getParameter("ictrami20").equals("")) {
			filterConsultas.setCtrami20(request.getParameter("ictrami20"));
			String tramitable = "";
			if (request.getParameter("ictrami20").equals("1")) {
				tramitable = this.appMessageSource.getMessage("si", null,
						LocaleContextHolder.getLocale());
			} else if (request.getParameter("ictrami20").equals("2")) {
				tramitable = this.appMessageSource.getMessage("no", null,
						LocaleContextHolder.getLocale());
			} else {
				tramitable = this.appMessageSource.getMessage("todos", null,
						LocaleContextHolder.getLocale());
			}
			listaFiltros.add(this.appMessageSource.getMessage("tramiConsulta",
					null, LocaleContextHolder.getLocale()) + ": " + tramitable);
		}

		if (request.getParameter("iubica20") != null
				&& !request.getParameter("iubica20").equals("")) {
			filterConsultas.setUbica20(request.getParameter("iubica20"));

			listaFiltros.add(this.appMessageSource.getMessage("expBaja", null,
					LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iubica20"));
		}

		if (request.getParameter("idepar20") != null
				&& !request.getParameter("idepar20").equals("")) {
			filterConsultas.setCdepar20(request.getParameter("idepar20"));

			Aa21b12s01 departamento = new Aa21b12s01();
			departamento
					.setCDepar12(new Long(request.getParameter("idepar20")));

			departamento = this.aa21b12s01Service.find(departamento);

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getEDepar12());
			} else {
				listaFiltros.add(this.appMessageSource.getMessage(
						"deparConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + departamento.getDDepar12());
			}
		}

		if (request.getParameter("iobjeto20") != null
				&& !request.getParameter("iobjeto20").equals("")) {
			filterConsultas.setObjeto20(request.getParameter("iobjeto20"));

			listaFiltros.add(this.appMessageSource.getMessage("objetoConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobjeto20"));
		}

		if (request.getParameter("iobser20") != null
				&& !request.getParameter("iobser20").equals("")) {
			filterConsultas.setObser20(request.getParameter("iobser20"));

			listaFiltros.add(this.appMessageSource.getMessage("obserConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ request.getParameter("iobser20"));
		}

		if (request.getParameter("icpais20") != null
				&& !request.getParameter("icpais20").equals("")) {
			filterConsultas.setCpais20(request.getParameter("icpais20"));

			NoraPais pais = new NoraPais();
			pais.setId(request.getParameter("icpais20"));

			pais = this.noraPaisService.find(pais);

			listaFiltros.add(this.appMessageSource.getMessage("paisConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ pais.getDsO());
		}

		if (request.getParameter("icprov20") != null
				&& !request.getParameter("icprov20").equals("")) {
			filterConsultas.setCprov20(request.getParameter("icprov20"));

			NoraProvincia provincia = new NoraProvincia();

			provincia.setId(request.getParameter("icprov20"));

			provincia = this.noraProvinciaService.find(provincia);

			listaFiltros.add(this.appMessageSource.getMessage("provConsulta",
					null, LocaleContextHolder.getLocale())
					+ ": "
					+ provincia.getDsO());

			if (request.getParameter("icmuni20") != null
					&& !request.getParameter("icmuni20").equals("")) {
				filterConsultas.setCmuni20(request.getParameter("icmuni20"));

				NoraMunicipio municipio = new NoraMunicipio();
				municipio.setId(request.getParameter("icmuni20"));
				municipio.setProvinciaId(provincia.getId());
				municipio = this.noraMunicipioService.find(municipio);

				listaFiltros.add(this.appMessageSource.getMessage(
						"muniConsulta", null, LocaleContextHolder.getLocale())
						+ ": " + municipio.getDsO());
			}
		}

		Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(false);

		if (request.getParameter("ifvto20desde") != null
				&& !request.getParameter("ifvto20desde").equals("")) {
			filterConsultas.setFvto20desde(formateadorFecha.parse(
					request.getParameter("ifvto20desde"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtodesdeConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20desde"));
		}

		if (request.getParameter("ifvto20hasta") != null
				&& !request.getParameter("ifvto20hasta").equals("")) {
			filterConsultas.setFvto20hasta(formateadorFecha.parse(
					request.getParameter("ifvto20hasta"), locale));

			listaFiltros.add(this.appMessageSource.getMessage(
					"fvtohastaConsulta", null, LocaleContextHolder.getLocale())
					+ ": " + request.getParameter("ifvto20hasta"));
		}

		if (request.getParameter("ifaper20desde") != null
				&& !request.getParameter("ifaper20desde").equals("")) {
			filterConsultas.setFaper20desde(formateadorFecha.parse(
					request.getParameter("ifaper20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20desde"));
		}

		if (request.getParameter("ifaper20hasta") != null
				&& !request.getParameter("ifaper20hasta").equals("")) {
			filterConsultas.setFaper20hasta(formateadorFecha.parse(
					request.getParameter("ifaper20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("faperhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifaper20hasta"));
		}

		if (request.getParameter("ifcier20desde") != null
				&& !request.getParameter("ifcier20desde").equals("")) {
			filterConsultas.setFcier20desde(formateadorFecha.parse(
					request.getParameter("ifcier20desde"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierdesdeConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20desde"));
		}

		if (request.getParameter("ifcier20hasta") != null
				&& !request.getParameter("ifcier20hasta").equals("")) {
			filterConsultas.setFcier20hasta(formateadorFecha.parse(
					request.getParameter("ifcier20hasta"), locale));

			listaFiltros
					.add(this.appMessageSource.getMessage("fcierhastaConsulta",
							null, LocaleContextHolder.getLocale())
							+ ": "
							+ request.getParameter("ifcier20hasta"));
		}
		if (request.getParameter("conTareas") != null
				&& !request.getParameter("conTareas").equals("")) {
			filterConsultas.setConTareas(request.getParameter("conTareas"));
			listaFiltros
					.add(this.appMessageSource.getMessage("fTareasSinRealizar",
							null, LocaleContextHolder.getLocale()));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv20");
		jqGridRequestDto.setSord("asc");

		List<Aa21b20s01Consultas> listaExpedientes = aa21b20s01Service
				.findAllLikeConsultas(filterConsultas, jqGridRequestDto,
						listaServicios, listaTiposExpedientes,
						listaResponsables, listaArchivos, listaEstados, false);

		model.addAttribute("listadoExpedientes", listaExpedientes);
		model.addAttribute("listaFiltros", listaFiltros);

		if (request.getParameter("tipoListadoExpediente") != null
				&& request.getParameter("tipoListadoExpediente").equals(
						"tramitacion")) {
			view = "reporteExcelInformeTramitacion";
		} else {
			view = "reporteExcelListadoExpedientes";
		}
		return view;
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b15s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */

	@RequestMapping(value = "/filterJerarTipoExp/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b02s01> filterJerarTipoExp(
			@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21bConsultasController.logger
				.info("[POST - filter] : Obtener filterJerarTipoExp");

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		// String usuario = "VDIAZSAN";

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		// aa21b15s01busqUsuario.setUxlnet15(usuario);
		logger.info("Buscar el usuario en la tabla 15");

		// aa21b15s01busqUsuario = this.aa21b15s01Service
		// .findXLNET(aa21b15s01busqUsuario);
		Aa21b15s01 usuarioFiltro = new Aa21b15s01();
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		// usuarioFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		// filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		if (!ps.isEsDeDireccion()) {
			logger.info("El usuario no es direccion.");
			logger.info("El usuario está en la tabla de usuarios Servicio="
					+ aa21b15s01busqUsuario.getCserv15());
			usuarioFiltro.setCserv15(aa21b15s01busqUsuario.getCserv15());
			filtroTipos.setCserv02(aa21b15s01busqUsuario.getCserv15());
		}

		if (filtroTipos == null || filtroTipos.getCserv02() == null) {
			filtroTipos.setCserv02("---");

		}
		if (filterAa21b02s01 != null) {
			if (!"".equals(filterAa21b02s01.getSitu02())) {
				filtroTipos.setSitu02("A");
			}
			if (!"".equals(filterAa21b02s01.getCtipoe02())) {
				filtroTipos.setCtipoe02(filterAa21b02s01.getCtipoe02());
			}
			if (!"".equals(filterAa21b02s01.getDtipoe02())) {
				filtroTipos.setDtipoe02(filterAa21b02s01.getDtipoe02());
			}
			if (!"".equals(filterAa21b02s01.getEtipoe02())) {
				filtroTipos.setEtipoe02(filterAa21b02s01.getEtipoe02());
			}
		}

		JQGridResponseDto<Aa21b02s01> listaResponsables = this.aa21b02s01Service
				.filterJerarTipoExp(filtroTipos, jqGridRequestDto, false);

		return listaResponsables;
	}
}