package com.ejie.aa21b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.aa21b.service.Aa21b29s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b29s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b29s01")
public class Aa21b29s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b29s01Controller.class);

	@Autowired
	private Aa21b29s01Service aa21b29s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idRespExp
	 *            String
	 * @return Aa21b29s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idRespExp}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b29s01 get(@PathVariable String idRespExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idRespExp != null && !idRespExp.trim().equals("")) {

			int longitud = idRespExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idRespExp.indexOf("-") != -1) {
					listaCamposClave.add(idRespExp.substring(0,
							idRespExp.indexOf("-")));
				} else {
					listaCamposClave.add(idRespExp);
				}
				idRespExp = idRespExp.substring(idRespExp.indexOf("-") + 1);
			}
		}
		Aa21b29s01 aa21b29s01 = new Aa21b29s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b29s01.setCserv29(listaCamposClave.get(0));
			aa21b29s01.setCexpe29(listaCamposClave.get(1));
			aa21b29s01.setAexpe29(listaCamposClave.get(2));
			aa21b29s01.setNexpe29(new Integer(listaCamposClave.get(3)));
			aa21b29s01.setCrespo29(new Long(listaCamposClave.get(4)));
			aa21b29s01.setFrespo29(new Date(listaCamposClave.get(5)));
		}

		aa21b29s01 = this.aa21b29s01Service.find(aa21b29s01);
		Aa21b29s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b29s01 por PK");
		return aa21b29s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b29s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b29s01> getAll(@ModelAttribute Aa21b29s01 filterAa21b29s01) {
		Aa21b29s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b29s01 por filtro");
		return this.aa21b29s01Service.findAll(filterAa21b29s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b29s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b29s01 edit(@RequestBody Aa21b29s01 aa21b29s01) {
		Aa21b29s01 aa21b29s01Aux = this.aa21b29s01Service.update(aa21b29s01);
		Aa21b29s01Controller.logger
				.info("[PUT] : Aa21b29s01 actualizado correctamente");
		return aa21b29s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b29s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b29s01 add(@RequestBody Aa21b29s01 aa21b29s01) {
		Aa21b29s01 aa21b29s01Aux = this.aa21b29s01Service.add(aa21b29s01);
		Aa21b29s01Controller.logger
				.info("[POST] : Aa21b29s01 insertado correctamente");
		return aa21b29s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param idRespExp
	 *            String
	 * @return Aa21b29s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{idRespExp}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b29s01 remove(@PathVariable String idRespExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idRespExp != null && !idRespExp.trim().equals("")) {

			int longitud = idRespExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idRespExp.indexOf("-") != -1) {
					listaCamposClave.add(idRespExp.substring(0,
							idRespExp.indexOf("-")));
				} else {
					listaCamposClave.add(idRespExp);
				}
				idRespExp = idRespExp.substring(idRespExp.indexOf("-") + 1);
			}
		}
		Aa21b29s01 aa21b29s01 = new Aa21b29s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b29s01.setCserv29(listaCamposClave.get(0));
			aa21b29s01.setCexpe29(listaCamposClave.get(1));
			aa21b29s01.setAexpe29(listaCamposClave.get(2));
			aa21b29s01.setNexpe29(new Integer(listaCamposClave.get(3)));
			aa21b29s01.setCrespo29(new Long(listaCamposClave.get(4)));
			aa21b29s01.setFrespo29(new Date(listaCamposClave.get(5)));
		}
		this.aa21b29s01Service.remove(aa21b29s01);
		Aa21b29s01Controller.logger
				.info("[DELETE] : Aa21b29s01 borrado correctamente");
		return aa21b29s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b29s01Controller.logger.info("[GET - View] : aa21b29s01");
		return "aa21b29s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b29s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b29s01> filter(
			@RequestJsonBody(param = "filter") Aa21b29s01 filterAa21b29s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b29s01s");
		return this.aa21b29s01Service.filter(filterAa21b29s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b29s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b29s01>> search(
			@RequestJsonBody(param = "filter") Aa21b29s01 filterAa21b29s01,
			@RequestJsonBody(param = "search") Aa21b29s01 searchAa21b29s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01Controller.logger
				.info("[POST - search] : Buscar Aa21b29s01s");
		return this.aa21b29s01Service.search(filterAa21b29s01,
				searchAa21b29s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b29s01 filterAa21b29s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b29s01s");
		this.aa21b29s01Service.removeMultiple(filterAa21b29s01,
				jqGridRequestDto, false);
		Aa21b29s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b29s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b29s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b29s01 filterAa21b29s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b29s01s jerarquia");
		return this.aa21b29s01Service.jerarquia(filterAa21b29s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b29s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b29s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b29s01 filterAa21b29s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b29s01s jerarquia - Hijos");
		return this.aa21b29s01Service.jerarquiaChildren(filterAa21b29s01,
				jqGridRequestDto);
	}

}
