package com.ejie.aa21b.control;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

import com.ejie.aa21b.model.Aa21b25s01;
import com.ejie.aa21b.service.Aa21b25s01Service;
import com.ejie.aa21b.service.Aa21bAccesoPIDService;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b25s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b25s01")
public class Aa21b25s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b25s01Controller.class);

	@Autowired
	private Aa21b25s01Service aa21b25s01Service;
	@Autowired
	private Aa21bAccesoPIDService pidService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idDocExp
	 *            String
	 * @return Aa21b25s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idDocExp}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b25s01 get(@PathVariable String idDocExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idDocExp != null && !idDocExp.trim().equals("")) {

			int longitud = idDocExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idDocExp.indexOf("-") != -1) {
					listaCamposClave.add(idDocExp.substring(0,
							idDocExp.indexOf("-")));
				} else {
					listaCamposClave.add(idDocExp);
				}
				idDocExp = idDocExp.substring(idDocExp.indexOf("-") + 1);
			}
		}
		Aa21b25s01 aa21b25s01 = new Aa21b25s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b25s01.setCserv25(new Long(listaCamposClave.get(0)));
			aa21b25s01.setCexpe25(listaCamposClave.get(1));
			aa21b25s01.setAexpe25(new Long(listaCamposClave.get(2)));
			aa21b25s01.setNexpe25(new Integer(listaCamposClave.get(3)));
			aa21b25s01.setTdocu25(listaCamposClave.get(4));
			aa21b25s01.setCdocu25(new Integer(listaCamposClave.get(5)));
			aa21b25s01.setNdocu25(new Integer(listaCamposClave.get(6)));

		}

		aa21b25s01 = this.aa21b25s01Service.find(aa21b25s01);
		Aa21b25s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b25s01 por PK");
		return aa21b25s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b25s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b25s01> getAll(@ModelAttribute Aa21b25s01 filterAa21b25s01) {
		Aa21b25s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b25s01 por filtro");
		return this.aa21b25s01Service.findAll(filterAa21b25s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b25s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b25s01 edit(@RequestBody Aa21b25s01 aa21b25s01) {
		Aa21b25s01 aa21b25s01Aux = this.aa21b25s01Service.update(aa21b25s01);
		Aa21b25s01Controller.logger
				.info("[PUT] : Aa21b25s01 actualizado correctamente");
		return aa21b25s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b25s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b25s01 add(@RequestBody Aa21b25s01 aa21b25s01) {
		Aa21b25s01 aa21b25s01Aux = this.aa21b25s01Service.add(aa21b25s01);
		Aa21b25s01Controller.logger
				.info("[POST] : Aa21b25s01 insertado correctamente");
		return aa21b25s01Aux;
	}

	@RequestMapping(value = "editar", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b25s01 edit2(
			@RequestParam(value = "cserv25", required = false) Long cserv25,
			@RequestParam(value = "cexpe25", required = false) String cexpe25,
			@RequestParam(value = "aexpe25", required = false) Long aexpe25,
			@RequestParam(value = "nexpe25", required = false) Integer nexpe25,
			@RequestParam(value = "tdocu25", required = false) String tdocu25,
			@RequestParam(value = "cdocu25", required = false) Integer cdocu25,
			@RequestParam(value = "ndocu25", required = false) Integer ndocu25,
			@RequestParam(value = "texto25", required = false) String texto25,
			@RequestParam(value = "fanot25", required = false) String fanot25,
			@RequestParam(value = "aanot25", required = false) Long aanot25,
			@RequestParam(value = "nanot25", required = false) Long nanot25,

			@RequestParam(value = "ddocu25", required = false) String ddocu25,
			@RequestParam(value = "edocu25", required = false) String edocu25,
			@RequestParam(value = "extdocu25", required = false) String extdocu25,
			@RequestParam(value = "codpid25", required = false) String codpid25,
			@RequestParam(value = "ctype25", required = false) String ctype25,
			Locale locale) {
		Aa21b25s01 aa21b25s01Aux = new Aa21b25s01();
		aa21b25s01Aux.setCserv25(cserv25);
		aa21b25s01Aux.setCexpe25(cexpe25);
		aa21b25s01Aux.setAexpe25(aexpe25);
		aa21b25s01Aux.setNexpe25(nexpe25);
		aa21b25s01Aux.setTdocu25(tdocu25);
		aa21b25s01Aux.setCdocu25(cdocu25);
		aa21b25s01Aux.setNdocu25(ndocu25);
		aa21b25s01Aux.setTexto25(texto25);
		Date fechaObtencion = null;
		try {
			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				fechaObtencion = new SimpleDateFormat("yyyy/MM/dd")
						.parse(fanot25);
			} else {
				fechaObtencion = new SimpleDateFormat("dd/MM/yyyy")
						.parse(fanot25);
			}
		} catch (Exception e) {
			fechaObtencion = null;
		}
		aa21b25s01Aux.setFanot25(fechaObtencion);
		aa21b25s01Aux.setAanot25(aanot25);
		aa21b25s01Aux.setNanot25(nanot25);
		aa21b25s01Aux.setDdocu25(ddocu25);
		aa21b25s01Aux.setEdocu25(edocu25);

		aa21b25s01Aux.setCodpid25(codpid25);
		aa21b25s01Aux.setCtype25(ctype25);
		aa21b25s01Aux.setExtdocu25(extdocu25);
		aa21b25s01Aux = this.aa21b25s01Service.update(aa21b25s01Aux);

		Aa21b25s01Controller.logger
				.info("[PUT] : Aa21b25s01 actualizado correctamente");
		return aa21b25s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b25s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(value = "saveNew", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b25s01 add2(
			@RequestParam(value = "cserv25", required = false) Long cserv25,
			@RequestParam(value = "cexpe25", required = false) String cexpe25,
			@RequestParam(value = "aexpe25", required = false) Long aexpe25,
			@RequestParam(value = "nexpe25", required = false) Integer nexpe25,
			@RequestParam(value = "tdocu25", required = false) String tdocu25,
			@RequestParam(value = "cdocu25", required = false) Integer cdocu25,
			@RequestParam(value = "ndocu25", required = false) Integer ndocu25,
			@RequestParam(value = "texto25", required = false) String texto25,
			@RequestParam(value = "fanot25", required = false) String fanot25,
			@RequestParam(value = "aanot25", required = false) Long aanot25,
			@RequestParam(value = "nanot25", required = false) Long nanot25,

			@RequestParam(value = "ddocu25", required = false) String ddocu25,
			@RequestParam(value = "edocu25", required = false) String edocu25,
			@RequestParam(value = "extdocu25", required = false) String extdocu25,
			@RequestParam(value = "codpid25", required = false) String codpid25,
			@RequestParam(value = "ctype25", required = false) String ctype25,
			@RequestParam(value = "docu25", required = false) MultipartFile documento,
			Locale locale) {

		Aa21b25s01 aa21b25s01Aux = new Aa21b25s01();
		aa21b25s01Aux.setCserv25(cserv25);
		aa21b25s01Aux.setCexpe25(cexpe25);
		aa21b25s01Aux.setAexpe25(aexpe25);
		aa21b25s01Aux.setNexpe25(nexpe25);
		aa21b25s01Aux.setTdocu25(tdocu25);
		aa21b25s01Aux.setCdocu25(cdocu25);
		aa21b25s01Aux.setNdocu25(ndocu25);
		aa21b25s01Aux.setTexto25(texto25);
		Date fechaObtencion = null;
		try {
			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				fechaObtencion = new SimpleDateFormat("yyyy/MM/dd")
						.parse(fanot25);
			} else {
				fechaObtencion = new SimpleDateFormat("dd/MM/yyyy")
						.parse(fanot25);
			}
		} catch (Exception e) {
			fechaObtencion = null;
		}
		aa21b25s01Aux.setFanot25(fechaObtencion);
		aa21b25s01Aux.setAanot25(aanot25);
		aa21b25s01Aux.setNanot25(nanot25);
		aa21b25s01Aux.setDdocu25(ddocu25);
		aa21b25s01Aux.setEdocu25(edocu25);
		aa21b25s01Aux.setExtdocu25(extdocu25);
		aa21b25s01Aux.setCodpid25(codpid25);
		aa21b25s01Aux.setCtype25(ctype25);

		aa21b25s01Aux = this.aa21b25s01Service.add(aa21b25s01Aux);
		if (documento != null && !documento.isEmpty())
			aa21b25s01Aux = this.aa21b25s01Service
					.guardarFicheroActualizarEntidad(aa21b25s01Aux, documento);
		Aa21b25s01Controller.logger
				.info("[POST] : Aa21b25s01 insertado correctamente");
		return aa21b25s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param idDocExp
	 *            String
	 * @return Aa21b25s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{idDocExp}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b25s01 remove(@PathVariable String idDocExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idDocExp != null && !idDocExp.trim().equals("")) {

			int longitud = idDocExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idDocExp.indexOf("-") != -1) {
					listaCamposClave.add(idDocExp.substring(0,
							idDocExp.indexOf("-")));
				} else {
					listaCamposClave.add(idDocExp);
				}
				idDocExp = idDocExp.substring(idDocExp.indexOf("-") + 1);
			}
		}
		Aa21b25s01 aa21b25s01 = new Aa21b25s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b25s01.setCserv25(new Long(listaCamposClave.get(0)));
			aa21b25s01.setCexpe25(listaCamposClave.get(1));
			aa21b25s01.setAexpe25(new Long(listaCamposClave.get(2)));
			aa21b25s01.setNexpe25(new Integer(listaCamposClave.get(3)));
			aa21b25s01.setTdocu25(listaCamposClave.get(4));
			aa21b25s01.setCdocu25(new Integer(listaCamposClave.get(5)));
			aa21b25s01.setNdocu25(new Integer(listaCamposClave.get(6)));

		}

		// Buscamos el codpid y eliminamos el documento del PID
		aa21b25s01 = this.aa21b25s01Service.find(aa21b25s01);
		try {
			pidService.delete(aa21b25s01.getCodpid25());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block

		}
		// Eliminamos registro
		this.aa21b25s01Service.remove(aa21b25s01);
		Aa21b25s01Controller.logger
				.info("[DELETE] : Aa21b25s01 borrado correctamente");
		return aa21b25s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b25s01Controller.logger.info("[GET - View] : aa21b25s01");
		return "aa21b25s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b25s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b25s01> filter(
			@RequestJsonBody(param = "filter") Aa21b25s01 filterAa21b25s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b25s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b25s01s");
		return this.aa21b25s01Service.filter(filterAa21b25s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b25s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b25s01>> search(
			@RequestJsonBody(param = "filter") Aa21b25s01 filterAa21b25s01,
			@RequestJsonBody(param = "search") Aa21b25s01 searchAa21b25s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b25s01Controller.logger
				.info("[POST - search] : Buscar Aa21b25s01s");
		return this.aa21b25s01Service.search(filterAa21b25s01,
				searchAa21b25s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b25s01 filterAa21b25s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b25s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b25s01s");
		this.aa21b25s01Service.removeMultiple(filterAa21b25s01,
				jqGridRequestDto, false);
		Aa21b25s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b25s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b25s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b25s01 filterAa21b25s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b25s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b25s01s jerarquia");
		return this.aa21b25s01Service.jerarquia(filterAa21b25s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b25s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b25s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b25s01 filterAa21b25s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b25s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b25s01s jerarquia - Hijos");
		return this.aa21b25s01Service.jerarquiaChildren(filterAa21b25s01,
				jqGridRequestDto);
	}

	/**
	 * añade un documento al PID
	 * 
	 * @param request
	 * @param documento
	 * @param docu05
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/aniadirDocumento", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b25s01 aniadirDocumento(
			HttpServletRequest request,
			@ModelAttribute Aa21b25s01 documento,
			@RequestParam(value = "docu25", required = false) MultipartFile docu05)
			throws Exception {
		Aa21b25s01Controller.logger.info("Añadir documento");

		documento = this.aa21b25s01Service.guardarFicheroActualizarEntidad(
				documento, docu05);
		return documento;
	}

	/**
	 * Actualiza un documento del PID
	 * 
	 * @param request
	 * @param documento
	 * @param docu05
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/actualizarDocumento", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b25s01 actualizarDocumento(
			HttpServletRequest request,
			// @RequestParam Long cserv25,
			// @RequestParam String cexpe25,
			// @RequestParam Long aexpe25,
			// @RequestParam Integer nexpe25,
			// @RequestParam Integer ndocu25,
			// @RequestParam String tdocu25,
			// @RequestParam Integer cdocu25,
			@ModelAttribute Aa21b25s01 documento,
			@RequestParam(value = "docu25", required = false) MultipartFile docu05)
			throws Exception {
		Aa21b25s01Controller.logger.info("Añadir documento");
		// Aa21b25s01 documento = new Aa21b25s01();
		// documento.setCserv25(cserv25);
		// documento.setCexpe25(cexpe25);
		// documento.setAexpe25(aexpe25);
		// documento.setNexpe25(nexpe25);
		// documento.setNdocu25(ndocu25);
		// documento.setTdocu25(tdocu25);
		// documento.setCdocu25(cdocu25);
		documento = this.aa21b25s01Service.actualizarFicheroActualizarEntidad(
				documento, docu05);
		return documento;
	}

	/**
	 * Muestra un documento del pid
	 * 
	 * @param documento
	 * @param request
	 * @param response
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/verDocumento", method = RequestMethod.POST)
	public void getDocumentoFaseExpediente(
			@ModelAttribute Aa21b25s01 documento,

			HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		documento = this.aa21b25s01Service.find(documento);
		byte[] fileByteArray = pidService.load(documento.getCodpid25());
		ServletOutputStream sos = null;
		BufferedOutputStream bos = null;
		StringBuffer fileName = new StringBuffer("Documento");
		if (fileByteArray != null) {

			response.setContentType(documento.getCtype25());
			fileName.append(".");

			fileName.append(documento.getExtdocu25());

			response.setContentLength(fileByteArray.length);
			response.setHeader("Pragma", "no-cache");
			response.setHeader("Expires", "-1");
			response.setHeader("Cache-Control",
					"no-store, no-cache, must-revalidate");
			response.setHeader("Content-Disposition", "attachment;filename=\""
					+ fileName + "\"");
			sos = response.getOutputStream();
			bos = new BufferedOutputStream(sos);// NOPMD
			bos.write(fileByteArray);
			bos.flush();
			bos.close();
		}

	}

	/**
	 * Elimina un documento del PID
	 * 
	 * @param documento
	 * @param request
	 * @param response
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/eliminarDocumento", method = RequestMethod.POST)
	public @ResponseBody
	String deleteDocumentoFaseExpediente(@RequestJsonBody Aa21b25s01 documento,

	HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		documento = this.aa21b25s01Service.find(documento);
		pidService.delete(documento.getCodpid25());
		documento.setCodpid25("");
		documento.setExtdocu25("");
		documento.setCtype25("");
		this.aa21b25s01Service.update(documento);
		return "OK";
	}

}
