package com.ejie.aa21b.control;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b21s01;
import com.ejie.aa21b.service.Aa21b21s01Service;
import com.ejie.aa21b.service.Aa21bAccesoPIDService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b21s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b21s01")
public class Aa21b21s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b21s01Controller.class);

	@Autowired
	private Aa21b21s01Service aa21b21s01Service;

	// @Autowired
	// private Aa21b01s01Service aa21b01s01Service;

	@Autowired
	private Aa21bAccesoPIDService pidService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idFaseExp
	 *            String
	 * @return Aa21b21s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idFaseExp}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b21s01 get(@PathVariable String idFaseExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFaseExp != null && !idFaseExp.trim().equals("")) {

			int longitud = idFaseExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFaseExp.indexOf("-") != -1) {
					listaCamposClave.add(idFaseExp.substring(0,
							idFaseExp.indexOf("-")));
				} else {
					listaCamposClave.add(idFaseExp);
				}
				idFaseExp = idFaseExp.substring(idFaseExp.indexOf("-") + 1);
			}
		}
		Aa21b21s01 aa21b21s01 = new Aa21b21s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b21s01.setCserv21(listaCamposClave.get(0));
			aa21b21s01.setCexpe21(listaCamposClave.get(1));
			aa21b21s01.setAexpe21(listaCamposClave.get(2));
			aa21b21s01.setNexpe21(new Integer(listaCamposClave.get(3)));
			aa21b21s01.setCfase21(new Long(listaCamposClave.get(4)));

		}

		Aa21b21s01 aa21b21s01Aux = this.aa21b21s01Service.find(aa21b21s01);

		Aa21b21s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b21s01 por PK");
		return aa21b21s01Aux;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b21s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b21s01> getAll(@ModelAttribute Aa21b21s01 filterAa21b21s01) {
		Aa21b21s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b21s01 por filtro");
		return this.aa21b21s01Service.findAll(filterAa21b21s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b21s01 Bean resultante de la modificacion.
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b21s01 edit(@RequestBody Aa21b21s01 aa21b21s01) throws Exception {

		/**
		 * Si tiene valor el campo ndocu21, hay que comprobar si la fase
		 * asociada tenía ya un documento asociado o por el contrario, al
		 * editar, ha pulsado en el botón ver documento asociado y debemos
		 * guardarlo.
		 */
		if (aa21b21s01.getCodPid21() != null
				&& aa21b21s01.getCodPid21().length() != 0
				&& aa21b21s01.getPathDocPif() != null) {

			pidService.actualizarFicheroEditado(aa21b21s01.getPathDocPif(),
					aa21b21s01.getCodPid21());

		}

		Aa21b21s01 aa21b21s01Aux = this.aa21b21s01Service.update(aa21b21s01);
		Aa21b21s01Controller.logger
				.info("[PUT] : Aa21b21s01 actualizado correctamente");
		return aa21b21s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b21s01 Bean resultante del proceso de creacion.
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b21s01 add(@RequestBody Aa21b21s01 aa21b21s01) throws Exception {

		/**
		 * Si tiene valor el campo ndocu21, significa que esta dando de alta en
		 * el expediente una fase que tiene un documento asociado. Obtenemos el
		 * documento para ese código y guardamos una copia asociada la tabla 21
		 * dándole un nuevo correlativo de ndocu21.
		 */
		/*
		 * if (aa21b21s01.getCodPid21() != null &&
		 * aa21b21s01.getCodPid21().length() > 0) { Aa21b01s01 aa21b01s01 = new
		 * Aa21b01s01(); aa21b01s01.setCserv01(aa21b21s01.getCserv21());
		 * aa21b01s01.setCtipoe01(aa21b21s01.getCexpe21());
		 * aa21b01s01.setCfase01(aa21b21s01.getCfase21()); // Obtengo el
		 * documento Aa21b01s01 aa21b01s01aux = this.aa21b01s01Service
		 * .findDocumentoFase(aa21b01s01); Aa21b21s01Controller.logger
		 * .info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");
		 * 
		 * // Creo la copia del documento en la tabla 23 con el nuevo ndocu que
		 * // después asignare al objeto aa21b21s01 aa21b01s01aux =
		 * this.aa21b01s01Service .addDocumentoFase(aa21b01s01aux);
		 * 
		 * aa21b21s01.setCodPid21(aa21b01s01aux.getCodPid01());
		 * aa21b21s01.setTdocu21(aa21b01s01aux.getTdocu01());
		 * aa21b21s01.setExtdocu21(aa21b01s01aux.getExtdocu01()); }
		 */
		// Hacer una copia del fichero en PID y obtener el código
		if (aa21b21s01.getPathDocPif() != null) {
			String copiaPid = pidService.subirFicheroEditado(aa21b21s01
					.getPathDocPif());
			aa21b21s01.setCodPid21(copiaPid);
		}

		Aa21b21s01 aa21b21s01Aux = this.aa21b21s01Service.add(aa21b21s01);
		Aa21b21s01Controller.logger
				.info("[POST] : Aa21b21s01 insertado correctamente");

		return aa21b21s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param idFaseExp
	 *            String
	 * @return Aa21b21s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{idFaseExp}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b21s01 remove(@PathVariable String idFaseExp) {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFaseExp != null && !idFaseExp.trim().equals("")) {

			int longitud = idFaseExp.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFaseExp.indexOf("-") != -1) {
					listaCamposClave.add(idFaseExp.substring(0,
							idFaseExp.indexOf("-")));
				} else {
					listaCamposClave.add(idFaseExp);
				}
				idFaseExp = idFaseExp.substring(idFaseExp.indexOf("-") + 1);
			}
		}
		Aa21b21s01 aa21b21s01 = new Aa21b21s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b21s01.setCserv21(listaCamposClave.get(0));
			aa21b21s01.setCexpe21(listaCamposClave.get(1));
			aa21b21s01.setAexpe21(listaCamposClave.get(2));
			aa21b21s01.setNexpe21(new Integer(listaCamposClave.get(3)));
			aa21b21s01.setCfase21(new Long(listaCamposClave.get(4)));

			// Busco el ndocu21, si tiene borraremos de la tabla 23 el
			// correspondiente
			aa21b21s01 = this.aa21b21s01Service.find(aa21b21s01);
			if (aa21b21s01.getCodPid21() != null
					&& aa21b21s01.getCodPid21().length() > 0) {
				this.aa21b21s01Service.removeDocumento(aa21b21s01);
			}
		}

		this.aa21b21s01Service.remove(aa21b21s01);
		if (aa21b21s01.getCodPid21() != null) {
			try {
				Aa21b21s01Controller.logger
						.info("[DELETE] : Borrar fichero del PIF");
				this.pidService.delete(aa21b21s01.getCodPid21());
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block

			}
		}
		Aa21b21s01Controller.logger
				.info("[DELETE] : Aa21b21s01 borrado correctamente");
		return aa21b21s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b21s01Controller.logger.info("[GET - View] : aa21b21s01");
		return "aa21b21s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b21s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b21s01> filter(
			@RequestJsonBody(param = "filter") Aa21b21s01 filterAa21b21s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {

		Aa21b21s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b21s01s");

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (filterAa21b21s01.getCserv21() != null
				&& !filterAa21b21s01.getCserv21().equals(vacio)
				// NULL como string...
				&& !filterAa21b21s01.getCserv21().equals("null")) {

			Aa21b13s01 servicio = new Aa21b13s01();// NOPMD
			servicio.setCServ13(filterAa21b21s01.getCserv21());
			listaServicios.add(servicio);
		}

		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		vacio = "";
		if (filterAa21b21s01.getCexpe21() != null
				&& !filterAa21b21s01.getCexpe21().equals(vacio)
				// NULL como string...
				&& !filterAa21b21s01.getCexpe21().equals("null")) {

			Aa21b02s01 tipoExp = new Aa21b02s01();
			tipoExp.setCtipoe02(filterAa21b21s01.getCexpe21());
			listaTiposExpedientes.add(tipoExp);

		}
		return this.aa21b21s01Service.filter(filterAa21b21s01,
				jqGridRequestDto, listaServicios, listaTiposExpedientes, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b21s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b21s01>> search(
			@RequestJsonBody(param = "filter") Aa21b21s01 filterAa21b21s01,
			@RequestJsonBody(param = "search") Aa21b21s01 searchAa21b21s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b21s01Controller.logger
				.info("[POST - search] : Buscar Aa21b21s01s");
		return this.aa21b21s01Service.search(filterAa21b21s01,
				searchAa21b21s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b21s01 filterAa21b21s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b21s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b21s01s");
		this.aa21b21s01Service.removeMultiple(filterAa21b21s01,
				jqGridRequestDto, false);
		Aa21b21s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b21s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b21s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b21s01 filterAa21b21s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b21s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b21s01s jerarquia");
		return this.aa21b21s01Service.jerarquia(filterAa21b21s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b21s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b21s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b21s01 filterAa21b21s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b21s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b21s01s jerarquia - Hijos");
		return this.aa21b21s01Service.jerarquiaChildren(filterAa21b21s01,
				jqGridRequestDto);
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param idFaseExp
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{idFaseExp}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable String idFaseExp) {

		return this.aa21b21s01Service.bloquear(idFaseExp);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param idFaseExp
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{idFaseExp}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable String idFaseExp) {

		return this.aa21b21s01Service.desbloquear(idFaseExp);
	}

	/**
	 * 
	 * @param idFase
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Aa21b01s01
	 * @throws IOException
	 *             Exception
	 */
	@RequestMapping(value = "/getDocumentoFaseExpediente", method = RequestMethod.GET)
	public @ResponseBody
	Object getDocumentoFaseExpediente(
			@RequestParam(value = "idFaseExp", required = false) String idFase,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {

			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0,
							idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b21s01 aa21b21s01 = new Aa21b21s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {

			aa21b21s01.setCserv21(listaCamposClave.get(0));
			aa21b21s01.setCexpe21(listaCamposClave.get(1));
			aa21b21s01.setAexpe21(listaCamposClave.get(2));
			aa21b21s01.setNexpe21(Integer.valueOf(listaCamposClave.get(3)));
			aa21b21s01.setCfase21(new Long(listaCamposClave.get(4)));
		}
		Aa21b21s01 aa21b21s01aux = this.aa21b21s01Service
				.findDocFaseExpediente(aa21b21s01);
		Aa21b21s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");

		if (aa21b21s01aux.getDocu21() != null) {
			byte[] fileByteArray = aa21b21s01aux.getDocumentoPID();
			ServletOutputStream sos = null;
			BufferedOutputStream bos = null;
			StringBuffer fileName = new StringBuffer("Documento");
			if (fileByteArray != null) {

				response.setContentType(aa21b21s01aux.getTdocu21());
				fileName.append(".");
				if (aa21b21s01aux.getExtdocu21() != null)
					fileName.append(aa21b21s01aux.getExtdocu21());
				else
					fileName.append("doc");

				response.setContentLength(fileByteArray.length);
				response.setHeader("Pragma", "no-cache");
				response.setHeader("Expires", "-1");
				response.setHeader("Cache-Control",
						"no-store, no-cache, must-revalidate");
				response.setHeader("Content-Disposition",
						"attachment;filename=\"" + fileName + "\"");
				sos = response.getOutputStream();
				bos = new BufferedOutputStream(sos);// NOPMD
				bos.write(fileByteArray);
				bos.flush();
				bos.close();
			}
		}

		return aa21b21s01aux;
	}

	/**
	 * 
	 * @param idFase
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Aa21b01s01
	 * @throws IOException
	 *             Exception
	 */
	@RequestMapping(value = "/copiarDocumentoFase", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b21s01 copiarDocumentoFase(
			@RequestBody Aa21b21s01 aa21b21s01,
			@RequestParam(value = "idFaseExp", required = false) String idFase,
			@RequestParam(value = "ndocuFase", required = false) String ndocuFase,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria
		// separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {

			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0,
							idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b21s01 aa21b21s01ux = new Aa21b21s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {

			aa21b21s01ux.setCserv21(listaCamposClave.get(0));
			aa21b21s01ux.setCexpe21(listaCamposClave.get(1));
			aa21b21s01ux.setAexpe21(listaCamposClave.get(2));
			aa21b21s01ux.setNexpe21(Integer.valueOf(listaCamposClave.get(3)));
			aa21b21s01ux.setCfase21(new Long(listaCamposClave.get(4)));

			Aa21b21s01 aa21b21s01doc = this.aa21b21s01Service
					.findDocFaseExpediente(aa21b21s01ux);
			Aa21b21s01Controller.logger
					.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");

			if (aa21b21s01doc.getCodPid21() != null) {
				// Copio del documento en la tabla 23 con el ndocu
				aa21b21s01.setCodPid21(aa21b21s01doc.getCodPid21());
				aa21b21s01.setTdocu21(aa21b21s01doc.getTdocu21());
				aa21b21s01.setExtdocu21(aa21b21s01doc.getExtdocu21());
				// Si existe el documento nuevo ,
				// Copiar el documento y guarda
				// copiar es hacer copia física
				String copiaPid = pidService.copy(aa21b21s01.getCodPid21());
				aa21b21s01.setCodPid21(copiaPid);
				// this.aa21b21s01Service
				// .updateDocumentoFaseExpediente(aa21b21s01);

				this.aa21b21s01Service.update(aa21b21s01);
			}

		}

		return aa21b21s01;
	}

	/**
	 * 
	 * @param idFase
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return Aa21b01s01
	 * @throws IOException
	 *             Exception
	 */
	@RequestMapping(value = "/getDocumentoFaseEdit", method = RequestMethod.GET)
	public @ResponseBody
	List<String> getDocumentoFaseEdit(
			@RequestParam(value = "codPid21", required = false) String codPid21,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {

		Aa21b21s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");

		return this.pidService.edicionOnline(codPid21);

	}
}
