//@formatter:off
package com.ejie.aa21b.control;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.model.Aa21b21s01;
import com.ejie.aa21b.model.Aa21b25s01;
import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b01s01Service;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b13s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.Aa21b21s01Service;
import com.ejie.aa21b.service.Aa21b22s01Service;
import com.ejie.aa21b.service.Aa21b25s01Service;
import com.ejie.aa21b.service.Aa21b29s01Service;
import com.ejie.aa21b.service.NoraMunicipioService;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bFormatoFecha;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b20s01Controller  
 * 
 *  
 */
@Controller
@RequestMapping(value = "/aa21b20s01")
public class Aa21b20s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b20s01Controller.class);

	public static final Integer[] grupoTipoExp_Serv92 = new Integer[] { 1, 2,
			3, 4, 5, 6 };

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	@Autowired
	private Aa21b29s01Service respExpService;

	@Autowired
	private Aa21b21s01Service aa21b21s01Service;

	@Autowired
	private Aa21b25s01Service documentosExpService;

	@Autowired
	private Aa21b15s01Service aa21b15s01Service;

	@Autowired
	private Aa21b13s01Service aa21b13s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b01s01Service aa21b01s01Service;

	@Autowired
	private Aa21b29s01Service aa21b29s01Service;

	@Autowired
	private Aa21b21s01Service fasesExpService;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraMunicipioService noraMunicipioService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Aa21b22s01Service asociadosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idExpe
	 *            String
	 * @return Aa21b20s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idExpe}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b20s01 get(@PathVariable String idExpe) {
		Aa21b20s01 aa21b20s01 = new Aa21b20s01();

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idExpe != null && !idExpe.trim().equals("")) {

			int longitud = idExpe.length();
			for (int i = 0; i <= longitud; i++) {
				if (idExpe.indexOf("-") != -1) {
					listaCamposClave.add(idExpe.substring(0,
							idExpe.indexOf("-")));
				} else {
					listaCamposClave.add(idExpe);
				}
				idExpe = idExpe.substring(idExpe.indexOf("-") + 1);
			}
		}

		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b20s01.setCserv20(listaCamposClave.get(0));
			aa21b20s01.setCexpe20(listaCamposClave.get(1));
			aa21b20s01.setAexpe20(new Long(listaCamposClave.get(2)));
			aa21b20s01.setNexpe20(new Integer(listaCamposClave.get(3)));
		}

		// Angel 21/05/2019
		// Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(aa21b20s01);

		// He recogido el grupo al que pertenece el tipo de expediente para
		// comprobar si pertenecía Servicio antiguo (Servicio 92)
		Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service
				.findConGrupoTipoExp(aa21b20s01);
		// Fin Angel 21/05/2019

		if (aa21b20s01aux.getCrespo20() != null) {
			Aa21b15s01 aa21b15s01 = new Aa21b15s01();
			aa21b15s01.setCusu15(aa21b20s01aux.getCrespo20().toString());
			aa21b15s01 = this.aa21b15s01Service.find(aa21b15s01);
			if (aa21b15s01 != null) {
				aa21b20s01aux.setDrespo20(aa21b15s01.getDusu15());
			}
		}

		if (aa21b20s01aux.getCesta20() != null) {
			Aa21b07s01 aa21b07s01 = new Aa21b07s01();
			aa21b07s01.setCesta07(aa21b20s01aux.getCesta20());
			aa21b07s01 = this.aa21b07s01Service.find(aa21b07s01);
			if (aa21b07s01 != null) {
				aa21b20s01aux.setDesta(aa21b07s01.getDesta07());
			}
		}

		if (aa21b20s01aux.getCarchi20() != null) {
			Aa21b14s01 aa21b14s01 = new Aa21b14s01();
			aa21b14s01.setCarchi14(aa21b20s01aux.getCarchi20());
			aa21b14s01 = this.aa21b14s01Service.find(aa21b14s01);
			if (aa21b14s01 != null) {
				aa21b20s01aux.setDarchi20(aa21b14s01.getDarchi14());
			}
		}

		if (aa21b20s01aux.getCdepar20() != null) {
			Aa21b12s01 aa21b12s01 = new Aa21b12s01();
			aa21b12s01.setCDepar12(Long.valueOf(aa21b20s01aux.getCdepar20()));
			aa21b12s01 = this.aa21b12s01Service.find(aa21b12s01);
			if (aa21b12s01 != null) {
				aa21b20s01aux.setDdepar20(aa21b12s01.getDDepar12());
			}
		}

		if (aa21b20s01aux.getCmuni20() != null) {
			NoraMunicipio municipio = new NoraMunicipio();
			NoraMunicipio municipioAux = new NoraMunicipio();
			municipio.setId(aa21b20s01aux.getCmuni20());
			municipio.setProvinciaId(aa21b20s01aux.getCprov20());
			municipioAux = this.noraMunicipioService.find(municipio);
			if (municipioAux != null) {
				aa21b20s01aux.setDmuni20(municipioAux.getDsO());
			}
		}

		Aa21b20s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b20s01 por PK");
		return aa21b20s01aux;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b20s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b20s01> getAll(@ModelAttribute Aa21b20s01 filterAa21b20s01) {
		Aa21b20s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b20s01 por filtro");
		return this.aa21b20s01Service.findAll(filterAa21b20s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b20s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b20s01 edit(@RequestBody Aa21b20s01 aa21b20s01) {
		Aa21b20s01 aa21b20s01Aux = this.aa21b20s01Service.update(aa21b20s01);
		Aa21b20s01Controller.logger
				.info("[PUT] : Aa21b20s01 actualizado correctamente");
		return aa21b20s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b20s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 add(@RequestBody Aa21b20s01 aa21b20s01) {
		Aa21b20s01 aa21b20s01Aux = this.aa21b20s01Service.add(aa21b20s01);
		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 insertado correctamente");
		return aa21b20s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param idExpe
	 *            String
	 * @return Aa21b20s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{idExpe}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b20s01 remove(@PathVariable String idExpe) {
		Aa21b20s01 aa21b20s01 = new Aa21b20s01();

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idExpe != null && !idExpe.trim().equals("")) {

			int longitud = idExpe.length();
			for (int i = 0; i <= longitud; i++) {
				if (idExpe.indexOf("-") != -1) {
					listaCamposClave.add(idExpe.substring(0,
							idExpe.indexOf("-")));
				} else {
					listaCamposClave.add(idExpe);
				}
				idExpe = idExpe.substring(idExpe.indexOf("-") + 1);
			}
		}

		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b20s01.setCserv20(listaCamposClave.get(0));
			aa21b20s01.setCexpe20(listaCamposClave.get(1));
			aa21b20s01.setAexpe20(new Long(listaCamposClave.get(2)));
			aa21b20s01.setNexpe20(new Integer(listaCamposClave.get(3)));
		}

		this.aa21b20s01Service.remove(aa21b20s01);
		Aa21b20s01Controller.logger
				.info("[DELETE] : Aa21b20s01 borrado correctamente");
		return aa21b20s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b20s01Controller.logger
				.info("Entra a expedientes-->Pantalla principal");

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		// String usuario = "VDIAZSAN";

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		// aa21b15s01busqUsuario.setUxlnet15(usuario);
		logger.info("Buscar el usuario en la tabla 15");

		// aa21b15s01busqUsuario = this.aa21b15s01Service
		// .findXLNET(aa21b15s01busqUsuario);
		Aa21b15s01 usuarioFiltro = new Aa21b15s01();
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		// usuarioFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		// filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		if (!ps.isEsDeDireccion()) {
			logger.info("El usuario no es direccion.");
			logger.info("El usuario está en la tabla de usuarios Servicio="
					+ aa21b15s01busqUsuario.getCserv15());
			usuarioFiltro.setCserv15(aa21b15s01busqUsuario.getCserv15());
			filtroTipos.setCserv02(aa21b15s01busqUsuario.getCserv15());
		}
		model.addAttribute("servicioLogueado",
				aa21b15s01busqUsuario.getCserv15());
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(filtroTipos, null));

		filtroTipos.setSitu02(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("tiposExpedientesAlta",
				this.aa21b02s01Service.findAll(filtroTipos, null));

		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		Aa21b07s01 estadosExpe = new Aa21b07s01();
		estadosExpe.setSitu07(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("estadosExpedientesAlta",
				this.aa21b07s01Service.findAll(estadosExpe, null));

		logger.info("Cargar usuarios en el modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(usuarioFiltro, null));
		usuarioFiltro.setSitu15(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("usuariosAlta",
				this.aa21b15s01Service.findAll(usuarioFiltro, null));

		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		Aa21b14s01 ubicacionesFilter = new Aa21b14s01();
		ubicacionesFilter.setSitu14(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("ubicacionesAlta",
				this.aa21b14s01Service.findAll(ubicacionesFilter, null));

		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		Aa21b12s01 departamentoFiltro = new Aa21b12s01();
		departamentoFiltro.setSitu12(Aa21bConstantes.SITUACION_ALTA);
		model.addAttribute("departamentosAlta",
				this.aa21b12s01Service.findAll(departamentoFiltro, null));
		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		logger.info("Cargar vista");
		return "aa21b20s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b20s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b20s01> filter(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b20s01s");

		// Compruebo si ha introducido en el criterio de búsqueda por Expediente
		// Asociado.
		// Si es así, obtendré el CGRUPO del exp asociado y lo pasaré al filtro
		// para que devuelva todos los expedientes asociados
		if (filterAa21b20s01.getRefExpAsociado() != null
				&& !filterAa21b20s01.getRefExpAsociado().trim().equals("")) {

			// Recorro el String getRefExpAsociado que trae el valor de los
			// campos de la clave primaria separados por el carácter "-"
			Aa21b20s01 expAsociado = new Aa21b20s01();
			expAsociado.setRefExp(filterAa21b20s01.getRefExpAsociado());
			expAsociado = this.aa21b20s01Service.findPorReferencia(expAsociado);
			if (expAsociado != null) {
				filterAa21b20s01.setGrupo(expAsociado.getGrupo());
			}
		}

		if (filterAa21b20s01.isCopiaFaseDoc()) {
			return this.aa21b20s01Service.filterConFase(filterAa21b20s01,
					jqGridRequestDto, false);
		} else {
			return this.aa21b20s01Service.filter(filterAa21b20s01,
					jqGridRequestDto, false);
		}
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b20s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b20s01>> search(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody(param = "search") Aa21b20s01 searchAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01Controller.logger
				.info("[POST - search] : Buscar Aa21b20s01s");
		return this.aa21b20s01Service.search(filterAa21b20s01,
				searchAa21b20s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b20s01s");
		this.aa21b20s01Service.removeMultiple(filterAa21b20s01,
				jqGridRequestDto, false);
		Aa21b20s01Controller.logger.info("All entities correctly deleted!");
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b20s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b20s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b20s01s jerarquia");
		return this.aa21b20s01Service.jerarquia(filterAa21b20s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b20s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b20s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b20s01 filterAa21b20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b20s01s jerarquia - Hijos");
		return this.aa21b20s01Service.jerarquiaChildren(filterAa21b20s01,
				jqGridRequestDto);
	}

	/**
	 * Method 'getCreateFormAltaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/altaexpediente", method = RequestMethod.GET)
	public String getCreateFormAltaExpediente(Model model,
			HttpServletRequest request) {
		logger.info("Entra en altaexpediente");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));

		String usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
				.getCodigo();
		logger.info("Usuario contectado" + usuario);
		// String usuario = "VDIAZSAN";

		Aa21b15s01 aa21b15s01busqUsuario = new Aa21b15s01();
		aa21b15s01busqUsuario.setUxlnet15(usuario);

		aa21b15s01busqUsuario = this.aa21b15s01Service
				.findXLNET(aa21b15s01busqUsuario);
		logger.info("Establecer usuario");
		Aa21b15s01 aa21b15s01Aux = new Aa21b15s01();
		Aa21b02s01 aa21b02s01Aux = new Aa21b02s01();

		if (aa21b15s01busqUsuario != null) {
			aa21b15s01Aux.setCserv15(aa21b15s01busqUsuario.getCserv15());
			aa21b02s01Aux.setCserv02(aa21b15s01busqUsuario.getCserv15());
		}
		logger.info("Añadir tipos de expedientesa al modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(aa21b02s01Aux, null));
		logger.info("Añadir usuario al modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(aa21b15s01Aux, null));
		logger.info("Añadir ubicaciones al modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		logger.info("Añadir estados de expediente al modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		logger.info("Añadir departamentos al modelo");
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		logger.info("Añadir paises del nora al modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Añadir provincias del nora al modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		logger.info("Añadir tipo al modelo");
		model.addAttribute("tipo", "A");
		logger.info("Devolver vista");
		return "detalleExpedientes";
	}

	/**
	 * Method 'getCreateFormModificarExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/modificarexpediente", method = RequestMethod.GET)
	public String getCreateFormModificarExpediente(Model model,
			HttpServletRequest request) {
		logger.info("Entra en modificar expediente");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		logger.info("Añadir tipos de expediente al modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(null, null));
		logger.info("Añadir usuario al modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(null, null));
		logger.info("Añadir ubicaciones al modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		logger.info("Añadir estados de expediente al modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		logger.info("Añadir departamentos al modelo");
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		logger.info("Añadir paises del nora al modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Añadir provincias del nora al modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		logger.info("Añadir tipo M al modelo");
		model.addAttribute("tipo", "M");
		logger.info("Añadir idExpe al modelo");
		model.addAttribute("idExpe", request.getParameter("idexpe"));
		logger.info("Devolver vista");
		return "detalleExpedientes";
	}

	/**
	 * Method 'getCreateFormConsultarExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarexpediente", method = RequestMethod.GET)
	public String getCreateFormConsultarExpediente(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(null, null));
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(null, null));
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		model.addAttribute("tipo", "C");
		model.addAttribute("idExpe", request.getParameter("idexpe"));
		return "detalleExpedientes";
	}

	/**
	 * Method 'getCreateFormConsultarExpedienteAsociado'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarexpedienteasociado", method = RequestMethod.GET)
	public String getCreateFormConsultarExpedienteAsociado(Model model,
			HttpServletRequest request) {
		logger.info("Entra en consultarexpedienteasociado");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		logger.info("Añadir tipos de expediente al modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(null, null));
		logger.info("Añadir usuarios al modelo");
		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(null, null));
		logger.info("Añadir ubicaciones al modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));
		logger.info("Añadir Estados de expedientes al modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));
		logger.info("Añadir departamentos al modelo");
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		logger.info("Añadir paises del nora al modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Añadir provincias del nora al modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);
		logger.info("Añadir tipo X al modelo");
		model.addAttribute("tipo", "C");
		logger.info("Añadir idExpeAsoc al modelo");
		model.addAttribute("idExpeAsoc", request.getParameter("idexpeasoc"));
		return "consultaExpedienteAsociado";
	}

	/**
	 * Method 'getCreateFormConsultarFasesExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarfasesexpediente", method = RequestMethod.GET)
	public String getCreateFormConsultarFasesExpediente(Model model,
			HttpServletRequest request) {
		logger.info("Entra en consultar fases de expedientes");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		model.addAttribute("modo", request.getParameter("modo"));
		model.addAttribute("cserv", request.getParameter("cserv"));
		model.addAttribute(
				"cexpe",
				request.getParameter("cexpe").substring(
						request.getParameter("cexpe").indexOf("-") + 1));
		model.addAttribute("aexpe", request.getParameter("aexpe"));
		model.addAttribute("nexpe", request.getParameter("nexpe"));
		logger.info("Devuelve la vista");
		return "fasesExpediente";
	}

	/**
	 * Method 'getCreateFormConsultarDocumentosExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultardocumentosexpediente", method = RequestMethod.GET)
	public String getCreateFormConsultarDocumentosExpediente(Model model,
			HttpServletRequest request) {
		logger.info("Entra en consultardocumentosexpedientes");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		model.addAttribute("modo", request.getParameter("modo"));
		model.addAttribute("cserv", request.getParameter("cserv"));
		model.addAttribute(
				"cexpe",
				request.getParameter("cexpe").substring(
						request.getParameter("cexpe").indexOf("-") + 1));
		model.addAttribute("aexpe", request.getParameter("aexpe"));
		model.addAttribute("nexpe", request.getParameter("nexpe"));
		logger.info("Devuelve la vista");
		return "documentosExpediente";
	}

	/**
	 * Method 'getCreateFormConsultarHistoricoExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarhistoricorespexpediente", method = RequestMethod.GET)
	public String getCreateFormConsultarHistoricoExpediente(Model model,
			HttpServletRequest request) {
		logger.info("Entra en consultarhistoricorespexpediente");
		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));
		model.addAttribute("modo", request.getParameter("modo"));
		model.addAttribute("cserv", request.getParameter("cserv"));
		model.addAttribute(
				"cexpe",
				request.getParameter("cexpe").substring(
						request.getParameter("cexpe").indexOf("-") + 1));
		model.addAttribute("aexpe", request.getParameter("aexpe"));
		model.addAttribute("nexpe", request.getParameter("nexpe"));
		logger.info("Devuelve la vista");
		return "historicoExpediente";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param request
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b20s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/findExpediente/filter", method = RequestMethod.POST)
	public @ResponseBody
	Object findExpediente(HttpServletRequest request) {
		Aa21b20s01Controller.logger
				.info("[POST - filter] : Obtener ExpedientesAsociadosTemp");
		JQGridRequestDto data = new JQGridRequestDto();
		data.setRows(new Long(0));
		data.setPage(new Long(0));
		return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
	}

	/**
	 * Method 'getExpedientesAsociados'.
	 * 
	 * @param grupo
	 *            String
	 * 
	 * @return List<Aa21b15s01>
	 */
	@RequestMapping(value = "/getExpedientesAsociados", method = RequestMethod.POST)
	public @ResponseBody
	List<Aa21b20s01> getExpedientesAsociados(@RequestParam String grupo) {
		List<Aa21b20s01> listaExpAsociados = this.aa21b20s01Service
				.findExpAsociados(grupo);
		return listaExpAsociados;
	}

	/**
	 * Method 'crearExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param listaExpAsociados
	 *            ArrayList<String>
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "/crearExpediente", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<Object> crearServicio(@RequestBody Aa21b20s01 expediente,
			@RequestParam ArrayList<String> listaExpAsociados, Locale locale)
			throws ParseException {
		logger.info("Entra en crearExpediente");
		Aa21b20s01 aa21b20s01Aux = this.aa21b20s01Service.add(expediente);
		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 insertado correctamente");

		ArrayList<Object> ret = new ArrayList<Object>();

		if (listaExpAsociados.size() > 0) {
			logger.info("Tiene expedientes asociados, los borra y los actualiza");
			if (expediente.getGrupo() != null) {
				this.asociadosService.removeAsociados(listaExpAsociados,
						expediente);
			}
			Aa21b20s01Controller.logger
					.info("[POST] : Aa21b20s01 actualizar expedientes asociados");

			ret = this.asociadosService.updateAsociados(listaExpAsociados,
					null, expediente);
			int grupo = (Integer) ret.get(0);
			aa21b20s01Aux.setGrupo("" + grupo);
		}

		// Si ha metido responsable, metemos registro en la tabla de históricos
		// de responsables
		if (expediente.getCrespo20() != null) {
			logger.info("Ha metido un responsable, metemos el registro en la tabla de históricos");
			Aa21b29s01 historicoResp = new Aa21b29s01();
			historicoResp.setCserv29(expediente.getCserv20().toString());
			historicoResp.setCexpe29(expediente.getCexpe20());
			historicoResp.setAexpe29(expediente.getAexpe20().toString());
			historicoResp.setNexpe29(expediente.getNexpe20());
			historicoResp.setCrespo29(expediente.getCrespo20());

			/** Para dar formato a las fechas **/
			Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(true);
			Calendar calendarioAhora = Calendar.getInstance();
			Date dateAhora = calendarioAhora.getTime();
			String dateAhoraFmt = formateadorFecha.print(dateAhora, locale);
			dateAhora = formateadorFecha.parse(dateAhoraFmt, locale);
			historicoResp.setFrespo29(dateAhora);
			logger.info("Llama al service del 29(históricos)");
			this.aa21b29s01Service.add(historicoResp);
		}

		ArrayList<Object> retorno = new ArrayList<Object>();
		retorno.add(aa21b20s01Aux);
		if (ret != null) {
			if (ret.size() > 1) {
				retorno.add(ret.get(1));
			}
			if (ret.size() > 2) {
				retorno.add(ret.get(2));
			}
		}

		return retorno;
	}

	/**
	 * Method 'eliminarExpAsociadoGrupo'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param expEliminarGrupo
	 *            String
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "/eliminarExpAsociadoGrupo", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 eliminarExpAsociadoGrupo(@RequestBody Aa21b20s01 expediente,
			@RequestParam String expEliminarGrupo, Locale locale)
			throws ParseException {
		logger.info("Entra en eliminarExpAsociadoGrupo");

		this.asociadosService.eliminarExpAsociadoGrupo(
				expediente.getReferenciaGrupo(), expEliminarGrupo);

		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b22s01 actualizado correctamente");

		return expediente;
	}

	/**
	 * Method 'actualizarExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param listaExpAsociados
	 *            ArrayList<String>
	 * @param listaDesasociar
	 *            ArrayList<String>
	 * @param respActualizado
	 *            boolean
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "/actualizarExpediente", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<Object> actualizarServicio(@RequestBody Aa21b20s01 expediente,
			@RequestParam ArrayList<String> listaExpAsociados,
			@RequestParam ArrayList<String> listaDesasociar,
			@RequestParam boolean respActualizado, Locale locale)
			throws ParseException {
		logger.info("Entra en actualizarExpediente");
		if (expediente.getRefExp() == null
				|| expediente.getRefExp().length() == 0)
			expediente.setRefExp(expediente.getReferenciaGrupo());
		this.aa21b20s01Service.update(expediente);

		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 actualizado correctamente");

		// if (listaDesasociar.size() > 0) {
		// Aa21b20s01Controller.logger.info("[POST] : Aa21b20s01 desasociar expedientes");
		// this.asociadosService.removeAsociados(listaDesasociar, expediente);
		// }

		// if (listaExpAsociados.size() > 0) {
		// this.asociadosService.removeAsociados(listaExpAsociados, expediente);
		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 actualizar usuarios asignados ");

		ArrayList<Object> ret = this.asociadosService.updateAsociados(
				listaExpAsociados, listaDesasociar, expediente);
		// }

		// Si ha modificado responsable, metemos registro en la tabla de
		// históricos de responsables
		if (respActualizado) {
			logger.info("Se ha modificado el responsable, metemos registro en la tabla de históricos");
			Aa21b29s01 historicoResp = new Aa21b29s01();
			historicoResp.setCserv29(expediente.getCserv20().toString());
			historicoResp.setCexpe29(expediente.getCexpe20());
			historicoResp.setAexpe29(expediente.getAexpe20().toString());
			historicoResp.setNexpe29(expediente.getNexpe20());
			historicoResp.setCrespo29(expediente.getCrespo20());

			/** Para dar formato a las fechas **/
			Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(true);
			Calendar calendarioAhora = Calendar.getInstance();
			Date dateAhora = calendarioAhora.getTime();
			String dateAhoraFmt = formateadorFecha.print(dateAhora, locale);
			dateAhora = formateadorFecha.parse(dateAhoraFmt, locale);
			historicoResp.setFrespo29(dateAhora);
			this.aa21b29s01Service.add(historicoResp);
		}

		ret.set(0, expediente.getRefExp());
		return ret;
	}

	/**
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return aa21b20s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 updateBloqueos(@RequestBody Aa21b20s01 aa21b20s01) {

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");

		if (aa21b20s01 != null) {
			aa21b20s01.setCserv20(aa21b15s01busqUsuario.getCserv15());
		} else {
			aa21b20s01 = new Aa21b20s01();
			aa21b20s01.setCserv20(aa21b15s01busqUsuario.getCserv15());
		}

		Aa21b20s01 aa21b20s01Aux = this.aa21b20s01Service
				.updateBloqueos(aa21b20s01);
		Aa21b20s01Controller.logger
				.info("[PUT] : aa21b13s01 estado actualizado correctamente");
		return aa21b20s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param idExpe
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{idExpe}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable String idExpe) {
		return this.aa21b20s01Service.bloquear(idExpe);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param idExpe
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{idExpe}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable String idExpe) {
		return this.aa21b20s01Service.desbloquear(idExpe);
	}

	/**
	 * Method 'getComboResponsablesPorServicio'.
	 * 
	 * @param q
	 *            String
	 * 
	 * @return List<Aa21b15s01>
	 */
	@RequestMapping(value = "/comboResponsablesServicio", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b15s01> getComboResponsablesPorServicio(
			@RequestParam(value = "cexpe20", required = false) String q) {
		Aa21b15s01 responsable = new Aa21b15s01();
		if (q != null) {
			responsable.setCserv15(q.substring(0, q.indexOf("-")));
		}
		return this.aa21b15s01Service.findAll(responsable, null);
	}

	/**
	 * Method 'getCreateFormConsultarExpedienteAsociado'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarexpedienteasociadoMantGenerales", method = RequestMethod.GET)
	public String getCreateFormConsultarExpedienteAsociadoMantGenerales(
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));

		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(null, null));

		model.addAttribute("usuarios",
				this.aa21b15s01Service.findAll(null, null));

		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));

		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));

		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));

		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);

		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);

		model.addAttribute("tipo", "C");
		model.addAttribute("idExpeAsoc", request.getParameter("idexpeasoc"));

		return "consultaExpedienteAsociado";
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/copiarExpediente", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 copiarExpediente(@RequestBody Aa21b20s01 expediente,
			Locale locale) throws Exception {

		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 actualizado correctamente");

		// Obtengo los datos del expediente que voy a copiar
		Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(expediente);

		// Obtengo las fases de el expediente, si no tiene fases no se realizará
		// la copia
		Aa21b21s01 aa21b21s01aux = new Aa21b21s01();
		aa21b21s01aux.setCserv21(aa21b20s01aux.getCserv20().toString());
		aa21b21s01aux.setCexpe21(aa21b20s01aux.getCexpe20());
		aa21b21s01aux.setAexpe21(aa21b20s01aux.getAexpe20().toString());
		aa21b21s01aux.setNexpe21(aa21b20s01aux.getNexpe20());
		List<Aa21b21s01> listAa21b21s01fases = this.aa21b21s01Service.findAll(
				aa21b21s01aux, null);

		Aa21b25s01 aa21b25s01aux = new Aa21b25s01();
		aa21b25s01aux.setCserv25(Long.parseLong(aa21b20s01aux.getCserv20()));
		aa21b25s01aux.setCexpe25(aa21b20s01aux.getCexpe20());
		aa21b25s01aux.setAexpe25(aa21b20s01aux.getAexpe20());
		aa21b25s01aux.setNexpe25(aa21b20s01aux.getNexpe20());
		List<Aa21b25s01> listAa21b25s01documentos = this.documentosExpService
				.findAll(aa21b25s01aux, null);

		Aa21b20s01 aa21b20s01copia = new Aa21b20s01();

		// Pongo la fecha de apertura a hoy
		/** Para dar formato a las fechas **/
		Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(true);
		Calendar calendarioAhora = Calendar.getInstance();
		Date dateAhora = calendarioAhora.getTime();
		String dateAhoraFmt = formateadorFecha.print(dateAhora, locale);
		dateAhora = formateadorFecha.parse(dateAhoraFmt, locale);

		aa21b20s01aux.setFaper20(dateAhora);
		if (dateAhoraFmt != null && !dateAhoraFmt.trim().equals("")) {
			aa21b20s01aux.setAexpe20((long) calendarioAhora.get(Calendar.YEAR));
		}

		// Borro la fecha de vencimiento si la tiene y la de cierre
		aa21b20s01aux.setFvto20(null);
		aa21b20s01aux.setFcier20(null);
		// Le quito el responsable
		// aa21b20s01aux.setCrespo20(null);
		// Pongo el estado a abierto
		aa21b20s01aux.setCesta20(Aa21bConstantes.ESTADO_EXPEDIENTE_ABIERTO);

		aa21b20s01copia = this.aa21b20s01Service.add(aa21b20s01aux);

		if (listAa21b21s01fases != null && listAa21b21s01fases.size() > 0) {
			// Copiamos las fases del expediente
			for (int i = 0; i < listAa21b21s01fases.size(); i++) {
				aa21b21s01aux = (Aa21b21s01) listAa21b21s01fases.get(i);

				// Si tiene código pid
				if (aa21b21s01aux.getCodPid21() != null
						&& aa21b21s01aux.getCodPid21().length() > 0) {
					// Obtenemos el documento del pid
					Aa21b21s01 aa21b21s01doc = this.aa21b21s01Service
							.findDocFaseExpediente(aa21b21s01aux);

					if (aa21b21s01doc.getDocu21() != null) {
						// Hago copia del documento
						Aa21b01s01 faseDoc = new Aa21b01s01();
						faseDoc.setDocumentoPID(aa21b21s01doc.getDocumentoPID());
						faseDoc.setExtdocu01(aa21b21s01doc.getExtdocu21());
						// guardamos en el pid
						faseDoc = this.aa21b01s01Service
								.addDocumentoFase(faseDoc);
						// establecemos el código
						aa21b21s01aux.setCodPid21(faseDoc.getCodPid01());

						// Asigno el nuevo número de ndocu
					}
				}
				aa21b21s01aux.setCserv21(aa21b20s01copia.getCserv20()
						.toString());
				aa21b21s01aux.setCexpe21(aa21b20s01copia.getCexpe20());
				aa21b21s01aux.setAexpe21(aa21b20s01copia.getAexpe20()
						.toString());
				aa21b21s01aux.setNexpe21(aa21b20s01copia.getNexpe20());

				// Añado la fase nueva en la tabla 21 ya relacionada con el exp
				// nuevo que se ha copiado
				aa21b21s01aux = this.aa21b21s01Service.add(aa21b21s01aux);
			}
		}
		if (listAa21b25s01documentos != null
				&& listAa21b25s01documentos.size() > 0) {

			// Copiamos los documentos del expediente
			for (int i = 0; i < listAa21b25s01documentos.size(); i++) {
				aa21b25s01aux = (Aa21b25s01) listAa21b25s01documentos.get(i);

				// Si tiene código pid
				if (aa21b25s01aux.getCodpid25() != null
						&& aa21b25s01aux.getCodpid25().length() > 0) {
					// Obtenemos el documento del pid
					Aa21b25s01 aa21b25s01doc = this.documentosExpService
							.findDocExpediente(aa21b25s01aux);

					if (aa21b25s01doc.getDdocu25() != null) {
						// Hago copia del documento
						aa21b25s01doc.setCserv25(Long.parseLong(aa21b20s01copia
								.getCserv20()));
						aa21b25s01doc.setCexpe25(aa21b20s01copia.getCexpe20());
						aa21b25s01doc.setAexpe25(aa21b20s01copia.getAexpe20());
						aa21b25s01doc.setNexpe25(aa21b20s01copia.getNexpe20());

						// guardamos en el pid
						aa21b25s01doc = this.documentosExpService
								.addDocumentoExpediente(aa21b25s01doc);

						// Creamos la copia del documento en la tabla asociado
						// al expediente copiado
						this.documentosExpService.add(aa21b25s01doc);
					}
				}
			}
		}

		return aa21b20s01copia;
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/copiarExpedienteConAsociados", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<Object> copiarExpedienteConAsociados(
			@RequestBody Aa21b20s01 expediente, Locale locale) throws Exception {

		Aa21b20s01Controller.logger
				.info("[POST] : Aa21b20s01 actualizado correctamente");

		// Obtengo los datos del expediente que voy a copiar
		Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(expediente);

		// Obtengo las fases de el expediente, si no tiene fases no se realizará
		// la copia
		Aa21b21s01 aa21b21s01aux = new Aa21b21s01();
		aa21b21s01aux.setCserv21(aa21b20s01aux.getCserv20().toString());
		aa21b21s01aux.setCexpe21(aa21b20s01aux.getCexpe20());
		aa21b21s01aux.setAexpe21(aa21b20s01aux.getAexpe20().toString());
		aa21b21s01aux.setNexpe21(aa21b20s01aux.getNexpe20());
		List<Aa21b21s01> listAa21b21s01fases = this.aa21b21s01Service.findAll(
				aa21b21s01aux, null);

		Aa21b25s01 aa21b25s01aux = new Aa21b25s01();
		aa21b25s01aux.setCserv25(Long.parseLong(aa21b20s01aux.getCserv20()));
		aa21b25s01aux.setCexpe25(aa21b20s01aux.getCexpe20());
		aa21b25s01aux.setAexpe25(aa21b20s01aux.getAexpe20());
		aa21b25s01aux.setNexpe25(aa21b20s01aux.getNexpe20());
		List<Aa21b25s01> listAa21b25s01documentos = this.documentosExpService
				.findAll(aa21b25s01aux, null);

		Aa21b20s01 aa21b20s01copia = new Aa21b20s01();

		// Pongo la fecha de apertura a hoy
		/** Para dar formato a las fechas **/
		Aa21bFormatoFecha formateadorFecha = new Aa21bFormatoFecha(true);
		Calendar calendarioAhora = Calendar.getInstance();
		Date dateAhora = calendarioAhora.getTime();
		String dateAhoraFmt = formateadorFecha.print(dateAhora, locale);
		dateAhora = formateadorFecha.parse(dateAhoraFmt, locale);

		aa21b20s01aux.setFaper20(dateAhora);
		if (dateAhoraFmt != null && !dateAhoraFmt.trim().equals("")) {
			aa21b20s01aux.setAexpe20((long) calendarioAhora.get(Calendar.YEAR));
		}

		// Borro la fecha de vencimiento si la tiene y la de cierre
		aa21b20s01aux.setFvto20(null);
		aa21b20s01aux.setFcier20(null);
		// Le quito el responsable
		// aa21b20s01aux.setCrespo20(null);
		// Pongo el estado a abierto
		aa21b20s01aux.setCesta20(Aa21bConstantes.ESTADO_EXPEDIENTE_ABIERTO);

		// Guardamos la copia del expediente
		aa21b20s01copia = this.aa21b20s01Service.add(aa21b20s01aux);

		/**
		 * Expedientes asociados
		 */

		List<Aa21b20s01> listaExpAsociados = this.aa21b20s01Service
				.findExpAsociados(expediente.getRefExp());

		Aa21b20s01 expAsociado = new Aa21b20s01();

		ArrayList<Object> ret = new ArrayList<Object>();

		ArrayList<String> listaRefAsociados = new ArrayList<String>();
		if (listaExpAsociados != null && listaExpAsociados.size() > 0) {

			// Asociamos los mismos expedientes al expediente nuevo creado por
			// la copia
			for (int i = 0; i < listaExpAsociados.size(); i++) {
				expAsociado = (Aa21b20s01) listaExpAsociados.get(i);
				if (expAsociado != null) {
					listaRefAsociados.add(expAsociado.getRefExp().replaceAll(
							"/", "-"));
				}
			}

			// logger.info("Tiene expedientes asociados, los borra y los actualiza");
			// this.asociadosService.removeAsociados(listaRefAsociados,
			// aa21b20s01aux);

			ret = this.asociadosService.updateAsociados(listaRefAsociados,
					null, aa21b20s01copia);
			int grupoAsoc = (Integer) ret.get(0);

			aa21b20s01copia.setGrupo("" + grupoAsoc);
		}

		if (listAa21b21s01fases != null && listAa21b21s01fases.size() > 0) {
			// Copiamos las fases del expediente
			for (int i = 0; i < listAa21b21s01fases.size(); i++) {
				aa21b21s01aux = (Aa21b21s01) listAa21b21s01fases.get(i);

				// Si tiene código pid
				if (aa21b21s01aux.getCodPid21() != null
						&& aa21b21s01aux.getCodPid21().length() > 0) {
					// Obtenemos el documento del pid
					Aa21b21s01 aa21b21s01doc = this.aa21b21s01Service
							.findDocFaseExpediente(aa21b21s01aux);

					if (aa21b21s01doc.getDocu21() != null) {
						// Hago copia del documento
						Aa21b01s01 faseDoc = new Aa21b01s01();
						faseDoc.setDocumentoPID(aa21b21s01doc.getDocumentoPID());
						faseDoc.setExtdocu01(aa21b21s01doc.getExtdocu21());
						// guardamos en el pid
						faseDoc = this.aa21b01s01Service
								.addDocumentoFase(faseDoc);
						// establecemos el código
						aa21b21s01aux.setCodPid21(faseDoc.getCodPid01());

						// Asigno el nuevo número de ndocu
					}
				}
				aa21b21s01aux.setCserv21(aa21b20s01copia.getCserv20()
						.toString());
				aa21b21s01aux.setCexpe21(aa21b20s01copia.getCexpe20());
				aa21b21s01aux.setAexpe21(aa21b20s01copia.getAexpe20()
						.toString());
				aa21b21s01aux.setNexpe21(aa21b20s01copia.getNexpe20());

				// Añado la fase nueva en la tabla 21 ya relacionada con el exp
				// nuevo que se ha copiado
				aa21b21s01aux = this.aa21b21s01Service.add(aa21b21s01aux);
			}
		}

		if (listAa21b25s01documentos != null
				&& listAa21b25s01documentos.size() > 0) {

			// Copiamos los documentos del expediente
			for (int i = 0; i < listAa21b25s01documentos.size(); i++) {
				aa21b25s01aux = (Aa21b25s01) listAa21b25s01documentos.get(i);

				// Si tiene código pid
				if (aa21b25s01aux.getCodpid25() != null
						&& aa21b25s01aux.getCodpid25().length() > 0) {
					// Obtenemos el documento del pid
					Aa21b25s01 aa21b25s01doc = this.documentosExpService
							.findDocExpediente(aa21b25s01aux);

					if (aa21b25s01doc.getDdocu25() != null) {
						// Hago copia del documento
						aa21b25s01doc.setCserv25(Long.parseLong(aa21b20s01copia
								.getCserv20()));
						aa21b25s01doc.setCexpe25(aa21b20s01copia.getCexpe20());
						aa21b25s01doc.setAexpe25(aa21b20s01copia.getAexpe20());
						aa21b25s01doc.setNexpe25(aa21b20s01copia.getNexpe20());

						// guardamos en el pid
						aa21b25s01doc = this.documentosExpService
								.addDocumentoExpediente(aa21b25s01doc);

						// Creamos la copia del documento en la tabla asociado
						// al expediente copiado
						this.documentosExpService.add(aa21b25s01doc);
					}
				}
			}
		}

		ArrayList<Object> retorno = new ArrayList<Object>();
		retorno.add(aa21b20s01copia);
		retorno.add(ret.get(1));
		retorno.add(ret.get(2));
		return retorno;
	}

	/**
	 * Method 'cambiartipoExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/cambiartipoExpediente", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 cambiarTipo(@RequestBody Aa21b20s01 expediente, Locale locale)
			throws Exception {

		Aa21b20s01Controller.logger.info("[POST] : Cambiar tipo de expediente");

		// Obtengo los datos del expediente que voy a copiar
		Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(expediente);
		String nuevoCexpe = expediente.getRefExpAsociado();
		expediente.setExpant20(expediente.getRefExp());
		// Obtengo las fases de el expediente, si no tiene fases no se realizará
		// la copia
		Aa21b21s01 aa21b21s01aux = new Aa21b21s01();
		aa21b21s01aux.setCserv21(aa21b20s01aux.getCserv20().toString());
		aa21b21s01aux.setCexpe21(aa21b20s01aux.getCexpe20());
		aa21b21s01aux.setAexpe21(aa21b20s01aux.getAexpe20().toString());
		aa21b21s01aux.setNexpe21(aa21b20s01aux.getNexpe20());
		List<Aa21b21s01> listAa21b21s01fases = this.aa21b21s01Service.findAll(
				aa21b21s01aux, null);
		if (listAa21b21s01fases != null && listAa21b21s01fases.size() > 0) {
			Aa21b20s01Controller.logger
					.info("Tiene fases, no se puede cambiar");
			// Si tiene fases, no hacer nada.
			return null;
		} else {
			// mensaje = "etNoExistenFasesExpedienteCopia";
			// throw new Exception(this.appMessageSource.getMessage(mensaje,
			// null,
			// LocaleContextHolder.getLocale()));
			this.aa21b20s01Service.updateTipoExpediente(expediente, nuevoCexpe);
			return expediente;
		}
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/comprobarFasesExpediente", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 comprobarFasesExpediente(@RequestBody Aa21b20s01 expediente,
			Locale locale) throws Exception {

		Aa21b20s01Controller.logger.info("[POST] : Comprobar fases expediente");

		// Obtengo los datos del expediente que voy a copiar
		// Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(expediente);
		// Obtengo las fases de el expediente, si no tiene fases no se realizará
		// la copia
		Aa21b21s01 aa21b21s01aux = new Aa21b21s01();
		aa21b21s01aux.setCserv21(expediente.getCserv20().toString());
		aa21b21s01aux.setCexpe21(expediente.getCexpe20());
		aa21b21s01aux.setAexpe21(expediente.getAexpe20().toString());
		aa21b21s01aux.setNexpe21(expediente.getNexpe20());
		List<Aa21b21s01> listAa21b21s01fases = this.aa21b21s01Service.findAll(
				aa21b21s01aux, null);
		if (listAa21b21s01fases != null && listAa21b21s01fases.size() > 0) {
			Aa21b20s01Controller.logger
					.info("Tiene fases, no se puede cambiar");
			// Si tiene fases, no hacer nada.
			return null;
		} else {
			return expediente;
		}
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param expediente
	 *            Aa21b20s01
	 * @param locale
	 *            Locale
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/obtenerCorrelativoUbica", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b20s01 obtenerCorrelativoUbica(@RequestBody Aa21b20s01 expediente,
			Locale locale) throws Exception {
		Aa21b20s01Controller.logger
				.info("[POST] : Obtener el correlativo del campo UBICA20 para el servicio 93");
		String correlaUbica = this.aa21b20s01Service.obtenerCorrelativoUbica();
		String ubica = "L/" + StringUtils.leftPad(correlaUbica + "", 10, '0');
		Aa21b20s01 aa21b20s01aux = new Aa21b20s01();
		aa21b20s01aux.setUbica20(ubica);
		return aa21b20s01aux;
	}

	/**
	 * Method 'getComboProvincias'.
	 * 
	 * @param q
	 *            String
	 * 
	 * @return List<NoraProvincia>
	 */
	/*
	 * @RequestMapping(value = "/comboProvincias", method = RequestMethod.GET)
	 * public @ResponseBody List<NoraProvincia> getComboProvincias(
	 * 
	 * @RequestParam(value = "cpais20_filter_table", required = true) String q)
	 * {
	 * 
	 * NoraProvincia provincia = new NoraProvincia(); NoraAutonomia autonomia =
	 * new NoraAutonomia(); NoraPais pais = new NoraPais(); pais.setId(q);
	 * NoraPais paisAux = this.noraPaisService.find(pais);
	 * 
	 * 
	 * provincia.setAutonomia(autonomia);
	 * 
	 * return this.noraProvinciaService.findAll(provincia, jqGridRequestDto); }
	 */

	/**
	 * Crear excel listado expedientes
	 * 
	 * @param model
	 *            Model
	 * @param filterConsultas
	 *            Aa21b20s01Consultas
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws ParseException
	 *             Exception
	 */
	@RequestMapping(value = "excelFichaExpediente", method = RequestMethod.POST)
	public String excelFichaExpedienteUsuarios(Model model,
			@ModelAttribute Aa21b20s01Consultas filterConsultas,
			HttpServletRequest request, Locale locale) throws ParseException {

		String view = "";

		logger.info("excelFichaExpediente - Inicio");

		String idExpe = "";
		if (request.getParameter("idExpePrint") != null
				&& !request.getParameter("idExpePrint").equals("")) {
			idExpe = request.getParameter("idExpePrint");
		}

		Aa21b20s01 aa21b20s01 = new Aa21b20s01();

		// Recorro el String id que trae el valor de los campos de la clave
		// primaria separados por el carácter "-"
		String[] listaCamposClave = null;
		if (idExpe != null && !idExpe.trim().equals("")) {
			listaCamposClave = idExpe.split("-");/*
												 * int longitud =
												 * idExpe.length(); for (int i =
												 * 0; i <= longitud; i++) { if
												 * (idExpe.indexOf("-") != -1) {
												 * listaCamposClave
												 * .add(idExpe.substring(0,
												 * idExpe.indexOf("-"))); } else
												 * {
												 * listaCamposClave.add(idExpe);
												 * } idExpe =
												 * idExpe.substring(idExpe
												 * .indexOf("-") + 1); }
												 */
		}

		if (listaCamposClave != null && listaCamposClave.length > 0) {
			aa21b20s01.setCserv20(listaCamposClave[0]);
			aa21b20s01.setCexpe20(listaCamposClave[1]);
			aa21b20s01.setAexpe20(new Long(listaCamposClave[2]));
			aa21b20s01.setNexpe20(new Integer(listaCamposClave[3]));
		}

		Aa21b20s01 aa21b20s01aux = this.aa21b20s01Service.find(aa21b20s01);

		List<NoraProvincia> provincias = null;
		List<NoraMunicipio> municipios = null;

		if (aa21b20s01aux != null && aa21b20s01aux.getCprov20() != null) {
			NoraProvincia provinciaAux = new NoraProvincia();
			provinciaAux.setId(aa21b20s01aux.getCprov20());
			provincias = this.noraProvinciaService.findAll(provinciaAux, null);
		}

		if (aa21b20s01aux != null && aa21b20s01aux.getCmuni20() != null) {
			NoraMunicipio municipioAux = new NoraMunicipio();
			municipioAux.setId(aa21b20s01aux.getCmuni20());
			municipios = this.noraMunicipioService.findAll(municipioAux, null);
		}
		List<Aa21b12s01> aa21b12s01aux = null;

		if (aa21b20s01aux != null && aa21b20s01aux.getCdepar20() != null) {
			Aa21b12s01 departamento = new Aa21b12s01();
			departamento.setCDepar12(new Long(aa21b20s01aux.getCdepar20()));
			aa21b12s01aux = this.aa21b12s01Service.findAll(departamento, null);
		}

		List<Aa21b15s01> aa21b15s01aux = null;
		if (aa21b20s01aux != null && aa21b20s01aux.getCrespo20() != null) {
			Aa21b15s01 responsable = new Aa21b15s01();
			responsable.setCusu15(aa21b20s01aux.getCrespo20().toString());
			aa21b15s01aux = this.aa21b15s01Service.findAll(responsable, null);
		}

		List<Aa21b13s01> aa21b13s01aux = null;
		if (aa21b20s01aux != null && aa21b20s01aux.getCserv20() != null) {
			Aa21b13s01 servicio = new Aa21b13s01();
			servicio.setCServ13(aa21b20s01aux.getCserv20().toString());
			aa21b13s01aux = this.aa21b13s01Service.findAll(servicio, null);
		}

		List<Aa21b14s01> aa21b14s01aux = null;
		if (aa21b20s01aux != null && aa21b20s01aux.getCarchi20() != null) {
			Aa21b14s01 ubicacion = new Aa21b14s01();
			ubicacion.setCarchi14(aa21b20s01aux.getCarchi20());
			aa21b14s01aux = this.aa21b14s01Service.findAll(ubicacion, null);
		}

		Aa21b25s01 filterDocumentosExp = new Aa21b25s01();

		filterDocumentosExp.setCserv25(new Long(aa21b20s01aux.getCserv20()));
		filterDocumentosExp.setCexpe25(aa21b20s01aux.getCexpe20());
		filterDocumentosExp.setAexpe25(aa21b20s01aux.getAexpe20());
		filterDocumentosExp.setNexpe25(aa21b20s01aux.getNexpe20());

		List<Aa21b25s01> aa21b25s01aux = this.documentosExpService.findAll(
				filterDocumentosExp, null);

		Aa21b21s01 filterFasesExp = new Aa21b21s01();
		filterFasesExp.setCserv21(aa21b20s01aux.getCserv20().toString());
		filterFasesExp.setCexpe21(aa21b20s01aux.getCexpe20());
		filterFasesExp.setAexpe21(aa21b20s01aux.getAexpe20().toString());
		filterFasesExp.setNexpe21(aa21b20s01aux.getNexpe20());

		List<Aa21b21s01> aa21b21s01aux = this.fasesExpService.findAll(
				filterFasesExp, null);

		Aa21b29s01 filterRespExp = new Aa21b29s01();
		filterRespExp.setCserv29(aa21b20s01aux.getCserv20().toString());
		filterRespExp.setCexpe29(aa21b20s01aux.getCexpe20());
		filterRespExp.setAexpe29(aa21b20s01aux.getAexpe20().toString());
		filterRespExp.setNexpe29(aa21b20s01aux.getNexpe20());

		List<Aa21b29s01> aa21b29s01aux = this.respExpService.findAll(
				filterRespExp, null);

		// String mierdaCodigo = aa21b20s01aux.getReferenciaGrupo();
		// List<Aa21b20s01> listaExpAsociados =
		// this.aa21b20s01Service.findExpAsociados(mierdaCodigo);
		List<Aa21b20s01> listaExpAsociados = this.aa21b20s01Service
				.findExpAsociados(aa21b20s01aux.getReferenciaGrupo());

		model.addAttribute("datosExpediente", aa21b20s01aux);
		model.addAttribute("listaExpAsociados", listaExpAsociados);
		model.addAttribute("documentosExp", aa21b25s01aux);
		model.addAttribute("provincias", provincias);
		model.addAttribute("municipios", municipios);
		model.addAttribute("usuarios", aa21b15s01aux);
		model.addAttribute("servicios", aa21b13s01aux);
		model.addAttribute("archivos", aa21b14s01aux);
		model.addAttribute("fasesExp", aa21b21s01aux);
		model.addAttribute("respExp", aa21b29s01aux);
		model.addAttribute("departamento", aa21b12s01aux);

		view = "reporteExcelFichaExpediente";

		return view;
	}
}